/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LETextField;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEOctets;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class LEIPPanel
extends Panel
implements KeyListener {
    public static final String DOT = ".";
    public static final int MIN = 0;
    public static final int MAX = 255;
    public static final String NO_ADDRESS = "0.0.0.0";
    LETextField[] m_tfs = new LETextField[4];

    public LEIPPanel() {
        super(new FlowLayout(0, 0, 0));
        int i = 0;
        while (i < 4) {
            if (i > 0) {
                this.add(new Label(DOT, 1));
            }
            this.m_tfs[i] = new LETextField(3);
            this.add(this.m_tfs[i]);
            this.m_tfs[i].setNumeric(true);
            this.m_tfs[i].setBounds(0L, 255L);
            this.m_tfs[i].addKeyListener(this);
            ++i;
        }
    }

    public LEIPPanel(String ipaddress) {
        this();
        this.setAddress(ipaddress);
    }

    public void setAddress(String ipaddress) {
        if (ipaddress.length() > 0) {
            LEOctets octets = new LEOctets(ipaddress);
            short[] octs = octets.getOctets();
            int len = Math.min(octs.length, 4);
            int i = 0;
            while (i < len) {
                ((TextComponent)this.m_tfs[i]).setText(Integer.toString(octs[i]));
                ++i;
            }
        } else {
            int i = 0;
            while (i < 4) {
                ((TextComponent)this.m_tfs[i]).setText("");
                ++i;
            }
        }
    }

    public String getAddress() {
        String val;
        StringBuffer buf = new StringBuffer();
        int numblank = 0;
        int i = 0;
        while (i < 4) {
            val = this.m_tfs[i].getText();
            if (val.length() == 0) {
                ++numblank;
            }
            ++i;
        }
        if (numblank != 4) {
            int i2 = 0;
            while (i2 < 4) {
                if (i2 > 0) {
                    buf.append(DOT);
                }
                if ((val = this.m_tfs[i2].getText()).length() == 0) {
                    val = Integer.toString(0);
                } else {
                    try {
                        int addr = Integer.parseInt(val);
                        addr = Math.min(addr, 255);
                        addr = Math.max(addr, 0);
                        val = Integer.toString(addr);
                    }
                    catch (NumberFormatException e) {
                        LEDebug.getLog().logln(20, e);
                        val = Integer.toString(0);
                    }
                }
                buf.append(val);
                ++i2;
            }
        }
        return buf.toString();
    }

    public void setEnabled(boolean enable) {
        int i = 0;
        while (i < 4) {
            this.m_tfs[i].setEnabled(enable);
            ++i;
        }
    }

    public void keyPressed(KeyEvent event) {
        if (event.getKeyChar() == '.') {
            LETextField src = (LETextField)event.getSource();
            int i = 0;
            while (i < 3) {
                if (src == this.m_tfs[i]) {
                    this.m_tfs[i + 1].requestFocus();
                }
                ++i;
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }
}

