/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEImageView
extends Canvas
implements ImageObserver {
    public static final int WEST = 0;
    public static final int NORTHWEST = 1;
    public static final int NORTH = 2;
    public static final int NORTHEAST = 3;
    public static final int EAST = 4;
    public static final int SOUTHEAST = 5;
    public static final int SOUTH = 6;
    public static final int SOUTHWEST = 7;
    public static final int CENTER = 8;
    Image m_image;
    boolean m_loaded;
    int m_anchor;

    public LEImageView(Image img, int anchor) {
        this.m_loaded = this.prepareImage(img, this);
        this.m_image = img;
        this.m_anchor = anchor;
    }

    public LEImageView(Image img) {
        this(img, 0);
    }

    public LEImageView(String file, int anchor) {
        this.m_anchor = anchor;
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.m_image = tk.getImage(file);
        this.m_loaded = this.prepareImage(this.m_image, this);
    }

    public LEImageView(String file) {
        this(file, 0);
    }

    public void setImage(Image img) {
        this.m_loaded = this.prepareImage(img, this);
        this.m_image = img;
        if (this.m_loaded) {
            this.repaint();
        }
    }

    public void setAnchor(int anchor) {
        this.m_anchor = anchor;
        if (this.m_loaded) {
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int w = 0;
        int h = 0;
        if (this.m_image != null) {
            w = this.m_image.getWidth(this);
            h = this.m_image.getHeight(this);
        }
        return new Dimension(w, h);
    }

    public void paint(Graphics gc) {
        this.update(gc);
    }

    public void update(Graphics gc) {
        if (!this.m_loaded) {
            return;
        }
        Dimension dim = this.getSize();
        int w = this.m_image.getWidth(this);
        int h = this.m_image.getHeight(this);
        int x = 0;
        int y = 0;
        switch (this.m_anchor) {
            case 0: {
                y = (dim.height - h) / 2;
                break;
            }
            case 2: {
                x = (dim.width - w) / 2;
                break;
            }
            case 3: {
                x = dim.width - w;
                break;
            }
            case 4: {
                x = dim.width - w;
                y = (dim.height - h) / 2;
                break;
            }
            case 5: {
                x = dim.width - w;
                y = dim.height - h;
                break;
            }
            case 6: {
                x = (dim.width - w) / 2;
                y = dim.height - h;
                break;
            }
            case 7: {
                y = dim.height - h;
                break;
            }
            case 8: {
                x = (dim.width - w) / 2;
                y = (dim.height - h) / 2;
                break;
            }
        }
        gc.drawImage(this.m_image, x, y, this);
    }

    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            this.m_loaded = true;
            this.repaint();
            return false;
        }
        return true;
    }
}

