/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.util.LEResource;
import java.awt.Image;
import java.awt.Toolkit;

public class LELEDs {
    public static int LED_WIDTH = 7;
    public static int LED_HEIGHT = 7;
    public static int BLACK;
    public static int BLUE;
    public static int GRAY;
    public static int GREEN;
    public static int RED;
    public static int YELLOW;
    public static int SQBLACK;
    public static int SQBLUE;
    public static int SQGRAY;
    public static int SQGREEN;
    public static int SQRED;
    public static int SQYELLOW;
    public static int OVAL_GRAY;
    public static int OVAL_GREEN;
    public static int OVAL_YELLOW;
    public static int VSQ_GRAY;
    public static int VSQ_YELLOW;
    static int SQ_OFFSET;
    static int OVAL_OFFSET;
    static int VSQ_OFFSET;
    static Image[] s_ovalLEDs;
    static Image[] s_smallLEDs;
    static Image[] s_sqLEDs;
    static Image[] s_vsqLEDs;

    static Image[] MakeSmallLEDs() {
        Image[] images = new Image[6];
        Toolkit tk = Toolkit.getDefaultToolkit();
        images[0] = LEResource.GetImage("led-black.gif");
        images[1] = LEResource.GetImage("led-blue.gif");
        images[2] = LEResource.GetImage("led-gray.gif");
        images[3] = LEResource.GetImage("led-green.gif");
        images[4] = LEResource.GetImage("led-red.gif");
        images[5] = LEResource.GetImage("led-yellow.gif");
        tk.prepareImage(images[0], -1, -1, null);
        tk.prepareImage(images[1], -1, -1, null);
        tk.prepareImage(images[2], -1, -1, null);
        tk.prepareImage(images[3], -1, -1, null);
        tk.prepareImage(images[4], -1, -1, null);
        tk.prepareImage(images[5], -1, -1, null);
        return images;
    }

    static Image[] MakeSquareLEDs() {
        Image[] images = new Image[6];
        Toolkit tk = Toolkit.getDefaultToolkit();
        images[0] = LEResource.GetImage("sq-led-black.gif");
        images[1] = LEResource.GetImage("sq-led-blue.gif");
        images[2] = LEResource.GetImage("sq-led-gray.gif");
        images[3] = LEResource.GetImage("sq-led-green.gif");
        images[4] = LEResource.GetImage("sq-led-red.gif");
        images[5] = LEResource.GetImage("sq-led-yellow.gif");
        tk.prepareImage(images[0], -1, -1, null);
        tk.prepareImage(images[1], -1, -1, null);
        tk.prepareImage(images[2], -1, -1, null);
        tk.prepareImage(images[3], -1, -1, null);
        tk.prepareImage(images[4], -1, -1, null);
        tk.prepareImage(images[5], -1, -1, null);
        return images;
    }

    static Image[] MakeOvalLEDs() {
        Image[] images = new Image[3];
        Toolkit tk = Toolkit.getDefaultToolkit();
        images[0] = LEResource.GetImage("led-oval-gray.gif");
        images[1] = LEResource.GetImage("led-oval-green.gif");
        images[2] = LEResource.GetImage("led-oval-yellow.gif");
        tk.prepareImage(images[0], -1, -1, null);
        tk.prepareImage(images[1], -1, -1, null);
        tk.prepareImage(images[2], -1, -1, null);
        return images;
    }

    static Image[] MakeVSquareLEDs() {
        Image[] images = new Image[2];
        Toolkit tk = Toolkit.getDefaultToolkit();
        images[0] = LEResource.GetImage("led-vsq-gray.gif");
        images[1] = LEResource.GetImage("led-vsq-yellow.gif");
        tk.prepareImage(images[0], -1, -1, null);
        tk.prepareImage(images[1], -1, -1, null);
        return images;
    }

    public static void Initialize() {
        if (s_smallLEDs == null) {
            s_smallLEDs = LELEDs.MakeSmallLEDs();
        }
        if (s_sqLEDs == null) {
            s_sqLEDs = LELEDs.MakeSquareLEDs();
        }
        if (s_ovalLEDs == null) {
            s_ovalLEDs = LELEDs.MakeOvalLEDs();
        }
        if (s_vsqLEDs == null) {
            s_vsqLEDs = LELEDs.MakeVSquareLEDs();
        }
    }

    public static Image GetLED(int color) {
        if (color >= BLACK && color <= YELLOW) {
            return s_smallLEDs[color];
        }
        if (color >= SQBLACK && color <= SQYELLOW) {
            return s_sqLEDs[color - SQ_OFFSET];
        }
        if (color >= OVAL_GRAY && color <= OVAL_YELLOW) {
            return s_ovalLEDs[color - OVAL_OFFSET];
        }
        if (color >= VSQ_GRAY && color <= VSQ_YELLOW) {
            return s_vsqLEDs[color - VSQ_OFFSET];
        }
        return null;
    }

    static {
        BLUE = 1;
        GRAY = 2;
        GREEN = 3;
        RED = 4;
        YELLOW = 5;
        SQBLACK = 10;
        SQBLUE = 11;
        SQGRAY = 12;
        SQGREEN = 13;
        SQRED = 14;
        SQYELLOW = 15;
        OVAL_GRAY = 20;
        OVAL_GREEN = 21;
        OVAL_YELLOW = 22;
        VSQ_GRAY = 30;
        VSQ_YELLOW = 31;
        SQ_OFFSET = 10;
        OVAL_OFFSET = 20;
        VSQ_OFFSET = 30;
        s_ovalLEDs = null;
        s_smallLEDs = null;
        s_sqLEDs = null;
        s_vsqLEDs = null;
    }
}

