/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LEMultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    static final int WIDTH = 1;
    static final int HEIGHT = 2;
    String m_label;
    int m_just;
    int m_width;
    int m_height;
    int m_sideBased;
    int m_border;

    public LEMultiLineLabel(String label, int justification) {
        this.m_label = label;
        this.m_just = justification;
    }

    public LEMultiLineLabel(String label) {
        this(label, 0);
    }

    public void setMinWidth(int width) {
        this.m_width = width;
    }

    public void setMinHeight(int height) {
        this.m_height = height;
    }

    public void setText(String label) {
        this.m_label = label;
        this.repaint();
    }

    public void setBorder(int border) {
        this.m_border = border;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        this.determineSize();
        return new Dimension(this.m_width, this.m_height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.repaint();
    }

    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.repaint();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.repaint();
    }

    public void update(Graphics gc) {
        this.paint(gc);
    }

    public void paint(Graphics gc) {
        String sub;
        if (gc == null) {
            return;
        }
        Dimension dim = this.getSize();
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, dim.width, dim.height);
        gc.setColor(this.getForeground());
        int width = dim.width - 2 * this.m_border;
        FontMetrics fm = gc.getFontMetrics();
        int y = fm.getLeading() + fm.getAscent();
        int x = this.m_border;
        int len = this.m_label.length();
        int accum = 0;
        int curLen = 0;
        int start = 0;
        int end = 0;
        int index = 0;
        while (index < len) {
            char cur;
            if (Character.isWhitespace(cur = this.m_label.charAt(index++))) {
                end = index - 1;
                curLen += accum;
                accum = 0;
            }
            if (cur == '\n') {
                sub = this.m_label.substring(start, end);
                this.drawString(gc, sub, width, curLen, x, y, this.m_just);
                curLen = 0;
                y += fm.getHeight() + fm.getLeading();
                start = end + 1;
                continue;
            }
            if (curLen + (accum += fm.charWidth(cur)) <= width) continue;
            if (start > end) {
                index = len;
                continue;
            }
            sub = this.m_label.substring(start, end);
            this.drawString(gc, sub, width, curLen, x, y, this.m_just);
            curLen = 0;
            y += fm.getHeight() + fm.getLeading();
            start = end + 1;
        }
        sub = this.m_label.substring(start, len);
        this.drawString(gc, sub, width, curLen + accum, x, y, this.m_just);
    }

    void drawString(Graphics gc, String str, int width, int strWidth, int x, int y, int just) {
        switch (just) {
            case 1: {
                x += (width - strWidth) / 2;
                break;
            }
            case 2: {
                x += width - strWidth;
                break;
            }
        }
        gc.drawString(str, x, y);
    }

    void determineSize() {
        Dimension dim = this.getSize();
        int dim_width = dim.width - 2 * this.m_border;
        int width = Math.max(dim_width, this.m_width);
        int height = Math.max(dim.height, this.m_height);
        if (width == 0 && height == 0) {
            return;
        }
        if (this.m_sideBased == 0) {
            this.m_sideBased = width == 0 ? 2 : 1;
        }
        this.m_width = 0;
        this.m_height = 0;
        if (this.m_label == null) {
            return;
        }
        Graphics gc = this.getGraphics();
        if (gc == null) {
            return;
        }
        FontMetrics fm = gc.getFontMetrics();
        if (fm == null) {
            return;
        }
        int lineHeight = fm.getHeight() + fm.getLeading();
        int len = this.m_label.length();
        this.m_height = fm.getLeading();
        if (this.m_sideBased == 1 && width > 0) {
            char cur = '.';
            int accum = 0;
            int curLen = 0;
            int index = 0;
            while (index < len) {
                if (Character.isWhitespace(cur = (char)this.m_label.charAt(index++))) {
                    curLen += accum;
                    accum = 0;
                }
                if (cur == '\n') {
                    this.m_height += lineHeight;
                    continue;
                }
                if (curLen + (accum += fm.charWidth(cur)) <= width) continue;
                curLen = 0;
                this.m_height += lineHeight;
            }
            this.m_width = width;
            this.m_height += lineHeight;
        } else if (this.m_sideBased == 2 && height > 0) {
            int numLines = height / lineHeight;
            if (numLines == 0) {
                ++numLines;
            }
            int charsLine = len / numLines;
            this.m_width = fm.getMaxAdvance() * charsLine * 2 / 3;
            this.m_height = height;
        }
    }
}

