/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEListItem;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMLListener;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollable;
import COM.livingston.util.LECompare;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class LEMultiList
extends Canvas
implements MouseListener,
MouseMotionListener,
LECompare,
LEScrollable {
    public static final int BORDER = 1;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    static final int HORZ_BUF = 4;
    static final int VERT_BUF = 2;
    int m_cols;
    int m_numTitleCols;
    int m_numTitleRows;
    int m_titleHeight;
    int m_titleWidth;
    int m_totalWidth;
    int m_totalHeight;
    int m_minDisplayRows;
    Object[][] m_colTitles;
    int[] m_colTitleJusts;
    int[] m_rowTitleJusts;
    int[] m_colJusts;
    int[] m_widths;
    int[] m_heights;
    int[] m_fixed;
    LEVector m_rows;
    boolean m_disabled;
    boolean[] m_sortable;
    LECompare[] m_sortObj;
    int m_sortCol;
    int m_lastSort;
    boolean m_rev = false;
    Font m_bold;
    Font m_font;
    Image m_cellDB;
    Image m_colTitleDB;
    Image m_rowTitleDB;
    Image m_cornerDB;
    Color m_fore;
    Color m_back;
    Color m_titleBack;
    Color m_selFore;
    Color m_selBack;
    boolean m_changed;
    boolean m_redraw;
    boolean m_grid;
    boolean m_done;
    LEScrollPanel m_scrollPanel;
    int m_x;
    int m_y;
    int m_mouse;
    int m_height;
    int m_resizeCol;
    Graphics m_gc;
    boolean m_inside;
    LEVector m_select = new LEVector();
    boolean m_multiSelect = true;
    LEVector m_listeners = new LEVector();

    public LEMultiList() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.white);
        this.m_back = Color.white;
        this.m_fore = LEColor.getForeground();
        this.m_titleBack = LEColor.getBackground();
        this.m_selFore = LEColor.getSelectForeground();
        this.m_selBack = LEColor.getSelectBackground();
    }

    public LEMultiList(int numTitleRows, int numTitleColumns, int numDataColumns) {
        this();
        this.initialize(numTitleRows, numTitleColumns, numDataColumns);
    }

    public void initialize(int numTitleRows, int numTitleColumns, int numDataColumns) {
        this.m_cols = numTitleColumns + numDataColumns;
        this.m_numTitleCols = numTitleColumns;
        this.m_numTitleRows = numTitleRows;
        this.m_colTitles = new Object[this.m_numTitleRows][this.m_cols];
        this.m_colTitleJusts = new int[this.m_cols];
        this.m_colJusts = new int[this.m_cols];
        this.m_fixed = new int[this.m_cols];
        this.m_sortable = new boolean[this.m_cols];
        this.m_widths = new int[this.m_cols];
        this.m_changed = true;
    }

    public void addNotify() {
        super.addNotify();
        this.totalArea();
    }

    public void cleanUp() {
        this.m_done = true;
        if (this.m_cellDB != null) {
            this.m_cellDB.flush();
        }
        if (this.m_colTitleDB != null) {
            this.m_colTitleDB.flush();
        }
        if (this.m_rowTitleDB != null) {
            this.m_rowTitleDB.flush();
        }
        if (this.m_cornerDB != null) {
            this.m_cornerDB.flush();
        }
        if (this.m_rows != null) {
            this.m_rows.removeAllElements();
        }
        this.m_rows = null;
        this.m_colTitles = null;
        this.m_colTitleJusts = null;
        this.m_colJusts = null;
        this.m_fixed = null;
        this.m_sortable = null;
        this.m_widths = null;
    }

    public Dimension getMinimumSize() {
        return this.totalArea();
    }

    public Dimension getPreferredSize() {
        return this.totalArea();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.m_disabled = false;
            this.redraw();
            super.setEnabled(enabled);
        } else {
            super.setEnabled(enabled);
            this.m_disabled = true;
            this.redraw();
        }
    }

    public void setTitles(int titleRow, Object[] titles) {
        if (titleRow < this.m_numTitleRows) {
            this.m_colTitles[titleRow] = titles;
            this.m_changed = true;
        }
    }

    public void setMultipleSelect(boolean multi) {
        this.m_multiSelect = multi;
    }

    public void setMinDisplayRows(int min) {
        this.m_minDisplayRows = min;
    }

    public synchronized void addRow(Object[] row) {
        Object[] objs = new Object[this.m_cols + 1];
        int len = Math.min(this.m_cols + 1, row.length);
        int i = 0;
        while (i < len) {
            objs[i] = row[i];
            ++i;
        }
        if (this.m_rows == null) {
            this.m_rows = new LEVector();
        }
        this.m_rows.addElement(objs);
        this.m_heights = null;
        this.m_changed = true;
    }

    public void showGrid(boolean show) {
        this.m_grid = show;
        this.m_changed = true;
    }

    public void setColumnWidth(int col, int pixels) {
        if (col < this.m_cols) {
            this.m_fixed[col] = pixels;
            this.m_changed = true;
        }
    }

    public void setCellJustification(int col, int justification) {
        if (col < this.m_cols) {
            this.m_colJusts[col] = justification;
            this.m_changed = true;
        }
    }

    public void setTitleJustification(int col, int justification) {
        if (col < this.m_cols) {
            this.m_colTitleJusts[col] = justification;
            this.m_changed = true;
        }
    }

    public void setRowObject(int row, Object obj) {
        if (this.m_rows == null && row >= this.m_rows.size()) {
            return;
        }
        Object[] rowObjs = (Object[])this.m_rows.elementAt(row);
        rowObjs[this.m_cols] = obj;
    }

    public Object getRowObject(int row) {
        return this.getCellItem(row, this.m_cols);
    }

    public int getNumColumns() {
        return this.m_cols;
    }

    public int getNumRows() {
        if (this.m_rows == null) {
            return 0;
        }
        return this.m_rows.size();
    }

    public Object getCellItem(int row, int col) {
        if (this.m_rows == null || row >= this.m_rows.size()) {
            return null;
        }
        if (col > this.m_cols) {
            return null;
        }
        Object[] rowObjs = (Object[])this.m_rows.elementAt(row);
        return rowObjs[col];
    }

    public synchronized void setCellItem(int row, int col, Object val) {
        if (this.m_rows == null || row >= this.m_rows.size()) {
            return;
        }
        if (col >= this.m_cols) {
            return;
        }
        this.drawCell(row, col, val);
    }

    public void deleteAllRows() {
        int len = this.m_select.size();
        int num = this.getNumRows();
        int i = num - 1;
        while (i > 0) {
            this.deleteRow(i, false);
            --i;
        }
        this.deleteRow(0, true);
        if (len > this.m_select.size()) {
            this.notifyListeners(new LEMLEvent(3));
        }
    }

    public void deleteRows(int[] rows) {
        if (rows.length > 0) {
            int len = this.m_select.size();
            int i = rows.length - 1;
            while (i > 0) {
                this.deleteRow(rows[i], false);
                --i;
            }
            this.deleteRow(rows[0], true);
            if (len > this.m_select.size()) {
                this.notifyListeners(new LEMLEvent(3));
            }
        }
    }

    public void deleteRow(int row) {
        int len = this.m_select.size();
        this.deleteRow(row, true);
        if (len > this.m_select.size()) {
            this.notifyListeners(new LEMLEvent(3));
        }
    }

    public boolean isRowSelected(int row) {
        Integer val = new Integer(row);
        return this.m_select.contains(val);
    }

    public int getSelectSize() {
        return this.m_select.size();
    }

    public int[] getSelectedRows() {
        LEVector sorted = new LEVector();
        sorted.addVector(this.m_select);
        sorted.quickSort(this);
        int len = sorted.size();
        int[] rows = new int[len];
        int i = 0;
        while (i < len) {
            rows[i] = (Integer)sorted.elementAt(i);
            ++i;
        }
        return rows;
    }

    public void selectRows(int[] rows) {
        this.clearSelect(true);
        int max = this.m_rows.size();
        int i = 0;
        while (i < rows.length) {
            if (rows[i] <= max) {
                this.select(rows[i], true);
            }
            ++i;
        }
        this.notifyListeners(new LEMLEvent(3));
        this.redraw();
    }

    public void addListener(LEMLListener listener) {
        this.m_listeners.addElementUnique(listener);
    }

    public void deleteListener(LEMLListener listener) {
        this.m_listeners.removeElement(listener);
    }

    public void setSortable(int column, boolean sortable) {
        if (column < this.m_cols) {
            this.m_sortable[column] = sortable;
        }
    }

    public void setSortObject(int column, LECompare obj) {
        if (column < this.m_cols) {
            if (this.m_sortObj == null) {
                this.m_sortObj = new LECompare[this.m_cols];
            }
            this.m_sortObj[column] = obj;
        }
    }

    public void sort(int column) {
        if (this.m_rows != null && column < this.m_cols) {
            this.notifyListeners(new LEMLEvent(4));
            int len = this.m_select.size();
            Object[][] tmp = new Object[len][];
            int i = 0;
            while (i < len) {
                tmp[i] = (Object[])this.m_rows.elementAt((Integer)this.m_select.elementAt(i));
                ++i;
            }
            if (column == this.m_sortCol) {
                this.m_rev = !this.m_rev;
                this.m_rows.quickSort(this, this.m_rev);
                this.secondarySort(this.m_lastSort, this.m_rev);
            } else {
                this.m_lastSort = this.m_sortCol;
                this.m_sortCol = column;
                this.m_rows.quickSort(this, this.m_rev);
                this.secondarySort(this.m_lastSort, this.m_rev);
            }
            this.m_select.removeAllElements();
            int rows = this.m_rows.size();
            int i2 = 0;
            while (i2 < rows) {
                Object[] row = (Object[])this.m_rows.elementAt(i2);
                int j = 0;
                while (j < len) {
                    if (tmp[j] == row) {
                        this.m_select.addElement(new Integer(i2));
                    }
                    ++j;
                }
                ++i2;
            }
            this.redraw();
            this.notifyListeners(new LEMLEvent(5));
        }
    }

    public void secondarySort(int secondary, boolean rev) {
        int primary = this.m_sortCol;
        this.m_sortCol = secondary;
        int start = 0;
        Object last = this.getCellItem(0, primary);
        int i = 1;
        while (i < this.m_rows.size()) {
            Object item = this.getCellItem(i, primary);
            if (last != item && item != null && !item.equals(last)) {
                if (i - start > 2) {
                    this.m_rows.quickSort(this, start, i - 1, rev);
                }
                start = i;
            }
            last = item;
            ++i;
        }
        if (i - start > 2) {
            this.m_rows.quickSort(this, start, i - 1, rev);
        }
        this.m_sortCol = primary;
    }

    public int compare(Object a, Object b) {
        if (a instanceof Integer) {
            return this.compare((Number)a, (Number)b);
        }
        Object[] row_a = (Object[])a;
        Object[] row_b = (Object[])b;
        Object obj_a = row_a[this.m_sortCol];
        Object obj_b = row_b[this.m_sortCol];
        if (obj_a == null && obj_b == null) {
            return 0;
        }
        if (obj_a == null) {
            return -1;
        }
        if (obj_b == null) {
            return 1;
        }
        if (this.m_sortObj != null && this.m_sortObj[this.m_sortCol] != null) {
            return this.m_sortObj[this.m_sortCol].compare(obj_a, obj_b);
        }
        if (obj_a instanceof LEListItem) {
            return ((LEListItem)obj_a).compareTo((LEListItem)obj_b);
        }
        if (obj_a instanceof String) {
            return ((String)obj_a).compareTo((String)obj_b);
        }
        if (obj_a instanceof Number) {
            return this.compare((Number)obj_a, (Number)obj_b);
        }
        return obj_a.toString().compareTo(obj_b.toString());
    }

    public int compare(Number num_a, Number num_b) {
        double b;
        if (num_a instanceof Long) {
            long b2;
            long a = num_a.longValue();
            if (a < (b2 = num_b.longValue())) {
                return -1;
            }
            if (a > b2) {
                return 1;
            }
            return 0;
        }
        double a = num_a.doubleValue();
        if (a < (b = num_b.doubleValue())) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public void update(Graphics gc) {
        if (!this.m_done) {
            this.paint(gc);
        }
    }

    public void redraw() {
        if (this.m_done) {
            return;
        }
        this.m_redraw = true;
        this.repaint();
    }

    public void layoutGrid() {
        if (this.m_done) {
            return;
        }
        this.m_changed = true;
        this.repaint();
    }

    public void paint(Graphics gc) {
        if (this.m_done) {
            return;
        }
        try {
            Dimension dim = this.getSize();
            LEMultiList lEMultiList = this;
            synchronized (lEMultiList) {
                if (this.m_changed) {
                    this.m_redraw = true;
                    this.calculateLayout(gc, false);
                    if (this.m_scrollPanel != null) {
                        this.m_scrollPanel.updateScrollbars(this.m_totalWidth, this.m_totalHeight);
                    }
                    this.m_changed = false;
                    if (this.m_cellDB != null) {
                        this.m_cellDB.flush();
                    }
                    if (this.m_colTitleDB != null) {
                        this.m_colTitleDB.flush();
                    }
                    if (this.m_rowTitleDB != null) {
                        this.m_rowTitleDB.flush();
                    }
                    if (this.m_cornerDB != null) {
                        this.m_cornerDB.flush();
                    }
                    int cellWidth = this.m_totalWidth - this.m_titleWidth;
                    int cellHeight = this.m_totalHeight - this.m_titleHeight;
                    this.m_cellDB = cellWidth > 0 && cellHeight > 0 ? this.createImage(cellWidth, cellHeight) : null;
                    this.m_rowTitleDB = this.m_titleWidth > 0 ? this.createImage(this.m_titleWidth, this.m_totalHeight - this.m_titleHeight) : null;
                    this.m_colTitleDB = this.m_titleHeight > 0 ? this.createImage(this.m_totalWidth - this.m_titleWidth, this.m_titleHeight) : null;
                    this.m_cornerDB = this.m_titleHeight > 0 && this.m_titleWidth > 0 ? this.createImage(this.m_titleWidth, this.m_titleHeight) : null;
                }
                if (this.m_redraw) {
                    this.drawMultiList();
                }
                if (dim.height > this.m_totalHeight) {
                    gc.clearRect(0, this.m_totalHeight, dim.width, dim.height - this.m_totalHeight);
                }
                if (this.m_colTitleDB != null) {
                    gc.drawImage(this.m_colTitleDB, this.m_titleWidth + this.m_x, 0, this);
                }
                if (this.m_cornerDB != null) {
                    gc.drawImage(this.m_cornerDB, 0, 0, this);
                }
                gc.clipRect(0, this.m_titleHeight, dim.width, dim.height - this.m_titleHeight);
                if (this.m_rowTitleDB != null) {
                    gc.drawImage(this.m_rowTitleDB, 0, this.m_titleHeight + this.m_y, this);
                } else {
                    gc.clearRect(0, this.m_titleHeight, this.m_titleWidth, dim.height - this.m_titleHeight);
                }
                gc.clipRect(this.m_titleWidth, this.m_titleHeight, dim.width - this.m_titleWidth, dim.height - this.m_titleHeight);
                if (this.m_cellDB != null) {
                    gc.drawImage(this.m_cellDB, this.m_titleWidth + this.m_x, this.m_titleHeight + this.m_y, this);
                }
                if (this.m_gc != null && this.m_inside) {
                    this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            this.m_changed = true;
            this.repaint(1000L);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (this.m_done) {
            return;
        }
        Rectangle rect = this.getBounds();
        if (rect.x != x || rect.y != y || rect.width != w || rect.height != h) {
            super.setBounds(x, y, w, h);
            this.m_changed = true;
        }
    }

    public void setSize(int w, int h) {
        if (this.m_done) {
            return;
        }
        super.setSize(w, h);
        this.m_changed = true;
    }

    public void setSize(Dimension d) {
        if (this.m_done) {
            return;
        }
        super.setSize(d);
        this.m_changed = true;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_gc != null) {
                this.m_inside = true;
                this.m_mouse = evt.getX();
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void mouseExited(MouseEvent evt) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_gc != null) {
                this.m_inside = false;
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void mousePressed(MouseEvent evt) {
        if (this.m_disabled || this.m_done) {
            return;
        }
        try {
            int x = evt.getX();
            int y = evt.getY();
            if (this.m_titleHeight == 0 || y < this.m_titleHeight) {
                int col;
                this.m_mouse = this.shouldResize(x);
                if (this.m_mouse > 0) {
                    this.m_gc = this.getGraphics();
                    this.m_gc.setXORMode(Color.white);
                    this.m_height = this.getSize().height - 1;
                    this.m_height = this.m_totalHeight - 1;
                    this.m_inside = true;
                } else if (y < this.m_titleHeight && this.m_sortable[col = this.getColumn(x)]) {
                    this.sort(col);
                }
            } else if (this.m_rows != null) {
                int row = this.getRow(y);
                if (row < 0 || row >= this.m_rows.size()) {
                    return;
                }
                if (evt.getClickCount() % 2 == 0) {
                    this.notifyListeners(new LEMLEvent(6));
                    return;
                }
                if (this.m_multiSelect && evt.isShiftDown()) {
                    int len = this.m_select.size();
                    if (len > 0) {
                        int end;
                        int[] sels = new int[len];
                        int i = 0;
                        while (i < len) {
                            sels[i] = (Integer)this.m_select.elementAt(i);
                            ++i;
                        }
                        int start = Math.min(row, sels[0]);
                        if (start < (end = Math.max(row, sels[0]))) {
                            int i2 = 1;
                            while (i2 < len) {
                                if (sels[i2] < start || sels[i2] > end) {
                                    this.unselect(sels[i2], true);
                                }
                                ++i2;
                            }
                            int i3 = start;
                            while (i3 <= end) {
                                if (!this.isRowSelected(i3)) {
                                    this.select(i3, true);
                                }
                                ++i3;
                            }
                        }
                    } else {
                        this.select(row, true);
                    }
                } else if (evt.isControlDown()) {
                    if (this.isRowSelected(row)) {
                        this.unselect(row, true);
                    } else if (this.m_multiSelect) {
                        this.select(row, true);
                    }
                } else {
                    this.clearSelect(true);
                    this.select(row, true);
                }
                this.notifyListeners(new LEMLEvent(3));
                this.redraw();
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_gc != null) {
                if (this.m_inside) {
                    this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                    this.resizeColumn(evt.getX());
                }
                this.m_gc.dispose();
                this.m_gc = null;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.m_done || this.m_disabled) {
            return;
        }
        try {
            if (this.m_inside && this.m_gc != null) {
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
                this.m_mouse = evt.getX();
                this.m_gc.drawLine(this.m_mouse, 0, this.m_mouse, this.m_height);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void setScrollPanel(LEScrollPanel panel) {
        this.m_scrollPanel = panel;
    }

    public void setOrigin(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    public void scrollTo(int x, int y) {
        this.m_x = x;
        this.m_y = y;
        this.repaint();
    }

    public void startScroll() {
    }

    public void endScroll() {
    }

    public synchronized Dimension totalArea() {
        Dimension dim;
        Graphics gc = this.getGraphics();
        if (gc != null && (this.m_totalWidth == 0 || this.m_totalHeight == 0)) {
            this.calculateLayout(gc, true);
            dim = new Dimension(this.m_totalWidth, this.m_totalHeight);
            this.calculateLayout(gc, false);
            gc.dispose();
        } else {
            dim = new Dimension(this.m_totalWidth, this.m_totalHeight);
        }
        return dim;
    }

    public void notifyListeners(LEMLEvent event) {
        int len = this.m_listeners.size();
        int i = 0;
        while (i < len) {
            LEMLListener listener = (LEMLListener)this.m_listeners.elementAt(i);
            listener.onLEMLEvent(event);
            ++i;
        }
    }

    void drawMultiList() {
        Graphics gc;
        if (this.m_done) {
            return;
        }
        Dimension dim = this.getSize();
        if (dim.height > this.m_totalHeight && (gc = this.getGraphics()) != null) {
            gc.setColor(this.m_back);
            gc.fillRect(0, dim.height, dim.width, dim.height - this.m_totalHeight);
            gc.dispose();
        }
        if (this.m_rows != null) {
            if (this.m_cellDB != null) {
                gc = this.m_cellDB.getGraphics();
                this.drawData(gc);
                if (this.m_grid) {
                    this.drawGrid(gc);
                }
                gc.dispose();
            }
            if (this.m_titleWidth > 0 && this.m_rowTitleDB != null) {
                gc = this.m_rowTitleDB.getGraphics();
                this.drawRowTitles(gc);
                gc.dispose();
            } else {
                this.m_rowTitleDB = null;
            }
        }
        if (this.m_titleHeight > 0 && this.m_colTitleDB != null) {
            gc = this.m_colTitleDB.getGraphics();
            this.drawColTitles(gc);
            gc.dispose();
        }
        if (this.m_titleHeight > 0 && this.m_titleWidth > 0 && this.m_cornerDB != null) {
            gc = this.m_cornerDB.getGraphics();
            this.drawCorner(gc);
            gc.dispose();
        }
        this.m_redraw = false;
    }

    void drawGrid(Graphics gc) {
        int width = 0;
        int i = this.m_numTitleCols;
        while (i < this.m_cols) {
            width += this.m_widths[i] + 1;
            ++i;
        }
        ++width;
        gc.setColor(this.m_titleBack);
        int cur_x = 0;
        int cur_y = 0;
        int height = 0;
        i = this.m_numTitleRows;
        while (i < this.m_heights.length) {
            gc.drawLine(cur_x, cur_y, width, cur_y);
            cur_y += this.m_heights[i] + 1;
            height += this.m_heights[i] + 1;
            ++i;
        }
        gc.drawLine(cur_x, cur_y, width, cur_y);
        cur_x = 0;
        cur_y = 0;
        i = this.m_numTitleCols;
        while (i < this.m_cols) {
            gc.drawLine(cur_x, cur_y, cur_x, height);
            cur_x += this.m_widths[i] + 1;
            ++i;
        }
        gc.drawLine(cur_x, cur_y, cur_x, height);
    }

    void drawData(Graphics gc) {
        FontMetrics fm = gc.getFontMetrics(this.m_font);
        gc.setFont(this.m_font);
        int cur_x = 1;
        int cur_y = 1;
        int rows = this.m_rows.size() + this.m_numTitleRows;
        int j = this.m_numTitleRows;
        while (j < rows) {
            Color fore;
            Color back;
            Object[] row = (Object[])this.m_rows.elementAt(j - this.m_numTitleRows);
            if (this.isRowSelected(j - this.m_numTitleRows)) {
                back = this.m_selBack;
                fore = this.m_selFore;
            } else {
                back = this.m_back;
                fore = this.m_disabled ? this.m_back.darker() : this.m_fore;
            }
            int i = this.m_numTitleCols;
            while (i < this.m_cols) {
                gc.setColor(back);
                gc.fillRect(cur_x - 1, cur_y, this.m_widths[i] + 1, this.m_heights[j]);
                gc.setColor(fore);
                this.drawItem(row[i], gc, fm, cur_x + 4, cur_y + 2, this.m_widths[i] - 8, this.m_heights[j] - 4, this.m_colJusts[i]);
                cur_x += this.m_widths[i] + 1;
                ++i;
            }
            cur_x = 1;
            cur_y += this.m_heights[j] + 1;
            ++j;
        }
    }

    void drawColTitles(Graphics gc) {
        Dimension dim = this.getSize();
        FontMetrics fm = gc.getFontMetrics(this.m_bold);
        Color fore = this.m_disabled ? this.m_titleBack.darker() : this.m_fore;
        gc.setFont(this.m_bold);
        gc.setColor(this.m_titleBack);
        gc.fillRect(0, 0, this.m_totalWidth - this.m_titleWidth, this.m_titleHeight);
        int x = 1;
        int y = 1;
        int i = this.m_numTitleCols;
        while (i < this.m_cols) {
            gc.setColor(this.m_titleBack);
            gc.fill3DRect(x, y, this.m_widths[i], this.m_titleHeight - 2, true);
            gc.setColor(fore);
            int j = 0;
            while (j < this.m_numTitleRows) {
                this.drawItem(this.m_colTitles[j][i], gc, fm, x + 4, y + 2, this.m_widths[i] - 8, this.m_heights[j] - 4, this.m_colTitleJusts[i]);
                y += this.m_heights[j] + 1;
                ++j;
            }
            x += this.m_widths[i] + 1;
            y = 1;
            ++i;
        }
    }

    void drawRowTitles(Graphics gc) {
        Dimension dim = this.getSize();
        FontMetrics fm = gc.getFontMetrics(this.m_bold);
        Color fore = this.m_disabled ? this.m_titleBack.darker() : this.m_fore;
        gc.setColor(this.m_titleBack);
        gc.fillRect(0, 0, this.m_titleWidth, this.m_totalHeight - this.m_titleHeight);
        gc.setFont(this.m_bold);
        int x = 1;
        int y = 1;
        int width = this.m_titleWidth - 2;
        int rows = this.m_rows.size();
        int i = 0;
        while (i < rows) {
            Object[] row = (Object[])this.m_rows.elementAt(i);
            gc.setColor(this.m_titleBack);
            gc.fill3DRect(x, y, width, this.m_heights[i + this.m_numTitleRows], true);
            gc.setColor(fore);
            int j = 0;
            while (j < this.m_numTitleCols) {
                this.drawItem(row[j], gc, fm, x + 4, y + 2, this.m_widths[j] - 8, this.m_heights[i + this.m_numTitleRows] - 4, this.m_colJusts[j]);
                x += this.m_widths[j] + 1;
                ++j;
            }
            x = 1;
            y += this.m_heights[i + this.m_numTitleRows] + 1;
            ++i;
        }
    }

    void drawCorner(Graphics gc) {
        FontMetrics fm = gc.getFontMetrics(this.m_bold);
        gc.setColor(this.m_titleBack);
        gc.fillRect(0, 0, this.m_titleWidth, this.m_titleHeight);
        gc.fill3DRect(1, 1, this.m_titleWidth - 2, this.m_titleHeight - 2, true);
        Color fore = this.m_disabled ? this.m_titleBack.darker() : this.m_fore;
        gc.setColor(fore);
        gc.setFont(this.m_bold);
        int x = 1;
        int y = 1;
        int i = 0;
        while (i < this.m_numTitleRows) {
            int j = 0;
            while (j < this.m_numTitleCols) {
                this.drawItem(this.m_colTitles[i][j], gc, fm, x + 4, y + 2, this.m_widths[j] - 8, this.m_heights[i] - 4, this.m_colJusts[j]);
                x += this.m_widths[j] + 1;
                ++j;
            }
            x = 1;
            y += this.m_heights[i] + 1;
            ++i;
        }
    }

    void drawItem(Object item, Graphics gc, FontMetrics fm, int x, int y, int w, int h, int just) {
        if (item instanceof LEListItem) {
            ((LEListItem)item).draw(gc, fm, x, y, w, h, just);
        } else if (item instanceof String) {
            this.drawString((String)item, gc, fm, x, y, w, h, just);
        } else if (item != null) {
            this.drawString(item.toString(), gc, fm, x, y, w, h, just);
        }
    }

    void drawString(String str, Graphics gc, FontMetrics fm, int x, int y, int width, int height, int justification) {
        if (str == null) {
            return;
        }
        y += (height - fm.getHeight()) / 2 + fm.getAscent();
        switch (justification) {
            case 1: {
                int c_x = Math.max(x, x + (width - fm.stringWidth(str)) / 2);
                gc.drawString(str, c_x, y);
                break;
            }
            case 2: {
                int r_x = Math.max(x, x + width - fm.stringWidth(str));
                gc.drawString(str, r_x, y);
                break;
            }
            default: {
                gc.drawString(str, x, y);
            }
        }
    }

    void drawCell(int row, int col, Object item) {
        Color fore;
        FontMetrics fm;
        Graphics gc;
        int start;
        int rows = this.m_rows.size();
        Object[] rowObjs = (Object[])this.m_rows.elementAt(row);
        rowObjs[col] = item;
        if (this.m_changed || this.m_cellDB == null) {
            return;
        }
        int x = 1;
        int i = start = col < this.m_numTitleCols ? 0 : this.m_numTitleCols;
        while (i < col) {
            x += this.m_widths[i] + 1;
            ++i;
        }
        int width = this.m_widths[i];
        int y = 1;
        row += this.m_numTitleRows;
        i = this.m_numTitleRows;
        while (i < row) {
            y += this.m_heights[i] + 1;
            ++i;
        }
        int height = this.m_heights[i];
        if (col < this.m_numTitleCols) {
            gc = this.m_rowTitleDB.getGraphics();
            fm = gc.getFontMetrics(this.m_bold);
            gc.setColor(this.m_titleBack);
            gc.setFont(this.m_bold);
            fore = this.m_fore;
        } else {
            gc = this.m_cellDB.getGraphics();
            fm = gc.getFontMetrics(this.m_font);
            if (this.isRowSelected(row - this.m_numTitleRows)) {
                gc.setColor(this.m_selBack);
                fore = this.m_selFore;
            } else {
                gc.setColor(this.m_back);
                fore = this.m_fore;
            }
            gc.setFont(this.m_font);
        }
        if (this.getItemHeight(item, gc, fm) > height || this.getItemWidth(item, gc, fm) > width) {
            this.m_changed = true;
        } else {
            gc.fillRect(x + 4, y + 2, width - 8, height - 4);
            gc.setColor(fore);
            this.drawItem(item, gc, fm, x + 4, y + 2, width - 8, height - 4, this.m_colJusts[col]);
        }
        gc.dispose();
        this.repaint();
    }

    void clearSelect(boolean notify) {
        int len = this.m_select.size();
        int i = 0;
        while (i < len) {
            this.unselect((Integer)this.m_select.elementAt(0), notify);
            ++i;
        }
    }

    void unselect(int row, boolean notify) {
        this.m_select.removeElement(new Integer(row));
        if (notify) {
            this.notifyListeners(new LEMLEvent(2, row));
        }
    }

    void select(int row, boolean notify) {
        this.m_select.addElement(new Integer(row));
        if (notify) {
            this.notifyListeners(new LEMLEvent(1, row));
        }
    }

    void calculateLayout(Graphics gc, boolean minimum) {
        if (this.m_done) {
            return;
        }
        try {
            if (this.m_font == null) {
                this.m_font = gc.getFont();
                this.m_bold = new Font(this.m_font.getName(), 1, this.m_font.getSize());
            }
            int titleHeight = 0;
            if (this.m_numTitleRows > 0 || this.m_rows != null) {
                int i;
                int i2;
                int numDataRows;
                FontMetrics bold_fm = gc.getFontMetrics(this.m_bold);
                FontMetrics fm = gc.getFontMetrics();
                int fontHeight = fm.getHeight();
                int numFixed = 0;
                int n = numDataRows = this.m_rows == null ? 0 : this.m_rows.size();
                if (this.m_heights == null) {
                    this.m_heights = new int[this.m_numTitleRows + numDataRows];
                }
                if (this.m_numTitleRows > 0) {
                    int i3 = 0;
                    while (i3 < this.m_numTitleRows) {
                        this.m_heights[i3] = 0;
                        int j = 0;
                        while (j < this.m_cols) {
                            if (i3 == 0) {
                                this.m_widths[j] = 0;
                            }
                            if (this.m_fixed[j] > 0 && this.m_widths[j] == 0) {
                                this.m_widths[j] = this.m_fixed[j];
                                ++numFixed;
                            } else if (this.m_fixed[j] == 0) {
                                this.m_widths[j] = Math.max(this.m_widths[j], this.getItemWidth(this.m_colTitles[i3][j], gc, bold_fm) + 8);
                            }
                            this.m_heights[i3] = Math.max(this.m_heights[i3], this.getItemHeight(this.m_colTitles[i3][j], gc, bold_fm) + 4);
                            ++j;
                        }
                        titleHeight += this.m_heights[i3] + 1;
                        ++i3;
                    }
                    ++titleHeight;
                }
                this.m_titleHeight = titleHeight;
                int numRows = 0;
                if (this.m_rows != null) {
                    int len = numRows = this.m_rows.size();
                    FontMetrics tmp_fm = this.m_numTitleCols > 0 ? bold_fm : fm;
                    i2 = 0;
                    while (i2 < len) {
                        Object[] row = (Object[])this.m_rows.elementAt(i2);
                        int j = 0;
                        while (j < this.m_cols) {
                            FontMetrics fontMetrics = tmp_fm = j < this.m_numTitleCols ? bold_fm : fm;
                            if (this.m_fixed[j] > 0 && this.m_widths[j] == 0) {
                                if (this.m_widths[j] == 0) {
                                    this.m_widths[j] = this.m_fixed[j];
                                    ++numFixed;
                                }
                            } else if (this.m_fixed[j] == 0) {
                                this.m_widths[j] = Math.max(this.m_widths[j], this.getItemWidth(row[j], gc, tmp_fm) + 8);
                            }
                            this.m_heights[i2 + this.m_numTitleRows] = Math.max(this.m_heights[i2 + this.m_numTitleRows], this.getItemHeight(row[j], gc, tmp_fm) + 4);
                            ++j;
                        }
                        ++i2;
                    }
                }
                int i4 = 0;
                while (i4 < this.m_numTitleCols) {
                    if (this.m_fixed[i4] == 0) {
                        ++numFixed;
                    }
                    ++i4;
                }
                if (!minimum) {
                    Dimension dim = this.getSize();
                    int total = dim.width - (this.m_cols + 1);
                    if (this.m_numTitleCols > 0) {
                        --total;
                    }
                    i2 = 0;
                    while (i2 < this.m_cols) {
                        total -= this.m_widths[i2];
                        ++i2;
                    }
                    if (total > 0 && this.m_cols - numFixed > 0) {
                        int lastCol = 0;
                        int dist = total / (this.m_cols - numFixed);
                        int i5 = this.m_numTitleCols;
                        while (i5 < this.m_cols) {
                            if (this.m_fixed[i5] == 0) {
                                lastCol = i5;
                                int n2 = i5;
                                this.m_widths[n2] = this.m_widths[n2] + dist;
                                total -= dist;
                            }
                            ++i5;
                        }
                        if (total > 0) {
                            int n3 = lastCol;
                            this.m_widths[n3] = this.m_widths[n3] + total;
                        }
                    }
                }
                this.m_titleWidth = 0;
                if (this.m_numTitleCols > 0) {
                    i = 0;
                    while (i < this.m_numTitleCols) {
                        this.m_titleWidth += this.m_widths[i] + 1;
                        ++i;
                    }
                    ++this.m_titleWidth;
                }
                this.m_totalWidth = 1;
                i = 0;
                while (i < this.m_cols) {
                    this.m_totalWidth += this.m_widths[i] + 1;
                    ++i;
                }
                if (this.m_numTitleCols > 0) {
                    ++this.m_totalWidth;
                }
                this.m_totalHeight = 1;
                int i6 = 0;
                while (i6 < this.m_heights.length) {
                    this.m_totalHeight += this.m_heights[i6] + 1;
                    ++i6;
                }
                if (this.m_numTitleRows > 0) {
                    ++this.m_totalHeight;
                }
                if (numRows < this.m_minDisplayRows) {
                    this.m_totalHeight += (this.m_minDisplayRows - numRows) * (fontHeight + 4);
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    int getItemHeight(Object item, Graphics gc, FontMetrics fm) {
        if (item == null) {
            return 0;
        }
        if (item instanceof LEListItem) {
            return ((LEListItem)item).getHeight(gc, fm);
        }
        if (item instanceof Image) {
            return ((Image)item).getHeight(null);
        }
        return fm.getHeight();
    }

    int getItemWidth(Object item, Graphics gc, FontMetrics fm) {
        if (item == null) {
            return 0;
        }
        if (item instanceof LEListItem) {
            return ((LEListItem)item).getWidth(gc, fm);
        }
        if (item instanceof Image) {
            return ((Image)item).getWidth(null);
        }
        if (item instanceof String) {
            return fm.stringWidth((String)item);
        }
        return fm.stringWidth(item.toString());
    }

    int shouldResize(int x) {
        if (x < this.m_titleWidth) {
            return 0;
        }
        int trans = x - this.m_x;
        int acc = 1;
        int i = 1;
        while (i < this.m_cols) {
            int diff = trans - (acc += this.m_widths[i - 1] + 1);
            if (diff < -2) {
                return 0;
            }
            if (diff <= 2) {
                this.m_resizeCol = i - 1;
                return acc + this.m_x;
            }
            ++i;
        }
        return 0;
    }

    int getColumn(int x) {
        int col = 0;
        if (x >= this.m_titleWidth) {
            x -= this.m_x;
        }
        int width = 1;
        int i = 0;
        while (i < this.m_cols) {
            col = i;
            if (x < (width += this.m_widths[i] + 1)) break;
            ++i;
        }
        return col;
    }

    int getRow(int y) {
        int row = -1;
        if (this.m_rows != null && (y -= this.m_y) < this.m_totalHeight) {
            int height = this.m_titleHeight;
            int i = this.m_numTitleRows;
            while (i < this.m_heights.length) {
                ++row;
                if (y < (height += this.m_heights[i] + 1)) break;
                ++i;
            }
        }
        return row;
    }

    void resizeColumn(int x) {
        int trans = x - this.m_x;
        int acc = 1;
        int i = 0;
        while (i <= this.m_resizeCol) {
            acc += this.m_widths[i] + 1;
            ++i;
        }
        this.m_fixed[this.m_resizeCol] = Math.max(this.m_widths[this.m_resizeCol] + trans - acc, 2);
        this.layoutGrid();
    }

    void deleteRow(int row, boolean redraw) {
        if (this.m_rows == null) {
            return;
        }
        int numRows = this.m_rows.size();
        if (row >= numRows) {
            return;
        }
        if (this.isRowSelected(row)) {
            this.unselect(row, true);
        }
        this.m_rows.removeElementAt(row);
        if (this.m_rows.size() == 0) {
            this.m_titleWidth = 0;
            this.m_rows = null;
        }
        int len = this.m_select.size();
        int i = 0;
        while (i < len) {
            int rowNum = (Integer)this.m_select.elementAt(i);
            if (rowNum > row) {
                this.m_select.removeElementAt(i);
                this.m_select.insertElementAt(new Integer(rowNum - 1), i);
            }
            ++i;
        }
        if (this.m_heights == null || this.m_heights.length == 0) {
            return;
        }
        int[] tmp = new int[this.m_heights.length - 1];
        int index = row + this.m_numTitleRows;
        int i2 = 0;
        while (i2 < index) {
            tmp[i2] = this.m_heights[i2];
            ++i2;
        }
        int i3 = index + 1;
        while (i3 < this.m_heights.length) {
            tmp[i3 - 1] = this.m_heights[i3];
            ++i3;
        }
        this.m_heights = tmp;
        if (redraw) {
            this.layoutGrid();
        }
    }
}

