/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEPathEvent;
import COM.livingston.ui.LEPathItem;
import COM.livingston.ui.LEPathListener;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class LEPathBar
extends Canvas
implements MouseListener {
    static final int SPACE = 2;
    static final int LINE = 10;
    static final int BUF = 3;
    LEPathItem[] m_path;
    int m_thickness = 2;
    int m_border = 2;
    Font m_bold;
    boolean m_disabled;
    Vector m_listeners = new Vector();

    public LEPathBar() {
        this.addMouseListener(this);
    }

    public LEPathBar(LEPathItem[] path) {
        this();
        this.m_path = path;
    }

    public LEPathBar(int border) {
        this();
        this.m_border = border;
    }

    public LEPathBar(LEPathItem[] path, int border) {
        this();
        this.m_path = path;
        this.m_border = border;
    }

    public void setPath(LEPathItem[] path) {
        this.m_path = path;
        this.repaint();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            super.setEnabled(enabled);
            this.m_disabled = false;
            this.repaint();
        } else {
            super.setEnabled(enabled);
            this.m_disabled = true;
            this.repaint();
        }
    }

    public synchronized Dimension getMinimumSize() {
        int height = this.m_thickness + 2 + this.m_border;
        int width = 2 * this.m_border;
        if (this.m_path != null && this.m_path.length > 0) {
            Font font = this.getFont();
            FontMetrics bold = null;
            int fontHeight = 0;
            if (font != null) {
                if (this.m_bold == null) {
                    this.m_bold = new Font(font.getName(), 1, font.getSize());
                }
                FontMetrics fm = this.getFontMetrics(font);
                bold = this.getFontMetrics(this.m_bold);
                fontHeight = bold.getHeight();
                width += bold.stringWidth(this.m_path[this.m_path.length - 1].getLabel());
                int i = 0;
                while (i < this.m_path.length - 1) {
                    width += fm.stringWidth(this.m_path[i].getLabel()) + 10 + 6;
                    ++i;
                }
            }
            height += fontHeight + 2;
        }
        return new Dimension(width, height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics gc) {
        Dimension dim = this.getSize();
        Font font = gc.getFont();
        if (this.m_bold == null) {
            this.m_bold = new Font(font.getName(), 1, font.getSize());
        }
        FontMetrics fm = gc.getFontMetrics();
        FontMetrics bold = gc.getFontMetrics(this.m_bold);
        int y = bold.getAscent() + this.m_border;
        if (this.m_disabled) {
            gc.setColor(this.getBackground().darker());
        }
        if (this.m_path != null && this.m_path.length > 0) {
            int x = this.m_border;
            int ly = bold.getHeight() / 2 + this.m_border;
            int i = 0;
            while (i < this.m_path.length - 1) {
                gc.drawString(this.m_path[i].getLabel(), x, y);
                x += fm.stringWidth(this.m_path[i].getLabel());
                if (this.m_path.length > 1) {
                    gc.drawLine(x += 3, ly, x + 10, ly);
                    x += 13;
                }
                ++i;
            }
            gc.setFont(this.m_bold);
            gc.drawString(this.m_path[this.m_path.length - 1].getLabel(), x, y);
            gc.setFont(font);
        }
        if (this.m_thickness > 0) {
            gc.fillRect(this.m_border, dim.height - this.m_thickness - 2, dim.width - 2 * this.m_border, this.m_thickness);
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        if (this.m_disabled || this.m_path == null || this.m_path.length < 2) {
            return;
        }
        Dimension dim = this.getSize();
        int x = evt.getX();
        int y = evt.getY();
        if (y < dim.height - this.m_thickness - 2) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int x1 = this.m_border;
            int i = 0;
            while (i < this.m_path.length - 1) {
                if (x < (x1 += fm.stringWidth(this.m_path[i].getLabel()))) {
                    this.notifyListeners(new LEPathEvent(1, this.m_path[i]));
                    return;
                }
                if (x < (x1 += 16)) {
                    return;
                }
                ++i;
            }
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void addListener(LEPathListener listener) {
        this.m_listeners.addElement(listener);
    }

    public void deleteListener(LEPathListener listener) {
        this.m_listeners.removeElement(listener);
    }

    synchronized void notifyListeners(LEPathEvent event) {
        int len = this.m_listeners.size();
        int i = 0;
        while (i < len) {
            LEPathListener listener = (LEPathListener)this.m_listeners.elementAt(i);
            if (listener != null) {
                listener.onLEPathEvent(event);
            }
            ++i;
        }
    }
}

