/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEColor;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEThreadStatus;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;

public class LEProgressBar
extends Canvas
implements Runnable,
LEObserver {
    int m_height = 18;
    int m_width = 100;
    int m_border = 2;
    int m_percent;
    boolean m_threeD = true;
    Thread m_thread;

    public LEProgressBar(LEObservable observable) {
        this.m_thread = new Thread((Runnable)this, "ProgressBar");
        this.m_thread.start();
        if (observable != null) {
            observable.addObserver(this);
        }
    }

    public LEProgressBar(int percent, LEObservable observable) {
        this.m_percent = percent;
        this.m_thread = new Thread(this);
        this.m_thread.start();
        if (observable != null) {
            observable.addObserver(this);
        }
    }

    public void updatePercent(int percent) {
        if (this.m_percent != percent && percent >= 0 && percent <= 100) {
            this.m_percent = percent;
            this.m_thread.resume();
        }
    }

    public void setBorder(int border) {
        this.m_border = border;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public synchronized Dimension getMinimumSize() {
        int height = this.m_height + this.m_border * 2;
        int width = this.m_width + this.m_border * 2;
        return new Dimension(width, height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void stop() {
        this.m_thread.stop();
    }

    public void paint(Graphics gc) {
        Dimension dim = this.getSize();
        int percent_width = (int)((float)dim.width * (float)((double)this.m_percent / 100.0));
        gc.setColor(LEColor.getForeground());
        if (this.m_percent > 0) {
            if (this.m_threeD) {
                gc.fill3DRect(this.m_border, this.m_border, percent_width, this.m_height, false);
                gc.setColor(LEColor.getBackground());
                gc.fillRect(percent_width, this.m_border, dim.width, this.m_height);
            } else {
                gc.fillRect(this.m_border, this.m_border, percent_width, this.m_height);
                gc.setColor(LEColor.getBackground());
                gc.fillRect(percent_width, this.m_border, dim.width, this.m_height);
            }
        }
    }

    public void update(Graphics gc) {
        this.paint(gc);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.m_thread.suspend();
                    this.repaint();
                }
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                continue;
            }
            break;
        }
    }

    public void update(LEObservable o, Object arg) {
        LEThreadStatus status = (LEThreadStatus)arg;
        int percent = status.getPercent();
        if (percent == 101) {
            this.updatePercent(100);
        } else {
            this.updatePercent(percent);
        }
    }
}

