/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEProgressBar;
import COM.livingston.ui.LETextArea;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEThreadStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;

public class LEProgressPanel
extends Panel
implements LEObserver {
    LEProgressBar m_bar;
    LETextArea m_text;
    LEObservable m_obs;
    String m_lastText = "";

    public LEProgressPanel(LEObservable observable) {
        this("", 0, observable);
    }

    public LEProgressPanel(String text, int percent, LEObservable observable) {
        this.setLayout(new BorderLayout());
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_text = new LETextArea(text);
        this.m_text.setEnabled(false);
        this.add((Component)this.m_text, "North");
        LEBorderPanel border = new LEBorderPanel(2);
        border.setInsets(1, 1, 1, 1);
        border.setLayout(new BorderLayout());
        this.m_bar = new LEProgressBar(percent, null);
        border.add((Component)this.m_bar, "North");
        this.add((Component)border, "South");
        this.m_obs = observable;
        if (observable != null) {
            observable.addObserver(this);
        }
    }

    public void stop() {
        this.m_bar.stop();
        if (this.m_obs != null) {
            this.m_obs.deleteObserver(this);
        }
    }

    private void appendText(String text) {
        if (text.length() > 0 && !this.m_lastText.equals(text)) {
            this.m_lastText = text;
            text = String.valueOf(text) + "\n";
            this.m_text.append(text);
            this.m_text.invalidate();
            this.m_text.validate();
        }
    }

    public void update(LEObservable o, Object arg) {
        if (arg instanceof LEThreadStatus) {
            LEThreadStatus status = (LEThreadStatus)arg;
            String msg = status.getMessage();
            this.appendText(msg);
            this.m_bar.update(o, status);
        }
    }
}

