/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEScrollable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEScrollPanel
extends Panel
implements AdjustmentListener,
MouseListener {
    Scrollbar m_horz;
    Scrollbar m_vert;
    LEScrollable m_scrollable;
    int m_x;
    int m_y;
    boolean m_scrolling;

    public LEScrollPanel() {
        this.addMouseListener(this);
        this.setLayout(null);
        this.m_horz = new Scrollbar(0);
        this.m_horz.addAdjustmentListener(this);
        this.m_vert = new Scrollbar(1);
        this.m_vert.addAdjustmentListener(this);
        this.add(this.m_horz);
        this.add(this.m_vert);
    }

    public LEScrollPanel(LEScrollable scrollable) {
        this();
        this.addScrollable(scrollable);
    }

    public void setScrollable(LEScrollable scrollable) {
        this.addScrollable(scrollable);
        this.invalidate();
        this.validate();
    }

    public void updateScrollbars(int width, int height) {
        this.doLayout(new Dimension(width, height));
    }

    public synchronized void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.doLayout();
        this.repaint();
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.doLayout();
        this.repaint();
    }

    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.doLayout();
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        int x = -this.m_horz.getValue();
        int y = -this.m_vert.getValue();
        if (x != this.m_x || y != this.m_y) {
            this.m_x = x;
            this.m_y = y;
            this.m_scrollable.scrollTo(this.m_x, this.m_y);
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        int y;
        int x = event.getX();
        Component comp = this.getComponentAt(x, y = event.getY());
        if (comp instanceof Scrollbar) {
            this.m_scrolling = true;
            if (this.m_scrollable != null) {
                this.m_scrollable.startScroll();
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.m_scrolling) {
            this.m_scrolling = false;
            if (this.m_scrollable != null) {
                this.m_scrollable.endScroll();
            }
        }
    }

    public synchronized void doLayout() {
        Dimension comp = this.m_scrollable != null ? this.m_scrollable.totalArea() : new Dimension(0, 0);
        this.doLayout(comp);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.m_scrollable instanceof Component) {
            Dimension dim = ((Component)((Object)this.m_scrollable)).getPreferredSize();
            Dimension vert = this.m_vert.getPreferredSize();
            Dimension horz = this.m_horz.getPreferredSize();
            return new Dimension(dim.width + vert.width, dim.height + horz.height);
        }
        return new Dimension(0, 0);
    }

    void addScrollable(LEScrollable scrollable) {
        if (this.m_scrollable instanceof Component) {
            this.removeAll();
            this.add(this.m_horz);
            this.add(this.m_vert);
        }
        this.m_scrollable = scrollable;
        this.m_scrollable.setScrollPanel(this);
        if (this.m_scrollable instanceof Component) {
            this.add((Component)((Object)this.m_scrollable));
        }
    }

    void doLayout(Dimension comp) {
        Dimension vertD = this.m_vert.getPreferredSize();
        Dimension horzD = this.m_horz.getPreferredSize();
        Dimension dim = this.getSize();
        int horzDiff = comp.width - dim.width;
        int vertDiff = comp.height - dim.height;
        this.m_x = 0;
        this.m_y = 0;
        if (horzDiff > 0 && vertDiff > 0) {
            this.m_y = this.manageVSB(true, dim.height - horzD.height, comp.height, dim.width - vertD.width, 0, vertD.width, dim.height - horzD.height);
            this.m_x = this.manageHSB(true, dim.width - vertD.width, comp.width, 0, dim.height - horzD.height, dim.width - vertD.width, horzD.height);
        } else if (horzDiff > 0 && vertDiff + horzD.height > 0) {
            this.m_y = this.manageVSB(true, dim.height - horzD.height, comp.height, dim.width - vertD.width, 0, vertD.width, dim.height - horzD.height);
            this.m_x = this.manageHSB(true, dim.width - vertD.width, comp.width, 0, dim.height - horzD.height, dim.width - vertD.width, horzD.height);
        } else if (vertDiff > 0 && horzDiff + vertD.width > 0) {
            this.m_y = this.manageVSB(true, dim.height - horzD.height, comp.height, dim.width - vertD.width, 0, vertD.width, dim.height - horzD.height);
            this.m_x = this.manageHSB(true, dim.width - vertD.width, comp.width, 0, dim.height - horzD.height, dim.width - vertD.width, horzD.height);
        } else if (horzDiff > 0) {
            this.m_y = this.manageVSB(false, 0, 0, 0, 0, 0, 0);
            this.m_x = this.manageHSB(true, dim.width, comp.width, 0, dim.height - horzD.height, dim.width, horzD.height);
        } else if (vertDiff > 0) {
            this.m_y = this.manageVSB(true, dim.height, comp.height, dim.width - vertD.width, 0, vertD.width, dim.height);
            this.m_x = this.manageHSB(false, 0, 0, 0, 0, 0, 0);
        } else {
            this.m_y = this.manageVSB(false, 0, 0, 0, 0, 0, 0);
            this.m_x = this.manageHSB(false, 0, 0, 0, 0, 0, 0);
        }
        if (this.m_scrollable != null) {
            int width = dim.width;
            int height = dim.height;
            if (this.m_vert.isEnabled()) {
                width -= vertD.width;
            }
            if (this.m_horz.isEnabled()) {
                height -= horzD.height;
            }
            this.m_scrollable.setOrigin(this.m_x, this.m_y);
            if (this.m_scrollable instanceof Component) {
                Component cmp = (Component)((Object)this.m_scrollable);
                cmp.setBounds(0, 0, width, height);
                cmp.invalidate();
                cmp.repaint();
            }
        }
    }

    int manageVSB(boolean show, int visible, int max, int x, int y, int w, int h) {
        int ret = 0;
        if (show) {
            if (this.m_vert.isEnabled()) {
                ret = this.m_vert.getValue();
            }
            ret = -Math.min(ret, max);
            this.m_vert.setBounds(x, y, w, h);
            this.m_vert.setValues(-ret, visible, 0, max);
            this.m_vert.setUnitIncrement(20);
            this.m_vert.setBlockIncrement(h);
            this.m_vert.setEnabled(true);
            this.m_vert.setVisible(true);
        } else {
            this.m_vert.setVisible(false);
            this.m_vert.setEnabled(false);
        }
        return ret;
    }

    int manageHSB(boolean show, int visible, int max, int x, int y, int w, int h) {
        int ret = 0;
        if (show) {
            if (this.m_horz.isEnabled()) {
                ret = this.m_horz.getValue();
            }
            ret = -Math.min(ret, max);
            this.m_horz.setBounds(x, y, w, h);
            this.m_horz.setValues(-ret, visible, 0, max);
            this.m_horz.setUnitIncrement(20);
            this.m_horz.setBlockIncrement(w);
            this.m_horz.setEnabled(true);
            this.m_horz.setVisible(true);
        } else {
            this.m_horz.setVisible(false);
            this.m_horz.setEnabled(false);
        }
        return ret;
    }
}

