/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LESPBar;
import COM.livingston.ui.LESPColumn;
import COM.livingston.ui.LESPRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class LESplitterPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    public static final int SIZE_UNSPECIFIED = 0;
    static final double PERCENT_UNSPECIFIED = 0.0;
    static final int BORDER = 5;
    Vector m_cols = new Vector();
    LESPBar m_bar = new LESPBar();
    boolean m_dragging;
    boolean m_inside;
    boolean m_over;
    Frame m_frame;

    public LESplitterPanel() {
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.doLayout();
    }

    public void addColumn(int pixels) {
        LESPColumn col = new LESPColumn(pixels);
        this.m_cols.addElement(col);
    }

    public void addColumn(double percent) {
        LESPColumn col = new LESPColumn(percent);
        this.m_cols.addElement(col);
    }

    public void addComponent(Component comp, int pixels) {
        LESPColumn col = this.getLastColumn();
        col.addRow(comp, pixels);
        this.add(comp);
    }

    public void addComponent(Component comp, double percent) {
        LESPColumn col = this.getLastColumn();
        col.addRow(comp, percent);
        this.add(comp);
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        if (this.m_dragging) {
            this.m_inside = true;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.m_dragging) {
            this.m_inside = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent event) {
        if (this.m_bar.m_orient != 0) {
            event.consume();
            this.m_dragging = true;
            this.m_inside = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.m_dragging) {
            event.consume();
            this.m_dragging = false;
            if (this.m_bar.m_row == null) {
                this.m_bar.m_col.m_pixels = this.m_bar.m_col.m_width + event.getX() - this.m_bar.m_edge - 1;
                if (this.m_bar.m_col.m_pixels < 0) {
                    this.m_bar.m_col.m_pixels = 0;
                }
            } else {
                this.m_bar.m_row.m_pixels = this.m_bar.m_row.m_height + event.getY() - this.m_bar.m_edge - 1;
                if (this.m_bar.m_row.m_pixels < 0) {
                    this.m_bar.m_row.m_pixels = 0;
                }
            }
            this.doLayout();
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this.m_dragging && this.m_inside) {
            event.consume();
            if (this.m_bar.move(event.getX(), event.getY())) {
                this.repaint();
            }
        }
    }

    public synchronized void mouseMoved(MouseEvent event) {
        if (this.m_dragging) {
            event.consume();
        } else {
            boolean over = this.checkResizeBars(this.m_cols, event.getX(), event.getY());
            if (over && !this.m_over) {
                this.m_over = true;
            } else if (!over && this.m_over) {
                this.m_over = false;
                this.m_bar.reset();
            }
        }
    }

    public void paint(Graphics gc) {
        if (this.m_bar.m_orient != 0 && this.m_inside) {
            if (this.m_dragging) {
                this.m_bar.paint(gc, false);
            } else {
                this.m_bar.paint(gc, true);
            }
        }
    }

    public synchronized void doLayout() {
        Dimension dim = this.getSize();
        int numCols = this.m_cols.size();
        int w = dim.width - (numCols + 1) * 5;
        this.getColumnWidths(numCols, w);
        int x = 5;
        int i = 0;
        while (i < numCols) {
            int y = 5;
            LESPColumn col = (LESPColumn)this.m_cols.elementAt(i);
            int numRows = col.m_rows.size();
            int h = dim.height - (numRows + 1) * 5;
            this.getRowHeights(col, numRows, h);
            int j = 0;
            while (j < numRows) {
                LESPRow row = (LESPRow)col.m_rows.elementAt(j);
                row.m_comp.setBounds(x, y, col.m_width, row.m_height);
                y += 5 + row.m_height;
                row.m_comp.invalidate();
                row.m_comp.validate();
                ++j;
            }
            x += 5 + col.m_width;
            ++i;
        }
        this.repaint();
    }

    LESPColumn getLastColumn() {
        LESPColumn col;
        if (this.m_cols.size() == 0) {
            col = new LESPColumn(0);
            this.m_cols.addElement(col);
        } else {
            col = (LESPColumn)this.m_cols.lastElement();
        }
        return col;
    }

    void getColumnWidths(int numCols, int width) {
        LESPColumn col;
        int avail = width;
        int count = 0;
        int i = 0;
        while (i < numCols) {
            col = (LESPColumn)this.m_cols.elementAt(i);
            if (col.m_pixels != 0) {
                col.m_width = col.m_pixels;
            } else if (col.m_percent != 0.0) {
                col.m_width = (int)((double)width * col.m_percent / 100.0);
            } else {
                ++count;
                col.m_width = 0;
            }
            avail -= col.m_width;
            ++i;
        }
        if (avail > 0 && count > 0) {
            width = avail;
            int i2 = 0;
            while (i2 < numCols) {
                col = (LESPColumn)this.m_cols.elementAt(i2);
                if (col.m_width == 0) {
                    col.m_width = width / count;
                    avail -= col.m_width;
                }
                ++i2;
            }
        }
        if (avail > 0 && numCols > 0) {
            col = (LESPColumn)this.m_cols.lastElement();
            col.m_width += avail;
        }
    }

    void getRowHeights(LESPColumn col, int numRows, int height) {
        LESPRow row;
        int[] heights = new int[numRows];
        int avail = height;
        int count = 0;
        int i = 0;
        while (i < numRows) {
            row = (LESPRow)col.m_rows.elementAt(i);
            if (row.m_pixels != 0) {
                row.m_height = row.m_pixels;
            } else if (row.m_percent != 0.0) {
                row.m_height = (int)((double)height * row.m_percent / 100.0);
            } else {
                ++count;
                row.m_height = 0;
            }
            avail -= row.m_height;
            ++i;
        }
        if (avail > 0 && count > 0) {
            height = avail;
            int i2 = 0;
            while (i2 < numRows) {
                row = (LESPRow)col.m_rows.elementAt(i2);
                if (row.m_height == 0) {
                    row.m_height = height / count;
                    avail -= row.m_height;
                }
                ++i2;
            }
            if (avail > 0) {
                int n = numRows - 1;
                heights[n] = heights[n] + avail;
            }
        }
        if (avail > 0 && numRows > 0) {
            row = (LESPRow)col.m_rows.lastElement();
            row.m_height += avail;
        }
    }

    boolean checkResizeBars(Vector cols, int x, int y) {
        int numCols = cols.size();
        int min_x = 5;
        int i = 0;
        while (i < numCols) {
            if (x < min_x) break;
            LESPColumn col = (LESPColumn)this.m_cols.elementAt(i);
            int max_x = min_x + col.m_width;
            if (x > min_x && x < max_x) {
                return this.checkRowBars(col, min_x, x, y);
            }
            if (i == numCols - 1) break;
            min_x = max_x;
            if (x > min_x && x < (max_x += 5)) {
                this.m_bar.set(col, null, min_x, 2, (min_x + max_x) / 2, 0, this.getSize().height);
                return true;
            }
            min_x = max_x;
            ++i;
        }
        return false;
    }

    boolean checkRowBars(LESPColumn col, int col_x, int x, int y) {
        int numRows = col.m_rows.size();
        int min_y = 5;
        int i = 1;
        while (i < numRows) {
            LESPRow row = (LESPRow)col.m_rows.elementAt(i - 1);
            int max_y = (min_y += row.m_height) + 5;
            if (y > min_y && y < max_y) {
                this.m_bar.set(col, row, min_y, 1, col_x - 5, (min_y + max_y) / 2, col.m_width + 5 + 5);
                return true;
            }
            min_y = max_y;
            ++i;
        }
        return false;
    }
}

