/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEBorderPanel;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.Toolkit;

public class LEStatusBar
extends LEBorderPanel
implements LEObserver,
Runnable {
    Label m_label;
    Thread m_repaint;
    LEStatusManager m_manager;

    public LEStatusBar(LEStatusManager manager) {
        this.initLEStatusBar(0, manager);
    }

    public LEStatusBar(int border, LEStatusManager manager) {
        super(border);
        this.initLEStatusBar(0, manager);
    }

    public LEStatusBar(int border, int labelAlign, LEStatusManager manager) {
        super(border);
        this.initLEStatusBar(labelAlign, manager);
    }

    public void setStatusText(String message) {
        this.m_label.setText(message);
        this.validate();
        this.m_repaint.resume();
    }

    public void update(LEObservable obs, Object arg) {
        if (arg instanceof LEThreadStatus) {
            LEThreadStatus status = (LEThreadStatus)arg;
            if (status.isDone()) {
                this.setStatusText(null);
            } else {
                this.setStatusText(status.getMessage());
            }
        }
    }

    public void stop() {
        this.m_repaint.stop();
    }

    public void run() {
        while (true) {
            Thread.currentThread().suspend();
            this.repaint();
            Toolkit.getDefaultToolkit().sync();
        }
    }

    void initLEStatusBar(int alignment, LEStatusManager manager) {
        this.setLayout(new BorderLayout(0, 0));
        this.m_label = new Label("", alignment);
        this.add("Center", this.m_label);
        manager.addObserver(this);
        this.m_repaint = new Thread(this);
        this.m_repaint.start();
    }
}

