/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEBusyPanel;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;

public class LEStatusDialog
extends Dialog
implements Runnable,
LEObserver {
    LEBusyPanel m_busy;
    Thread m_repaint;
    Label m_status;

    public LEStatusDialog(Frame parent) {
        super(parent, "Status", false);
        this.setLayout(new BorderLayout(5, 5));
        this.m_busy = new LEBusyPanel(1);
        this.add("West", this.m_busy);
        this.m_status = new Label("", 0);
        this.add("Center", this.m_status);
        ((Component)this).setVisible(true);
        this.m_repaint = new Thread((Runnable)this, "LEStatusDialog");
        this.m_repaint.start();
        LEStatusManager.GetManager().addObserver(this);
    }

    public void hideStatus() {
        this.m_repaint.stop();
        this.m_busy.stop();
        LEStatusManager.GetManager().deleteObserver(this);
        ((Component)this).setVisible(false);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dim = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, 400, dim.height);
    }

    public void update(LEObservable obs, Object arg) {
        if (arg instanceof LEThreadStatus) {
            LEThreadStatus status = (LEThreadStatus)arg;
            this.m_status.setText(status.getMessage());
            if (this.m_repaint != null) {
                this.m_repaint.resume();
            }
        }
    }

    public void run() {
        this.m_busy.start();
        while (true) {
            this.invalidate();
            this.validate();
            this.m_repaint.suspend();
        }
    }
}

