/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEColor;
import COM.livingston.util.LEDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class LETextField
extends TextField
implements KeyListener,
FocusListener {
    boolean m_numeric = false;
    boolean m_hex;
    int m_cols = -1;
    long m_min = -1L;
    long m_max = -1L;
    boolean m_bounds = false;
    boolean m_limit_length = true;

    public LETextField() {
    }

    public LETextField(int cols) {
        super(cols);
        this.m_cols = cols;
    }

    public LETextField(String text) {
        super(text);
    }

    public LETextField(String text, int cols) {
        super(text, cols);
        this.m_cols = cols;
    }

    public void addNotify() {
        super.addNotify();
        ((Component)this).setBackground(LEColor.getTextBackground());
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public boolean isHex() {
        return this.m_hex;
    }

    public boolean isNumeric() {
        return this.m_numeric;
    }

    public boolean isBounded() {
        return this.m_bounds;
    }

    public void setHex(boolean hex) {
        this.m_hex = hex;
        this.m_numeric = false;
    }

    public void setNumeric(boolean numeric) {
        this.m_numeric = numeric;
        this.m_hex = false;
    }

    public void setBounded(boolean bound) {
        this.m_bounds = bound;
    }

    public void setBounds(long min, long max) {
        this.m_min = min;
        this.m_max = max;
        this.m_bounds = true;
    }

    public void setLimitLength(boolean limit) {
        this.m_limit_length = limit;
    }

    public void setColumns(int cols) {
        this.m_cols = cols;
    }

    public void keyPressed(KeyEvent event) {
        int key = event.getKeyCode();
        if (!this.validEditKey(key)) {
            String text;
            if (this.m_hex && !this.validHexKey(key)) {
                if (!event.isControlDown()) {
                    event.consume();
                    return;
                }
                if (this.validPasteKey(event, key) && !this.checkPasteHex()) {
                    event.consume();
                    return;
                }
            }
            if (this.m_numeric && !this.validNumericKey(key)) {
                if (!event.isControlDown()) {
                    event.consume();
                    return;
                }
                if (this.validPasteKey(event, key) && !this.checkPasteNumeric()) {
                    event.consume();
                    return;
                }
            }
            if (this.m_cols > -1 && this.getSelectionEnd() <= this.getSelectionStart() && this.m_limit_length && (text = this.getText()).length() + 1 > this.m_cols) {
                event.consume();
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void focusGained(FocusEvent e) {
        this.selectAll();
    }

    public void focusLost(FocusEvent e) {
        if (this.m_bounds && (this.m_numeric || this.m_hex)) {
            this.checkBounds();
        } else {
            this.select(0, 0);
        }
    }

    public synchronized Dimension getPreferredSize() {
        if (this.m_cols != -1) {
            return this.getPreferredSize(this.m_cols);
        }
        return super.getPreferredSize();
    }

    public boolean validEditKey(int keyCode) {
        boolean valid = false;
        switch (keyCode) {
            case 8: 
            case 9: 
            case 37: 
            case 39: 
            case 127: {
                valid = true;
                break;
            }
        }
        return valid;
    }

    public boolean validHexKey(int keyCode) {
        boolean valid = false;
        switch (keyCode) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                valid = true;
                break;
            }
        }
        return valid;
    }

    public boolean validNumericKey(int keyCode) {
        boolean valid = false;
        switch (keyCode) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                valid = true;
                break;
            }
        }
        return valid;
    }

    private void checkBounds() {
        block13: {
            long val = this.m_min;
            String text = this.getText();
            if (text.length() <= 0) break block13;
            try {
                if (this.m_numeric) {
                    val = Long.parseLong(text);
                } else if (this.m_hex) {
                    val = Long.parseLong(text, 16);
                }
                if (val > this.m_max) {
                    if (this.m_numeric) {
                        ((TextComponent)this).setText(Long.toString(this.m_max));
                    } else if (this.m_hex) {
                        ((TextComponent)this).setText(Long.toHexString(this.m_max));
                    }
                    this.selectAll();
                    Toolkit.getDefaultToolkit().beep();
                    break block13;
                }
                if (val < this.m_min) {
                    if (this.m_numeric) {
                        ((TextComponent)this).setText(Long.toString(this.m_min));
                    } else if (this.m_hex) {
                        ((TextComponent)this).setText(Long.toHexString(this.m_min));
                    }
                    this.selectAll();
                    Toolkit.getDefaultToolkit().beep();
                    break block13;
                }
                this.select(0, 0);
            }
            catch (NumberFormatException xc) {
                LEDebug.getLog().logln(20, xc);
                ((TextComponent)this).setText("");
            }
        }
    }

    private boolean validCopyKey(KeyEvent event, int key) {
        return key == 67 && event.isControlDown();
    }

    private boolean validPasteKey(KeyEvent event, int key) {
        return key == 86 && event.isControlDown();
    }

    private boolean checkPasteHex() {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable trans = clip.getContents(this);
        if (trans == null) {
            return false;
        }
        try {
            String data = (String)trans.getTransferData(DataFlavor.stringFlavor);
            int i = 0;
            while (i < data.length()) {
                char c = data.charAt(i);
                if (!this.isHexChar(c)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    private boolean checkPasteNumeric() {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable trans = clip.getContents(this);
        if (trans == null) {
            return false;
        }
        try {
            String data = (String)trans.getTransferData(DataFlavor.stringFlavor);
            int i = 0;
            while (i < data.length()) {
                char c = data.charAt(i);
                if (!Character.isDigit(c)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    private boolean isHexChar(char c) {
        if (Character.isDigit(c)) {
            return true;
        }
        if (Character.toLowerCase(c) == 'a') {
            return true;
        }
        if (Character.toLowerCase(c) == 'b') {
            return true;
        }
        if (Character.toLowerCase(c) == 'c') {
            return true;
        }
        if (Character.toLowerCase(c) == 'd') {
            return true;
        }
        if (Character.toLowerCase(c) == 'e') {
            return true;
        }
        return Character.toLowerCase(c) == 'f';
    }
}

