/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LETitleBar
extends Canvas {
    static final int SPACE = 2;
    String m_title;
    int m_thickness = 2;
    int m_border;

    public LETitleBar() {
    }

    public LETitleBar(String title) {
        this.m_title = title;
    }

    public LETitleBar(String title, int border) {
        this.m_title = title;
        this.m_border = border;
    }

    public void setBorder(int border) {
        this.m_border = border;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public synchronized Dimension getMinimumSize() {
        int height = this.m_thickness + this.m_border;
        int width = 0;
        if (this.m_title != null) {
            height += 2;
            Font font = this.getFont();
            if (font != null) {
                FontMetrics fm = this.getFontMetrics(font);
                height += fm.getHeight();
                if (this.m_title != null) {
                    width += fm.stringWidth(this.m_title) + 2 * this.m_border;
                }
            }
        }
        return new Dimension(width, height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics gc) {
        Dimension dim = this.getSize();
        if (this.m_title != null) {
            Font font = gc.getFont();
            if (font != null && (font = new Font(font.getName(), 1, font.getSize())) != null) {
                gc.setFont(font);
            }
            FontMetrics fm = gc.getFontMetrics();
            gc.drawString(this.m_title, this.m_border, fm.getAscent() + this.m_border);
        }
        if (this.m_thickness > 0) {
            gc.fillRect(this.m_border, dim.height - this.m_thickness, dim.width - 2 * this.m_border, this.m_thickness);
        }
    }
}

