/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LETreeEtchedLAF;
import COM.livingston.ui.LETreeEvent;
import COM.livingston.ui.LETreeFlatLAF;
import COM.livingston.ui.LETreeGraphicsInfo;
import COM.livingston.ui.LETreeItem;
import COM.livingston.ui.LETreeLAF;
import COM.livingston.ui.LETreeListener;
import COM.livingston.util.LEDebug;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class LETree
extends Panel
implements MouseListener,
AdjustmentListener {
    LETreeGraphicsInfo m_info;
    LETreeLAF m_selLAF;
    LETreeLAF m_unselLAF;
    LETreeItem m_selected;
    Vector m_items;
    Vector m_listeners;
    int m_rows;
    Dimension m_imgDim;
    int m_width;
    int m_height;
    Image m_offScreen;
    boolean m_redraw;
    int m_x;
    int m_y;
    Scrollbar m_vert;
    Scrollbar m_horz;

    public LETree() {
        this.addMouseListener(this);
        this.m_vert = new Scrollbar(1);
        this.m_vert.addAdjustmentListener(this);
        this.m_horz = new Scrollbar(0);
        this.m_horz.addAdjustmentListener(this);
        this.m_vert.setVisible(false);
        this.m_vert.setEnabled(false);
        this.m_horz.setVisible(false);
        this.m_horz.setEnabled(false);
        this.add(this.m_vert);
        this.add(this.m_horz);
        this.m_info = new LETreeGraphicsInfo();
        this.m_info.setImageObserver(this);
        this.m_items = new Vector();
        this.m_listeners = new Vector();
        this.m_imgDim = new Dimension();
        this.m_selLAF = new LETreeEtchedLAF(this.m_info);
        this.m_unselLAF = new LETreeFlatLAF(this.m_info);
        this.m_info.setMaxBorder(Math.max(this.m_selLAF.getBorder(), this.m_unselLAF.getBorder()));
    }

    public void addNotify() {
        super.addNotify();
        Graphics gc = this.getGraphics();
        this.m_info.setGraphics(gc);
        this.m_info.setGraphics(null);
        gc.dispose();
    }

    public void setDefaultImages(Image colImage, Image expImage) {
        this.m_info.setDefaultImages(colImage, expImage);
    }

    public void addTree(LETreeItem root) {
        this.m_items.addElement(root);
        this.m_rows = root.setPosition(this.m_rows, 0);
        this.m_width = -1;
    }

    public void recalcTree() {
        this.m_rows = 0;
        int len = this.m_items.size();
        int i = 0;
        while (i < len) {
            LETreeItem item = (LETreeItem)this.m_items.elementAt(i);
            this.m_rows = item.setPosition(this.m_rows, 0);
            ++i;
        }
        this.m_width = -1;
        this.repaint();
    }

    public void addListener(LETreeListener listener) {
        this.m_listeners.addElement(listener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_selLAF.setEnabled(enabled);
        this.m_unselLAF.setEnabled(enabled);
        if (this.m_vert.isVisible()) {
            this.m_vert.setEnabled(enabled);
        }
        if (this.m_horz.isVisible()) {
            this.m_horz.setEnabled(enabled);
        }
        this.m_redraw = true;
        this.repaint();
    }

    public void update(Graphics gc) {
        try {
            if (this.m_width == -1) {
                this.m_width = this.determineWidth(this.m_items, gc);
                this.m_height = this.m_rows * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_maxBorder;
            }
            if (this.m_offScreen == null || this.m_width != this.m_imgDim.width || this.m_height != this.m_imgDim.height) {
                this.m_imgDim.width = this.m_width;
                this.m_imgDim.height = this.m_height;
                if (this.m_offScreen != null) {
                    this.m_offScreen.flush();
                }
                this.m_offScreen = this.createImage(this.m_width, this.m_height);
                this.prepareImage(this.m_offScreen, this);
                this.manageScrollbars();
                this.m_redraw = true;
            }
            if (this.m_redraw) {
                LETree lETree = this;
                synchronized (lETree) {
                    Graphics ogc = this.m_offScreen.getGraphics();
                    ogc.setColor(this.getBackground());
                    ogc.setFont(gc.getFont());
                    ogc.fillRect(0, 0, this.m_width, this.m_height);
                    this.m_info.setGraphics(ogc);
                    this.drawTree(this.m_unselLAF);
                    if (this.m_selected != null) {
                        this.drawPath(this.m_selLAF, this.m_selected, null);
                    }
                    this.m_redraw = false;
                    ogc.dispose();
                    this.m_info.setGraphics(null);
                }
            }
            gc.drawImage(this.m_offScreen, this.m_x, this.m_y, this);
            if (this.m_horz.isEnabled() && this.m_vert.isEnabled()) {
                Rectangle hRect = this.m_horz.getBounds();
                Rectangle vRect = this.m_vert.getBounds();
                gc.clearRect(vRect.x, hRect.y, vRect.width, hRect.height);
            }
            Dimension win = this.getSize();
            int extra = win.width - (this.m_width + this.m_x);
            if (extra > 0) {
                gc.clearRect(win.width - extra, 0, extra, win.height);
            }
            if ((extra = win.height - (this.m_height + this.m_y)) > 0) {
                gc.clearRect(0, win.height - extra, win.width, extra);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public void paint(Graphics gc) {
        this.update(gc);
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 400);
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        this.m_x = -this.m_horz.getValue();
        this.m_y = -this.m_vert.getValue();
        this.repaint();
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isConsumed() || !this.isEnabled()) {
            return;
        }
        int x = event.getX();
        int y = event.getY();
        Graphics gc = this.m_offScreen.getGraphics();
        LETreeItem item = this.getItemAt(x, y, gc);
        gc.dispose();
        if (item != null && item != this.m_selected) {
            this.select(item, true);
        }
        if (item != null && event.getClickCount() > 1) {
            if (item.m_children != null) {
                item.m_collapsed = !item.m_collapsed;
                this.recalcTree();
            }
            this.notifyListeners(3, item);
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public synchronized void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.doLayout();
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.doLayout();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.doLayout();
    }

    public synchronized void doLayout() {
        if (this.m_width > -1) {
            this.manageScrollbars();
        }
    }

    public void drawTree(LETreeLAF laf) {
        int len = this.m_items.size();
        int i = 0;
        while (i < len) {
            LETreeItem item = (LETreeItem)this.m_items.elementAt(i);
            this.drawItem(laf, item);
            ++i;
        }
    }

    public void drawItem(LETreeLAF laf, LETreeItem item) {
        laf.drawItem(item);
        if (!item.m_collapsed && item.m_children != null) {
            LETreeItem last = item;
            int numChildren = item.m_children.size();
            int i = 0;
            while (i < numChildren) {
                LETreeItem child = (LETreeItem)item.m_children.elementAt(i);
                this.drawItem(laf, child);
                if (i == numChildren - 1) {
                    laf.drawConnection(2, last.m_row, child);
                } else {
                    laf.drawConnection(1, last.m_row, child);
                }
                last = child;
                ++i;
            }
        }
    }

    public void drawPath(LETreeLAF laf, LETreeItem item, LETreeItem child) {
        laf.drawItem(item);
        if (child != null) {
            laf.drawConnection(2, item.m_row, child);
        }
        if (item.m_parent != null) {
            this.drawPath(laf, item.m_parent, item);
        }
    }

    public LETreeItem getItemAt(int x, int y, Graphics gc) {
        x -= this.m_x;
        int row = ((y -= this.m_y) - this.m_info.m_maxBorder) / (this.m_info.m_rowHeight + this.m_info.m_rowOffset);
        LETreeItem item = this.getItemRow(this.m_items, row);
        if (item != null) {
            int left = item.m_column * this.m_info.m_colOffset;
            int right = this.getItemWidth(item, gc);
            if (x < left || x > right) {
                item = null;
            }
        }
        return item;
    }

    public LETreeItem getItemRow(Vector items, int row) {
        LETreeItem item = null;
        LETreeItem found = null;
        int len = items.size();
        int i = 0;
        while (i < len) {
            item = (LETreeItem)items.elementAt(i);
            if (item.m_row == row) {
                found = item;
            } else if (!item.m_collapsed && item.m_children != null) {
                found = this.getItemRow(item.m_children, row);
            }
            if (found != null) break;
            ++i;
        }
        return found;
    }

    public LETreeItem getSelectedItem() {
        return this.m_selected;
    }

    public Vector getRoots() {
        return this.m_items;
    }

    public void select(LETreeItem item, boolean notify) {
        if (notify && this.m_selected != null) {
            this.notifyListeners(2, this.m_selected);
        }
        boolean recalc = false;
        LETreeItem tmp = item.m_parent;
        while (tmp != null) {
            if (tmp.m_collapsed) {
                tmp.m_collapsed = false;
                recalc = true;
            }
            tmp = tmp.m_parent;
        }
        this.m_selected = item;
        this.recalcTree();
        this.m_redraw = true;
        this.repaint();
        if (notify && this.m_selected != null) {
            this.notifyListeners(1, this.m_selected);
        }
    }

    int getItemWidth(LETreeItem item, Graphics gc) {
        int width = item.m_column * this.m_info.m_colOffset + 2 * this.m_info.m_maxBorder + 2 * this.m_info.m_cellInset + this.m_info.m_maxImageWidth + this.m_info.m_imageBuffer + gc.getFontMetrics().stringWidth(item.m_label);
        return width;
    }

    void notifyListeners(int id, LETreeItem item) {
        LETreeEvent event = new LETreeEvent(id, item);
        int len = this.m_listeners.size();
        int i = 0;
        while (i < len) {
            LETreeListener listener = (LETreeListener)this.m_listeners.elementAt(i);
            if (listener != null) {
                listener.onLETreeEvent(event);
            }
            ++i;
        }
    }

    int determineWidth(Vector items, Graphics gc) {
        int maxW = 0;
        int len = items.size();
        int i = 0;
        while (i < len) {
            LETreeItem item = (LETreeItem)items.elementAt(i);
            int itemW = this.getItemWidth(item, gc);
            int n = maxW = itemW > maxW ? itemW : maxW;
            if (!item.m_collapsed && item.m_children != null) {
                itemW = this.determineWidth(item.m_children, gc);
            }
            maxW = itemW > maxW ? itemW : maxW;
            ++i;
        }
        return maxW;
    }

    void manageScrollbars() {
        Dimension vertD = this.m_vert.getPreferredSize();
        Dimension horzD = this.m_horz.getPreferredSize();
        Dimension dim = this.getSize();
        int horzDiff = this.m_width - dim.width;
        int vertDiff = this.m_height - dim.height;
        if (horzDiff > 0 && vertDiff > 0) {
            this.manageVSB(true, dim.height - horzD.height, this.m_height, dim.width - vertD.width, 0, vertD.width, dim.height - horzD.height);
            this.manageHSB(true, dim.width - vertD.width, this.m_width, 0, dim.height - horzD.height, dim.width - vertD.width, horzD.height);
        } else if (horzDiff > 0 && vertDiff + horzD.height > 0) {
            this.manageVSB(true, dim.height - horzD.height, this.m_height, dim.width - vertD.width, 0, vertD.width, dim.height - horzD.height);
            this.manageHSB(true, dim.width - vertD.width, this.m_width, 0, dim.height - horzD.height, dim.width - vertD.width, horzD.height);
        } else if (vertDiff > 0 && horzDiff + vertD.width > 0) {
            this.manageVSB(true, dim.height - horzD.height, this.m_height, dim.width - vertD.width, 0, vertD.width, dim.height - horzD.height);
            this.manageHSB(true, dim.width - vertD.width, this.m_width, 0, dim.height - horzD.height, dim.width - vertD.width, horzD.height);
        } else if (horzDiff > 0) {
            this.manageVSB(false, 0, 0, 0, 0, 0, 0);
            this.manageHSB(true, dim.width, this.m_width, 0, dim.height - horzD.height, dim.width, horzD.height);
        } else if (vertDiff > 0) {
            this.manageVSB(true, dim.height, this.m_height, dim.width - vertD.width, 0, vertD.width, dim.height);
            this.manageHSB(false, 0, 0, 0, 0, 0, 0);
        } else {
            this.manageVSB(false, 0, 0, 0, 0, 0, 0);
            this.manageHSB(false, 0, 0, 0, 0, 0, 0);
        }
    }

    void manageVSB(boolean show, int visible, int max, int x, int y, int w, int h) {
        if (show) {
            int old = 0;
            if (this.m_vert.isEnabled()) {
                old = this.m_vert.getValue();
            }
            old = old > max ? max : old;
            this.m_y = -old;
            this.m_vert.setBounds(x, y, w, h);
            this.m_vert.setValues(old, visible, 0, max);
            this.m_vert.setUnitIncrement(this.m_info.m_rowHeight + this.m_info.m_rowOffset);
            this.m_vert.setBlockIncrement(h);
            this.m_vert.setVisible(true);
            if (this.isEnabled()) {
                this.m_vert.setEnabled(true);
            } else {
                this.m_vert.setEnabled(false);
            }
        } else {
            this.m_vert.setVisible(false);
            this.m_vert.setEnabled(false);
            this.m_y = 0;
        }
    }

    void manageHSB(boolean show, int visible, int max, int x, int y, int w, int h) {
        if (show) {
            int old = 0;
            if (this.m_horz.isEnabled()) {
                old = this.m_horz.getValue();
            }
            old = old > max ? max : old;
            this.m_x = -old;
            this.m_horz.setBounds(x, y, w, h);
            this.m_horz.setValues(0, visible, 0, max);
            this.m_horz.setUnitIncrement(this.m_info.m_colOffset);
            this.m_horz.setBlockIncrement(w);
            this.m_horz.setVisible(true);
            if (this.isEnabled()) {
                this.m_horz.setEnabled(true);
            } else {
                this.m_horz.setEnabled(false);
            }
        } else {
            this.m_horz.setVisible(false);
            this.m_horz.setEnabled(false);
            this.m_x = 0;
        }
    }

    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0) {
            this.m_redraw = true;
            this.repaint();
            return false;
        }
        return true;
    }
}

