/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LEColor;
import COM.livingston.ui.LETreeGraphicsInfo;
import COM.livingston.ui.LETreeItem;
import COM.livingston.ui.LETreeLAF;
import java.awt.Color;

public class LETreeEtchedLAF
extends LETreeLAF {
    Color m_light;
    Color m_dark;

    public LETreeEtchedLAF(LETreeGraphicsInfo info) {
        super(info);
        this.m_border = 3;
        this.m_fore = LEColor.getSelectForeground();
        this.m_back = LEColor.getSelectBackground();
        this.m_light = LEColor.getSelectShadowLight();
        this.m_dark = LEColor.getSelectShadowDark();
    }

    void drawItemBackground(LETreeItem item, int x, int y, int w, int h) {
        int x2 = x + w - 1;
        int y2 = y + h - 1;
        this.m_info.m_gc.fillRect(x, y, w, h);
        this.m_info.m_gc.setColor(this.m_dark);
        this.m_info.m_gc.drawLine(x, y, x2, y);
        this.m_info.m_gc.drawLine(x, y, x, y2);
        this.m_info.m_gc.drawLine(x + 3, y2 - 2, x2 - 2, y2 - 2);
        this.m_info.m_gc.drawLine(x2 - 2, y + 3, x2 - 2, y2 - 2);
        this.m_info.m_gc.setColor(this.m_light);
        this.m_info.m_gc.drawLine(x + 1, y2, x2, y2);
        this.m_info.m_gc.drawLine(x2, y + 1, x2, y2);
        this.m_info.m_gc.drawLine(x + 2, y + 2, x2 - 2, y + 2);
        this.m_info.m_gc.drawLine(x + 2, y + 2, x + 2, y2 - 2);
    }

    void drawLConnection(LETreeItem item, int x, int y, int w, int h) {
        int x1 = x + w / 2;
        int x2 = x + w - this.m_border;
        int y1 = y + this.m_border - 1;
        int y2 = y + h - 1 - this.m_info.m_rowHeight / 2;
        this.drawLineV(x1, y1, y2);
        this.drawLineH(x1, x2, y2);
        this.drawLJoint(x1, y2);
    }

    void drawTConnection(LETreeItem item, int x, int y, int w, int h) {
        int x1 = x + w / 2;
        int x2 = x + w - this.m_border;
        int y1 = y + this.m_border - 1;
        int y2 = y + h - 1;
        int y3 = y + h - 1 - this.m_info.m_rowHeight / 2;
        this.drawLineV(x1, y1, y2);
        this.drawLineH(x1, x2, y3);
        this.drawTJoint(x1, y3);
    }

    void drawLineV(int x, int y1, int y2) {
        this.m_info.m_gc.setColor(this.m_back);
        this.m_info.m_gc.drawLine(x, y1, x, y2);
        this.m_info.m_gc.setColor(this.m_dark);
        this.m_info.m_gc.drawLine(x - 1, y1, x - 1, y2);
        this.m_info.m_gc.setColor(this.m_light);
        this.m_info.m_gc.drawLine(x + 1, y1, x + 1, y2);
    }

    void drawLineH(int x1, int x2, int y) {
        this.m_info.m_gc.setColor(this.m_back);
        this.m_info.m_gc.drawLine(x1, y, x2, y);
        this.m_info.m_gc.setColor(this.m_dark);
        this.m_info.m_gc.drawLine(x1, y - 1, x2, y - 1);
        this.m_info.m_gc.setColor(this.m_light);
        this.m_info.m_gc.drawLine(x1, y + 1, x2, y + 1);
    }

    void drawLJoint(int x, int y) {
        this.m_info.m_gc.setColor(this.m_back);
        this.m_info.m_gc.drawLine(x, y - 1, x, y);
        this.m_info.m_gc.drawLine(x + 1, y, x + 1, y);
        this.m_info.m_gc.setColor(this.m_dark);
        this.m_info.m_gc.drawLine(x - 1, y - 1, x - 1, y + 1);
        this.m_info.m_gc.setColor(this.m_light);
        this.m_info.m_gc.drawLine(x, y + 1, x + 1, y + 1);
        this.m_info.m_gc.drawLine(x + 1, y - 1, x + 1, y - 1);
    }

    void drawTJoint(int x, int y) {
        this.m_info.m_gc.setColor(this.m_dark);
        this.m_info.m_gc.drawLine(x - 1, y - 1, x - 1, y + 1);
        this.m_info.m_gc.setColor(this.m_back);
        this.m_info.m_gc.drawLine(x, y - 1, x, y + 1);
        this.m_info.m_gc.drawLine(x + 1, y, x + 1, y);
        this.m_info.m_gc.setColor(this.m_light);
        this.m_info.m_gc.drawLine(x + 1, y - 1, x + 1, y - 1);
        this.m_info.m_gc.drawLine(x + 1, y + 1, x + 1, y + 1);
    }
}

