/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

public class LETreeGraphicsInfo {
    public int m_rowHeight;
    public int m_rowOffset;
    public int m_colOffset = 20;
    public int m_maxBorder;
    public int m_maxImageWidth = 12;
    public int m_maxImageHeight = 12;
    public int m_imageBuffer = 2;
    public int m_cellInset = 2;
    public Graphics m_gc;
    public FontMetrics m_fm;
    public int m_fontAdj;
    public Image m_expImage;
    public Image m_colImage;
    public ImageObserver m_observer;

    public void setImageObserver(ImageObserver observer) {
        this.m_observer = observer;
    }

    public void setMaxBorder(int maxBorder) {
        this.m_maxBorder = maxBorder;
        this.m_rowOffset = 2 * this.m_maxBorder + 1;
    }

    public void setDefaultImages(Image colImage, Image expImage) {
        this.m_colImage = colImage;
        this.m_expImage = expImage;
    }

    public void setGraphics(Graphics gc) {
        this.m_gc = gc;
        if (this.m_gc != null) {
            this.m_fm = this.m_gc.getFontMetrics();
            int height = this.m_fm.getHeight() - this.m_fm.getLeading();
            this.m_rowHeight = height = Math.max(height, this.m_maxImageHeight);
            int extra = this.m_rowHeight - height;
            this.m_fontAdj = this.m_fm.getAscent();
            if (extra > 0) {
                this.m_fontAdj += extra / 2;
            }
        }
    }
}

