/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LETreeGraphicsInfo;
import COM.livingston.ui.LETreeItem;
import java.awt.Color;
import java.awt.Image;

public abstract class LETreeLAF {
    public static final int T_CONNECT = 1;
    public static final int L_CONNECT = 2;
    LETreeGraphicsInfo m_info;
    int m_border;
    Color m_fore;
    Color m_back;

    public LETreeLAF(LETreeGraphicsInfo info) {
        this.m_info = info;
    }

    public int getBorder() {
        return this.m_border;
    }

    public void setEnabled(boolean enabled) {
    }

    public void drawItem(LETreeItem item) {
        int x = item.m_column * this.m_info.m_colOffset + this.m_info.m_maxBorder - this.m_border;
        int y = item.m_row * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_maxBorder - this.m_border;
        int w = 2 * this.m_info.m_cellInset + 2 * this.m_border + this.m_info.m_maxImageWidth + this.m_info.m_imageBuffer + this.m_info.m_fm.stringWidth(item.m_label);
        int h = this.m_info.m_rowHeight + 2 * this.m_border;
        this.m_info.m_gc.setColor(this.m_back);
        this.drawItemBackground(item, x, y, w, h);
        this.m_info.m_gc.setColor(this.m_fore);
        this.drawItemForeground(item, x += this.m_border, y += this.m_border, w -= 2 * this.m_border, h -= 2 * this.m_border);
    }

    public void drawConnection(int type, int row, LETreeItem item) {
        int x = (item.m_column - 1) * this.m_info.m_colOffset + this.m_info.m_maxBorder;
        int y = row * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_maxBorder + this.m_info.m_rowHeight;
        int w = this.m_info.m_colOffset;
        int h = item.m_row * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_rowHeight + this.m_info.m_maxBorder - y;
        switch (type) {
            case 1: {
                this.drawTConnection(item, x, y, w, h);
                break;
            }
            case 2: {
                this.drawLConnection(item, x, y, w, h);
                break;
            }
        }
    }

    void drawItemBackground(LETreeItem item, int x, int y, int w, int h) {
    }

    void drawItemForeground(LETreeItem item, int x, int y, int w, int h) {
        Image img;
        Image image = img = item.m_collapsed ? item.m_colImage : item.m_expImage;
        if (img == null && item.m_children != null) {
            img = item.m_collapsed ? this.m_info.m_colImage : this.m_info.m_expImage;
        }
        x += this.m_info.m_cellInset;
        if (img != null) {
            int height = img.getHeight(this.m_info.m_observer);
            height = Math.min(height, this.m_info.m_maxImageHeight);
            int y1 = y + (this.m_info.m_rowHeight - height) / 2;
            this.m_info.m_gc.drawImage(img, x, y1, this.m_info.m_observer);
        }
        this.m_info.m_gc.drawString(item.m_label, x += this.m_info.m_maxImageWidth + this.m_info.m_imageBuffer, y + this.m_info.m_fontAdj);
    }

    abstract void drawTConnection(LETreeItem var1, int var2, int var3, int var4, int var5);

    abstract void drawLConnection(LETreeItem var1, int var2, int var3, int var4, int var5);
}

