/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.util.LEHelpManager;
import COM.livingston.util.LEVector;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LETriStateBox
extends Canvas
implements MouseListener,
KeyListener,
FocusListener {
    public static final int ON = 2;
    public static final int MID = 1;
    public static final int OFF = 0;
    private static final int SIZE = 15;
    private static final int INSET = 2;
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    String m_label;
    int m_label_size;
    int m_state;
    int m_height;
    int m_width;
    LEVector m_states;
    boolean m_pressed;
    boolean m_enabled;
    boolean m_frozen;
    boolean m_tri;
    boolean m_help;

    public LETriStateBox() {
        this.initialize();
        this.m_state = 0;
        this.determineSize();
        this.setSize(this.m_width, this.m_height);
    }

    public LETriStateBox(String label, int state) {
        this.initialize();
        this.setLabel(label);
        this.determineSize();
        this.setSize(this.m_width, this.m_height);
        this.m_state = state;
    }

    public LETriStateBox(String label) {
        this.initialize();
        this.setLabel(label);
        this.determineSize();
        this.setSize(this.m_width, this.m_height);
        this.m_state = 0;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public void setState(int state) {
        this.m_state = state;
        this.repaint();
    }

    public void setEnabled(boolean state) {
        this.m_enabled = state;
    }

    public void setFrozen(boolean frozen) {
        this.m_frozen = frozen;
    }

    public void setThreeWay(boolean three) {
        this.m_tri = three;
    }

    public void setHelp(LEVector states) {
        if (states != null) {
            this.m_help = true;
            this.m_states = states;
        } else {
            this.m_help = false;
            this.m_states = null;
        }
    }

    public int getState() {
        return this.m_state;
    }

    public String getLabel() {
        return this.m_label;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isFrozen() {
        return this.m_frozen;
    }

    public boolean isThreeWay() {
        return this.m_tri;
    }

    public void addNotify() {
        super.addNotify();
    }

    public Dimension getMininumSize() {
        this.determineSize();
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.repaint();
    }

    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return this.isEnabled() && !this.isFrozen();
    }

    public void paint(Graphics gc) {
        Dimension dim = this.getSize();
        int x = 2;
        int y = 2;
        int x2 = x + 15;
        int y2 = y + 15;
        this.drawTriBox(gc, Color.white);
        int label_x = x + 15 + 2 + 2;
        if (this.m_enabled) {
            gc.setColor(Color.black);
            if (this.m_label != null) {
                gc.drawString(this.m_label, label_x, y + 15 - 2);
            }
        } else {
            gc.setColor(Color.white);
            if (this.m_label != null) {
                gc.drawString(this.m_label, label_x + 1, y + 15 - 1);
            }
            gc.setColor(Color.gray);
            if (this.m_label != null) {
                gc.drawString(this.m_label, label_x, y + 15 - 2);
            }
        }
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
        if (this.m_help) {
            LEHelpManager.SetHelp(this.getValidValues());
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.m_help) {
            LEHelpManager.SetHelp("");
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.isConsumed() || !this.isEnabled() || this.isFrozen()) {
            return;
        }
        this.m_pressed = true;
        Graphics gc = this.getGraphics();
        this.drawTriBox(gc, Color.lightGray);
        gc.dispose();
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isConsumed() || !this.m_pressed || !this.isEnabled() || this.isFrozen()) {
            return;
        }
        this.m_pressed = false;
        this.switchState();
        this.requestFocus();
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == ' ' && this.isEnabled()) {
            this.m_pressed = true;
            Graphics gc = this.getGraphics();
            this.drawTriBox(gc, Color.lightGray);
            gc.dispose();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (!this.m_pressed || !this.isEnabled()) {
            return;
        }
        this.m_pressed = false;
        this.switchState();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Graphics gc = this.getGraphics();
        this.drawHighlight(gc);
        gc.dispose();
    }

    public void focusLost(FocusEvent e) {
        Graphics gc = this.getGraphics();
        this.eraseHighlight(gc);
        gc.dispose();
    }

    private void initialize() {
        this.m_pressed = false;
        this.m_label_size = 0;
        this.m_enabled = true;
        this.m_frozen = false;
        this.m_help = false;
        this.m_states = null;
        this.m_tri = true;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    private String getValidValues() {
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        while (i < this.m_states.size()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)this.m_states.elementAt(i));
            ++i;
        }
        return buf.toString();
    }

    private void drawTriBox(Graphics gc, Color background) {
        int x = 2;
        int y = 2;
        int x2 = x + 15;
        int y2 = y + 15;
        gc.setColor(background);
        gc.fillRect(3, 3, 15, 15);
        gc.setColor(Color.darkGray);
        gc.drawLine(x, y, x2 - 2, y);
        gc.drawLine(x, y, x, y2 - 2);
        gc.setColor(Color.white);
        gc.drawLine(x2, y, x2, y2);
        gc.drawLine(x, y2, x2, y2);
        gc.setColor(Color.darkGray);
        gc.drawLine(x + 1, y + 1, x2 - 2, y + 1);
        gc.drawLine(x + 1, y + 1, x + 1, y2 - 2);
        gc.setColor(Color.lightGray);
        gc.drawLine(x2 - 1, y + 1, x2 - 1, y2);
        gc.drawLine(x + 1, y2 - 1, x2 - 1, y2 - 1);
        if (this.m_state == 2) {
            this.drawOn(gc);
        } else if (this.m_state == 1) {
            this.drawMid(gc);
        }
    }

    private void drawOn(Graphics gc) {
        int x = 6;
        int y = 6;
        int mid = 9;
        int x2 = 13;
        int y2 = 13;
        if (this.isEnabled()) {
            gc.setColor(Color.black);
        } else {
            gc.setColor(Color.lightGray);
        }
        gc.drawLine(x, mid, x2, mid);
        gc.drawLine(x, mid + 1, x2, mid + 1);
        gc.drawLine(mid, y, mid, y2);
        gc.drawLine(mid + 1, y, mid + 1, y2);
    }

    private void drawMid(Graphics gc) {
        int x = 6;
        int y = 9;
        int x2 = 13;
        int y2 = 9;
        if (this.isEnabled()) {
            gc.setColor(Color.black);
        } else {
            gc.setColor(Color.lightGray);
        }
        gc.drawLine(x, y, x2, y2);
        gc.drawLine(x, y + 1, x2, y2 + 1);
    }

    private void determineSize() {
        if (this.m_label != null && this.m_label.length() > 0) {
            this.m_height = 21;
            this.m_width = 19 + this.m_label.length() * 10;
        } else {
            this.m_width = 21;
            this.m_height = 21;
        }
    }

    private void switchState() {
        this.m_state = this.m_state == 0 ? 2 : (this.m_tri ? --this.m_state : 0);
        Graphics gc = this.getGraphics();
        this.drawTriBox(gc, Color.white);
        gc.dispose();
    }

    private void drawHighlight(Graphics gc) {
        if (this.m_label == null || this.m_label.length() == 0) {
            return;
        }
        FontMetrics fm = gc.getFontMetrics();
        int strWidth = fm.stringWidth(this.m_label);
        int x = 19;
        int y = 2;
        int x2 = x + strWidth + 2 + 2;
        int y2 = 17;
        this.drawDottedLine(gc, Color.black, x, x2, y, 1);
        this.drawDottedLine(gc, Color.black, x, x2, y2, 1);
        this.drawDottedLine(gc, Color.black, y, y2, x, 2);
        this.drawDottedLine(gc, Color.black, y, y2, x2, 2);
    }

    private void eraseHighlight(Graphics gc) {
        if (this.m_label == null || this.m_label.length() == 0) {
            return;
        }
        FontMetrics fm = gc.getFontMetrics();
        int strWidth = fm.stringWidth(this.m_label);
        int x = 19;
        int y = 2;
        int x2 = x + strWidth + 2 + 2;
        int y2 = 17;
        Color bg = this.getBackground();
        this.drawDottedLine(gc, bg, x, x2, y, 1);
        this.drawDottedLine(gc, bg, x, x2, y2, 1);
        this.drawDottedLine(gc, bg, y, y2, x, 2);
        this.drawDottedLine(gc, bg, y, y2, x2, 2);
    }

    private void drawDottedLine(Graphics gc, Color fg, int begin, int finish, int other, int direction) {
        gc.setColor(fg);
        if (direction == 1) {
            int i = begin;
            while (i <= finish) {
                gc.drawLine(i, other, i, other);
                i += 2;
            }
        } else {
            int i = begin;
            while (i <= finish) {
                gc.drawLine(other, i, other, i);
                i += 2;
            }
        }
    }
}

