/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEAboutDialog;
import COM.livingston.ui.LEActionClient;
import COM.livingston.ui.LEActionDialog;
import COM.livingston.ui.LEClipboard;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEConnectDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LELEDs;
import COM.livingston.ui.LELoginClient;
import COM.livingston.ui.LEStatusBar;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEProperties;
import COM.livingston.util.LEResource;
import COM.livingston.util.LEStatusManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import oracle.help.Book;
import oracle.help.Help;

public class LEEditorWindow
extends Frame
implements WindowListener,
ActionListener,
LEActionClient,
LELoginClient,
LEConfirmClient {
    public static final String ABOUT = "About";
    public static final String NEW_FILTER = "NewFilter";
    public static final String FF_READ = "FFRead";
    public static final String CHOICE_READ = "ChoiceRead";
    public static final String CONNECT = "Connect";
    public static final String COPY = "Copy";
    public static final String EXPORT = "Export";
    public static final String PM_READ = "PMRead";
    public static final String FF_SAVE = "FFSave";
    public static final String PM_SAVE = "PMSave";
    public static final String QUIT = "Quit";
    public static final String HELP = "Help";
    static final String DONT_SAVE = "Don't Save";
    static final String SAVE = "Save";
    static final String CANCEL = "Cancel";
    public static final String PROPERTIES_FILE = "feprops.cfg";
    static final String PROP_TOP_H = "top_h";
    static final String PROP_BOTTOM_H = "bottom_h";
    static final String PROP_MAIN_X = "main_x";
    static final String PROP_MAIN_Y = "main_y";
    static final String PROP_MAIN_W = "main_w";
    static final String PROP_MAIN_H = "main_h";
    MenuBar m_menubar;
    LEEditorPanel m_topPanel;
    String m_hostname;
    String m_username;
    String m_password;
    LEPortMaster m_pm;
    LEFilterMediator m_mediator;
    static String s_prop_path;
    Rectangle m_mainBounds;
    int m_topHeight = 240;
    int m_bottomHeight = 240;
    Book m_book;
    Help m_help;
    static /* synthetic */ Class class$fehlp$FilterEditorHelp;

    public LEEditorWindow() {
        super(LEAppInfo.getAppTitle());
        this.addNotify();
        this.m_mediator = new LEFilterMediator();
        LELEDs.Initialize();
        LEUiUtils.SetBaseFrame(this);
        LEProperties.SetPropertyFile(LEAppInfo.getUserAppDirPath(PROPERTIES_FILE));
        this.loadProperties();
        ((Component)this).setBackground(LEColor.getBackground());
        this.addWindowListener(this);
        Image image = LEResource.GetImage("lucent_32.gif");
        if (image instanceof Image) {
            this.setIconImage(image);
        }
        this.m_menubar = this.createMenuBar();
        this.setMenuBar(this.m_menubar);
        this.m_topPanel = new LEEditorPanel(this.m_mediator, this.m_topHeight, this.m_bottomHeight);
        this.add(this.m_topPanel);
        try {
            LEPortMaster lEPortMaster = new LEPortMaster(LEAppInfo.getUserAppDir(), "untitled");
            LEFilters lEFilters = new LEFilters(null);
            lEPortMaster.set("filter", lEFilters);
            this.m_mediator.add(lEPortMaster);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.positionWindow();
        try {
            this.m_book = Help.createBook((Class)(class$fehlp$FilterEditorHelp != null ? class$fehlp$FilterEditorHelp : (class$fehlp$FilterEditorHelp = LEEditorWindow.class$("fehlp.FilterEditorHelp"))), (String)".", (String)"FilterEditor", (String)"FilterEditor Help");
            if (this.m_book != null) {
                this.m_help = new Help();
                this.m_help.addBook(this.m_book);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            LEDebug.getLog().logln(20, "Help system disabled");
        }
        ((Component)this).setVisible(true);
    }

    public void addNotify() {
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
    }

    public void getInitialFilters() {
        String string = ".";
        LEPortMaster lEPortMaster = null;
        String string2 = LEAppInfo.getFlag("-h");
        try {
            ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
            if (string2 != null) {
                String string3 = LEAppInfo.getFlag("-p");
                String string4 = LEAppInfo.getFlag("-u") != null ? LEAppInfo.getFlag("-u") : "!root";
                lEPortMaster = new LEPortMaster(string2, string4, string3);
            } else {
                String string5 = LEAppInfo.getFlag("-f");
                if (string5 != null) {
                    String string6;
                    int n = string5.lastIndexOf(File.pathSeparatorChar);
                    if (n >= 0) {
                        string = string5.substring(0, n);
                        string6 = string5.substring(n);
                    } else {
                        string6 = string5;
                    }
                    lEPortMaster = new LEPortMaster(string, string6);
                }
            }
            ((Component)this).setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        if (lEPortMaster != null) {
            this.getPortMasterFilters(lEPortMaster);
        }
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(SAVE)) {
            this.m_mediator.saveAll();
        } else if (string.equals(CANCEL)) {
            return;
        }
        this.saveProperties();
        System.exit(0);
    }

    public void cancelAction(Object object) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(QUIT)) {
            this.quit();
            return;
        }
        if (string.equals(FF_READ)) {
            this.open();
            return;
        }
        if (string.equals(CONNECT)) {
            LEConnectDialog.Show(this, this);
            return;
        }
        if (string.equals(ABOUT)) {
            LEAboutDialog.Show(this);
            return;
        }
        if (string.equals(HELP)) {
            this.showHelp();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.quit();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.quit();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void loginTo(String string, String string2, String string3) {
        this.m_hostname = string;
        this.m_password = string3;
        this.m_username = string2;
        LEActionDialog lEActionDialog = new LEActionDialog((Frame)this, "Connecting", this, LEStatusManager.GetManager());
        new Thread(lEActionDialog).start();
        ((Component)lEActionDialog).setVisible(true);
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        try {
            LEStatusBar lEStatusBar = lEActionDialog.getStatusBar();
            lEStatusBar.setStatusText("Connecting to " + this.m_hostname + "...");
            this.m_pm = new LEPortMaster(this.m_hostname, this.m_username, this.m_password);
            if (this.m_hostname == null) {
                this.m_pm.disconnect();
                this.m_pm = null;
                return;
            }
            LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
            if (lEDSSPortMaster == null || !lEDSSPortMaster.isConnected()) {
                new LEErrorDialog((Frame)this, new String("Failed to connect to " + this.m_hostname));
                this.m_pm = null;
            }
            return;
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            this.m_pm = null;
            new LEErrorDialog((Frame)this, new String("Invalid password!"));
            return;
        }
        catch (Exception exception) {
            this.m_pm = null;
            LEDebug.getLog().logln(20, exception);
            if (this.m_hostname != null) {
                new LEErrorDialog((Frame)this, exception.getMessage());
            }
            return;
        }
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        this.getPortMasterFilters(this.m_pm);
        this.actionCancel(lEActionDialog);
    }

    public void actionCancel(LEActionDialog lEActionDialog) {
        this.m_pm = null;
        this.m_hostname = null;
        this.m_password = null;
    }

    private void quit() {
        if (!this.m_mediator.needToSave()) {
            this.saveProperties();
            System.exit(0);
            return;
        }
        String string = "There are filters that need to be saved.";
        String[] stringArray = new String[]{DONT_SAVE, SAVE, CANCEL};
        LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.GetBaseFrame(), (LEConfirmClient)this, string, stringArray, null);
        ((Component)lEConfirmDialog).setVisible(true);
    }

    private void open() {
        String string = LEAppInfo.getUserAppDir();
        FileDialog fileDialog = new FileDialog((Frame)this, "Open Filter File", 0);
        fileDialog.setDirectory(string);
        fileDialog.show();
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            this.readFilters(string2, string3);
        }
    }

    private void readFilters(String string, String string2) {
        try {
            LEPortMaster lEPortMaster = new LEPortMaster(string, string2);
            lEPortMaster.get("filter");
            this.m_mediator.add(lEPortMaster);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    private void positionWindow() {
        int n = this.m_mainBounds.width;
        int n2 = this.m_mainBounds.height;
        int n3 = this.m_mainBounds.x;
        int n4 = this.m_mainBounds.y;
        ((Component)this).setLocation(n3, n4);
        ((Component)this).setSize(n, n2);
    }

    private MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("Edit");
        Menu menu3 = new Menu("Filters");
        Menu menu4 = new Menu(HELP);
        MenuItem menuItem = new MenuItem("Open File...");
        menuItem.setActionCommand(FF_READ);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        MenuItem menuItem2 = new MenuItem("Connect...");
        menuItem2.setActionCommand(CONNECT);
        menuItem2.addActionListener(this);
        menu.add(menuItem2);
        menu.addSeparator();
        MenuItem menuItem3 = new MenuItem(SAVE);
        menuItem3.setActionCommand("save");
        menuItem3.addActionListener(this.m_mediator);
        menuItem3.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem3, "save");
        menu.add(menuItem3);
        MenuItem menuItem4 = new MenuItem("Save all");
        menuItem4.setActionCommand("save_all");
        menuItem4.addActionListener(this.m_mediator);
        menuItem4.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem4, "save_all");
        menu.add(menuItem4);
        menu.addSeparator();
        MenuItem menuItem5 = new MenuItem("Export Filters to File...");
        menuItem5.setActionCommand("export_filter");
        menuItem5.addActionListener(this.m_mediator);
        menuItem5.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem5, "export_filter");
        menu.add(menuItem5);
        MenuItem menuItem6 = new MenuItem("Import ChoiceNet Filter...");
        menuItem6.setActionCommand("import_choice");
        menuItem6.addActionListener(this.m_mediator);
        this.m_mediator.setMenuItem(menuItem6, "import_choice");
        menu.add(menuItem6);
        MenuItem menuItem7 = new MenuItem("Export Filter to ChoiceNet File...");
        menuItem7.setActionCommand("export_choice");
        menuItem7.addActionListener(this.m_mediator);
        menuItem7.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem7, "export_choice");
        menu.add(menuItem7);
        menu.addSeparator();
        MenuItem menuItem8 = new MenuItem("Exit");
        menuItem8.setActionCommand(QUIT);
        menuItem8.addActionListener(this);
        menu.add(menuItem8);
        MenuItem menuItem9 = new MenuItem("Cut");
        menuItem9.setEnabled(false);
        menu2.add(menuItem9);
        MenuItem menuItem10 = new MenuItem(COPY);
        menu2.add(menuItem10);
        MenuItem menuItem11 = new MenuItem("Paste");
        menu2.add(menuItem11);
        MenuItem menuItem12 = new MenuItem("Delete");
        menuItem12.setEnabled(false);
        menu2.add(menuItem12);
        LEClipboard lEClipboard = LEClipboard.GetClipboard();
        lEClipboard.setMenuItems(menuItem9, menuItem10, menuItem11, menuItem12);
        lEClipboard.reset();
        this.m_mediator.set(lEClipboard);
        MenuItem menuItem13 = new MenuItem("New Filter...");
        menuItem13.setActionCommand("new_filter");
        menuItem13.addActionListener(this.m_mediator);
        menuItem13.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem13, "new_filter");
        menu3.add(menuItem13);
        MenuItem menuItem14 = new MenuItem("Rename Filter...");
        menuItem14.setActionCommand("rename_filter");
        menuItem14.addActionListener(this.m_mediator);
        menuItem14.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem14, "rename_filter");
        menu3.add(menuItem14);
        MenuItem menuItem15 = new MenuItem("Clone Filter...");
        menuItem15.setActionCommand("clone_filter");
        menuItem15.addActionListener(this.m_mediator);
        menuItem15.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem15, "clone_filter");
        menu3.add(menuItem15);
        MenuItem menuItem16 = new MenuItem("Revert Filter");
        menuItem16.setActionCommand("revert_filter");
        menuItem16.addActionListener(this.m_mediator);
        menuItem16.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem16, "revert_filter");
        menu3.add(menuItem16);
        MenuItem menuItem17 = new MenuItem("Delete Filter");
        menuItem17.setActionCommand("delete_filter");
        menuItem17.addActionListener(this.m_mediator);
        menuItem17.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem17, "delete_filter");
        menu3.add(menuItem17);
        menu3.addSeparator();
        MenuItem menuItem18 = new MenuItem("Copy Filters...");
        menuItem18.setActionCommand("copy_filter");
        menuItem18.addActionListener(this.m_mediator);
        menuItem18.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem18, "copy_filter");
        menu3.add(menuItem18);
        MenuItem menuItem19 = new MenuItem("Reload Filters");
        menuItem19.setActionCommand("reload");
        menuItem19.addActionListener(this.m_mediator);
        menuItem19.setEnabled(false);
        this.m_mediator.setMenuItem(menuItem19, "reload");
        menu3.add(menuItem19);
        MenuItem menuItem20 = new MenuItem("Help Contents...");
        menuItem20.setActionCommand(HELP);
        menuItem20.addActionListener(this);
        menu4.add(menuItem20);
        menu4.addSeparator();
        MenuItem menuItem21 = new MenuItem("About FilterEditor...");
        menuItem21.setActionCommand(ABOUT);
        menuItem21.addActionListener(this);
        menu4.add(menuItem21);
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        menuBar.add(menu4);
        return menuBar;
    }

    private void saveToFile() {
        block9: {
            String string;
            LEPortMaster lEPortMaster = this.m_mediator.getCurrentPortMaster();
            LEConfigFacility lEConfigFacility = lEPortMaster.getConfigFacility();
            String string2 = lEConfigFacility.getDescription();
            int n = string2.lastIndexOf(File.pathSeparatorChar);
            if (n < 0) {
                string = LEAppInfo.getUserAppDir();
                n = 0;
            } else {
                string = string2.substring(0, n);
            }
            String string3 = string2.substring(n);
            FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Save Filters", 1);
            fileDialog.setDirectory(string);
            fileDialog.setFile(string3);
            fileDialog.show();
            String string4 = fileDialog.getDirectory();
            String string5 = fileDialog.getFile();
            if (string5 != null) {
                if (!string5.equals(string3)) {
                    try {
                        LEPortMaster lEPortMaster2 = new LEPortMaster(string4, string5);
                        LEFilters lEFilters = (LEFilters)lEPortMaster.get("filter");
                        if (lEFilters instanceof LEFilters) {
                            LEFilters lEFilters2 = (LEFilters)lEFilters.clone();
                            lEPortMaster2.set("filter", lEFilters2);
                            lEPortMaster2.saveChanges();
                            return;
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        LEDebug.getLog().logln(20, exception);
                        return;
                    }
                }
                try {
                    lEPortMaster.saveChanges();
                    return;
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    return;
                }
            }
        }
    }

    private void getPortMasterFilters(LEPortMaster lEPortMaster) {
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        if (lEPortMaster != null) {
            LEConfigFacility lEConfigFacility = lEPortMaster.getConfigFacility();
            lEConfigFacility.getConfig("filter");
            this.m_mediator.add(lEPortMaster);
        }
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    void loadProperties() {
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = 640;
            int n2 = 520;
            int n3 = dimension.width / 2 - n / 2;
            int n4 = dimension.height / 2 - n2 / 2;
            String string = LEProperties.GetProperty(PROP_MAIN_X);
            if (string != null) {
                n3 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_Y)) != null) {
                n4 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_W)) != null) {
                n = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_MAIN_H)) != null) {
                n2 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_TOP_H)) != null) {
                this.m_topHeight = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_BOTTOM_H)) != null) {
                this.m_bottomHeight = Integer.parseInt(string);
            }
            this.m_mainBounds = new Rectangle(n3, n4, n, n2);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void saveProperties() {
        try {
            Rectangle rectangle = this.getBounds();
            LEProperties.SetProperty(PROP_MAIN_X, Integer.toString(rectangle.x));
            LEProperties.SetProperty(PROP_MAIN_Y, Integer.toString(rectangle.y));
            LEProperties.SetProperty(PROP_MAIN_W, Integer.toString(rectangle.width));
            if (LEAppInfo.isUnix()) {
                LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height));
            } else {
                LEProperties.SetProperty(PROP_MAIN_H, Integer.toString(rectangle.height + 19));
            }
            int n = this.m_topPanel.getTopHeight() + 4;
            if (n < 10) {
                n = 10;
            }
            LEProperties.SetProperty(PROP_TOP_H, Integer.toString(n));
            int n2 = this.m_topPanel.getBottomHeight() - 4;
            if (n2 < 10) {
                n2 = 10;
            }
            LEProperties.SetProperty(PROP_BOTTOM_H, Integer.toString(n2));
            LEProperties.SaveProperties();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void showHelp() {
        if (this.m_help != null) {
            this.m_help.showContents();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

