/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LETitleBar;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class LEFilterCopyDialog
extends Dialog
implements ActionListener,
WindowListener,
ItemListener {
    public static final String CLOSE = "close";
    public static final String COPY = "copy";
    public static final String FILTER_ALL = "filt_all";
    public static final String FILTER_NONE = "filt_none";
    public static final String DST_ALL = "dst_all";
    public static final String DST_NONE = "dst_none";
    private static final int NUMROWS = 10;
    LEConfirmClient m_client;
    LEVector m_sources;
    LEPortMaster m_current;
    LEFilters m_filters;
    LEFilterMediator m_mediator;
    List m_filter_list;
    List m_source_list;
    List m_dst_list;
    Button m_close;
    Button m_copy;
    Button m_filt_all;
    Button m_filt_none;
    Button m_dst_all;
    Button m_dst_none;

    public LEFilterCopyDialog(LEFilterMediator lEFilterMediator, LEVector lEVector, LEPortMaster lEPortMaster) {
        super(LEUiUtils.GetBaseFrame(), "Copy Filters", true);
        this.m_sources = lEVector;
        this.m_current = lEPortMaster;
        this.m_mediator = lEFilterMediator;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(20, 10));
        this.add("Center", this.createMainPanel());
        this.add("South", this.createButtonPanel());
        this.fillFilterList();
        this.fillSourceList();
        this.fillDestList();
        this.m_copy.setEnabled(false);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dimension.width, dimension.height);
    }

    public LEVector getSelectedFilters() {
        LEVector lEVector = new LEVector();
        String[] stringArray = this.m_filter_list.getSelectedItems();
        int n = 0;
        while (n < stringArray.length) {
            lEVector.add(stringArray[n]);
            ++n;
        }
        return lEVector;
    }

    public LEVector getSelectedPortMasters() {
        LEVector lEVector = new LEVector();
        lEVector.add(this.m_source_list.getSelectedItem());
        return lEVector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CLOSE)) {
            ((Component)this).setVisible(false);
            if (this.m_client != null) {
                this.m_client.cancelAction(null);
            }
            this.dispose();
            return;
        }
        if (string.equals(FILTER_ALL)) {
            this.selectFilters(true);
            int[] nArray = this.m_filter_list.getSelectedIndexes();
            int[] nArray2 = this.m_dst_list.getSelectedIndexes();
            if (nArray.length > 0 && nArray2.length > 0) {
                this.m_copy.setEnabled(true);
                return;
            }
            this.m_copy.setEnabled(false);
            return;
        }
        if (string.equals(FILTER_NONE)) {
            this.selectFilters(false);
            this.m_copy.setEnabled(false);
            return;
        }
        if (string.equals(DST_ALL)) {
            this.selectDest(true);
            int[] nArray = this.m_filter_list.getSelectedIndexes();
            int[] nArray3 = this.m_dst_list.getSelectedIndexes();
            if (nArray.length > 0 && nArray3.length > 0) {
                this.m_copy.setEnabled(true);
                return;
            }
            this.m_copy.setEnabled(false);
            return;
        }
        if (string.equals(DST_NONE)) {
            this.selectDest(false);
            this.m_copy.setEnabled(false);
            return;
        }
        if (string.equals(COPY)) {
            this.copyFilters();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        String string = this.m_source_list.getSelectedItem();
        if (!string.equals(this.m_current.getHostname())) {
            int n = this.m_sources.size();
            int n2 = 0;
            while (n2 < n) {
                object = (LEPortMaster)this.m_sources.elementAt(n2);
                if (string.equals(((LEPortMaster)object).getHostname())) {
                    this.m_current = object;
                    break;
                }
                ++n2;
            }
            this.fillFilterList();
            this.fillDestList();
        }
        int[] nArray = this.m_filter_list.getSelectedIndexes();
        object = this.m_dst_list.getSelectedIndexes();
        if (nArray.length > 0 && ((int[])object).length > 0) {
            this.m_copy.setEnabled(true);
            return;
        }
        this.m_copy.setEnabled(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        if (this.m_client != null) {
            this.m_client.cancelAction(null);
        }
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private Panel createMainPanel() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        panel.add((Component)new Label("Source"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        panel.add((Component)new Label("Filters"), gridBagConstraints);
        gridBagConstraints.gridx += 2;
        panel.add((Component)new Label("Destination"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.m_source_list = new List(10);
        this.m_source_list.addItemListener(this);
        panel.add((Component)this.m_source_list, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.m_filter_list = new List(10);
        this.m_filter_list.setMultipleMode(true);
        this.m_filter_list.addItemListener(this);
        panel.add((Component)this.m_filter_list, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        this.m_copy = new Button("Copy ->");
        this.m_copy.setActionCommand(COPY);
        this.m_copy.addActionListener(this);
        this.m_copy.setEnabled(false);
        panel.add((Component)this.m_copy, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        this.m_dst_list = new List(10);
        this.m_dst_list.setMultipleMode(true);
        this.m_dst_list.addItemListener(this);
        panel.add((Component)this.m_dst_list, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        panel.add((Component)this.createFilterButtons(), gridBagConstraints);
        gridBagConstraints.gridx += 2;
        panel.add((Component)this.createDestButtons(), gridBagConstraints);
        return panel;
    }

    private Panel createFilterListPanel() {
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", new Label("Select filters"));
        this.m_filter_list = new List(10);
        this.m_filter_list.setMultipleMode(true);
        panel.add("Center", this.m_filter_list);
        panel.add("South", this.createFilterButtons());
        return panel;
    }

    private Panel createSourceListPanel() {
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", new Label("Source"));
        this.m_source_list = new List(10);
        this.m_source_list.setMultipleMode(false);
        this.m_source_list.addItemListener(this);
        panel.add("Center", this.m_source_list);
        return panel;
    }

    private Panel createDestListPanel() {
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", new Label("Destination"));
        Panel panel2 = new Panel();
        this.m_copy = new Button("Copy");
        this.m_copy.setActionCommand(COPY);
        this.m_copy.addActionListener(this);
        panel2.add(this.m_copy);
        panel.add("West", panel2);
        this.m_dst_list = new List(10);
        this.m_dst_list.setMultipleMode(true);
        panel.add("Center", this.m_dst_list);
        panel.add("South", this.createDestButtons());
        return panel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel();
        this.m_close = new Button("Close");
        this.m_close.setActionCommand(CLOSE);
        this.m_close.addActionListener(this);
        panel2.add(this.m_close);
        LETitleBar lETitleBar = new LETitleBar("", 1);
        panel.add("North", lETitleBar);
        panel.add("Center", panel2);
        return panel;
    }

    private Panel createFilterButtons() {
        Panel panel = new Panel();
        this.m_filt_all = new Button("All");
        this.m_filt_all.setActionCommand(FILTER_ALL);
        this.m_filt_all.addActionListener(this);
        this.m_filt_none = new Button("None");
        this.m_filt_none.setActionCommand(FILTER_NONE);
        this.m_filt_none.addActionListener(this);
        panel.add(this.m_filt_all);
        panel.add(this.m_filt_none);
        return panel;
    }

    private Panel createDestButtons() {
        Panel panel = new Panel();
        this.m_dst_all = new Button("All");
        this.m_dst_all.setActionCommand(DST_ALL);
        this.m_dst_all.addActionListener(this);
        this.m_dst_none = new Button("None");
        this.m_dst_none.setActionCommand(DST_NONE);
        this.m_dst_none.addActionListener(this);
        panel.add(this.m_dst_all);
        panel.add(this.m_dst_none);
        return panel;
    }

    private void fillFilterList() {
        this.m_filter_list.removeAll();
        LEFilters lEFilters = this.m_mediator.getFilters(this.m_current);
        int n = lEFilters.size();
        if (n > 0) {
            this.m_copy.setEnabled(true);
            this.m_filt_all.setEnabled(true);
            this.m_filt_none.setEnabled(true);
            LEVector lEVector = lEFilters.getKeys();
            int n2 = 0;
            while (n2 < n) {
                this.m_filter_list.addItem((String)lEVector.elementAt(n2));
                ++n2;
            }
            return;
        }
        this.m_copy.setEnabled(false);
        this.m_filt_all.setEnabled(false);
        this.m_filt_none.setEnabled(false);
    }

    private void fillSourceList() {
        int n = this.m_sources.size();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_sources.elementAt(n2);
            this.m_source_list.addItem(lEPortMaster.getHostname());
            if (lEPortMaster == this.m_current) {
                this.m_source_list.select(n2);
            }
            ++n2;
        }
    }

    private void fillDestList() {
        int n = this.m_sources.size();
        this.m_dst_list.removeAll();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                LEPortMaster lEPortMaster = (LEPortMaster)this.m_sources.elementAt(n2);
                if (lEPortMaster != this.m_current) {
                    this.m_dst_list.addItem(lEPortMaster.getHostname());
                }
                ++n2;
            }
        }
        if (this.m_dst_list.getItemCount() > 0) {
            this.m_copy.setEnabled(true);
            this.m_dst_all.setEnabled(true);
            this.m_dst_none.setEnabled(true);
            return;
        }
        this.m_copy.setEnabled(false);
        this.m_dst_all.setEnabled(false);
        this.m_dst_none.setEnabled(false);
    }

    private void selectFilters(boolean bl) {
        int n = this.m_filter_list.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                if (!this.m_filter_list.isIndexSelected(n2)) {
                    this.m_filter_list.select(n2);
                }
            } else {
                this.m_filter_list.deselect(n2);
            }
            ++n2;
        }
    }

    private void selectDest(boolean bl) {
        int n = this.m_dst_list.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                if (!this.m_dst_list.isIndexSelected(n2)) {
                    this.m_dst_list.select(n2);
                }
            } else {
                this.m_dst_list.deselect(n2);
            }
            ++n2;
        }
    }

    private void copyFilters() {
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        LEVector lEVector = new LEVector();
        LEVector lEVector2 = new LEVector();
        String[] stringArray = this.m_filter_list.getSelectedItems();
        int n = 0;
        while (n < stringArray.length) {
            lEVector2.add(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = this.m_dst_list.getSelectedItems();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            lEVector.add(stringArray2[n2]);
            ++n2;
        }
        this.m_mediator.copyFilters(this.m_current, lEVector, lEVector2);
        ((Component)this).setCursor(Cursor.getDefaultCursor());
        this.m_copy.setEnabled(false);
    }
}

