/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEFilters;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LETitleBar;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class LEFilterExportDialog
extends Dialog
implements ActionListener,
WindowListener,
ItemListener {
    public static final String OK = "ok";
    public static final String CANCEL = "cancel";
    public static final String FILTER_ALL = "filt_all";
    public static final String FILTER_NONE = "filt_none";
    private static final int NUMROWS = 10;
    LEConfirmClient m_client;
    Frame m_parent;
    LEFilters m_filters;
    List m_filter_list;
    Button m_filt_all;
    Button m_filt_none;
    Button m_save;
    Button m_cancel;

    public LEFilterExportDialog(Frame frame, LEConfirmClient lEConfirmClient, LEFilters lEFilters) {
        super(frame, "Export Filters", true);
        this.m_parent = frame;
        this.m_client = lEConfirmClient;
        this.m_filters = lEFilters;
        this.setLayout(new BorderLayout(10, 0));
        this.add("West", new Panel());
        this.add("East", new Panel());
        this.add("Center", this.createFilterListPanel());
        this.add("South", this.createButtonPanel());
        this.fillFilterList();
        this.m_save.setEnabled(false);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dimension.width, dimension.height);
    }

    public LEVector getSelectedFilters() {
        LEVector lEVector = new LEVector();
        String[] stringArray = this.m_filter_list.getSelectedItems();
        int n = 0;
        while (n < stringArray.length) {
            lEVector.add(stringArray[n]);
            ++n;
        }
        return lEVector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK)) {
            ((Component)this).setVisible(false);
            if (this.m_client != null) {
                this.m_client.confirmAction(string, this);
            }
            this.dispose();
            return;
        }
        if (string.equals(CANCEL)) {
            ((Component)this).setVisible(false);
            if (this.m_client != null) {
                this.m_client.cancelAction(null);
            }
            this.dispose();
            return;
        }
        if (string.equals(FILTER_ALL)) {
            this.selectFilters(true);
            this.m_save.setEnabled(true);
            return;
        }
        if (string.equals(FILTER_NONE)) {
            this.selectFilters(false);
            this.m_save.setEnabled(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int[] nArray = this.m_filter_list.getSelectedIndexes();
        if (nArray.length > 0) {
            this.m_save.setEnabled(true);
            return;
        }
        this.m_save.setEnabled(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        if (this.m_client != null) {
            this.m_client.cancelAction(null);
        }
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        if (this.m_client != null) {
            this.m_client.cancelAction(null);
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private Panel createFilterListPanel() {
        Panel panel = new Panel(new BorderLayout(5, 5));
        panel.add((Component)new Label("Select filters"), "North");
        this.m_filter_list = new List(10);
        this.m_filter_list.setMultipleMode(true);
        this.m_filter_list.addItemListener(this);
        panel.add("Center", this.m_filter_list);
        Panel panel2 = new Panel(new FlowLayout(1));
        this.m_filt_all = new Button("All");
        this.m_filt_all.setActionCommand(FILTER_ALL);
        this.m_filt_all.addActionListener(this);
        this.m_filt_none = new Button("None");
        this.m_filt_none.setActionCommand(FILTER_NONE);
        this.m_filt_none.addActionListener(this);
        panel2.add(this.m_filt_all);
        panel2.add(this.m_filt_none);
        panel.add("South", panel2);
        return panel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel();
        this.m_save = new Button("OK");
        this.m_save.setActionCommand(OK);
        this.m_save.addActionListener(this);
        this.m_cancel = new Button("Cancel");
        this.m_cancel.setActionCommand(CANCEL);
        this.m_cancel.addActionListener(this);
        panel2.add(this.m_save);
        panel2.add(this.m_cancel);
        LETitleBar lETitleBar = new LETitleBar("", 1);
        panel.add("North", lETitleBar);
        panel.add("Center", panel2);
        return panel;
    }

    private void fillFilterList() {
        int n = this.m_filters.size();
        LEVector lEVector = this.m_filters.getKeys();
        int n2 = 0;
        while (n2 < n) {
            this.m_filter_list.addItem((String)lEVector.elementAt(n2));
            ++n2;
        }
    }

    private void selectFilters(boolean bl) {
        int n = this.m_filter_list.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (bl) {
                if (!this.m_filter_list.isIndexSelected(n2)) {
                    this.m_filter_list.select(n2);
                }
            } else {
                this.m_filter_list.deselect(n2);
            }
            ++n2;
        }
    }
}

