/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.model.LEChoiceNetFilterParser;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEFileConfigFacility;
import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilterRule;
import COM.livingston.model.LEFilterRules;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEIPRule;
import COM.livingston.model.LEIPRules;
import COM.livingston.model.LEIPXRule;
import COM.livingston.model.LEIPXRules;
import COM.livingston.model.LEPMConfigFacility;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESAPRule;
import COM.livingston.model.LESAPRules;
import COM.livingston.ui.LEClipboard;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEErrorListDialog;
import COM.livingston.ui.LEStatusDialog;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEVector;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;

public class LEFilterMediator
extends LEObservable
implements ActionListener,
LEObserver,
LEConfirmClient {
    public static final String NEW_FILTER = "new_filter";
    public static final String NEW_RULE = "new_rule";
    public static final String COPY_FILTER = "copy_filter";
    public static final String EXPORT_FILTER = "export_filter";
    public static final String SAVE = "save";
    public static final String SAVE_ALL = "save_all";
    public static final String IMPORT_CHOICE = "import_choice";
    public static final String EXPORT_CHOICE = "export_choice";
    public static final String DELETE_FILTER = "delete_filter";
    public static final String RENAME_FILTER = "rename_filter";
    public static final String CLONE_FILTER = "clone_filter";
    public static final String REVERT_FILTER = "revert_filter";
    public static final String RELOAD = "reload";
    public static final String IP_EDITOR = "ipeditor";
    public static final String IPX_EDITOR = "ipxeditor";
    public static final String SAP_EDITOR = "sapeditor";
    LEVector m_selected_rules;
    LEVector m_clipboard_rules;
    LEVector m_config_facilities;
    LEVector m_portmasters = new LEVector();
    Hashtable m_filterTable = new Hashtable();
    LEPortMaster m_current_portmaster;
    LERuleListPanel m_rule_list;
    LERuleEditor m_rule_editor;
    LEFilter m_filter;
    LEIPRuleEditor m_iprule_editor;
    LEIPXRuleEditor m_ipxrule_editor;
    LESAPRuleEditor m_saprule_editor;
    LEClipboard m_cb;
    LEEditorPanel m_editorpanel;
    boolean m_demo;
    boolean m_save_dlg = false;
    MenuItem m_newfilter_mi;
    MenuItem m_save_mi;
    MenuItem m_saveall_mi;
    MenuItem m_copyfilter_mi;
    MenuItem m_exportfilter_mi;
    MenuItem m_importchoice_mi;
    MenuItem m_exportchoice_mi;
    MenuItem m_deletefilter_mi;
    MenuItem m_renamefilter_mi;
    MenuItem m_clonefilter_mi;
    MenuItem m_revertfilter_mi;
    MenuItem m_reload_mi;

    public LEFilterMediator() {
        if (LEAppInfo.getFlag("-d") == null) {
            this.m_demo = false;
            return;
        }
        this.m_demo = true;
    }

    public void setSelection(LEVector lEVector) {
        if (lEVector.size() != 1) {
            if (this.m_rule_editor != null) {
                this.m_rule_editor.clearRule();
                this.m_rule_editor.setEnabled(false);
            }
        } else if (this.m_rule_editor != null) {
            this.m_rule_editor.setEnabled(true);
            this.m_rule_editor.setRule((LEFilterRule)lEVector.elementAt(0));
        }
        this.m_selected_rules = lEVector;
        if (lEVector.size() > 0) {
            this.m_cb.setCopy(true);
            this.m_cb.setCut(true);
            this.m_cb.setDelete(true);
            return;
        }
        this.m_cb.setCopy(false);
        this.m_cb.setCut(false);
        this.m_cb.setDelete(false);
    }

    public void setPortMaster(String string) {
        int n = this.m_portmasters.size();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_portmasters.elementAt(n2);
            if (string.equals(lEPortMaster.getHostname())) {
                this.set(lEPortMaster);
                return;
            }
            ++n2;
        }
    }

    public LEVector getPortMasters() {
        return this.m_portmasters;
    }

    public LEPortMaster getCurrentPortMaster() {
        return this.m_current_portmaster;
    }

    public LERuleEditor getCurrentEditor() {
        return this.m_rule_editor;
    }

    public LEFilters getFilters(LEPortMaster lEPortMaster) {
        if (this.m_filterTable.containsKey(lEPortMaster)) {
            return (LEFilters)this.m_filterTable.get(lEPortMaster);
        }
        return null;
    }

    public void setList(String string) {
    }

    public void editApplied() {
        if (!this.m_demo) {
            this.m_save_mi.setEnabled(true);
            this.m_saveall_mi.setEnabled(true);
        }
        this.m_revertfilter_mi.setEnabled(true);
    }

    public void editApplied(LEFilterRule lEFilterRule) {
        this.m_rule_list.set(lEFilterRule);
        if (!this.m_demo) {
            this.m_save_mi.setEnabled(true);
            this.m_saveall_mi.setEnabled(true);
        }
        this.m_revertfilter_mi.setEnabled(true);
    }

    public void editCanceled(LEFilterRule lEFilterRule) {
    }

    public void newRule(LEVector lEVector) {
    }

    public void deleteRule(LEVector lEVector) {
    }

    public void add(Object object) {
        if (object instanceof LEFilter) {
            if (this.m_rule_list != null) {
                this.m_rule_list.add((LEFilter)object);
            }
            if (!this.m_demo) {
                this.m_save_mi.setEnabled(true);
                this.m_saveall_mi.setEnabled(true);
                this.m_exportchoice_mi.setEnabled(true);
                this.m_exportfilter_mi.setEnabled(true);
            }
            this.m_renamefilter_mi.setEnabled(true);
            this.m_deletefilter_mi.setEnabled(true);
            this.m_copyfilter_mi.setEnabled(true);
            this.m_clonefilter_mi.setEnabled(true);
            return;
        }
        if (object instanceof LEFilterRule) {
            LEFilterRule lEFilterRule = (LEFilterRule)object;
            this.m_copyfilter_mi.setEnabled(true);
            this.m_renamefilter_mi.setEnabled(true);
            this.m_deletefilter_mi.setEnabled(true);
            this.m_clonefilter_mi.setEnabled(true);
            this.m_revertfilter_mi.setEnabled(true);
            if (!this.m_demo) {
                this.m_save_mi.setEnabled(true);
                this.m_saveall_mi.setEnabled(true);
                this.m_exportfilter_mi.setEnabled(true);
                this.m_exportchoice_mi.setEnabled(true);
            }
            if (this.m_rule_list != null) {
                this.m_rule_list.add(lEFilterRule);
                return;
            }
        } else {
            if (object instanceof LEFilters) {
                this.m_filterTable.put(this.m_current_portmaster, (LEFilters)object);
                return;
            }
            if (object instanceof LEPortMaster) {
                this.m_current_portmaster = (LEPortMaster)object;
                if (!this.m_portmasters.contains(this.m_current_portmaster)) {
                    this.m_portmasters.add(this.m_current_portmaster);
                    LEFilters lEFilters = (LEFilters)this.m_current_portmaster.get("filter");
                    if (lEFilters.size() > 0) {
                        if (!this.m_demo) {
                            this.m_exportfilter_mi.setEnabled(true);
                            this.m_exportchoice_mi.setEnabled(true);
                        }
                        this.m_copyfilter_mi.setEnabled(true);
                        this.m_renamefilter_mi.setEnabled(true);
                        this.m_deletefilter_mi.setEnabled(true);
                        this.m_clonefilter_mi.setEnabled(true);
                    } else {
                        this.m_renamefilter_mi.setEnabled(false);
                        this.m_deletefilter_mi.setEnabled(false);
                        this.m_exportchoice_mi.setEnabled(false);
                        this.m_clonefilter_mi.setEnabled(false);
                        this.m_cb.setPaste(false);
                    }
                    LEFilters lEFilters2 = (LEFilters)lEFilters.clone();
                    lEFilters2.clearChangeVectors();
                    this.m_filterTable.put(this.m_current_portmaster, lEFilters2);
                }
                if (this.m_rule_list != null) {
                    this.m_rule_list.set(this.m_current_portmaster);
                }
                if (this.m_rule_editor != null) {
                    this.m_rule_editor.clearRule();
                    this.m_rule_editor.setEnabled(false);
                }
                if (!this.m_newfilter_mi.isEnabled()) {
                    this.m_newfilter_mi.setEnabled(true);
                }
                if (this.m_current_portmaster.getConfigFacility() instanceof LEPMConfigFacility) {
                    this.m_reload_mi.setEnabled(true);
                    return;
                }
                this.m_reload_mi.setEnabled(false);
            }
        }
    }

    public void set(Object object) {
        if (object instanceof LERuleListPanel) {
            this.m_rule_list = (LERuleListPanel)object;
            return;
        }
        if (object instanceof LERuleEditor) {
            if (object instanceof LEIPRuleEditor) {
                if (this.m_iprule_editor == null) {
                    this.m_iprule_editor = (LEIPRuleEditor)object;
                }
                this.m_rule_editor = this.m_iprule_editor;
                return;
            }
            if (object instanceof LEIPXRuleEditor) {
                if (this.m_ipxrule_editor == null) {
                    this.m_ipxrule_editor = (LEIPXRuleEditor)object;
                }
                this.m_rule_editor = this.m_ipxrule_editor;
                return;
            }
            if (object instanceof LESAPRuleEditor) {
                if (this.m_saprule_editor == null) {
                    this.m_saprule_editor = (LESAPRuleEditor)object;
                }
                this.m_rule_editor = this.m_saprule_editor;
                return;
            }
        } else if (object instanceof LEFilter) {
            this.m_filter = (LEFilter)object;
            this.m_revertfilter_mi.setEnabled(this.m_filter.hasChanges());
            if (this.m_rule_list != null) {
                this.m_rule_list.set(this.m_filter);
                return;
            }
        } else {
            if (object instanceof LEPortMaster) {
                this.m_current_portmaster = (LEPortMaster)object;
                LEFilters lEFilters = this.getFilters(this.m_current_portmaster);
                this.m_revertfilter_mi.setEnabled(false);
                if (lEFilters.size() > 0) {
                    if (!this.m_demo) {
                        this.m_exportfilter_mi.setEnabled(true);
                        this.m_exportchoice_mi.setEnabled(true);
                        this.m_save_mi.setEnabled(lEFilters.hasChanges());
                    }
                    this.m_copyfilter_mi.setEnabled(true);
                    this.m_renamefilter_mi.setEnabled(true);
                    this.m_deletefilter_mi.setEnabled(true);
                    this.m_clonefilter_mi.setEnabled(true);
                } else {
                    this.m_cb.setPaste(false);
                    this.m_exportfilter_mi.setEnabled(false);
                    this.m_exportchoice_mi.setEnabled(false);
                    this.m_renamefilter_mi.setEnabled(false);
                    this.m_deletefilter_mi.setEnabled(false);
                    this.m_clonefilter_mi.setEnabled(false);
                }
                if (this.m_rule_list != null) {
                    this.m_rule_list.set(this.m_current_portmaster);
                }
                if (this.m_rule_editor != null) {
                    this.m_rule_editor.clearRule();
                    this.m_rule_editor.setEnabled(false);
                }
                if (!this.m_newfilter_mi.isEnabled()) {
                    this.m_newfilter_mi.setEnabled(true);
                }
                if (this.m_current_portmaster.getConfigFacility() instanceof LEPMConfigFacility) {
                    this.m_reload_mi.setEnabled(true);
                    return;
                }
                this.m_reload_mi.setEnabled(false);
                return;
            }
            if (object instanceof LEFilterRules) {
                this.m_rule_list.set((LEFilterRules)object);
                if (object instanceof LEIPRules) {
                    if (this.m_rule_editor != this.m_iprule_editor) {
                        this.m_rule_editor = this.m_iprule_editor;
                    }
                    this.m_rule_editor.clearRule();
                    this.m_rule_editor.setEnabled(false);
                    this.m_editorpanel.showEditor(IP_EDITOR);
                    return;
                }
                if (object instanceof LEIPXRules) {
                    if (this.m_rule_editor != this.m_ipxrule_editor) {
                        this.m_rule_editor = this.m_ipxrule_editor;
                    }
                    this.m_rule_editor.clearRule();
                    this.m_rule_editor.setEnabled(false);
                    this.m_editorpanel.showEditor(IPX_EDITOR);
                    return;
                }
                if (object instanceof LESAPRules) {
                    if (this.m_rule_editor != this.m_saprule_editor) {
                        this.m_rule_editor = this.m_saprule_editor;
                    }
                    this.m_rule_editor.clearRule();
                    this.m_rule_editor.setEnabled(false);
                    this.m_editorpanel.showEditor(SAP_EDITOR);
                    return;
                }
            } else {
                if (object instanceof LEClipboard) {
                    this.m_cb = (LEClipboard)object;
                    this.m_cb.addObserver(this);
                    return;
                }
                if (object instanceof LEEditorPanel) {
                    this.m_editorpanel = (LEEditorPanel)object;
                }
            }
        }
    }

    public void confirmAction(String string, Object object) {
        if (object instanceof LEFilterExportDialog) {
            LEFilterExportDialog lEFilterExportDialog = (LEFilterExportDialog)object;
            LEVector lEVector = lEFilterExportDialog.getSelectedFilters();
            this.exportFilters(lEVector);
            return;
        }
        if (object instanceof FilterDelete) {
            if (string.equals(LEConfirmDialog.YES) || string.equals(LEConfirmDialog.OK)) {
                this.deleteCurrentFilter();
            }
            return;
        }
        if (object instanceof FilterRevert) {
            if (string.equals(LEConfirmDialog.YES) || string.equals(LEConfirmDialog.OK)) {
                this.revertCurrentFilter();
            }
            return;
        }
        if (object instanceof FilterReload) {
            if (string.equals(LEConfirmDialog.YES) || string.equals(LEConfirmDialog.OK)) {
                this.reloadCurrentSource();
            }
            return;
        }
        if (string.equals(NEW_FILTER)) {
            if (object != null) {
                LEFilter lEFilter = new LEFilter(null, (String)object);
                this.add(lEFilter);
                return;
            }
        } else if (string.equals(RENAME_FILTER)) {
            if (object != null) {
                this.renameCurrentFilter((String)object);
                return;
            }
        } else if (string.equals(CLONE_FILTER) && object != null) {
            this.cloneCurrentFilter((String)object);
        }
    }

    public void cancelAction(Object object) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(NEW_FILTER)) {
            String string2 = "New filter name: ";
            LEFilterNameDialog lEFilterNameDialog = new LEFilterNameDialog(this, "New Filter", string2, "", NEW_FILTER);
            ((Component)lEFilterNameDialog).setVisible(true);
            return;
        }
        if (string.equals(NEW_RULE)) {
            if (this.m_rule_editor == this.m_iprule_editor) {
                LEIPRule lEIPRule = new LEIPRule(null, "", "");
                lEIPRule.initialize("permit");
                this.add(lEIPRule);
                return;
            }
            if (this.m_rule_editor == this.m_ipxrule_editor) {
                LEIPXRule lEIPXRule = new LEIPXRule(null, "", "");
                lEIPXRule.initialize("permit");
                this.add(lEIPXRule);
                return;
            }
            LESAPRule lESAPRule = new LESAPRule(null, "", "");
            lESAPRule.initialize("permit");
            this.add(lESAPRule);
            return;
        }
        if (string.equals(COPY_FILTER)) {
            LEFilterCopyDialog lEFilterCopyDialog = new LEFilterCopyDialog(this, this.m_portmasters, this.m_current_portmaster);
            ((Component)lEFilterCopyDialog).setVisible(true);
            return;
        }
        if (string.equals(EXPORT_FILTER)) {
            LEFilterExportDialog lEFilterExportDialog = new LEFilterExportDialog(LEUiUtils.GetBaseFrame(), this, this.getFilters(this.m_current_portmaster));
            ((Component)lEFilterExportDialog).setVisible(true);
            return;
        }
        if (string.equals(SAVE)) {
            this.saveFilters(this.m_current_portmaster);
            this.m_save_mi.setEnabled(false);
            if (this.needToSave() && !this.m_demo) {
                this.m_saveall_mi.setEnabled(true);
                return;
            }
            this.m_saveall_mi.setEnabled(false);
            return;
        }
        if (string.equals(SAVE_ALL)) {
            this.saveAll();
            this.m_save_mi.setEnabled(false);
            this.m_saveall_mi.setEnabled(false);
            return;
        }
        if (string.equals(IMPORT_CHOICE)) {
            String string3 = LEAppInfo.getUserAppDir();
            FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Import ChoiceNet Filter", 0);
            fileDialog.setDirectory(string3);
            fileDialog.show();
            String string4 = fileDialog.getDirectory();
            String string5 = fileDialog.getFile();
            if (string5 != null) {
                this.importChoiceFilter(string4, string5);
                return;
            }
        } else if (string.equals(EXPORT_CHOICE)) {
            String string6 = LEAppInfo.getUserAppDir();
            LEChoiceNetFilenameFilter lEChoiceNetFilenameFilter = new LEChoiceNetFilenameFilter();
            FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Export ChoiceNet Filter", 1);
            fileDialog.setDirectory(string6);
            fileDialog.setFile(this.m_filter.getName());
            fileDialog.setFilenameFilter(lEChoiceNetFilenameFilter);
            fileDialog.show();
            String string7 = fileDialog.getDirectory();
            String string8 = fileDialog.getFile();
            if (string8 != null) {
                this.exportChoiceFilter(string7, string8);
                return;
            }
        } else {
            if (string.equals(RENAME_FILTER)) {
                String string9 = "New name for filter: ";
                LEFilterNameDialog lEFilterNameDialog = new LEFilterNameDialog(this, "Rename Filter", string9, "", RENAME_FILTER);
                ((Component)lEFilterNameDialog).setVisible(true);
                return;
            }
            if (string.equals(DELETE_FILTER)) {
                String string10 = "Are you sure you want to delete the current filter?";
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                FilterDelete filterDelete = new FilterDelete();
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.GetBaseFrame(), (LEConfirmClient)this, string10, stringArray, (Object)filterDelete);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            if (string.equals(CLONE_FILTER)) {
                String string11 = "Name for cloned filter: ";
                String string12 = this.m_filter.getName();
                if (string12.length() < 13) {
                    string12 = String.valueOf(string12) + ".1";
                } else {
                    string12 = string12.substring(0, 13);
                    string12 = String.valueOf(string12) + ".2";
                }
                LEFilterNameDialog lEFilterNameDialog = new LEFilterNameDialog(this, "Clone Filter", string11, string12, CLONE_FILTER);
                ((Component)lEFilterNameDialog).setVisible(true);
                return;
            }
            if (string.equals(REVERT_FILTER)) {
                String string13 = "Are you sure you want to revert the current filter?";
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                FilterRevert filterRevert = new FilterRevert();
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.GetBaseFrame(), (LEConfirmClient)this, string13, stringArray, (Object)filterRevert);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            if (string.equals(RELOAD)) {
                StringBuffer stringBuffer = new StringBuffer(30);
                stringBuffer.append("Are you sure you want to reload the filters from ");
                stringBuffer.append(this.m_current_portmaster.getHostname());
                stringBuffer.append("?");
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                FilterReload filterReload = new FilterReload();
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.GetBaseFrame(), (LEConfirmClient)this, stringBuffer.toString(), stringArray, (Object)filterReload);
                ((Component)lEConfirmDialog).setVisible(true);
            }
        }
    }

    public boolean needToSave() {
        int n = this.m_portmasters.size();
        boolean bl = false;
        if (!this.m_demo) {
            int n2 = 0;
            new LEVector();
            while (n2 < n && !bl) {
                LEPortMaster lEPortMaster = (LEPortMaster)this.m_portmasters.elementAt(n2);
                LEFilters lEFilters = this.getFilters(lEPortMaster);
                bl = lEFilters.hasChanges();
                ++n2;
            }
        }
        return bl;
    }

    public void update(LEObservable lEObservable, Object object) {
        if (lEObservable instanceof LEClipboard) {
            Integer n = (Integer)object;
            if (n.equals(LEClipboard.CUT)) {
                this.m_clipboard_rules = (LEVector)this.m_selected_rules.clone();
                if (this.m_clipboard_rules.size() > 0) {
                    this.m_cb.setPaste(true);
                }
                this.m_rule_list.deleteRules();
                return;
            }
            if (n.equals(LEClipboard.COPY)) {
                this.m_clipboard_rules = (LEVector)this.m_selected_rules.clone();
                if (this.m_clipboard_rules.size() > 0) {
                    this.m_cb.setPaste(true);
                    return;
                }
            } else {
                if (n.equals(LEClipboard.PASTE)) {
                    int n2 = this.m_clipboard_rules.size();
                    LEVector lEVector = new LEVector(n2);
                    int n3 = 0;
                    while (n3 < n2) {
                        LEFilterRule lEFilterRule = (LEFilterRule)this.m_clipboard_rules.elementAt(n3);
                        lEVector.add((LEFilterRule)lEFilterRule.clone());
                        ++n3;
                    }
                    this.m_rule_list.add(lEVector);
                    return;
                }
                if (n.equals(LEClipboard.DELETE)) {
                    this.m_rule_list.deleteRules();
                }
            }
        }
    }

    public void setMenuItem(MenuItem menuItem, String string) {
        if (string.equals(NEW_FILTER)) {
            this.m_newfilter_mi = menuItem;
            return;
        }
        if (string.equals(EXPORT_FILTER)) {
            this.m_exportfilter_mi = menuItem;
            return;
        }
        if (string.equals(COPY_FILTER)) {
            this.m_copyfilter_mi = menuItem;
            return;
        }
        if (string.equals(SAVE)) {
            this.m_save_mi = menuItem;
            return;
        }
        if (string.equals(SAVE_ALL)) {
            this.m_saveall_mi = menuItem;
            return;
        }
        if (string.equals(IMPORT_CHOICE)) {
            this.m_importchoice_mi = menuItem;
            return;
        }
        if (string.equals(EXPORT_CHOICE)) {
            this.m_exportchoice_mi = menuItem;
            return;
        }
        if (string.equals(DELETE_FILTER)) {
            this.m_deletefilter_mi = menuItem;
            return;
        }
        if (string.equals(RENAME_FILTER)) {
            this.m_renamefilter_mi = menuItem;
            return;
        }
        if (string.equals(CLONE_FILTER)) {
            this.m_clonefilter_mi = menuItem;
            return;
        }
        if (string.equals(REVERT_FILTER)) {
            this.m_revertfilter_mi = menuItem;
            return;
        }
        if (string.equals(RELOAD)) {
            this.m_reload_mi = menuItem;
        }
    }

    void saveAll() {
        this.m_save_dlg = true;
        LEStatusDialog lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        int n = this.m_portmasters.size();
        int n2 = 0;
        while (n2 < n) {
            this.saveFilters((LEPortMaster)this.m_portmasters.elementAt(n2));
            ++n2;
        }
        lEStatusDialog.hideStatus();
        this.m_save_dlg = false;
    }

    private void saveFilters(LEPortMaster lEPortMaster) {
        LEConfigFacility lEConfigFacility;
        LEStatusDialog lEStatusDialog = null;
        if (!this.m_save_dlg) {
            lEStatusDialog = new LEStatusDialog(LEUiUtils.GetBaseFrame());
        }
        if ((lEConfigFacility = lEPortMaster.getConfigFacility()) instanceof LEFileConfigFacility) {
            this.saveFile(lEPortMaster);
        } else if (lEConfigFacility instanceof LEPMConfigFacility) {
            this.savePortMaster(lEPortMaster);
        }
        this.m_revertfilter_mi.setEnabled(false);
        if (!this.m_save_dlg) {
            lEStatusDialog.hideStatus();
        }
        if (lEPortMaster == this.m_current_portmaster) {
            String string = this.m_filter.getName();
            LEFilters lEFilters = this.getFilters(this.m_current_portmaster);
            this.m_filter = (LEFilter)lEFilters.get(string);
            if (this.m_filter != null) {
                this.m_rule_list.set(this.m_filter);
            }
        }
    }

    private void saveFile(LEPortMaster lEPortMaster) {
        LEFilters lEFilters = (LEFilters)lEPortMaster.get("filter");
        LEFilters lEFilters2 = this.getFilters(lEPortMaster);
        if (lEFilters2 != null) {
            lEFilters.copy(lEFilters2);
            LEVector lEVector = new LEVector();
            lEFilters.getCommands(lEVector);
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                lEPortMaster.execute((String)lEVector.elementAt(n2));
                ++n2;
            }
            LEFileConfigFacility lEFileConfigFacility = (LEFileConfigFacility)lEPortMaster.getConfigFacility();
            try {
                lEFileConfigFacility.close();
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            lEFilters2 = (LEFilters)lEFilters.clone();
            lEFilters2.clearChangeVectors();
            this.m_filterTable.put(lEPortMaster, lEFilters2);
        }
    }

    private void savePortMaster(LEPortMaster lEPortMaster) {
        LEFilters lEFilters = (LEFilters)lEPortMaster.get("filter");
        LEFilters lEFilters2 = this.getFilters(lEPortMaster);
        if (lEFilters2 != null) {
            lEFilters.copy(lEFilters2);
            LEVector lEVector = lEFilters.saveChanges();
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
                return;
            }
            lEFilters2 = (LEFilters)lEFilters.clone();
            lEFilters2.clearChangeVectors();
            this.m_filterTable.put(lEPortMaster, lEFilters2);
        }
    }

    private void exportFilters(LEVector lEVector) {
        String string;
        LEConfigFacility lEConfigFacility = this.m_current_portmaster.getConfigFacility();
        String string2 = lEConfigFacility.getDescription();
        int n = string2.lastIndexOf(File.pathSeparatorChar);
        if (n < 0) {
            string = LEAppInfo.getUserAppDir();
            n = 0;
        } else {
            string = string2.substring(0, n);
        }
        String string3 = "export.txt";
        FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), "Save Filters", 1);
        fileDialog.setDirectory(string);
        fileDialog.setFile(string3);
        fileDialog.show();
        String string4 = fileDialog.getDirectory();
        String string5 = fileDialog.getFile();
        if (string5 != null) {
            try {
                LEPortMaster lEPortMaster = new LEPortMaster(string4, string5);
                LEFilters lEFilters = new LEFilters(lEPortMaster.getConfigFacility());
                lEPortMaster.set("filter", lEFilters);
                LEFilters lEFilters2 = this.getFilters(this.m_current_portmaster);
                if (lEFilters2 instanceof LEFilters) {
                    int n2 = lEVector.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        String string6 = (String)lEVector.elementAt(n3);
                        LEFilter lEFilter = (LEFilter)lEFilters2.get(string6);
                        if (lEFilter != null) {
                            lEFilters.set(string6, (LEFilter)lEFilter.clone());
                        }
                        ++n3;
                    }
                    LEVector lEVector2 = new LEVector();
                    lEFilters.getCommands(lEVector2);
                    int n4 = lEVector2.size();
                    int n5 = 0;
                    while (n5 < n4) {
                        lEPortMaster.execute((String)lEVector2.elementAt(n5));
                        ++n5;
                    }
                    try {
                        LEFileConfigFacility lEFileConfigFacility = (LEFileConfigFacility)lEPortMaster.getConfigFacility();
                        lEFileConfigFacility.close();
                        return;
                    }
                    catch (Exception exception) {
                        LEDebug.getLog().logln(20, exception);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    public void copyFilters(LEPortMaster lEPortMaster, LEVector lEVector, LEVector lEVector2) {
        int n = this.m_portmasters.size();
        LEFilters lEFilters = this.getFilters(lEPortMaster);
        int n2 = lEVector2.size();
        LEVector lEVector3 = new LEVector();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            LEPortMaster lEPortMaster2 = (LEPortMaster)this.m_portmasters.elementAt(n3);
            if (lEVector.contains(lEPortMaster2.getHostname())) {
                LEFilters lEFilters2 = this.getFilters(lEPortMaster2);
                if (lEPortMaster2 == this.m_current_portmaster) {
                    bl = true;
                }
                int n4 = 0;
                while (n4 < n2) {
                    String string = (String)lEVector2.elementAt(n4);
                    if (!this.filterExists(lEPortMaster2, string)) {
                        LEFilter lEFilter = (LEFilter)lEFilters.get(string);
                        if (lEFilter != null) {
                            lEFilters2.set(string, lEFilter.clone());
                        }
                    } else {
                        StringBuffer stringBuffer = new StringBuffer(30);
                        stringBuffer.append(lEPortMaster2.getHostname());
                        stringBuffer.append(" already has a filter named ");
                        stringBuffer.append(string);
                        stringBuffer.append(".");
                        lEVector3.add(stringBuffer.toString());
                    }
                    ++n4;
                }
                if (lEPortMaster2 == this.m_current_portmaster) {
                    this.m_rule_list.set(lEPortMaster2);
                }
            }
            ++n3;
        }
        if (lEVector3.size() > 0) {
            new LEErrorListDialog(LEUiUtils.GetBaseFrame(), lEVector3);
        }
        if (lEVector2.size() > lEVector3.size() && !this.m_demo) {
            this.m_saveall_mi.setEnabled(true);
            if (bl) {
                this.m_save_mi.setEnabled(true);
            }
        }
    }

    private void importChoiceFilter(String string, String string2) {
        LEChoiceNetFilterParser lEChoiceNetFilterParser = new LEChoiceNetFilterParser(string2);
        try {
            String string3 = LEAppInfo.createFullPath(string, string2);
            LEDSSFlatFile lEDSSFlatFile = new LEDSSFlatFile(string3, 0);
            lEDSSFlatFile.connect();
            LEVector lEVector = lEDSSFlatFile.getCommands();
            lEChoiceNetFilterParser.readFilters(lEVector);
            LEFilter lEFilter = lEChoiceNetFilterParser.getFilter();
            this.add(lEFilter);
            lEDSSFlatFile.disconnect();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    private void exportChoiceFilter(String string, String string2) {
        try {
            String string3 = LEAppInfo.createFullPath(string, string2);
            LEDSSFlatFile lEDSSFlatFile = new LEDSSFlatFile(string3, 1);
            lEDSSFlatFile.connect();
            LEVector lEVector = LEChoiceNetFilterParser.WriteFilter(this.m_filter);
            lEDSSFlatFile.writeConfig(lEVector);
            lEDSSFlatFile.disconnect();
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    private void deleteCurrentFilter() {
        LEFilters lEFilters = this.getFilters(this.m_current_portmaster);
        LEVector lEVector = lEFilters.getKeys();
        int n = lEVector.size();
        String string = this.m_filter.getName();
        LEFilters lEFilters2 = new LEFilters(null);
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)lEVector.elementAt(n2);
            if (!string.equals(string2)) {
                LEFilter lEFilter = (LEFilter)lEFilters.get(string2);
                lEFilters2.set(string2, lEFilter);
            }
            ++n2;
        }
        this.m_filterTable.put(this.m_current_portmaster, lEFilters2);
        if (!this.m_demo) {
            this.m_save_mi.setEnabled(true);
            this.m_saveall_mi.setEnabled(true);
        }
        this.set(this.m_current_portmaster);
    }

    private void revertCurrentFilter() {
        String string = this.m_filter.getName();
        LEFilters lEFilters = this.getFilters(this.m_current_portmaster);
        LEFilters lEFilters2 = (LEFilters)this.m_current_portmaster.get("filter");
        LEFilter lEFilter = null;
        if (lEFilters2 != null) {
            LEFilter lEFilter2 = (LEFilter)lEFilters2.get(string);
            if (lEFilter2 != null) {
                LEFilterRules lEFilterRules = (LEFilterRules)lEFilter2.get("ip_rule");
                this.m_filter.set("ip_rule", lEFilterRules.clone());
                lEFilterRules = (LEFilterRules)lEFilter2.get("ipx_rule");
                this.m_filter.set("ipx_rule", lEFilterRules.clone());
                lEFilterRules = (LEFilterRules)lEFilter2.get("sap_rule");
                this.m_filter.set("sap_rule", lEFilterRules.clone());
                this.m_filter.getChanges(new LEVector());
                this.m_revertfilter_mi.setEnabled(false);
                if (!this.m_demo) {
                    this.m_save_mi.setEnabled(lEFilters.hasChanges());
                    this.m_saveall_mi.setEnabled(this.needToSave());
                }
                lEFilter = this.m_filter;
            } else {
                LEFilters lEFilters3 = new LEFilters(null);
                LEVector lEVector = lEFilters.getKeys();
                int n = lEVector.size();
                int n2 = 0;
                while (n2 < n) {
                    String string2 = (String)lEVector.elementAt(n2);
                    if (!string2.equals(string)) {
                        lEFilters3.set(string2, lEFilters.get(string2));
                    }
                    ++n2;
                }
                this.m_filterTable.put(this.m_current_portmaster, lEFilters3);
                lEVector = lEFilters3.getKeys();
                if (lEVector.size() > 0) {
                    lEFilter = (LEFilter)lEFilters3.get((String)lEVector.elementAt(0));
                }
            }
        }
        this.set(this.m_current_portmaster);
        if (lEFilter != null) {
            this.set(lEFilter);
        }
    }

    private void renameCurrentFilter(String string) {
        if (!this.filterExists(this.m_current_portmaster, string)) {
            LEFilters lEFilters = this.getFilters(this.m_current_portmaster);
            LEVector lEVector = lEFilters.getKeys();
            int n = lEVector.size();
            String string2 = this.m_filter.getName();
            LEFilters lEFilters2 = new LEFilters(null);
            LEFilter lEFilter = null;
            int n2 = 0;
            while (n2 < n) {
                String string3 = (String)lEVector.elementAt(n2);
                lEFilter = (LEFilter)lEFilters.get(string3);
                if (!string2.equals(string3)) {
                    lEFilters2.set(string3, lEFilter);
                } else {
                    this.m_filter = lEFilter;
                    this.m_filter.setName(string);
                    lEFilters2.set(string, this.m_filter);
                }
                ++n2;
            }
            this.m_filterTable.put(this.m_current_portmaster, lEFilters2);
            if (!this.m_demo) {
                this.m_save_mi.setEnabled(true);
                this.m_saveall_mi.setEnabled(true);
            }
            this.set(this.m_current_portmaster);
            this.set(lEFilter);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("A filter already exists with the name ");
        stringBuffer.append(string);
        stringBuffer.append("!");
        new LEErrorDialog(LEUiUtils.GetBaseFrame(), stringBuffer.toString());
    }

    private void cloneCurrentFilter(String string) {
        if (!this.filterExists(this.m_current_portmaster, string)) {
            LEFilters lEFilters = this.getFilters(this.m_current_portmaster);
            LEFilter lEFilter = (LEFilter)this.m_filter.clone();
            lEFilter.setName(string);
            lEFilters.set(string, lEFilter);
            if (!this.m_demo) {
                this.m_save_mi.setEnabled(true);
                this.m_saveall_mi.setEnabled(true);
            }
            this.set(this.m_current_portmaster);
            this.set(lEFilter);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("A filter already exists with the name ");
        stringBuffer.append(string);
        stringBuffer.append("!");
        new LEErrorDialog(LEUiUtils.GetBaseFrame(), stringBuffer.toString());
    }

    private void reloadCurrentSource() {
        LEFilters lEFilters = (LEFilters)this.m_current_portmaster.fetch("filter");
        if (lEFilters != null) {
            LEFilters lEFilters2 = (LEFilters)lEFilters.clone();
            lEFilters2.clearChangeVectors();
            this.m_filterTable.put(this.m_current_portmaster, lEFilters2);
            if (!this.m_demo) {
                this.m_save_mi.setEnabled(false);
                this.m_saveall_mi.setEnabled(this.needToSave());
            }
            this.set(this.m_current_portmaster);
        }
    }

    private boolean filterExists(LEPortMaster lEPortMaster, String string) {
        LEFilters lEFilters = this.getFilters(lEPortMaster);
        LEVector lEVector = lEFilters.getKeys();
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)lEVector.elementAt(n2);
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

