/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class LEFilterSaveDialog
extends Dialog
implements ActionListener,
WindowListener {
    public static final String OK = "ok";
    public static final String CANCEL = "cancel";
    LEConfirmClient m_client;
    LEVector m_sources;
    Frame m_parent;
    LEFilters m_filters;
    List m_filter_list;
    List m_source_list;
    Button m_save;
    Button m_cancel;

    public LEFilterSaveDialog(Frame frame, LEConfirmClient lEConfirmClient, LEVector lEVector, LEFilters lEFilters) {
        super(frame, "Copy Filters", true);
        this.m_parent = frame;
        this.m_sources = lEVector;
        this.m_client = lEConfirmClient;
        this.m_filters = lEFilters;
        this.setLayout(new BorderLayout());
        this.add("West", this.createFilterListPanel());
        this.add("East", this.createSourceListPanel());
        this.add("South", this.createButtonPanel());
        this.fillFilterList();
        this.fillSourceList();
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = this.getPreferredSize();
        LEUiUtils.CenterDialog(this, dimension.width, dimension.height);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals(OK) && string.equals(CANCEL)) {
            ((Component)this).setVisible(false);
            if (this.m_client != null) {
                this.m_client.cancelAction(null);
            }
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        if (this.m_client != null) {
            this.m_client.cancelAction(null);
        }
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        if (this.m_client != null) {
            this.m_client.cancelAction(null);
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private Panel createFilterListPanel() {
        Panel panel = new Panel(new GridLayout(2, 1));
        panel.add(new Label("Select filters"));
        this.m_filter_list = new List();
        this.m_filter_list.setMultipleMode(true);
        panel.add(this.m_filter_list);
        return panel;
    }

    private Panel createSourceListPanel() {
        Panel panel = new Panel(new GridLayout(2, 1));
        panel.add(new Label("Select destinations"));
        this.m_source_list = new List();
        this.m_source_list.setMultipleMode(true);
        panel.add(this.m_source_list);
        return panel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel();
        this.m_save = new Button("OK");
        this.m_save.setActionCommand(OK);
        this.m_save.addActionListener(this);
        this.m_cancel = new Button("Cancel");
        this.m_cancel.setActionCommand(CANCEL);
        this.m_cancel.addActionListener(this);
        panel.add(this.m_save);
        panel.add(this.m_cancel);
        return panel;
    }

    private void fillFilterList() {
        int n = this.m_filters.size();
        LEVector lEVector = this.m_filters.getKeys();
        int n2 = 0;
        while (n2 < n) {
            this.m_filter_list.addItem((String)lEVector.elementAt(n2));
            ++n2;
        }
    }

    private void fillSourceList() {
        int n = this.m_sources.size();
        int n2 = 0;
        while (n2 < n) {
            LEPortMaster lEPortMaster = (LEPortMaster)this.m_sources.elementAt(n2);
            String string = lEPortMaster.getHostname();
            this.m_source_list.addItem(string);
            ++n2;
        }
    }
}

