/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEFilterRule;
import COM.livingston.model.LEIPRule;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.ui.LETextField;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEDebug;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.StringTokenizer;

public class LEIPRuleEditor
extends LERuleEditor
implements ItemListener,
ActionListener,
TextListener {
    private static final String DNS = "dns";
    private static final String FTP = "ftp";
    private static final String FTP_DATA = "ftp-data";
    private static final String HTTP = "http";
    private static final String IMAP3 = "imap3";
    private static final String NNTP = "nntp";
    private static final String NTP = "ntp";
    private static final String POP3 = "pop3";
    private static final String SMTP = "smtp";
    private static final String SNMP = "snmp";
    private static final String TELNET = "telnet";
    private static final String ECHO_REPLY = "echo reply";
    private static final String DEST_UNREACH = "dest unreachable";
    private static final String SRC_QUENCH = "source quench";
    private static final String REDIRECT = "redirect";
    private static final String ECHO = "echo";
    private static final String TIME_EXCEED = "time exceeded";
    private static final String TIMESTAMP = "timestamp";
    private static final String TIMESTAMP_REPLY = "timestamp reply";
    private static final String INFO_REQ = "information request";
    private static final String INFO_REPLY = "information reply";
    LEIPRule m_rule;
    Checkbox m_src_on;
    Checkbox m_dst_on;
    Checkbox m_log;
    Checkbox m_notify;
    Checkbox m_estab;
    Label m_src_addr_label;
    Label m_dst_addr_label;
    Label m_proto_label;
    Label m_proto_number_label;
    Label m_src_port_label;
    Label m_dst_port_label;
    Label m_icmp_label;
    Label m_options_label;
    Label m_src_cmp_label;
    Label m_dst_cmp_label;
    Label m_log_label;
    Label m_notify_label;
    Label m_estab_label;
    LETextField m_srcaddress;
    LETextField m_dstaddress;
    LETextField m_protocol_num;
    LETextField m_src_port;
    LETextField m_dst_port;
    LETextField m_icmp_type;
    Choice m_protocol;
    Choice m_src_cmp;
    Choice m_src_port_proto;
    Choice m_dst_cmp;
    Choice m_dst_port_proto;
    Choice m_icmp_type_choice;

    public LEIPRuleEditor(LEFilterMediator lEFilterMediator, Container container) {
        this.s_edit_panel = null;
        this.m_mediator = lEFilterMediator;
        this.m_changed = false;
        this.m_container = container;
    }

    public Panel getPanel() {
        if (this.s_edit_panel == null) {
            this.s_edit_panel = this.createPanel();
        }
        this.m_changed = false;
        this.updateActionButtons(this.m_changed);
        return this.s_edit_panel;
    }

    public void setEnabled(boolean bl) {
        this.m_permit.setEnabled(bl);
        this.m_deny.setEnabled(bl);
        this.m_src_on.setEnabled(bl);
        this.m_dst_on.setEnabled(bl);
        this.m_log.setEnabled(bl);
        this.m_log_label.setEnabled(bl);
        this.m_notify.setEnabled(bl);
        this.m_notify_label.setEnabled(bl);
        this.m_estab.setEnabled(bl);
        this.m_estab_label.setEnabled(bl);
        this.m_action_label.setEnabled(bl);
        this.m_src_addr_label.setEnabled(bl);
        this.m_dst_addr_label.setEnabled(bl);
        this.m_proto_label.setEnabled(bl);
        this.m_proto_number_label.setEnabled(bl);
        this.m_src_port_label.setEnabled(bl);
        this.m_dst_port_label.setEnabled(bl);
        this.m_icmp_label.setEnabled(bl);
        this.m_srcaddress.setEnabled(bl);
        this.m_dstaddress.setEnabled(bl);
        this.m_protocol_num.setEnabled(bl);
        this.m_src_port.setEnabled(bl);
        this.m_dst_port.setEnabled(bl);
        this.m_icmp_type.setEnabled(bl);
        this.m_protocol.setEnabled(bl);
        this.m_src_cmp_label.setEnabled(bl);
        this.m_src_cmp.setEnabled(bl);
        this.m_src_port_proto.setEnabled(bl);
        this.m_dst_cmp_label.setEnabled(bl);
        this.m_dst_cmp.setEnabled(bl);
        this.m_dst_port_proto.setEnabled(bl);
        this.m_apply.setEnabled(bl);
        this.m_cancel.setEnabled(bl);
    }

    public void setRule(LEFilterRule lEFilterRule) {
        String string;
        if (!(lEFilterRule instanceof LEIPRule)) {
            return;
        }
        this.m_rule = (LEIPRule)lEFilterRule;
        String string2 = (String)lEFilterRule.get("action");
        if (string2.equals("permit")) {
            this.m_permit.setState(true);
        } else {
            this.m_deny.setState(true);
        }
        ((TextComponent)this.m_srcaddress).setText((String)lEFilterRule.get("source"));
        ((TextComponent)this.m_dstaddress).setText((String)lEFilterRule.get("destination"));
        String string3 = (String)lEFilterRule.get("protocol");
        this.m_protocol.select(string3);
        if (string3.equals("tcp")) {
            this.enableTCPOptions();
            ((TextComponent)this.m_icmp_type).setText("");
            ((TextComponent)this.m_protocol_num).setText("");
        } else if (string3.equals("udp")) {
            this.enableUDPOptions();
            ((TextComponent)this.m_icmp_type).setText("");
            ((TextComponent)this.m_protocol_num).setText("");
        } else if (string3.equals("icmp")) {
            this.enableICMPOptions();
            ((TextComponent)this.m_icmp_type).setText((String)lEFilterRule.get("type"));
            ((TextComponent)this.m_protocol_num).setText("");
            ((TextComponent)this.m_src_port).setText("");
            ((TextComponent)this.m_dst_port).setText("");
        } else if (string3.equals("protocol")) {
            this.enableIPOptions();
            this.m_proto_number_label.setEnabled(true);
            this.m_protocol_num.setEnabled(true);
            ((TextComponent)this.m_icmp_type).setText("");
            ((TextComponent)this.m_protocol_num).setText((String)lEFilterRule.get("protocol_number"));
            ((TextComponent)this.m_src_port).setText("");
            ((TextComponent)this.m_dst_port).setText("");
        } else {
            this.enableIPOptions();
            ((TextComponent)this.m_icmp_type).setText("");
            ((TextComponent)this.m_protocol_num).setText("");
            ((TextComponent)this.m_src_port).setText("");
            ((TextComponent)this.m_dst_port).setText("");
        }
        if (string3.equals("tcp") || string3.equals("udp")) {
            string = (String)lEFilterRule.get("src_cmp");
            if (string.equals("eq")) {
                this.m_src_cmp.select(0);
                this.m_src_on.setState(true);
                this.enableSrcCmp(true);
                ((TextComponent)this.m_src_port).setText((String)lEFilterRule.get("src_port"));
            } else if (string.equals("gt")) {
                this.m_src_cmp.select(1);
                this.m_src_on.setState(true);
                this.enableSrcCmp(true);
                ((TextComponent)this.m_src_port).setText((String)lEFilterRule.get("src_port"));
            } else if (string.equals("lt")) {
                this.m_src_cmp.select(2);
                this.m_src_on.setState(true);
                this.enableSrcCmp(true);
                ((TextComponent)this.m_src_port).setText((String)lEFilterRule.get("src_port"));
            } else {
                this.m_src_on.setState(false);
                this.enableSrcCmp(false);
                ((TextComponent)this.m_src_port).setText("");
            }
            string = (String)lEFilterRule.get("dst_cmp");
            if (string.equals("eq")) {
                this.m_dst_on.setState(true);
                this.enableDstCmp(true);
                this.m_dst_cmp.select(0);
                ((TextComponent)this.m_dst_port).setText((String)lEFilterRule.get("dst_port"));
            } else if (string.equals("gt")) {
                this.m_dst_on.setState(true);
                this.enableDstCmp(true);
                this.m_dst_cmp.select(1);
                ((TextComponent)this.m_dst_port).setText((String)lEFilterRule.get("dst_port"));
            } else if (string.equals("lt")) {
                this.m_dst_on.setState(true);
                this.enableDstCmp(true);
                this.m_dst_cmp.select(2);
                ((TextComponent)this.m_dst_port).setText((String)lEFilterRule.get("dst_port"));
            } else {
                this.m_dst_on.setState(false);
                this.enableDstCmp(false);
                this.enableDstCmp(false);
                ((TextComponent)this.m_dst_port).setText("");
            }
        }
        if ((string = (String)lEFilterRule.get("log")).equals("on")) {
            this.m_log.setState(true);
        } else {
            this.m_log.setState(false);
        }
        string = (String)lEFilterRule.get("notify");
        if (string.equals("on")) {
            this.m_notify.setState(true);
        } else {
            this.m_notify.setState(false);
        }
        string = (String)lEFilterRule.get("estab");
        if (string.equals("on")) {
            this.m_estab.setState(true);
        } else {
            this.m_estab.setState(false);
        }
        this.m_changed = false;
        this.updateActionButtons(this.m_changed);
    }

    public LEFilterRule getRule() {
        return this.m_rule;
    }

    public void clearRule() {
        this.m_rule = null;
        this.m_permit.setState(true);
        ((TextComponent)this.m_srcaddress).setText("");
        ((TextComponent)this.m_dstaddress).setText("");
        this.m_protocol.select(0);
        ((TextComponent)this.m_protocol_num).setText("");
        ((TextComponent)this.m_icmp_type).setText("");
        this.m_src_on.setState(false);
        this.m_src_cmp.select(0);
        ((TextComponent)this.m_src_port).setText("");
        this.m_dst_on.setState(false);
        this.m_dst_cmp.select(0);
        ((TextComponent)this.m_dst_port).setText("");
        this.m_log.setState(false);
        this.m_notify.setState(false);
        this.m_estab.setState(false);
        this.m_apply.setEnabled(false);
        this.m_cancel.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_rule == null) {
            return;
        }
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        this.m_changed = true;
        if (itemSelectable == this.m_protocol) {
            String string = this.m_protocol.getSelectedItem();
            if (string.equals("protocol")) {
                this.enableIPOptions();
                this.m_proto_number_label.setEnabled(true);
                this.m_protocol_num.setEnabled(true);
            } else if (string.equals("icmp")) {
                this.m_proto_number_label.setEnabled(false);
                this.m_protocol_num.setEnabled(false);
                this.enableICMPOptions();
            } else if (string.equals("tcp")) {
                this.enableTCPOptions();
            } else if (string.equals("udp")) {
                this.enableUDPOptions();
            } else {
                this.enableIPOptions();
            }
        } else if (itemSelectable == this.m_src_port_proto) {
            String string = this.processPortNumber(this.m_src_port_proto);
            if (!string.equals("")) {
                ((TextComponent)this.m_src_port).setText(string);
            }
            this.m_src_port_proto.select(0);
        } else if (itemSelectable == this.m_dst_port_proto) {
            String string = this.processPortNumber(this.m_dst_port_proto);
            if (!string.equals("")) {
                ((TextComponent)this.m_dst_port).setText(string);
            }
            this.m_dst_port_proto.select(0);
        } else if (itemSelectable == this.m_src_on) {
            this.enableSrcCmp(this.m_src_on.getState());
        } else if (itemSelectable == this.m_dst_on) {
            this.enableDstCmp(this.m_dst_on.getState());
        } else if (itemSelectable == this.m_icmp_type_choice) {
            String string = this.processICMPType(this.m_icmp_type_choice);
            if (!string.equals("")) {
                ((TextComponent)this.m_icmp_type).setText(string);
            }
            this.m_icmp_type_choice.select(0);
        }
        this.updateActionButtons(this.m_changed);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.m_rule == null) {
            return;
        }
        this.m_changed = true;
        this.updateActionButtons(this.m_changed);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            if (this.m_rule != null) {
                this.applyChanges();
                this.m_mediator.editApplied(this.m_rule);
            }
            this.m_changed = false;
        } else if (string.equals("cancel")) {
            this.setRule(this.m_rule);
            this.m_changed = false;
        }
        this.updateActionButtons(this.m_changed);
    }

    private Panel createPanel() {
        Panel panel = new Panel(new BorderLayout(5, 5));
        Component[][] componentArray = new Component[6][4];
        this.m_action_label = new Label("Rule Action:");
        this.m_action_label.setFont(LEFont.getBoldFont());
        this.m_action_label.setEnabled(false);
        componentArray[0][0] = this.m_action_label;
        componentArray[0][1] = this.createActionPanel();
        this.m_src_addr_label = new Label("Source Address:");
        this.m_src_addr_label.setFont(LEFont.getBoldFont());
        componentArray[1][0] = this.m_src_addr_label;
        this.m_srcaddress = new LETextField(20);
        this.m_srcaddress.addTextListener(this);
        componentArray[1][1] = this.m_srcaddress;
        this.m_dst_addr_label = new Label("Destination Address:");
        this.m_dst_addr_label.setFont(LEFont.getBoldFont());
        componentArray[2][0] = this.m_dst_addr_label;
        this.m_dstaddress = new LETextField(20);
        this.m_dstaddress.addTextListener(this);
        componentArray[2][1] = this.m_dstaddress;
        this.m_proto_label = new Label("Protocol:");
        this.m_proto_label.setFont(LEFont.getBoldFont());
        componentArray[3][0] = this.m_proto_label;
        componentArray[3][1] = this.createProtocolChoice();
        this.m_src_cmp_label = new Label("Source Port:");
        this.m_src_cmp_label.setFont(LEFont.getBoldFont());
        componentArray[4][0] = this.m_src_cmp_label;
        componentArray[4][1] = this.createSrcPortPanel();
        this.m_dst_cmp_label = new Label("Destination Port:");
        this.m_dst_cmp_label.setFont(LEFont.getBoldFont());
        componentArray[5][0] = this.m_dst_cmp_label;
        componentArray[5][1] = this.createDstPortPanel();
        this.m_proto_number_label = new Label("Protocol Number:");
        this.m_proto_number_label.setFont(LEFont.getBoldFont());
        this.m_proto_number_label.setEnabled(false);
        componentArray[0][2] = this.m_proto_number_label;
        this.m_protocol_num = new LETextField(3);
        this.m_protocol_num.setEnabled(false);
        this.m_protocol_num.setNumeric(true);
        this.m_protocol_num.setBounds(0L, 255L);
        this.m_protocol_num.addTextListener(this);
        componentArray[0][3] = this.m_protocol_num;
        this.m_icmp_label = new Label("ICMP Type:");
        this.m_icmp_label.setFont(LEFont.getBoldFont());
        this.m_icmp_label.setEnabled(false);
        componentArray[1][2] = this.m_icmp_label;
        componentArray[1][3] = this.createICMPTypePanel();
        this.m_log_label = new Label("Log:");
        this.m_log_label.setFont(LEFont.getBoldFont());
        componentArray[2][2] = this.m_log_label;
        this.m_log = new Checkbox("");
        this.m_log.addItemListener(this);
        componentArray[2][3] = this.m_log;
        this.m_notify_label = new Label("Notify:");
        this.m_notify_label.setFont(LEFont.getBoldFont());
        componentArray[3][2] = this.m_notify_label;
        this.m_notify = new Checkbox("");
        this.m_notify.addItemListener(this);
        componentArray[3][3] = this.m_notify;
        this.m_estab_label = new Label("Established:");
        this.m_estab_label.setFont(LEFont.getBoldFont());
        componentArray[4][2] = this.m_estab_label;
        this.m_estab = new Checkbox("");
        this.m_estab.addItemListener(this);
        componentArray[4][3] = this.m_estab;
        componentArray[5][2] = new Label("");
        componentArray[5][3] = new Label("");
        LECompGrid lECompGrid = new LECompGrid(componentArray, 5);
        LEScrollablePanel lEScrollablePanel = new LEScrollablePanel(lECompGrid, true, true);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(lEScrollablePanel);
        panel.add("Center", lEScrollPanel);
        panel.add("South", this.createButtonPanel());
        return panel;
    }

    private Choice createProtocolChoice() {
        this.m_protocol = new Choice();
        this.m_protocol.addItem("ip");
        this.m_protocol.addItem("tcp");
        this.m_protocol.addItem("udp");
        this.m_protocol.addItem("icmp");
        this.m_protocol.addItem("ipip");
        this.m_protocol.addItem("ah");
        this.m_protocol.addItem("esp");
        this.m_protocol.addItem("protocol");
        this.m_protocol.setEnabled(false);
        this.m_protocol.addItemListener(this);
        return this.m_protocol;
    }

    private Panel createSrcPortPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.m_src_on = new Checkbox("");
        this.m_src_on.setState(false);
        this.m_src_on.addItemListener(this);
        panel.add(this.m_src_on);
        this.m_src_cmp = new Choice();
        this.m_src_cmp.addItem("=");
        this.m_src_cmp.addItem(">");
        this.m_src_cmp.addItem("<");
        this.m_src_cmp.setEnabled(false);
        this.m_src_cmp.addItemListener(this);
        panel.add(this.m_src_cmp);
        this.m_src_port_label = new Label("port");
        this.m_src_port_label.setEnabled(false);
        panel.add(this.m_src_port_label);
        this.m_src_port = new LETextField(5);
        this.m_src_port.setNumeric(true);
        this.m_src_port.setEnabled(false);
        this.m_src_port.setBounds(1L, 65535L);
        this.m_src_port.addTextListener(this);
        panel.add(this.m_src_port);
        this.m_src_port_proto = this.createPortProtocolChoice();
        this.m_src_port_proto.setEnabled(false);
        this.m_src_port_proto.addItemListener(this);
        panel.add(this.m_src_port_proto);
        return panel;
    }

    private Panel createDstPortPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.m_dst_on = new Checkbox("");
        this.m_dst_on.setState(false);
        this.m_dst_on.addItemListener(this);
        panel.add(this.m_dst_on);
        this.m_dst_cmp = new Choice();
        this.m_dst_cmp.addItem("=");
        this.m_dst_cmp.addItem(">");
        this.m_dst_cmp.addItem("<");
        this.m_dst_cmp.setEnabled(false);
        this.m_dst_cmp.addItemListener(this);
        panel.add(this.m_dst_cmp);
        this.m_dst_port_label = new Label("port");
        this.m_dst_port_label.setEnabled(false);
        panel.add(this.m_dst_port_label);
        this.m_dst_port = new LETextField(5);
        this.m_dst_port.setNumeric(true);
        this.m_dst_port.setEnabled(false);
        this.m_dst_port.setBounds(1L, 65535L);
        this.m_dst_port.addTextListener(this);
        panel.add(this.m_dst_port);
        this.m_dst_port_proto = this.createPortProtocolChoice();
        this.m_dst_port_proto.setEnabled(false);
        this.m_dst_port_proto.addItemListener(this);
        panel.add(this.m_dst_port_proto);
        return panel;
    }

    private Panel createICMPTypePanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.m_icmp_type = new LETextField(3);
        this.m_icmp_type.setNumeric(true);
        this.m_icmp_type.setEnabled(false);
        this.m_icmp_type.setBounds(0L, 255L);
        this.m_icmp_type.addTextListener(this);
        panel.add(this.m_icmp_type);
        this.m_icmp_type_choice = this.createICMPChoice();
        this.m_icmp_type_choice.setEnabled(false);
        this.m_icmp_type_choice.addItemListener(this);
        panel.add(this.m_icmp_type_choice);
        return panel;
    }

    private Choice createPortProtocolChoice() {
        Choice choice = new Choice();
        choice.addItem("");
        choice.addItem(DNS);
        choice.addItem(FTP);
        choice.addItem(FTP_DATA);
        choice.addItem(HTTP);
        choice.addItem(IMAP3);
        choice.addItem(NNTP);
        choice.addItem(NTP);
        choice.addItem(POP3);
        choice.addItem(SMTP);
        choice.addItem(SNMP);
        choice.addItem(TELNET);
        return choice;
    }

    private Choice createICMPChoice() {
        Choice choice = new Choice();
        choice.addItem("");
        choice.addItem(ECHO_REPLY);
        choice.addItem(DEST_UNREACH);
        choice.addItem(SRC_QUENCH);
        choice.addItem(REDIRECT);
        choice.addItem(ECHO);
        choice.addItem(TIME_EXCEED);
        choice.addItem(TIMESTAMP);
        choice.addItem(TIMESTAMP_REPLY);
        choice.addItem(INFO_REQ);
        choice.addItem(INFO_REPLY);
        return choice;
    }

    private void enableSrcCmp(boolean bl) {
        this.m_src_cmp.setEnabled(bl);
        this.m_src_port_label.setEnabled(bl);
        this.m_src_port.setEnabled(bl);
        this.m_src_port_proto.setEnabled(bl);
    }

    private void enableDstCmp(boolean bl) {
        this.m_dst_cmp.setEnabled(bl);
        this.m_dst_port_label.setEnabled(bl);
        this.m_dst_port.setEnabled(bl);
        this.m_dst_port_proto.setEnabled(bl);
    }

    private String processPortNumber(Choice choice) {
        String string = choice.getSelectedItem();
        if (string.equals("")) {
            return "";
        }
        if (string.equals(FTP)) {
            return "21";
        }
        if (string.equals(FTP_DATA)) {
            return "20";
        }
        if (string.equals(SMTP)) {
            return "25";
        }
        if (string.equals(HTTP)) {
            return "80";
        }
        if (string.equals(DNS)) {
            return "53";
        }
        if (string.equals(TELNET)) {
            return "23";
        }
        if (string.equals(NTP)) {
            return "123";
        }
        if (string.equals(NNTP)) {
            return "123";
        }
        if (string.equals(SNMP)) {
            return "161";
        }
        if (string.equals(IMAP3)) {
            return "220";
        }
        if (string.equals(POP3)) {
            return "110";
        }
        return "";
    }

    private String processICMPType(Choice choice) {
        String string = choice.getSelectedItem();
        if (string.equals(ECHO_REPLY)) {
            return "0";
        }
        if (string.equals(DEST_UNREACH)) {
            return "3";
        }
        if (string.equals(SRC_QUENCH)) {
            return "4";
        }
        if (string.equals(REDIRECT)) {
            return "5";
        }
        if (string.equals(ECHO)) {
            return "8";
        }
        if (string.equals(TIME_EXCEED)) {
            return "11";
        }
        if (string.equals(TIMESTAMP)) {
            return "13";
        }
        if (string.equals(TIMESTAMP_REPLY)) {
            return "14";
        }
        if (string.equals(INFO_REQ)) {
            return "15";
        }
        if (string.equals(INFO_REPLY)) {
            return "16";
        }
        return "";
    }

    private void enableICMPOptions() {
        this.m_icmp_label.setEnabled(true);
        this.m_icmp_type.setEnabled(true);
        this.m_icmp_type_choice.setEnabled(true);
        this.m_estab_label.setEnabled(false);
        this.m_estab.setEnabled(false);
        this.m_src_on.setState(false);
        this.m_src_on.setEnabled(false);
        this.m_src_cmp_label.setEnabled(false);
        this.enableSrcCmp(false);
        this.m_dst_on.setState(false);
        this.m_dst_on.setEnabled(false);
        this.m_dst_cmp_label.setEnabled(false);
        this.enableDstCmp(false);
        this.m_proto_number_label.setEnabled(false);
        this.m_protocol_num.setEnabled(false);
    }

    private void enableIPOptions() {
        this.m_icmp_label.setEnabled(false);
        this.m_icmp_type.setEnabled(false);
        this.m_icmp_type_choice.setEnabled(false);
        this.m_estab_label.setEnabled(false);
        this.m_estab.setEnabled(false);
        this.m_src_on.setState(false);
        this.m_src_on.setEnabled(false);
        this.m_src_cmp_label.setEnabled(false);
        this.enableSrcCmp(false);
        this.m_dst_on.setState(false);
        this.m_dst_on.setEnabled(false);
        this.m_dst_cmp_label.setEnabled(false);
        this.enableDstCmp(false);
        this.m_proto_number_label.setEnabled(false);
        this.m_protocol_num.setEnabled(false);
    }

    private void enableTCPOptions() {
        this.m_icmp_label.setEnabled(false);
        this.m_icmp_type.setEnabled(false);
        this.m_icmp_type_choice.setEnabled(false);
        this.m_estab_label.setEnabled(true);
        this.m_estab.setEnabled(true);
        this.m_src_on.setEnabled(true);
        this.m_src_cmp_label.setEnabled(true);
        if (this.m_src_on.getState()) {
            this.enableSrcCmp(true);
        }
        this.m_dst_on.setEnabled(true);
        this.m_dst_cmp_label.setEnabled(true);
        if (this.m_dst_on.getState()) {
            this.enableDstCmp(true);
        }
        this.m_proto_number_label.setEnabled(false);
        this.m_protocol_num.setEnabled(false);
    }

    private void enableUDPOptions() {
        this.m_icmp_label.setEnabled(false);
        this.m_icmp_type.setEnabled(false);
        this.m_icmp_type_choice.setEnabled(false);
        this.m_estab_label.setEnabled(false);
        this.m_estab.setEnabled(false);
        this.m_src_on.setEnabled(true);
        this.m_src_cmp_label.setEnabled(true);
        if (this.m_src_on.getState()) {
            this.enableSrcCmp(true);
        }
        this.m_dst_on.setEnabled(true);
        this.m_dst_cmp_label.setEnabled(true);
        if (this.m_dst_on.getState()) {
            this.enableDstCmp(true);
        }
        this.m_proto_number_label.setEnabled(false);
        this.m_protocol_num.setEnabled(false);
    }

    private void applyChanges() {
        if (this.m_rule == null) {
            return;
        }
        if (!this.validAddress(this.m_srcaddress.getText())) {
            String string = new String("The source address is invalid!");
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), string);
            return;
        }
        if (!this.validAddress(this.m_dstaddress.getText())) {
            String string = new String("The destination address is invalid!");
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), string);
            return;
        }
        if (this.m_permit.getState()) {
            this.m_rule.set("action", "permit");
        } else {
            this.m_rule.set("action", "deny");
        }
        String string = this.m_srcaddress.getText();
        if (string.equals("")) {
            this.m_rule.set("source", "0.0.0.0/0");
        } else {
            this.m_rule.set("source", string);
        }
        string = this.m_dstaddress.getText();
        if (string.equals("")) {
            this.m_rule.set("destination", "0.0.0.0/0");
        } else {
            this.m_rule.set("destination", string);
        }
        String string2 = this.m_protocol.getSelectedItem();
        this.m_rule.set("protocol", string2);
        if (string2.equals("tcp") || string2.equals("udp")) {
            int n;
            if (this.m_dst_on.getState()) {
                n = this.m_dst_cmp.getSelectedIndex();
                if (n == 0) {
                    this.m_rule.set("dst_cmp", "eq");
                } else if (n == 1) {
                    this.m_rule.set("dst_cmp", "gt");
                } else {
                    this.m_rule.set("dst_cmp", "lt");
                }
                this.m_rule.set("dst_port", this.m_dst_port.getText());
            } else {
                this.m_rule.set("dst_cmp", "");
                this.m_rule.set("dst_port", "0");
            }
            if (this.m_src_on.getState()) {
                n = this.m_src_cmp.getSelectedIndex();
                if (n == 0) {
                    this.m_rule.set("src_cmp", "eq");
                } else if (n == 1) {
                    this.m_rule.set("src_cmp", "gt");
                } else {
                    this.m_rule.set("src_cmp", "lt");
                }
                this.m_rule.set("src_port", this.m_src_port.getText());
            } else {
                this.m_rule.set("src_cmp", "");
                this.m_rule.set("src_port", "0");
            }
        } else {
            this.m_rule.set("dst_cmp", "");
            this.m_rule.set("dst_port", "0");
            this.m_rule.set("src_cmp", "");
            this.m_rule.set("src_port", "0");
        }
        if (string2.equals("protocol")) {
            this.m_rule.set("protocol_number", this.m_protocol_num.getText());
        } else {
            this.m_rule.set("protocol_number", "0");
        }
        if (string2.equals("icmp")) {
            this.m_rule.set("type", this.m_icmp_type.getText());
        } else {
            this.m_rule.set("type", "");
        }
        if (this.m_log.getState()) {
            this.m_rule.set("log", "on");
        } else {
            this.m_rule.set("log", "off");
        }
        if (this.m_notify.getState()) {
            this.m_rule.set("notify", "on");
        } else {
            this.m_rule.set("notify", "off");
        }
        if (this.m_estab.isEnabled() && this.m_estab.getState()) {
            this.m_rule.set("estab", "on");
            return;
        }
        this.m_rule.set("estab", "off");
    }

    boolean validAddress(String string) {
        if (string.startsWith("=")) {
            return this.validChoiceNetAddress(string.substring(1));
        }
        if (string.indexOf(".") > 0 && string.indexOf("/") > 0) {
            return this.validIPAddress(string);
        }
        return false;
    }

    boolean validChoiceNetAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = string2.toLowerCase();
            int n = string3.length();
            char[] cArray = string3.toCharArray();
            int n2 = 0;
            while (n2 < n) {
                if (!Character.isLetterOrDigit(cArray[n2]) && cArray[n2] != '_') {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    boolean validIPAddress(String string) {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "./");
        if (stringTokenizer.countTokens() != 5) {
            return false;
        }
        try {
            int n3;
            String string2;
            int n4 = 0;
            while (n4 < 4) {
                string2 = stringTokenizer.nextToken();
                n3 = Integer.parseInt(string2);
                if (n3 < 0 || n3 > 255) {
                    return false;
                }
                n += n3;
                ++n4;
            }
            string2 = stringTokenizer.nextToken();
            n3 = Integer.parseInt(string2);
            if (n3 < 0 || n3 > 32) {
                return false;
            }
            n2 = n3;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return n2 != 0 || n <= 0;
    }
}

