/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEFilterRule;
import COM.livingston.model.LEIPXRule;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.ui.LETextField;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class LEIPXRuleEditor
extends LERuleEditor
implements TextListener {
    LEIPXRule m_rule;
    LETextField m_srcnet;
    LETextField m_dstnet;
    LETextField m_srchost;
    LETextField m_dsthost;
    LETextField m_srcsocket;
    LETextField m_dstsocket;
    Label m_srcnet_label;
    Label m_dstnet_label;
    Label m_srchost_label;
    Label m_dsthost_label;
    Label m_src_cmp_label;
    Label m_dst_cmp_label;
    Checkbox m_src_cmp_on;
    Checkbox m_dst_cmp_on;
    Choice m_src_cmp;
    Choice m_dst_cmp;

    public LEIPXRuleEditor(LEFilterMediator lEFilterMediator, Container container) {
        this.s_edit_panel = null;
        this.m_mediator = lEFilterMediator;
        this.m_changed = false;
        this.m_container = container;
    }

    public Panel getPanel() {
        if (this.s_edit_panel == null) {
            this.s_edit_panel = this.createPanel();
        }
        this.m_changed = false;
        this.updateActionButtons(this.m_changed);
        return this.s_edit_panel;
    }

    public void setEnabled(boolean bl) {
        this.m_permit.setEnabled(bl);
        this.m_deny.setEnabled(bl);
        this.m_action_label.setEnabled(bl);
        this.m_srcnet.setEnabled(bl);
        this.m_dstnet.setEnabled(bl);
        this.m_srchost.setEnabled(bl);
        this.m_dsthost.setEnabled(bl);
        this.m_srcsocket.setEnabled(bl);
        this.m_dstsocket.setEnabled(bl);
        this.m_srcnet_label.setEnabled(bl);
        this.m_dstnet_label.setEnabled(bl);
        this.m_srchost_label.setEnabled(bl);
        this.m_dsthost_label.setEnabled(bl);
        this.m_src_cmp_label.setEnabled(bl);
        this.m_dst_cmp_label.setEnabled(bl);
        this.m_src_cmp_on.setEnabled(bl);
        this.m_dst_cmp_on.setEnabled(bl);
        this.m_src_cmp.setEnabled(bl);
        this.m_dst_cmp.setEnabled(bl);
        this.m_apply.setEnabled(bl);
        this.m_cancel.setEnabled(bl);
    }

    public void setRule(LEFilterRule lEFilterRule) {
        if (!(lEFilterRule instanceof LEIPXRule)) {
            return;
        }
        this.m_rule = (LEIPXRule)lEFilterRule;
        String string = (String)lEFilterRule.get("action");
        if (string.equals("permit")) {
            this.m_permit.setState(true);
        } else {
            this.m_deny.setState(true);
        }
        ((TextComponent)this.m_srcnet).setText((String)lEFilterRule.get("src_net"));
        ((TextComponent)this.m_dstnet).setText((String)lEFilterRule.get("dst_net"));
        ((TextComponent)this.m_srchost).setText((String)lEFilterRule.get("src_host"));
        ((TextComponent)this.m_dsthost).setText((String)lEFilterRule.get("dst_host"));
        String string2 = (String)lEFilterRule.get("src_cmp");
        if (!string2.equals("")) {
            this.m_src_cmp_on.setState(true);
            if (string2.equals("gt")) {
                this.m_src_cmp.select(1);
            } else if (string2.equals("lt")) {
                this.m_src_cmp.select(2);
            }
            ((TextComponent)this.m_srcsocket).setText((String)lEFilterRule.get("src_socket"));
        } else {
            this.m_src_cmp_on.setState(false);
            this.m_src_cmp.select(0);
            ((TextComponent)this.m_srcsocket).setText("");
            this.enableSrcCmp(false);
        }
        string2 = (String)lEFilterRule.get("dst_cmp");
        if (!string2.equals("")) {
            this.m_dst_cmp_on.setState(true);
            if (string2.equals("gt")) {
                this.m_dst_cmp.select(1);
            } else if (string2.equals("lt")) {
                this.m_dst_cmp.select(2);
            }
            ((TextComponent)this.m_dstsocket).setText((String)lEFilterRule.get("dst_socket"));
            return;
        }
        this.m_dst_cmp_on.setState(false);
        this.m_dst_cmp.select(0);
        ((TextComponent)this.m_dstsocket).setText("");
        this.enableDstCmp(false);
    }

    public LEFilterRule getRule() {
        return this.m_rule;
    }

    public void clearRule() {
        ((TextComponent)this.m_srcnet).setText("");
        ((TextComponent)this.m_dstnet).setText("");
        ((TextComponent)this.m_srchost).setText("");
        ((TextComponent)this.m_dsthost).setText("");
        ((TextComponent)this.m_srcsocket).setText("");
        ((TextComponent)this.m_dstsocket).setText("");
        this.m_src_cmp_on.setState(false);
        this.m_dst_cmp_on.setState(false);
        this.m_src_cmp.select(0);
        this.m_dst_cmp.select(0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        this.m_changed = true;
        if (itemSelectable == this.m_src_cmp_on) {
            this.enableSrcCmp(this.m_src_cmp_on.getState());
            return;
        }
        if (itemSelectable == this.m_dst_cmp_on) {
            this.enableDstCmp(this.m_dst_cmp_on.getState());
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.m_changed = true;
        this.updateActionButtons(this.m_changed);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            if (this.m_rule != null) {
                this.applyChanges();
                this.m_mediator.editApplied(this.m_rule);
            }
            this.m_changed = false;
        } else if (string.equals("cancel")) {
            this.setRule(this.m_rule);
            this.m_changed = false;
        }
        this.updateActionButtons(this.m_changed);
    }

    private Panel createPanel() {
        Panel panel = new Panel(new BorderLayout(5, 5));
        Component[][] componentArray = new Component[5][4];
        panel.add("South", this.createButtonPanel());
        this.m_action_label = new Label("Rule Action:");
        this.m_action_label.setFont(LEFont.getBoldFont());
        componentArray[0][0] = this.m_action_label;
        componentArray[0][1] = this.createActionPanel();
        this.m_srcnet_label = new Label("Source Network:");
        this.m_srcnet_label.setFont(LEFont.getBoldFont());
        componentArray[1][0] = this.m_srcnet_label;
        this.m_srcnet = new LETextField(8);
        this.m_srcnet.setHex(true);
        this.m_srcnet.addTextListener(this);
        componentArray[1][1] = this.m_srcnet;
        this.m_dstnet_label = new Label("Destination Network:");
        this.m_dstnet_label.setFont(LEFont.getBoldFont());
        componentArray[2][0] = this.m_dstnet_label;
        this.m_dstnet = new LETextField(8);
        this.m_dstnet.setHex(true);
        this.m_dstnet.addTextListener(this);
        componentArray[2][1] = this.m_dstnet;
        this.m_src_cmp_label = new Label("Source Socket:");
        this.m_src_cmp_label.setFont(LEFont.getBoldFont());
        componentArray[3][0] = this.m_src_cmp_label;
        componentArray[3][1] = this.createSrcSocketPanel();
        this.m_dst_cmp_label = new Label("Destination Socket:");
        this.m_dst_cmp_label.setFont(LEFont.getBoldFont());
        componentArray[4][0] = this.m_dst_cmp_label;
        componentArray[4][1] = this.createDstSocketPanel();
        componentArray[0][2] = new Label("");
        componentArray[0][3] = new Label("");
        this.m_srchost_label = new Label("Source Host:");
        this.m_srchost_label.setFont(LEFont.getBoldFont());
        componentArray[1][2] = this.m_srchost_label;
        this.m_srchost = new LETextField(12);
        this.m_srchost.setHex(true);
        this.m_srchost.addTextListener(this);
        componentArray[1][3] = this.m_srchost;
        this.m_dsthost_label = new Label("Destination Host:");
        this.m_dsthost_label.setFont(LEFont.getBoldFont());
        componentArray[2][2] = this.m_dsthost_label;
        this.m_dsthost = new LETextField(12);
        this.m_dsthost.setHex(true);
        this.m_dsthost.addTextListener(this);
        componentArray[2][3] = this.m_dsthost;
        componentArray[3][2] = new Label("");
        componentArray[3][3] = new Label("");
        componentArray[4][2] = new Label("");
        componentArray[4][3] = new Label("");
        LECompGrid lECompGrid = new LECompGrid(componentArray, 5);
        LEScrollablePanel lEScrollablePanel = new LEScrollablePanel(lECompGrid, true, true);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(lEScrollablePanel);
        panel.add("Center", lEScrollPanel);
        return panel;
    }

    private Panel createSrcSocketPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.m_src_cmp_on = new Checkbox("", false);
        this.m_src_cmp_on.setFont(LEFont.getBoldFont());
        this.m_src_cmp_on.addItemListener(this);
        this.m_src_cmp = new Choice();
        this.m_src_cmp.addItem("=");
        this.m_src_cmp.addItem(">");
        this.m_src_cmp.addItem("<");
        this.m_src_cmp.setEnabled(false);
        this.m_srcsocket = new LETextField(5);
        this.m_srcsocket.setNumeric(true);
        this.m_srcsocket.setBounds(1L, 65535L);
        this.m_srcsocket.addTextListener(this);
        panel.add(this.m_src_cmp_on);
        panel.add(this.m_src_cmp);
        panel.add(this.m_srcsocket);
        return panel;
    }

    private Panel createDstSocketPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.m_dst_cmp_on = new Checkbox("", false);
        this.m_dst_cmp_on.setFont(LEFont.getBoldFont());
        this.m_dst_cmp_on.addItemListener(this);
        this.m_dst_cmp = new Choice();
        this.m_dst_cmp.addItem("=");
        this.m_dst_cmp.addItem(">");
        this.m_dst_cmp.addItem("<");
        this.m_dst_cmp.setEnabled(false);
        this.m_dstsocket = new LETextField(5);
        this.m_dstsocket.setNumeric(true);
        this.m_dstsocket.setBounds(1L, 65535L);
        this.m_dstsocket.addTextListener(this);
        panel.add(this.m_dst_cmp_on);
        panel.add(this.m_dst_cmp);
        panel.add(this.m_dstsocket);
        return panel;
    }

    private void enableSrcCmp(boolean bl) {
        this.m_src_cmp.setEnabled(bl);
        this.m_srcsocket.setEnabled(bl);
    }

    private void enableDstCmp(boolean bl) {
        this.m_dst_cmp.setEnabled(bl);
        this.m_dstsocket.setEnabled(bl);
    }

    private void applyChanges() {
        int n;
        if (this.m_rule == null) {
            return;
        }
        if (this.m_permit.getState()) {
            this.m_rule.set("action", "permit");
        } else {
            this.m_rule.set("action", "deny");
        }
        String string = this.m_srcnet.getText();
        this.m_rule.set("src_net", string);
        string = this.m_dstnet.getText();
        this.m_rule.set("dst_net", string);
        string = this.m_srchost.getText();
        this.m_rule.set("src_host", string);
        string = this.m_dsthost.getText();
        this.m_rule.set("dst_host", string);
        if (this.m_src_cmp_on.getState()) {
            n = this.m_src_cmp.getSelectedIndex();
            if (n == 0) {
                this.m_rule.set("src_cmp", "eq");
            } else if (n == 1) {
                this.m_rule.set("src_cmp", "gt");
            } else {
                this.m_rule.set("src_cmp", "lt");
            }
            this.m_rule.set("src_socket", this.m_srcsocket.getText());
        } else {
            this.m_rule.set("src_cmp", "");
            this.m_rule.set("src_socket", "");
        }
        if (this.m_dst_cmp_on.getState()) {
            n = this.m_dst_cmp.getSelectedIndex();
            if (n == 0) {
                this.m_rule.set("dst_cmp", "eq");
            } else if (n == 1) {
                this.m_rule.set("dst_cmp", "gt");
            } else {
                this.m_rule.set("dst_cmp", "lt");
            }
            this.m_rule.set("dst_socket", this.m_dstsocket.getText());
            return;
        }
        this.m_rule.set("dst_cmp", "");
        this.m_rule.set("dst_socket", "");
    }
}

