/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEIPRule;
import COM.livingston.model.LEIPXRule;
import COM.livingston.model.LESAPRule;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEUiUtils;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class LENewRule
implements LEConfirmClient {
    public static final int IP = 0;
    public static final int IPX = 1;
    public static final int SAP = 2;
    public static final String DEFAULT_ADDR = "0.0.0.0/0";
    public static final String DEFAULT_PORT = "0";
    LEFilterMediator m_mediator;
    Checkbox m_scratch;
    int m_rule_type;

    public LENewRule(LEFilterMediator lEFilterMediator, int n) {
        this.m_mediator = lEFilterMediator;
        this.m_rule_type = n;
    }

    public void createNewRule() {
        Panel panel = new Panel(new GridLayout(3, 1));
        panel.add(new Label("New rule:"));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_scratch = new Checkbox("Create new rule from scratch", checkboxGroup, true);
        panel.add(this.m_scratch);
        Checkbox checkbox = new Checkbox("Create one or more rules from wizard", checkboxGroup, false);
        checkbox.setEnabled(false);
        panel.add(checkbox);
        String[] stringArray = new String[]{LEConfirmDialog.OK, LEConfirmDialog.CANCEL};
        LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.GetBaseFrame(), (LEConfirmClient)this, panel, stringArray, null);
        ((Component)lEConfirmDialog).setVisible(true);
    }

    public void confirmAction(String string, Object object) {
        if (string.equals("OK") && this.m_scratch.getState()) {
            this.createRule();
        }
    }

    public void cancelAction(Object object) {
    }

    private void createRule() {
        switch (this.m_rule_type) {
            case 0: {
                LEIPRule lEIPRule = new LEIPRule(null, "", "");
                this.initIPRule(lEIPRule);
                this.m_mediator.add(lEIPRule);
                return;
            }
            case 1: {
                LEIPXRule lEIPXRule = new LEIPXRule(null, "", "");
                this.initIPXRule(lEIPXRule);
                this.m_mediator.add(lEIPXRule);
                return;
            }
            case 2: {
                LESAPRule lESAPRule = new LESAPRule(null, "", "");
                this.initSAPRule(lESAPRule);
                this.m_mediator.add(lESAPRule);
                return;
            }
        }
    }

    private void initIPRule(LEIPRule lEIPRule) {
        lEIPRule.set("action", "permit");
        lEIPRule.set("dst_cmp", "");
        lEIPRule.set("dst_port", DEFAULT_PORT);
        lEIPRule.set("destination", DEFAULT_ADDR);
        lEIPRule.set("estab", "off");
        lEIPRule.set("log", "off");
        lEIPRule.set("notify", "off");
        lEIPRule.set("protocol", "ip");
        lEIPRule.set("protocol_number", DEFAULT_PORT);
        lEIPRule.set("source", DEFAULT_ADDR);
        lEIPRule.set("src_cmp", "");
        lEIPRule.set("src_port", DEFAULT_PORT);
        lEIPRule.set("type", "");
    }

    private void initIPXRule(LEIPXRule lEIPXRule) {
        lEIPXRule.set("action", "permit");
        lEIPXRule.set("dst_cmp", "");
        lEIPXRule.set("dst_net", "");
        lEIPXRule.set("dst_host", "");
        lEIPXRule.set("dst_socket", "");
        lEIPXRule.set("src_cmp", "");
        lEIPXRule.set("src_host", "");
        lEIPXRule.set("src_net", "");
        lEIPXRule.set("src_socket", "");
    }

    private void initSAPRule(LESAPRule lESAPRule) {
        lESAPRule.set("action", "permit");
        lESAPRule.set("cmp", "");
        lESAPRule.set("server", "");
        lESAPRule.set("network", "");
        lESAPRule.set("host", "");
        lESAPRule.set("socket", "");
    }
}

