/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilterRule;
import COM.livingston.model.LEFilterRules;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEIPRule;
import COM.livingston.model.LEIPRules;
import COM.livingston.model.LEIPXRule;
import COM.livingston.model.LEIPXRules;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESAPRule;
import COM.livingston.model.LESAPRules;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMLListener;
import COM.livingston.ui.LEMultiList;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LETitleBar;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LERuleListPanel
extends Panel
implements ActionListener,
LEMLListener,
ItemListener,
LEConfirmClient {
    public static final String DELETE = "delete";
    public static final String UP = "up";
    public static final String DOWN = "down";
    private static final String IPRULES = "IP Rules";
    private static final String IPXRULES = "IPX Rules";
    private static final String SAPRULES = "SAP Rules";
    Button m_add;
    Button m_delete;
    Button m_up;
    Button m_down;
    Button m_new_filter;
    Choice m_filter_choice;
    Choice m_rule_choice;
    Choice m_source_choice;
    Panel m_listpanel;
    LEMultiList m_filterlist;
    LEFilterMediator m_mediator;
    LEFilter m_curr_filter;
    LEPortMaster m_portmaster;
    LEVector m_selected_rows;
    LEScrollPanel m_scrollpanel;
    Panel m_selectionpanel;

    public LERuleListPanel(LEFilterMediator lEFilterMediator) {
        super(new BorderLayout());
        this.m_mediator = lEFilterMediator;
        this.m_selectionpanel = this.createSelectionPanel();
        this.add("North", this.m_selectionpanel);
        this.add("South", this.createButtonPanel());
        this.m_filterlist = new LEMultiList(1, 1, 7);
        this.m_filterlist.addListener(this);
        this.m_scrollpanel = new LEScrollPanel(this.m_filterlist);
        this.m_filterlist.setScrollPanel(this.m_scrollpanel);
        this.set(new LEFilter(null, ""));
        this.m_selected_rows = new LEVector();
        this.add("Center", this.m_scrollpanel);
    }

    public void updateFilterNames(LEVector lEVector) {
        this.m_filter_choice.invalidate();
        this.m_filter_choice.removeAll();
        this.fillFilterNames(lEVector);
        if (lEVector.size() > 0) {
            this.m_add.setEnabled(true);
        } else {
            this.enableControlButtons(false);
        }
        this.enableTraverseButtons(false);
        this.m_filter_choice.validate();
        this.m_selectionpanel.invalidate();
        this.m_selectionpanel.validate();
    }

    public void set(LEFilter lEFilter) {
        this.m_curr_filter = lEFilter;
        this.m_filter_choice.select(lEFilter.getName());
        this.m_filterlist.deleteAllRows();
        String string = this.m_rule_choice.getSelectedItem();
        if (string.equals(IPRULES)) {
            this.buildIPRuleList((LEIPRules)lEFilter.get("ip_rule"));
        } else if (string.equals(IPXRULES)) {
            this.buildIPXRuleList((LEIPXRules)lEFilter.get("ipx_rule"));
        } else if (string.equals(SAPRULES)) {
            this.buildSAPRuleList((LESAPRules)lEFilter.get("sap_rule"));
        }
        this.m_filterlist.layoutGrid();
    }

    public void set(LEFilterRule lEFilterRule) {
        Object object;
        int n;
        String string = lEFilterRule.getNumber();
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        if (lEFilterRule instanceof LEIPRule) {
            object = (LEIPRules)this.m_curr_filter.get("ip_rule");
            ((LEConfig)object).set(string, lEFilterRule);
            this.m_filterlist.deleteAllRows();
            this.buildIPRuleList((LEIPRules)object);
        } else if (lEFilterRule instanceof LEIPXRule) {
            object = (LEIPXRules)this.m_curr_filter.get("ipx_rule");
            ((LEConfig)object).set(string, lEFilterRule);
            this.m_filterlist.deleteAllRows();
            this.buildIPXRuleList((LEIPXRules)object);
        } else if (lEFilterRule instanceof LESAPRule) {
            object = (LESAPRules)this.m_curr_filter.get("sap_rule");
            ((LEConfig)object).set(string, lEFilterRule);
            this.m_filterlist.deleteAllRows();
            this.buildSAPRuleList((LESAPRules)object);
        }
        object = new int[1];
        object[0] = n - 1;
        this.m_filterlist.selectRows((int[])object);
    }

    public void set(LEFilterRules lEFilterRules) {
        if (lEFilterRules instanceof LEIPRules) {
            this.m_filterlist.deleteAllRows();
            this.buildIPRuleList((LEIPRules)lEFilterRules);
        } else if (lEFilterRules instanceof LEIPXRules) {
            this.m_filterlist.deleteAllRows();
            this.buildIPXRuleList((LEIPXRules)lEFilterRules);
        } else if (lEFilterRules instanceof LESAPRules) {
            this.m_filterlist.deleteAllRows();
            this.buildSAPRuleList((LESAPRules)lEFilterRules);
        }
        this.m_filterlist.layoutGrid();
    }

    public void set(LEPortMaster lEPortMaster) {
        this.m_portmaster = lEPortMaster;
        String string = lEPortMaster.getHostname();
        int n = this.m_source_choice.getItemCount();
        boolean bl = false;
        int n2 = 0;
        this.m_source_choice.invalidate();
        while (n2 < n && !bl) {
            if (this.m_source_choice.getItem(n2).equals(string)) {
                bl = true;
                this.m_source_choice.select(n2);
            }
            ++n2;
        }
        if (!bl) {
            this.m_source_choice.addItem(string);
            this.m_source_choice.select(string);
        }
        this.m_source_choice.validate();
        this.m_selectionpanel.invalidate();
        this.m_selectionpanel.validate();
        LEFilters lEFilters = this.m_mediator.getFilters(lEPortMaster);
        if (lEFilters == null) {
            lEFilters = new LEFilters(lEPortMaster.getConfigFacility());
            lEPortMaster.set("filter", lEFilters);
            this.m_mediator.add(lEFilters);
        }
        LEVector lEVector = lEFilters != null ? lEFilters.getKeys() : new LEVector();
        this.updateFilterNames(lEVector);
        if (lEVector.size() > 0) {
            this.m_mediator.set((LEFilter)lEFilters.get((String)lEVector.elementAt(0)));
            return;
        }
        this.m_curr_filter = null;
        this.m_filterlist.deleteAllRows();
        this.m_filterlist.layoutGrid();
    }

    public void add(LEFilter lEFilter) {
        LEFilters lEFilters = this.m_mediator.getFilters(this.m_portmaster);
        LEVector lEVector = lEFilters.getKeys();
        int n = lEVector.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n && !bl) {
            String string = (String)lEVector.elementAt(n2);
            if (string.equals(lEFilter.getName())) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            lEFilters.set(lEFilter.getName(), lEFilter);
            lEVector.add(lEFilter.getName());
            this.updateFilterNames(lEVector);
            this.m_mediator.set(lEFilter);
        }
    }

    public void add(LEFilterRule lEFilterRule) {
        LEFilterRules lEFilterRules = null;
        if (lEFilterRule instanceof LEIPRule) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ip_rule");
            if (lEFilterRules == null) {
                lEFilterRules = new LEIPRules(null, this.m_curr_filter.getName());
                this.m_curr_filter.set("ip_rule", lEFilterRules);
            }
        } else if (lEFilterRule instanceof LEIPXRule) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ipx_rule");
            if (lEFilterRules == null) {
                lEFilterRules = new LEIPXRules(null, this.m_curr_filter.getName());
                this.m_curr_filter.set("ipx_rule", lEFilterRules);
            }
        } else if (lEFilterRule instanceof LESAPRule && (lEFilterRules = (LEFilterRules)this.m_curr_filter.get("sap_rule")) == null) {
            lEFilterRules = new LESAPRules(null, this.m_curr_filter.getName());
            this.m_curr_filter.set("sap_rule", lEFilterRules);
        }
        LEVector lEVector = lEFilterRules.getKeys();
        int n = lEVector.size();
        int n2 = n + 1;
        lEFilterRule.setNumber(Integer.toString(n2));
        lEFilterRule.setName(this.m_curr_filter.getName());
        lEFilterRules.set(Integer.toString(n2), lEFilterRule);
        Object[] objectArray = lEFilterRule instanceof LEIPRule ? this.createIPRuleRow((LEIPRule)lEFilterRule) : (lEFilterRule instanceof LEIPXRule ? this.createIPXRuleRow((LEIPXRule)lEFilterRule) : this.createSAPRuleRow((LESAPRule)lEFilterRule));
        this.m_filterlist.addRow(objectArray);
        int[] nArray = new int[]{n2 - 1};
        this.m_filterlist.selectRows(nArray);
        this.m_filterlist.layoutGrid();
    }

    public void add(LEVector lEVector) {
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = lEVector.elementAt(n2);
            if (object instanceof LEFilterRule) {
                this.add((LEFilterRule)object);
            } else if (object instanceof LEFilter) {
                this.add((LEFilter)object);
            }
            ++n2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(DELETE)) {
            this.deleteRules();
            this.m_mediator.editApplied();
            return;
        }
        if (string.equals(UP)) {
            this.moveRulesUp();
            this.m_mediator.editApplied();
            return;
        }
        if (string.equals(DOWN)) {
            this.moveRulesDown();
            this.m_mediator.editApplied();
        }
    }

    public void confirmAction(String string, Object object) {
    }

    public void cancelAction(Object object) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.m_filter_choice) {
            String string = this.m_filter_choice.getSelectedItem();
            LEFilters lEFilters = this.m_mediator.getFilters(this.m_portmaster);
            LEFilter lEFilter = (LEFilter)lEFilters.get(string);
            if (lEFilter != this.m_curr_filter) {
                this.m_mediator.set(lEFilter);
                return;
            }
        } else if (itemSelectable == this.m_source_choice) {
            String string = this.m_source_choice.getSelectedItem();
            if (!string.equals(this.m_portmaster.getHostname())) {
                this.m_mediator.setPortMaster(string);
                return;
            }
        } else if (itemSelectable == this.m_rule_choice) {
            if (this.m_curr_filter == null) {
                return;
            }
            int n = this.m_rule_choice.getSelectedIndex();
            if (n == 0) {
                LEIPRules lEIPRules = (LEIPRules)this.m_curr_filter.get("ip_rule");
                if (lEIPRules == null) {
                    lEIPRules = new LEIPRules(null, "");
                    this.m_curr_filter.set("ip_rule", lEIPRules);
                }
                this.m_mediator.set(lEIPRules);
                return;
            }
            if (n == 1) {
                LEIPXRules lEIPXRules = (LEIPXRules)this.m_curr_filter.get("ipx_rule");
                if (lEIPXRules == null) {
                    lEIPXRules = new LEIPXRules(null, "");
                    this.m_curr_filter.set("ipx_rule", lEIPXRules);
                }
                this.m_mediator.set(lEIPXRules);
                return;
            }
            LESAPRules lESAPRules = (LESAPRules)this.m_curr_filter.get("sap_rule");
            if (lESAPRules == null) {
                lESAPRules = new LESAPRules(null, "");
                this.m_curr_filter.set("sap_rule", lESAPRules);
            }
            this.m_mediator.set(lESAPRules);
        }
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (lEMLEvent.getType() == 3) {
            LEFilterRules lEFilterRules = null;
            int[] nArray = this.m_filterlist.getSelectedRows();
            this.m_selected_rows.removeAllElements();
            if (this.m_curr_filter == null) {
                return;
            }
            if (this.m_rule_choice.getSelectedItem().equals(IPRULES)) {
                lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ip_rule");
                if (lEFilterRules == null) {
                    lEFilterRules = new LEIPRules(this.m_curr_filter.getConfigFacility(), this.m_curr_filter.getName());
                    this.m_curr_filter.set("ip_rule", lEFilterRules);
                }
            } else if (this.m_rule_choice.getSelectedItem().equals(IPXRULES)) {
                lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ipx_rule");
                if (lEFilterRules == null) {
                    lEFilterRules = new LEIPXRules(this.m_curr_filter.getConfigFacility(), this.m_curr_filter.getName());
                    this.m_curr_filter.set("ipx_rule", lEFilterRules);
                }
            } else if (this.m_rule_choice.getSelectedItem().equals(SAPRULES) && (lEFilterRules = (LEFilterRules)this.m_curr_filter.get("sap_rule")) == null) {
                lEFilterRules = new LESAPRules(this.m_curr_filter.getConfigFacility(), this.m_curr_filter.getName());
                this.m_curr_filter.set("sap_rule", lEFilterRules);
            }
            LEVector lEVector = lEFilterRules.getKeys();
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (n2 == 0) {
                    bl2 = true;
                }
                if (n2 == lEFilterRules.size() - 1) {
                    bl3 = true;
                }
                this.m_selected_rows.add(lEFilterRules.get((String)lEVector.elementAt(nArray[n])));
                if (n > 0 && nArray[n - 1] != n2 + 1 && nArray[n - 1] != n2 - 1) {
                    bl = false;
                }
                ++n;
            }
            if (nArray.length > 0) {
                this.enableControlButtons(true);
            } else {
                this.m_delete.setEnabled(false);
            }
            if (bl && nArray.length > 0) {
                this.m_up.setEnabled(!bl2);
                this.m_down.setEnabled(!bl3);
            } else {
                this.enableTraverseButtons(false);
            }
            this.m_mediator.setSelection(this.m_selected_rows);
        }
    }

    private void buildIPRuleList(LEIPRules lEIPRules) {
        Object[] objectArray = new String[]{new String("Number"), new String("Action"), new String("Source"), new String("Destination"), new String("Protocol"), new String("Src Port"), new String("Dst Port"), new String("Options")};
        this.m_filterlist.setTitles(0, objectArray);
        if (!(lEIPRules instanceof LEIPRules)) {
            return;
        }
        int n = lEIPRules.size();
        LEVector lEVector = lEIPRules.getKeys();
        int n2 = 0;
        while (n2 < n) {
            LEIPRule lEIPRule = (LEIPRule)lEIPRules.get((String)lEVector.elementAt(n2));
            Object[] objectArray2 = this.createIPRuleRow(lEIPRule);
            this.m_filterlist.addRow(objectArray2);
            ++n2;
        }
    }

    private void buildIPXRuleList(LEIPXRules lEIPXRules) {
        Object[] objectArray = new String[]{new String("Number"), new String("Action"), new String("Src Network"), new String("Src Host"), new String("Src Socket"), new String("Dest Network"), new String("Dest Host"), new String("Dest Socket")};
        this.m_filterlist.setTitles(0, objectArray);
        if (!(lEIPXRules instanceof LEIPXRules)) {
            return;
        }
        int n = lEIPXRules.size();
        LEVector lEVector = lEIPXRules.getKeys();
        int n2 = 0;
        while (n2 < n) {
            LEIPXRule lEIPXRule = (LEIPXRule)lEIPXRules.get((String)lEVector.elementAt(n2));
            Object[] objectArray2 = this.createIPXRuleRow(lEIPXRule);
            this.m_filterlist.addRow(objectArray2);
            ++n2;
        }
    }

    private void buildSAPRuleList(LESAPRules lESAPRules) {
        Object[] objectArray = new String[]{new String("Number"), new String("Action"), new String("Server"), new String("Network"), new String("Host"), new String("Socket"), new String(""), new String("")};
        this.m_filterlist.setTitles(0, objectArray);
        if (!(lESAPRules instanceof LESAPRules)) {
            return;
        }
        int n = lESAPRules.size();
        LEVector lEVector = lESAPRules.getKeys();
        int n2 = 0;
        while (n2 < n) {
            LESAPRule lESAPRule = (LESAPRule)lESAPRules.get((String)lEVector.elementAt(n2));
            Object[] objectArray2 = this.createSAPRuleRow(lESAPRule);
            this.m_filterlist.addRow(objectArray2);
            ++n2;
        }
    }

    private String[] createIPRuleRow(LEIPRule lEIPRule) {
        String string;
        String[] stringArray = new String[8];
        StringBuffer stringBuffer = new StringBuffer();
        stringArray[0] = lEIPRule.getNumber();
        stringArray[1] = (String)lEIPRule.get("action");
        stringArray[2] = (String)lEIPRule.get("source");
        stringArray[3] = (String)lEIPRule.get("destination");
        stringArray[4] = (String)lEIPRule.get("protocol");
        if (stringArray[4].equals("protocol")) {
            stringArray[4] = String.valueOf(stringArray[4]) + " = ";
            stringArray[4] = String.valueOf(stringArray[4]) + (String)lEIPRule.get("protocol_number");
        } else if (stringArray[4].equals("icmp") && !(string = (String)lEIPRule.get("type")).equals("")) {
            stringArray[4] = String.valueOf(stringArray[4]) + " type ";
            stringArray[4] = String.valueOf(stringArray[4]) + string;
        }
        string = (String)lEIPRule.get("src_cmp");
        if (string.equals("")) {
            stringArray[5] = "";
        } else {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append((String)lEIPRule.get("src_port"));
            stringArray[5] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        string = (String)lEIPRule.get("dst_cmp");
        if (string.equals("")) {
            stringArray[6] = "";
        } else {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append((String)lEIPRule.get("dst_port"));
            stringArray[6] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        string = (String)lEIPRule.get("estab");
        if (string.equals("on")) {
            stringBuffer.append("estab");
        }
        if ((string = (String)lEIPRule.get("log")).equals("on")) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("log");
        }
        if ((string = (String)lEIPRule.get("notify")).equals("on")) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("notify");
        }
        stringArray[7] = stringBuffer.toString();
        return stringArray;
    }

    private String[] createIPXRuleRow(LEIPXRule lEIPXRule) {
        String[] stringArray = new String[8];
        StringBuffer stringBuffer = new StringBuffer();
        stringArray[0] = lEIPXRule.getNumber();
        stringArray[1] = (String)lEIPXRule.get("action");
        stringArray[2] = (String)lEIPXRule.get("src_net");
        stringArray[3] = (String)lEIPXRule.get("src_host");
        String string = (String)lEIPXRule.get("src_cmp");
        if (string.equals("")) {
            stringArray[4] = "";
        } else {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append((String)lEIPXRule.get("src_socket"));
            stringArray[4] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        stringArray[5] = (String)lEIPXRule.get("dst_net");
        stringArray[6] = (String)lEIPXRule.get("dst_host");
        string = (String)lEIPXRule.get("dst_cmp");
        if (string.equals("")) {
            stringArray[7] = "";
        } else {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append((String)lEIPXRule.get("dst_socket"));
            stringArray[7] = stringBuffer.toString();
        }
        return stringArray;
    }

    private String[] createSAPRuleRow(LESAPRule lESAPRule) {
        String[] stringArray = new String[8];
        StringBuffer stringBuffer = new StringBuffer();
        stringArray[0] = lESAPRule.getNumber();
        stringArray[1] = (String)lESAPRule.get("action");
        stringArray[2] = (String)lESAPRule.get("server");
        stringArray[3] = (String)lESAPRule.get("network");
        stringArray[4] = (String)lESAPRule.get("host");
        String string = (String)lESAPRule.get("cmp");
        if (string.equals("")) {
            stringArray[5] = "";
        } else {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append((String)lESAPRule.get("socket"));
            stringArray[5] = stringBuffer.toString();
        }
        stringArray[6] = "";
        stringArray[7] = "";
        return stringArray;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new BorderLayout());
        Panel panel2 = new Panel(new FlowLayout(1));
        this.m_add = new Button("Add ...");
        this.m_add.setActionCommand("new_rule");
        this.m_add.addActionListener(this.m_mediator);
        this.m_add.setEnabled(false);
        panel2.add(this.m_add);
        this.m_delete = new Button("Delete");
        this.m_delete.setActionCommand(DELETE);
        this.m_delete.addActionListener(this);
        this.m_delete.setEnabled(false);
        panel2.add(this.m_delete);
        this.m_up = new Button("Move up");
        this.m_up.setActionCommand(UP);
        this.m_up.addActionListener(this);
        this.m_up.setEnabled(false);
        panel2.add(this.m_up);
        this.m_down = new Button("Move down");
        this.m_down.setActionCommand(DOWN);
        this.m_down.addActionListener(this);
        this.m_down.setEnabled(false);
        panel2.add(this.m_down);
        LETitleBar lETitleBar = new LETitleBar("", 1);
        panel.add("North", lETitleBar);
        panel.add("Center", panel2);
        return panel;
    }

    private Panel createSelectionPanel() {
        Panel panel = new Panel(new FlowLayout(1, 15, 5));
        this.m_source_choice = new Choice();
        this.m_source_choice.addItemListener(this);
        panel.add(this.m_source_choice);
        this.m_filter_choice = new Choice();
        this.m_filter_choice.addItemListener(this);
        panel.add(this.m_filter_choice);
        this.m_rule_choice = new Choice();
        this.m_rule_choice.addItem(IPRULES);
        this.m_rule_choice.addItem(IPXRULES);
        this.m_rule_choice.addItem(SAPRULES);
        this.m_rule_choice.addItemListener(this);
        panel.add(this.m_rule_choice);
        this.m_new_filter = new Button("New Filter");
        this.m_new_filter.setActionCommand("new_filter");
        this.m_new_filter.addActionListener(this.m_mediator);
        panel.add(this.m_new_filter);
        return panel;
    }

    private void fillFilterNames(LEVector lEVector) {
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)lEVector.elementAt(n2);
            this.m_filter_choice.addItem(string);
            ++n2;
        }
    }

    private void enableTraverseButtons(boolean bl) {
        this.m_down.setEnabled(bl);
        this.m_up.setEnabled(bl);
    }

    private void enableControlButtons(boolean bl) {
        this.m_add.setEnabled(bl);
        this.m_delete.setEnabled(bl);
    }

    private void moveRulesUp() {
        LEFilterRules lEFilterRules = null;
        LEVector lEVector = new LEVector();
        if (this.m_rule_choice.getSelectedItem().equals(IPRULES)) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ip_rule");
        } else if (this.m_rule_choice.getSelectedItem().equals(IPXRULES)) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ipx_rule");
        } else if (this.m_rule_choice.getSelectedItem().equals(SAPRULES)) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("sap_rule");
        }
        int n = this.m_selected_rows.size();
        int n2 = 0;
        while (n2 < n) {
            lEFilterRules = this.moveUp(lEFilterRules, (LEFilterRule)this.m_selected_rows.elementAt(n2), lEVector);
            ++n2;
        }
        if (lEFilterRules != null) {
            if (this.m_rule_choice.getSelectedItem().equals(IPRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildIPRuleList((LEIPRules)lEFilterRules);
            } else if (this.m_rule_choice.getSelectedItem().equals(IPXRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildIPXRuleList((LEIPXRules)lEFilterRules);
            } else if (this.m_rule_choice.getSelectedItem().equals(SAPRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildSAPRuleList((LESAPRules)lEFilterRules);
            }
            n = lEVector.size();
            int[] nArray = new int[n];
            int n3 = 0;
            while (n3 < n) {
                String string = (String)lEVector.elementAt(n3);
                nArray[n3] = Integer.parseInt(string) - 1;
                ++n3;
            }
            this.m_filterlist.selectRows(nArray);
        }
    }

    private void moveRulesDown() {
        LEFilterRules lEFilterRules = null;
        LEVector lEVector = new LEVector();
        if (this.m_rule_choice.getSelectedItem().equals(IPRULES)) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ip_rule");
        } else if (this.m_rule_choice.getSelectedItem().equals(IPXRULES)) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("ipx_rule");
        } else if (this.m_rule_choice.getSelectedItem().equals(SAPRULES)) {
            lEFilterRules = (LEFilterRules)this.m_curr_filter.get("sap_rule");
        }
        int n = this.m_selected_rows.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            lEFilterRules = this.moveDown(lEFilterRules, (LEFilterRule)this.m_selected_rows.elementAt(n2), lEVector);
            --n2;
        }
        if (lEFilterRules != null) {
            if (this.m_rule_choice.getSelectedItem().equals(IPRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildIPRuleList((LEIPRules)lEFilterRules);
            } else if (this.m_rule_choice.getSelectedItem().equals(IPXRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildIPXRuleList((LEIPXRules)lEFilterRules);
            } else if (this.m_rule_choice.getSelectedItem().equals(SAPRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildSAPRuleList((LESAPRules)lEFilterRules);
            }
            n = lEVector.size();
            int[] nArray = new int[n];
            int n3 = 0;
            while (n3 < n) {
                String string = (String)lEVector.elementAt(n3);
                nArray[n3] = Integer.parseInt(string) - 1;
                ++n3;
            }
            this.m_filterlist.selectRows(nArray);
        }
    }

    private LEFilterRules moveUp(LEFilterRules lEFilterRules, LEFilterRule lEFilterRule, LEVector lEVector) {
        LEFilterRule lEFilterRule2 = null;
        String string = lEFilterRule.getNumber();
        try {
            int n = Integer.parseInt(string);
            if (n == 1) {
                return lEFilterRules;
            }
            int n2 = n - 1;
            String string2 = Integer.toString(n2);
            lEFilterRule2 = (LEFilterRule)lEFilterRules.get(string2);
            lEFilterRule2.setNumber(string);
            lEFilterRule.setNumber(string2);
            lEFilterRules.set(string2, lEFilterRule);
            lEFilterRules.set(string, lEFilterRule2);
            lEVector.add(string2);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return lEFilterRules;
    }

    private LEFilterRules moveDown(LEFilterRules lEFilterRules, LEFilterRule lEFilterRule, LEVector lEVector) {
        LEFilterRule lEFilterRule2 = null;
        String string = lEFilterRule.getNumber();
        try {
            int n = Integer.parseInt(string);
            if (n >= lEFilterRules.size()) {
                return lEFilterRules;
            }
            int n2 = n + 1;
            String string2 = Integer.toString(n2);
            lEFilterRule2 = (LEFilterRule)lEFilterRules.get(string2);
            lEFilterRule2.setNumber(string);
            lEFilterRule.setNumber(string2);
            lEFilterRules.set(string2, lEFilterRule);
            lEFilterRules.set(string, lEFilterRule2);
            lEVector.add(string2);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return lEFilterRules;
    }

    public void deleteRules() {
        LEFilterRules lEFilterRules = null;
        int n = this.m_selected_rows.size();
        int n2 = 0;
        while (n2 < n) {
            LEFilterRule lEFilterRule = (LEFilterRule)this.m_selected_rows.elementAt(n2);
            lEFilterRules = this.deleteRule(lEFilterRule);
            ++n2;
        }
        if (lEFilterRules != null) {
            if (this.m_rule_choice.getSelectedItem().equals(IPRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildIPRuleList((LEIPRules)lEFilterRules);
                return;
            }
            if (this.m_rule_choice.getSelectedItem().equals(IPXRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildIPXRuleList((LEIPXRules)lEFilterRules);
                return;
            }
            if (this.m_rule_choice.getSelectedItem().equals(SAPRULES)) {
                this.m_filterlist.deleteAllRows();
                this.buildSAPRuleList((LESAPRules)lEFilterRules);
            }
        }
    }

    private LEFilterRules deleteRule(LEFilterRule lEFilterRule) {
        LEFilterRules lEFilterRules = null;
        String string = lEFilterRule.getNumber();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        if (this.m_rule_choice.getSelectedItem().equals(IPRULES)) {
            LEIPRules lEIPRules = (LEIPRules)this.m_curr_filter.get("ip_rule");
            lEFilterRules = new LEIPRules(this.m_curr_filter.getConfigFacility(), this.m_curr_filter.getName());
            int n2 = lEIPRules.size();
            int n3 = 1;
            while (n3 <= n2) {
                LEFilterRule lEFilterRule2 = (LEFilterRule)lEIPRules.get(Integer.toString(n3));
                if (n3 < n) {
                    lEFilterRules.set(Integer.toString(n3), lEFilterRule2);
                } else if (n3 > n) {
                    lEFilterRule2.setNumber(Integer.toString(n3 - 1));
                    lEFilterRules.set(Integer.toString(n3 - 1), lEFilterRule2);
                }
                ++n3;
            }
            this.m_curr_filter.set("ip_rule", lEFilterRules);
        } else if (this.m_rule_choice.getSelectedItem().equals(IPXRULES)) {
            LEIPXRules lEIPXRules = (LEIPXRules)this.m_curr_filter.get("ipx_rule");
            lEFilterRules = new LEIPXRules(this.m_curr_filter.getConfigFacility(), this.m_curr_filter.getName());
            int n4 = lEIPXRules.size();
            int n5 = 1;
            while (n5 <= n4) {
                LEFilterRule lEFilterRule3 = (LEFilterRule)lEIPXRules.get(Integer.toString(n5));
                if (n5 < n) {
                    lEFilterRules.set(Integer.toString(n5), lEFilterRule3);
                } else if (n5 > n) {
                    lEFilterRule3.setNumber(Integer.toString(n5 - 1));
                    lEFilterRules.set(Integer.toString(n5 - 1), lEFilterRule3);
                }
                ++n5;
            }
            this.m_curr_filter.set("ipx_rule", lEFilterRules);
        } else if (this.m_rule_choice.getSelectedItem().equals(SAPRULES)) {
            LESAPRules lESAPRules = (LESAPRules)this.m_curr_filter.get("sap_rule");
            lEFilterRules = new LESAPRules(this.m_curr_filter.getConfigFacility(), this.m_curr_filter.getName());
            int n6 = lESAPRules.size();
            int n7 = 1;
            while (n7 <= n6) {
                LEFilterRule lEFilterRule4 = (LEFilterRule)lESAPRules.get(Integer.toString(n7));
                if (n7 < n) {
                    lEFilterRules.set(Integer.toString(n7), lEFilterRule4);
                } else if (n7 > n) {
                    lEFilterRule4.setNumber(Integer.toString(n7 - 1));
                    lEFilterRules.set(Integer.toString(n7 - 1), lEFilterRule4);
                }
                ++n7;
            }
            this.m_curr_filter.set("sap_rule", lEFilterRules);
        }
        return lEFilterRules;
    }
}

