/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEFilterRule;
import COM.livingston.model.LESAPRule;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollablePanel;
import COM.livingston.ui.LETextField;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class LESAPRuleEditor
extends LERuleEditor
implements TextListener {
    LESAPRule m_rule;
    LETextField m_network;
    LETextField m_host;
    LETextField m_socket;
    LETextField m_server;
    Label m_network_label;
    Label m_server_label;
    Label m_host_label;
    Label m_socket_label;
    Checkbox m_cmp_on;
    Choice m_cmp;

    public LESAPRuleEditor(LEFilterMediator lEFilterMediator, Container container) {
        this.s_edit_panel = null;
        this.m_mediator = lEFilterMediator;
        this.m_changed = false;
        this.m_container = container;
    }

    public Panel getPanel() {
        if (this.s_edit_panel == null) {
            this.s_edit_panel = this.createPanel();
        }
        this.m_changed = false;
        this.updateActionButtons(this.m_changed);
        return this.s_edit_panel;
    }

    public void setEnabled(boolean bl) {
        this.m_permit.setEnabled(bl);
        this.m_deny.setEnabled(bl);
        this.m_action_label.setEnabled(bl);
        this.m_network.setEnabled(bl);
        this.m_host.setEnabled(bl);
        this.m_socket.setEnabled(bl);
        this.m_server.setEnabled(bl);
        this.m_network_label.setEnabled(bl);
        this.m_server_label.setEnabled(bl);
        this.m_host_label.setEnabled(bl);
        this.m_socket_label.setEnabled(bl);
        this.m_cmp_on.setEnabled(bl);
        this.m_cmp.setEnabled(bl);
        this.m_apply.setEnabled(bl);
        this.m_cancel.setEnabled(bl);
    }

    public void setRule(LEFilterRule lEFilterRule) {
        if (!(lEFilterRule instanceof LESAPRule)) {
            return;
        }
        this.m_rule = (LESAPRule)lEFilterRule;
        String string = (String)lEFilterRule.get("action");
        if (string.equals("permit")) {
            this.m_permit.setState(true);
        } else {
            this.m_deny.setState(true);
        }
        ((TextComponent)this.m_network).setText((String)lEFilterRule.get("network"));
        ((TextComponent)this.m_server).setText((String)lEFilterRule.get("server"));
        ((TextComponent)this.m_host).setText((String)lEFilterRule.get("host"));
        String string2 = (String)lEFilterRule.get("cmp");
        if (!string2.equals("")) {
            this.m_cmp_on.setState(true);
            if (string2.equals("gt")) {
                this.m_cmp.select(1);
            } else if (string2.equals("lt")) {
                this.m_cmp.select(2);
            }
            ((TextComponent)this.m_socket).setText((String)lEFilterRule.get("socket"));
            return;
        }
        this.m_cmp_on.setState(false);
        this.m_cmp.select(0);
        ((TextComponent)this.m_socket).setText("");
        this.enableCmp(false);
    }

    public LEFilterRule getRule() {
        return this.m_rule;
    }

    public void clearRule() {
        ((TextComponent)this.m_network).setText("");
        ((TextComponent)this.m_host).setText("");
        ((TextComponent)this.m_socket).setText("");
        ((TextComponent)this.m_server).setText("");
        this.m_cmp_on.setState(false);
        this.m_cmp.select(0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        this.m_changed = true;
        if (itemSelectable == this.m_cmp_on) {
            this.enableCmp(this.m_cmp_on.getState());
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        this.m_changed = true;
        this.updateActionButtons(this.m_changed);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("apply")) {
            if (this.m_rule != null) {
                this.applyChanges();
                this.m_mediator.editApplied(this.m_rule);
            }
            this.m_changed = false;
        } else if (string.equals("cancel")) {
            this.setRule(this.m_rule);
            this.m_changed = false;
        }
        this.updateActionButtons(this.m_changed);
    }

    private Panel createPanel() {
        Panel panel = new Panel(new BorderLayout());
        Component[][] componentArray = new Component[5][2];
        panel.add("South", this.createButtonPanel());
        this.m_action_label = new Label("Rule Action:");
        this.m_action_label.setFont(LEFont.getBoldFont());
        componentArray[0][0] = this.m_action_label;
        componentArray[0][1] = this.createActionPanel();
        this.m_server_label = new Label("Server Name:");
        this.m_server_label.setFont(LEFont.getBoldFont());
        componentArray[1][0] = this.m_server_label;
        this.m_server = new LETextField(15);
        this.m_server.addTextListener(this);
        componentArray[1][1] = this.m_server;
        this.m_network_label = new Label("Network:");
        this.m_network_label.setFont(LEFont.getBoldFont());
        componentArray[2][0] = this.m_network_label;
        this.m_network = new LETextField(8);
        this.m_network.setHex(true);
        this.m_network.addTextListener(this);
        componentArray[2][1] = this.m_network;
        this.m_host_label = new Label("Host:");
        this.m_host_label.setFont(LEFont.getBoldFont());
        componentArray[3][0] = this.m_host_label;
        this.m_host = new LETextField(12);
        this.m_host.setHex(true);
        this.m_host.addTextListener(this);
        componentArray[3][1] = this.m_host;
        this.m_socket_label = new Label("Socket:");
        this.m_socket_label.setFont(LEFont.getBoldFont());
        componentArray[4][0] = this.m_socket_label;
        componentArray[4][1] = this.createSocketPanel();
        LECompGrid lECompGrid = new LECompGrid(componentArray, 5);
        LEScrollablePanel lEScrollablePanel = new LEScrollablePanel(lECompGrid, true, true);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(lEScrollablePanel);
        panel.add("Center", lEScrollPanel);
        return panel;
    }

    private Panel createSocketPanel() {
        Panel panel = new Panel(new FlowLayout(0, 0, 0));
        this.m_cmp_on = new Checkbox("", false);
        this.m_cmp_on.setFont(LEFont.getBoldFont());
        this.m_cmp_on.addItemListener(this);
        this.m_cmp = new Choice();
        this.m_cmp.addItem("=");
        this.m_cmp.addItem(">");
        this.m_cmp.addItem("<");
        this.m_cmp.setEnabled(false);
        this.m_socket = new LETextField(5);
        this.m_socket.setNumeric(true);
        this.m_socket.setBounds(1L, 65535L);
        this.m_socket.addTextListener(this);
        panel.add(this.m_cmp_on);
        panel.add(this.m_cmp);
        panel.add(this.m_socket);
        return panel;
    }

    private void applyChanges() {
        if (this.m_rule == null) {
            return;
        }
        if (this.m_permit.getState()) {
            this.m_rule.set("action", "permit");
        } else {
            this.m_rule.set("action", "deny");
        }
        this.m_rule.set("server", this.m_server.getText());
        this.m_rule.set("network", this.m_network.getText());
        this.m_rule.set("host", this.m_host.getText());
        if (this.m_cmp_on.getState()) {
            int n = this.m_cmp.getSelectedIndex();
            if (n == 0) {
                this.m_rule.set("cmp", "eq");
            } else if (n == 1) {
                this.m_rule.set("cmp", "gt");
            } else {
                this.m_rule.set("cmp", "lt");
            }
            this.m_rule.set("socket", this.m_socket.getText());
            return;
        }
        this.m_rule.set("cmp", "");
        this.m_rule.set("socket", "");
    }

    private void enableCmp(boolean bl) {
        this.m_cmp.setEnabled(bl);
        this.m_socket.setEnabled(bl);
    }
}

