/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEThreadStatus;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardAction;
import COM.livingston.wizard.LEWizardActionClient;
import COM.livingston.wizard.LEWizardDataModel;
import java.io.IOException;

public class LEBackupAction
extends LEWizardAction {
    public LEBackupAction(LEWizardDataModel model, LEWizardActionClient client) {
        super(model, client);
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart(this, "Saving the configurations to a backup file ");
        this.backupConfig();
    }

    private void backupConfig() {
        LEPortMaster pm = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
        if (pm == null) {
            this.m_client.actionDone(this, "Could not get the Portmaster", -1);
            return;
        }
        LEVector commands = new LEVector();
        if (!pm.getCommands(commands)) {
            this.m_client.actionDone(this, "Could not get the configurations", -1);
            return;
        }
        String filename = LEAppInfo.createFullPath(this.m_model.get(LEPMWizardModel.BACKUP_DIR), this.m_model.get(LEPMWizardModel.BACKUP_FILE));
        LEDSSFlatFile ff = new LEDSSFlatFile(filename, 1);
        String ether_address = "IP_ADDRESS ";
        ether_address = String.valueOf(ether_address) + this.m_model.get(LEPMWizardModel.IPADDRESS);
        String netmask = "NET_MASK ";
        netmask = String.valueOf(netmask) + this.m_model.get(LEPMWizardModel.NETMASK);
        try {
            ff.connect();
            ff.writeComments(ether_address);
            ff.writeComments(netmask);
            ff.writeConfig(commands);
            ff.disconnect();
        }
        catch (IOException iOException) {
            String err = "Could not open the selected backup file.  \n\nPress Retry and verify that the location ";
            err = String.valueOf(err) + "for the backup file exists, or press Cancel to save the current configuration and exit the wizard.";
            this.m_client.actionDone(this, err, -1);
            return;
        }
        this.m_client.actionDone(this, LEThreadStatus.NO_MESSAGE, 0);
    }
}

