/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEEthernet;
import COM.livingston.model.LEEthernets;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardAction;
import COM.livingston.wizard.LEWizardActionClient;
import COM.livingston.wizard.LEWizardDataModel;

public class LEEthernetAction
extends LEWizardAction {
    String m_ether_name;

    public LEEthernetAction(LEWizardDataModel model, LEWizardActionClient client, String ether_name) {
        super(model, client);
        this.m_ether_name = ether_name;
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart(this, "Configuring the ethernet port. ");
        this.configure();
    }

    public void configure() {
        String broadcast;
        LEStatusManager manager = (LEStatusManager)this.m_model.getObject(LEPMWizardModel.STATUS_MANAGER);
        LEConfig config = (LEConfig)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
        if (config == null) {
            String msg = new String("Irrecoverable error, lost connect to the Portmaster");
            this.m_client.actionDone(this, msg, -2);
            return;
        }
        LEEthernets ethernets = (LEEthernets)config.get("720896");
        if (ethernets == null) {
            StringBuffer buffer = new StringBuffer(300);
            buffer.append("Was not able to retrieve the configuration information for the ");
            buffer.append("ethernet ports.  \n\nPress Retry if you wish to attempt to configure ");
            buffer.append("again or Cancel to save the current configuration and exit the Wizard.");
            this.m_client.actionDone(this, buffer.toString(), -1);
            return;
        }
        LEEthernet ether = (LEEthernet)ethernets.get(this.m_ether_name);
        if (ether == null) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append("Was not able to retrieve the configuration information for the ");
            buffer.append("ethernet port. \n\nPress Retry if you wish to attempt to configure ");
            buffer.append("again or Cancel to exit the Wizard.");
            this.m_client.actionDone(this, buffer.toString(), -1);
            return;
        }
        if (this.m_model.get(LEPMWizardModel.IPADDRESS) != null) {
            ether.set("9", this.m_model.get(LEPMWizardModel.IPADDRESS));
        }
        if (this.m_model.get(LEPMWizardModel.NETMASK) != null) {
            ether.set("15", this.m_model.get(LEPMWizardModel.NETMASK));
        }
        if (this.m_model.get(LEPMWizardModel.BROADCAST) != null && !(broadcast = (String)ether.get("186")).equals(this.m_model.get(LEPMWizardModel.BROADCAST))) {
            ether.set("186", this.m_model.get(LEPMWizardModel.BROADCAST));
        }
        if (this.m_model.get(LEPMWizardModel.ROUTING) != null) {
            String rip_broad = (String)ether.get("187");
            String rip_listen = (String)ether.get("188");
            String routing = this.m_model.get(LEPMWizardModel.ROUTING);
            if (routing.equals("on")) {
                if (!rip_broad.equals("on")) {
                    ether.set("187", "on");
                }
                if (!rip_listen.equals("on")) {
                    ether.set("188", "on");
                }
            } else if (routing.equals("broadcast")) {
                if (!rip_broad.equals("on")) {
                    ether.set("187", "on");
                }
                if (!rip_listen.equals("off")) {
                    ether.set("188", "off");
                }
            } else if (routing.equals("listen")) {
                if (!rip_broad.equals("off")) {
                    ether.set("187", "off");
                }
                if (!rip_listen.equals("on")) {
                    ether.set("188", "on");
                }
            } else {
                if (!rip_broad.equals("off")) {
                    ether.set("187", "off");
                }
                if (!rip_listen.equals("off")) {
                    ether.set("188", "off");
                }
            }
        }
        LEVector commands = new LEVector();
        config.getChanges(commands);
        LEConfigFacility facility = config.getConfigFacility();
        int len = commands.size();
        int i = 0;
        while (i < len) {
            if (manager != null) {
                manager.setStatus((String)commands.elementAt(i));
            }
            facility.execute((String)commands.elementAt(i));
            ++i;
        }
        this.m_client.actionDone(this, LEThreadStatus.NO_MESSAGE, 0);
    }
}

