/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.pm_wizard;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.bootp.LEBootPARPTableHandler;
import COM.livingston.bootp.LEBootPIPHandler;
import COM.livingston.bootp.LEBootPPacketHandler;
import COM.livingston.model.LEPortMaster;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LEActionClient;
import COM.livingston.ui.LEActionDialog;
import COM.livingston.ui.LEStatusBar;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEIPAddress;
import COM.livingston.util.LEStatusManager;
import COM.livingston.wizard.LEWizardAction;
import COM.livingston.wizard.LEWizardActionClient;
import COM.livingston.wizard.LEWizardDataModel;
import java.awt.Component;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.util.Hashtable;

public class LEPMConnectAction
extends LEWizardAction
implements LEActionClient {
    public static final String IP_DONE = "SetupIPDone";
    static final int MAX_CONNECT_ATTEMPTS = 30;
    static final String NO_DEVICE = "Could not find the device with the specified IP Address.  Make sure the device is on the same subnet.";
    static final String BAD_PASSWORD_MSG = "You entered a wrong password for this device.";
    static final String NEED_ROOT = "You need to be root in order to set the Internet address from the Wizard!";
    static final String UNKNOWN_PROBLEM = "An unknown problem has occurred, please restart the wizard.";
    static final String SOCKET_EXCEPTION = "The BootP server could not start because another application is using the socket.";
    static final String SECURITY_EXCEPTION = "The BootP server could not start because you don't have the necessary privledges.";
    static final String CONNECTION_REFUSED = "Connection to the specified address was refused.";
    static final String CONFIG_PROBLEM = "Could not retrieve the configuration information.";
    static final String SUCCESS = "Successful Connection.";
    static final String VENDOR_CODE = "00:c0:05:";
    static final int CONNECTED = 0;
    static final int NO_RESPONSE = -1;
    static final int BAD_PASSWORD = -2;
    static final int ROOT = -3;
    static final int NO_SOCKET = -4;
    static final int SECURITY = -5;
    static final int CONNECT_FAILURE = -6;
    static final int UNKNOWN_FAILURE = -20;
    boolean m_connected;
    boolean m_canceled = false;
    LEBootPPacketHandler m_ipHandler;
    LEActionDialog m_connectDlg;
    String m_problem;
    LEStatusBar m_status;
    LEPortMaster m_pm;
    LEStatusManager m_manager;

    public LEPMConnectAction(LEWizardDataModel model, LEWizardActionClient client) {
        super(model, client);
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart(this, "Connecting...");
        this.setupDialog();
        this.m_thread.suspend();
        if (this.m_canceled) {
            if (!this.m_connected) {
                this.m_model.set(LEPMWizardModel.CONNECTED, "off");
            }
            this.m_client.actionDone(this, "", -3);
        } else if (!this.m_connected) {
            this.m_model.set(LEPMWizardModel.CONNECTED, "off");
            this.m_client.actionDone(this, this.m_problem, -1);
        } else {
            this.m_model.set(LEPMWizardModel.CONNECTED, "on");
            this.m_client.actionDone(this, "", 0);
        }
    }

    public void actionStart(LEActionDialog dlg) {
        this.m_status = dlg.getStatusBar();
        this.m_status.setStatusText("Connecting to device");
        this.setupPM();
    }

    public void actionDone(LEActionDialog dlg) {
        if (this.m_thread != null) {
            this.m_thread.resume();
        }
    }

    public void actionCancel(LEActionDialog dlg) {
        this.m_canceled = true;
        if (this.m_pm != null) {
            this.m_pm.disconnect();
            this.m_pm = null;
        }
        if (this.m_thread != null) {
            this.m_thread.resume();
        }
    }

    void setupDialog() {
        this.m_manager = new LEStatusManager();
        this.m_connectDlg = new LEActionDialog(LEUiUtils.GetBaseFrame(), "Connecting...", this, this.m_manager);
        ((Component)this.m_connectDlg).setVisible(true);
        new Thread(this.m_connectDlg).start();
    }

    private int connectToPM() {
        try {
            this.m_pm = new LEPortMaster(this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", this.m_model.get(LEPMWizardModel.ADMIN_PASSWORD));
            if (this.m_pm != null && this.m_pm.isConnected()) {
                this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
            }
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            try {
                this.m_pm = new LEPortMaster(this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", "");
                if (this.m_pm != null && this.m_pm.isConnected()) {
                    this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
                }
            }
            catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException2) {
                return -2;
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                return -20;
            }
        }
        catch (LEDSSException e) {
            LEDebug.getLog().logln(20, e);
            return -20;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            return -1;
        }
        catch (ConnectException e) {
            LEDebug.getLog().logln(20, e);
            return -6;
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return -20;
        }
        if (this.m_model.getObject(LEPMWizardModel.PORTMASTER) == null) {
            this.m_connected = false;
            return -1;
        }
        this.m_connected = true;
        return 0;
    }

    private void setupPM() {
        try {
            int status = this.connectToPM();
            if (status == -1) {
                int attempts = 0;
                if (LEAppInfo.isUnix()) {
                    String name = System.getProperty("user.name");
                    if (name.equals("root")) {
                        int bootpStatus = this.runIPHandler();
                        if (bootpStatus < 0) {
                            status = bootpStatus;
                            attempts = 30;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(15000L);
                        }
                        catch (Exception exception) {}
                    } else {
                        status = -3;
                        attempts = 30;
                    }
                } else {
                    int bootpStatus = this.runIPHandler();
                    if (bootpStatus < 0) {
                        status = bootpStatus;
                        attempts = 30;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(15000L);
                    }
                    catch (Exception exception) {}
                }
                while (attempts < 30) {
                    this.m_status.setStatusText("Setting the unit's ipaddress and then connecting...");
                    ++attempts;
                    status = this.connectToPM();
                    if (status != 0) continue;
                    attempts = 30;
                }
            }
            switch (status) {
                case 0: {
                    this.m_status.setStatusText("Connected, getting configuration...");
                    if (!this.m_model.getModelInfo()) {
                        this.m_status.setStatusText("Could not get configuration!");
                        System.out.println("Problem with configuration");
                        this.m_problem = CONFIG_PROBLEM;
                    }
                    break;
                }
                case -2: {
                    this.m_status.setStatusText("Incorrect password");
                    this.m_problem = BAD_PASSWORD_MSG;
                    break;
                }
                case -3: {
                    this.m_problem = NEED_ROOT;
                    break;
                }
                case -5: {
                    this.m_problem = SECURITY_EXCEPTION;
                    break;
                }
                case -4: {
                    this.m_problem = SOCKET_EXCEPTION;
                    break;
                }
                case -6: {
                    this.m_problem = CONNECTION_REFUSED;
                    break;
                }
                case -20: {
                    this.m_problem = NO_DEVICE;
                    break;
                }
                default: {
                    this.m_problem = UNKNOWN_PROBLEM;
                    break;
                }
            }
        }
        catch (Exception e) {
            this.m_status.setStatusText("Could not connect.");
            LEDebug.getLog().logln(20, e);
        }
        if (this.m_ipHandler != null) {
            this.m_ipHandler.disconnect();
        }
    }

    private int runIPHandler() {
        try {
            String ip_address = this.m_model.get(LEPMWizardModel.IPADDRESS);
            String mac_address = this.m_model.get(LEPMWizardModel.MAC_ADDRESS);
            String broadcast_addr = LEIPAddress.determineBroadcastAddress(ip_address, this.m_model.get(LEPMWizardModel.NETMASK));
            InetAddress server_ip = InetAddress.getLocalHost();
            String server_addr = server_ip.getHostAddress();
            if (mac_address.equals("")) {
                this.m_ipHandler = new LEBootPIPHandler(ip_address, server_addr, broadcast_addr);
            } else {
                Hashtable<String, String> ip_table = new Hashtable<String, String>();
                ip_table.put(mac_address, ip_address);
                this.m_ipHandler = new LEBootPARPTableHandler(ip_table, server_addr, broadcast_addr);
            }
        }
        catch (SecurityException securityException) {
            return -5;
        }
        catch (SocketException socketException) {
            return -4;
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
            return -20;
        }
        return 0;
    }
}

