/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.pm_wizard.LEPMWizardModel;
import COM.livingston.ui.LETextField;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import COM.livingston.wizard.LEWizardDataModel;
import COM.livingston.wizard.LEWizardDataPage;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;

public class LEWizardPathPage
extends LEWizardDataPage
implements ItemListener,
ActionListener {
    public static final String NO_FILE_FOUND = "The specified file was not found.";
    public static final String BROWSE = "Browse";
    Checkbox m_backup;
    Checkbox m_step;
    LETextField m_location;
    Button m_browse;
    Label m_loclabel;
    String m_backupFile;
    String m_backupDir;
    Frame m_topFrame = LEUiUtils.GetBaseFrame();

    public LEWizardPathPage(LEWizardDataModel lEWizardDataModel) {
        super(lEWizardDataModel);
        this.setTitle("  Configure or Restore");
        this.setImage("wiz.gif");
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("If this is the first time you are configuring your PortMaster, click Next ");
        stringBuffer.append("for a step-by-step configuration.  If you want to restore the configuration ");
        stringBuffer.append("of your PortMaster, choose the 'Restore ...' option and specify the ");
        stringBuffer.append("location of your backup file. ");
        this.m_instructions = stringBuffer.toString();
        stringBuffer = null;
        this.setHelpTag("Configure_Restore");
        if (this.m_model.get(LEPMWizardModel.BACKUP_FILE) == null) {
            this.m_model.set(LEPMWizardModel.BACKUP_FILE, "pmwiz.bak");
        }
    }

    public Panel createPanel() {
        super.createPanel();
        String string = new String("Choose a configuration path:");
        this.m_component = new Label(string);
        this.m_panel.add(this.m_component, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_gbc.insets.top = 10;
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_step = new Checkbox("Configure using the step-by-step process", checkboxGroup, true);
        this.m_step.addItemListener(this);
        this.m_panel.add((Component)this.m_step, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_gbc.insets.top = 0;
        ++this.m_gbc.gridy;
        this.m_gbc.insets.top = 20;
        this.m_backup = new Checkbox("Restore the configuration using the backup file", checkboxGroup, false);
        this.m_backup.addItemListener(this);
        this.m_panel.add((Component)this.m_backup, this.m_gbc);
        this.m_gbc.insets.top = 0;
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        string = new String("The location of your backup file is: ");
        this.m_loclabel = new Label(string);
        this.m_panel.add((Component)this.m_loclabel, this.m_gbc);
        ++this.m_gbc.gridy;
        ++this.m_gbc.gridy;
        this.m_location = new LETextField(50);
        this.m_location.setLimitLength(false);
        this.m_backupDir = LEAppInfo.getUserAppDir();
        this.m_backupFile = this.m_model.get(LEPMWizardModel.BACKUP_FILE);
        String string2 = LEAppInfo.createFullPath(this.m_backupDir, this.m_backupFile);
        ((TextComponent)this.m_location).setText(string2);
        this.m_panel.add((Component)this.m_location, this.m_gbc);
        this.m_gbc.insets.right = 0;
        this.m_gbc.insets.left = 0;
        this.m_browse = new Button(BROWSE);
        this.m_browse.setActionCommand(BROWSE);
        this.m_browse.addActionListener(this);
        this.m_panel.add((Component)this.m_browse, this.m_gbc);
        this.m_loclabel.setEnabled(false);
        this.m_location.setEnabled(false);
        this.m_browse.setEnabled(false);
        return this.m_panel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processPanelData() {
        this.m_problem = null;
        if (this.m_backup.getState()) {
            String string = this.m_location.getText();
            String string2 = System.getProperty("file.separator");
            int n = string.lastIndexOf(string2);
            String string3 = string.substring(n + 1);
            String string4 = string.substring(0, n);
            if (string4 != null && string3 != null) {
                this.m_backupDir = string4;
                this.m_backupFile = string3;
                this.m_model.set(LEPMWizardModel.BACKUP_DIR, string4);
                this.m_model.set(LEPMWizardModel.BACKUP_FILE, string3);
                if (this.readBackupFile()) return true;
                this.m_problem = NO_FILE_FOUND;
                return false;
            }
            this.m_problem = NO_FILE_FOUND;
            return false;
        }
        this.m_model.set(LEPMWizardModel.BACKUP_DIR, "");
        this.m_model.removeObject(LEPMWizardModel.COMMANDS);
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_backup.getState()) {
            this.m_loclabel.setEnabled(true);
            this.m_location.setEnabled(true);
            this.m_browse.setEnabled(true);
            return;
        }
        this.m_loclabel.setEnabled(false);
        this.m_location.setEnabled(false);
        this.m_browse.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(BROWSE)) {
            this.browse();
        }
    }

    private void browse() {
        String string = this.m_location.getText();
        String string2 = System.getProperty("file.separator");
        int n = string.lastIndexOf(string2);
        String string3 = string.substring(n + 1);
        String string4 = string.substring(0, n);
        FileDialog fileDialog = new FileDialog(this.m_topFrame, "Open Configuration", 0);
        fileDialog.setDirectory(string4);
        fileDialog.setFile(string3);
        fileDialog.show();
        string4 = fileDialog.getDirectory();
        string3 = fileDialog.getFile();
        if (string3 != null) {
            String string5 = LEAppInfo.createFullPath(string4, string3);
            ((TextComponent)this.m_location).setText(string5);
        }
    }

    private boolean readBackupFile() {
        String string = LEAppInfo.createFullPath(this.m_model.get(LEPMWizardModel.BACKUP_DIR), this.m_model.get(LEPMWizardModel.BACKUP_FILE));
        LEDSSFlatFile lEDSSFlatFile = new LEDSSFlatFile(string, 0);
        LEVector lEVector = new LEVector();
        try {
            lEDSSFlatFile.connect();
            lEVector = lEDSSFlatFile.getCommands();
            lEDSSFlatFile.disconnect();
            if (lEVector.size() > 0) {
                this.m_model.putObject(LEPMWizardModel.COMMANDS, lEVector);
                this.getBackupAddress(lEVector);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.m_model.set(LEPMWizardModel.BACKUP_DIR, "");
            return false;
        }
        return true;
    }

    private void getBackupAddress(LEVector lEVector) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = "set ether0 address";
        String string2 = "set ether0 netmask";
        int n2 = lEVector.size();
        while (n < n2) {
            StringTokenizer stringTokenizer;
            String string3 = (String)lEVector.elementAt(n);
            if (!bl && string3.startsWith(string)) {
                stringTokenizer = new StringTokenizer(string3);
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                this.m_model.set(LEPMWizardModel.IPADDRESS, string4);
                bl = true;
            } else if (!bl2 && string3.startsWith(string2)) {
                stringTokenizer = new StringTokenizer(string3);
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                this.m_model.set(LEPMWizardModel.NETMASK, string5);
                bl2 = true;
            }
            ++n;
        }
    }
}

