#!/usr/local/bin/perl
#
### -------------------------------------------------------------------------
#
### -------------------------------------------------------------------------
#
#
# Copyright (C) 1997 Random Communications Inc.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
$version = '1.01';
#
### -------------------------------------------------------------------------
#   Where to find stuff... Alter this to suite your site.
### -------------------------------------------------------------------------

$logdir 	= '/misc/tmp/';
$ofile  	= '/usr/users/marius/scripts/rot.log';
$month 		= substr(`date +"%B"`, 0, 3);
$movar		= '';
$wvar		= 0;
$debug		= 0;

### ---------------------------------------------------------------------
#    Signal Catching.
### ---------------------------------------------------------------------
 
sub handler {
  local($sig) = @_;
  print "Caught SIG$sig - shutting down.\n";
  &D("Caught SIG$sig - shutting down program.\n");
  exit(0);
}
 
$SIG{'INT'} = 'handler';
$SIG{'KILL'} = 'handler';
$SIG{'QUIT'} = 'handler';

### -------------------------------------------------------------------------
#    Debugging and logging.
### -------------------------------------------------------------------------

sub D {
  if($::debug) {
    print STDOUT @_;
  } else {
    open(LOG, ">>$ofile") || die "$!\n";
    print LOG @_;
    close LOG;
  }
}

### -------------------------------------------------------------------------
#
### -------------------------------------------------------------------------

opendir(DIR, "$logdir") || die "Error opening dir $logdir\n";
@dirs = readdir(DIR);
# @dirs = grep( !/^..?$/, grep(-d, readdir(DIR)) );
# @dirs = grep( !/^\.([^A-Za-z]*)\.?$/, grep(-d, readdir(DIR)) );
closedir(DIR);

foreach $dir ( @dirs ) {
  push(@tmparr, $logdir . $dir . '/detail');
}

for ( $i=0; $i <= $#tmparr; $i++ ) {
  &D("Opening $tmparr[$i] for processing.\n");

  open(FILE, "<$tmparr[$i]"), if ( -f $tmparr[$i] );	# Input.
  open(TMP, ">/tmp/tmpfile") 	|| die "Error: $!\n";	# Output.

  BLOCK: while(<FILE>) {
 
    if(eof(FILE)) {
      close(TMP);
      &writefile($tmparr[$i]) && last;
    }
  
    if(/^$/) {			# Blank line.
      print TMP $_;
      next;
    }

    if(/^([\S]*) (\w+)/) {	# Date.
      ($wday,$mo,$mday,$dtime,$yr) = split(/\s+/, $_);
 
      $movar = $mo if($. == 1);

      if($movar !~ /$mo/i) {	# Month check.
  	close(TMP);
	&writefile($tmparr[$i]);
	$movar = $mo;
	open(TMP, ">/tmp/tmpfile") || die "Error: $!\n";
      } 
      print TMP $_;
      next;
    }
    print TMP $_;
    next;
  }
}

#
# Write the actual file and move to the correct month suffix.
#
sub writefile {
  local($dir) = @_;

  if($month =~ /$movar/i) {
    system("mv /tmp/tmpfile $_[0]");
  } else {
    system("mv /tmp/tmpfile $_[0].$movar");
  }
}
