#!/usr/bin/perl -w
##############################################################################
#
# This program logs into the Lucent Portmaster 3 and finds dual logins.
# If dual logins are found, it compares these dual logins with the 
# file 'excludedb'. If the user is found in the 'excludedb' file, this
# user is not terminated (modem reset). The 'excludedb' file are for those
# users who are allowed dual logins. Everyone else is gone! 
#
# The 'excludedb' file is populated with one user on a single line. At a
# minimum, the 'excludedb' file should contain PPP, as this is indicated on
# the Portmaster during the handshake and auth stage when a user is dialing in.
# 
# This program also logs off users if the portmaster has no vacant channels
# left. The users are logged off if they are the most idle > 1hr. If none are
# idle for more than one hour, the user with the most login time is logged off.
# If no user has a login time > 1hr., Then no one is logged off. If this
# occurs, its time for a another portmaster (RAS). No one is excluded when the 
# portmaster is full (no exclude list). Idle and login time is rounded up 
# (i.e. 30-50 minutes equals 1 hr.), (10-23 hours equals one day).
#
# If this program loggs off a user. Its saved in a log file with the time
# the user is logged off. You should place the log file so it can be viewed
# from an httpd server. Another log file of interest is 'sesout'. This file
# shows who was logged in at the time this program was last executed.
#
# This program was written for a single portmaster. Since we are a small
# network, we only have one portmaster at this time. It should be possible 
# to save the $dualuserdb to a file to extend this program to as many
# portmasters as you wish. You may of course exec an instance for each 
# portmaster you have.
#
# Written by Emmett Lewis for Logical Design Tools,Inc. Its written in
# Sorta C and seems to work with perl. So I'll call it a perl program.
#
# Use at your own risk! No Warranty of any kind. License is GPL. If you find
# a bug. Fix it! Since it's free.., ya get no support! ok?
#
# My email is emmett@ccinternet.net if you have trouble setting this up.
# I charge $200 or more to set this up (no freebies).
#
# Uses pmcom.c to communicate with the portmaster. I had to modify it slightly
# so it would work with Redhat Linux 6.2 and not use the !root login. 
# Don't be stooopid, set up a admin account for your portmaster. Some hacker 
# would love to have your root password so he can wreck your Portmaster.
#
# No fancy code. Should be easy reading for an experienced programmer. Lots of
# extra printf() for debugging (no patience for a debugger).
#
# For best results, run from Cron about every five minutes. Its best to compile
# this code before use so some hacker can't 'tweak' it to wreck havoc on your 
# network.
#
# The file 'ses-out-command' contains the 'show session' command that is sent
# to the portmaster to get the users currently logged in. Its possible this 
# command might change someday and is why its in a file.
##############################################################################

#enter full path name for pmcom (below and at the end of this file).
#change server name below to your portmaster's name.
system('/home/bootusers/pmcom -v pm3-1.ccinternet.net sh-ses-command>sesout');
system ('date>>sesout'); #save date in sesout
open (FILE, "sesout" ) or die "Can't find open myfile: $!\n";
while ($line =<FILE>)
    {
    $y=0;
    if ($line =~ m/S0 /) #beginning of ports
	{
	$userdb[$y] = substr ($line,5,15); #first port user name
	$logintimedb[$y] = substr ($line,66,1); #first port login time
	$idledb[$y++] = substr ($line,73,1); #first port idle hours
	$x=0;
	#printf ("%s",$line);
	while ($line=<FILE>)
	    {
	    #printf ("%s\n",$line);
	    if(substr ($line,0,1) ne "-") #skip the line where "Press Enter"
		{
		$userdb[$y] = substr ($line,5,15); #make user database
		$tt=substr ($line,65,1); #login time (tens place,hours)
		if ($tt eq "1" || $tt eq "2") 
		    {$tt="d";} #give em day status (ie 24 hrs)
			else {$tt=substr ($line,66,1); } #login time ones base
		$logintimedb[$y] = $tt;
		$tt = substr ($line,75,1); #idle time (tens place,minutes)
		if ($tt eq "3" || $tt eq "4" || $tt eq "5") {$tt=1;} #round up to one hour
		    else {$tt=substr ($line,73,1); } #idle hours
		$idledb[$y++] = $tt; #idle hours db
		#$it= substr ($line,73,1);
		#printf ("%s",$line);
		$x++;
		if($x>=22) {last;}
		}
	    }
	}    
    }
close FILE;
$x=0;$idlechan=0;$duc=0;$dupfound=0;
$du1=0;$du2=0;$du3=0;$du4=0;$du5=0;$du6=0;
$dup1=0;$dup2=0;$dup3=0;$dup4=0;$dup5=0;$dup6=0;
while ($x<=22)
    {
    #printf ("%s\n",$userdb[$x]);
    $user=$userdb[$x];
    $y=0;$match=0;
    if(substr($user,0,1) eq "-") {$idlechan++;}
    while ($y<=22) #compare user within db
	{
	$compuser=$userdb[$y];	
	if ( ($compuser eq $user) && ( (substr($user,0,1)) ne "-")) #match, dual login
	    {
	    if ($match) #skip the first instance of the user
		{
		#lets take a shortcut on the dup problem...
		$noescape=1;
		while($noescape) #goto broken when compiled. make 'last' work.
		    {
    		    if ($du1 eq $compuser && $y eq $dup1) {last;}
		    if ($du2 eq $compuser && $y eq $dup2) {last;}
		    if ($du3 eq $compuser && $y eq $dup3) {last;}
		    if ($du4 eq $compuser && $y eq $dup4) {last;}
		    if ($du5 eq $compuser && $y eq $dup5) {last;}
		    if ($du6 eq $compuser && $y eq $dup6) {last;}
		    $dualuserdb[$duc]=$compuser;
		    $dualuserportdb[$duc++]=$y;
		    $dupfound=1; #duplicate user found
		    #printf ("Dual login %s at %s\n",$compuser,$y);
		    if(! $du1) {$du1=$compuser;$dup1=$y;last;}
		    if(! $du2) {$du2=$compuser;$dup2=$y;last;}
		    if(! $du3) {$du3=$compuser;$dup3=$y;last;}
		    if(! $du4) {$du4=$compuser;$dup4=$y;last;}
		    if(! $du5) {$du5=$compuser;$dup5=$y;last;}
		    if(! $du6) {$du6=$compuser;$dup6=$y;last;}
		    $noescape=0; #make sure we exit
		    }
		}
	    $match=1; #set if found the first instance of the user
	    }
	$y++;
	}
    $x++;
    }
#printf("%s idle channels\n",$idlechan);
$x=0;
system ('cp -f /dev/null resetmodem');
while ($dualuserdb[$x])
    {
    $exclude=0;
    open (FILE, "excludedb" ) or die "Can't find open myfile: $!\n";
    while ($excludeuser=<FILE>)
	{
	chomp ($excludeuser);
	$z=0;$zz=0;
	while ( ($dualuser=substr($dualuserdb[$x],$zz,1)) ne " ")
	    {
	    $zz++;
	    $z++; #count number of letters
	    }
	#printf ("\nNumber letters %s",$zz);
	$dualuser=substr($dualuserdb[$x],0,$zz);
	#printf ("-%s-%s-\n",$excludeuser,$dualuser);
	if ($excludeuser eq $dualuser) 
	    {
	    $exclude=1;
	    } #skip excluded user
	}
    if ($exclude)
	{
	$x++;
	}
	else
	    {
	    open (OUTFILE, ">>loggedoffusers") or die "Can't open file: $!\n";
	    #printf ("%s port %s.",$dualuserdb[$x],$dualuserportdb[$x]);
	    #printf ("Need to reset port %s\n",$dualuserportdb[$x]);
	    print OUTFILE "Logged off dual user '$dualuserdb[$x]' port $dualuserportdb[$x] ";
	    close OUTFILE;
	    system ('date>>loggedoffusers');
	    open (OUTFILE, ">>resetmodem") or die "Can't open file: $!\n";
	    print OUTFILE "reset s","$dualuserportdb[$x]\n";
	    close OUTFILE;
	    }
    close FILE;
    $x++;
    }
$x=0;$it=0;$idletime=0;$mip=0;
while ( $idledb[$x] ) #find the most idle time
    {
    $it = $idledb[$x];
    if ($it eq " ") {$it =0;}
    if ($it eq "d") {$it =25;} #found "days"
    if ($idletime < $it)
        {
        $idletime = $it;
	$mip=$x; #save most idle port number
        }
    $x++;
    }
#printf ("Most idle time=%s at port %s\n",$idletime,$mip);
$x=0;$lt=0;$logintime=0;$tip=0;
while ( $logintimedb[$x] ) #find the most idle time
    {
    $lt = $logintimedb[$x];
    if ($lt eq " ") {$lt =0;}
    if ($lt eq "d") {$lt =25;} #found "days"
    if ($logintime < $lt)
        {
        $logintime = $lt;
	$tip=$x; #save most idle port number
        }
    $x++;
    }
#printf ("Most login time=%s at port %s\n",$logintime,$tip);
if ($idlechan <= 0) #running out of idle channels
    {
    if ($idletime >=1) #reset a port if idle for an hour or more
	{
	open (OUTFILE, ">>loggedoffusers") or die "Can't open file: $!\n";
	print OUTFILE "Idlechans=$idlechan. Reset s$mip for $idletime hours idletime.";
	close OUTFILE;
	system ('date>>loggedoffusers');
	open (OUTFILE, ">>resetmodem") or die "Can't open file: $!\n";
	print OUTFILE "reset s","$mip";
	close OUTFILE;
	}
	else # reset the most port thats been logged in the longest
	    {
	    if ($logintime >= 1)
		{
		open (OUTFILE, ">>loggedoffusers") or die "Can't open file: $!\n";
		print OUTFILE "Idlechans=$idlechan. Reset s$tip for $logintime hours logintime.";
		close OUTFILE;
		system ('date>>loggedoffusers');
		open (OUTFILE, ">>resetmodem") or die "Can't open file: $!\n";
		print OUTFILE "reset s","$tip";
		close OUTFILE;
		}
		    else #if no idle time>1hr or login times > 1hr. can't log anyone off.
			{
			open (OUTFILE, ">>loggedoffusers") or die "Can't open file: $!\n";
			print OUTFILE "Idlechans=$idlechan. No logins>1hr and no idle users>1hr.";
			close OUTFILE;
			system ('date>>loggedoffusers');
			}
	    }
    }
$maxidletime=25; # change this to the maximum allowable idle time.
if ($idletime >= $maxidletime) #reset a port if idle for nine hours or more
    {
    open (OUTFILE, ">>loggedoffusers") or die "Can't open file: $!\n";
    print OUTFILE "Max idle time reached. Reset s$mip for $idletime hours idletime.";
    close OUTFILE;
    system ('date>>loggedoffusers');
    open (OUTFILE, ">>resetmodem") or die "Can't open file: $!\n";
    print OUTFILE "reset s","$mip";
    close OUTFILE;
    }
if ($dupfound)
    {
    #change path of pmcom to match your path
    system('/bootusers/pmcom -v pm3-1.ccinternet.net resetmodem');
    }
exit;
