<P>
	Troubleshooting IRX PPP over leased lines
</P><P>
How to set up an IRX to speak to another on a leased line via PPP
using its ethernet address for the serial link. 
The IRX always uses external clock so make sure the TelCo or the CSU/DSU
is providing it.
</P><PRE>
set ether0 address 204.138.245.2
set ether0 netmask 255.255.255.0
set ether0 routing on
set sysname digifix			# SNMP sysname
set gateway 198.133.162.1		# or whatever it is
set namesvc dns				# this line and next aren't required
set nameserver 204.138.245.1

set s1 network hardwire
set s1 speed 57600			# this speed is just a comment
set s1 address 0.0.0.0			# use ethernet address for your end
					# of serial link
set s1 destination 198.133.162.1 255.255.255.0	# or whatever their address is
set s1 protocol ppp
set s1 routing on
set s1 mtu 1500
save all
reset s1
</PRE><P>
If you're not sure of the destination's IP address you can
negotiate it and then set your default gateway to whatever it turns
out to be.
</P><P>
set s1 destination 255.255.255.255
</P><P>
If you're having problems, the following two commands will show you the
PPP negotiations; ftp.morningstar.com has a nice PPP reference sheet
for decoding the debug output:
</P><PRE>
set console
set debug 0x51
</PRE><PRE>
To turn it off,
set debug 0
reset console
</PRE><P>
If you put your CSU/DSU into local loopback or the remote CSU/DSU into
loopback while set debug 0x51 is set, you should see LCP_APPARENT_LOOP
messages.

</P><P>
<H4>Hints on Troubleshooting</H4>
</P><P>
CHECK ERROR COUNTERS FIRST!
</P><P>
If they're nonzero, there's almost certainly a hardware problem unrelated
to the IRX - check cables, CSU/DSU, modem, and line.  A few abort errors
from plugging & unplugging cables is OK.
</P><P>
On a sync line:
</P><P>
There are only three situations where we have seen the abort counter
on an IRX increment:
</P><P>
<DL>
<DD> 1) CSU/DSU either misconfigured or gone out to lunch for good.
<DD> 2) Open pair on the TelCo wire
<DD> 3) Cisco on the other end running release 9.14(2), which has a 1's assertion bug; it should be running 9.14(5) or later.
</DL>
</P><P>
Q. My IRX is having problems talking with a Cisco router
The cisco is a 3000 IGS-K Version is 9.14(2) release fc3.
</P><P>
There's a bug (1's assertion problem) in certain cisco routers where
they interoperate with each other but not others; this problem is
definately in 9.14 (2) and they recommend going to 9.14(4) at least,
but better for you to go to 9.14(5).  Please contact Cisco tech support
for this fix.
</P><P>
If the framing errors on the IRX are greater than 0 and the other
router is not an IRX, make sure it's using PPP encapsulation (not HDLC).
</P><P>
If all of this checks out, call the Telco and have them check the line, as
many times as it takes. :-)
</P>
If this document is in any way incomplete or mis-leading please send
e-mail to <A HREF="mailto:support@livingston.com"> support@livingston.com</A> pointing out its weakness(es).
