/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/

#include	<security/pam_appl.h>

#include	<string.h>
#include	<sys/types.h>

#include	"radius.h"

typedef struct {
	char *name, *pw;
} pam_userinfo;

/*************************************************************************
 *
 *	Function: local_conv
 *
 *	Purpose: Fetch the user and password (passed in via
 *		 appdata_ptr) and validate
 *
 *************************************************************************/

int local_conv(int num_msg, const struct pam_message **msg,
    struct pam_response **resp, void *appdata_ptr) {
	unsigned short i = 0;
	pam_userinfo *userinfo = (pam_userinfo*)appdata_ptr;
	struct pam_response *response = 0;

	/* parameter sanity checking */
	if(!resp || !msg || !userinfo)
		return PAM_CONV_ERR;

	/* allocate memory to store response */
	response = malloc(num_msg * sizeof(struct pam_response));
	if(!response)
		return PAM_CONV_ERR;

	/* copy values */
	for(i = 0; i < num_msg; i++) {
		/* initialize to safe values */
		response[i].resp_retcode = 0;
		response[i].resp = 0;

		/* select response based on requested output style */
		switch(msg[i]->msg_style) {
		    case PAM_PROMPT_ECHO_ON:
			/* on memory allocation failure, auth fails */
			response[i].resp = strdup(userinfo->name);
			break;
		    case PAM_PROMPT_ECHO_OFF:
			response[i].resp = strdup(userinfo->pw);
			break;
		    default:
			if(response)
				free(response);
			return PAM_CONV_ERR;
		}
	}
	/* everything okay, set PAM response values */
	*resp = response;
	return PAM_SUCCESS;
}

/*************************************************************************
 *
 *	Function: pam_pass
 *
 *	Purpose: Check the users password using the PAM system
 *		 (requires a service description in /etc/pam.d/)
 *
 *************************************************************************/

int
pam_pass(name, passwd)
char	*name;
char	*passwd;
{
	pam_handle_t *pamh = NULL;
	pam_userinfo userinfo = { name, passwd };
	struct pam_conv conv_info = { (void *)local_conv, (void *)&userinfo};
	int rval = 0;

	if((rval = pam_start("radius", name, &conv_info, &pamh)) != PAM_SUCCESS) {
		DEBUG("pam_pass: error in pam_start: %s\n", (char *)pam_strerror(pamh, rval));
		return(-1);
	}

	if(pam_authenticate(pamh, PAM_DISALLOW_NULL_AUTHTOK) != PAM_SUCCESS) {
		DEBUG("pam_pass: user unknown or incorrect password\n");
		rval = -1;
	}
	
	else if(pam_acct_mgmt(pamh, 0) != PAM_SUCCESS) {
		DEBUG("pam_pass: user access was denied\n");
		rval = -1;
	}
	
	if(pam_end(pamh, PAM_SUCCESS) != PAM_SUCCESS)
		DEBUG("pam_pass: couldn't release auth token\n");

	return(rval);
}
