#!/bin/sh
#######################################################################
# radlog.sh v 1.0 Radius Detail Log Management Script by Rick Nickell #
#######################################################################

# This script is distributed as Freeware but remains the soul property
# of Old Dominion Networks, Inc. Any re-distribution or update must 
# include all items in the original archive PLUS the comments seen herein. 

# This Program is delivered and accepted AS-IS with no warranty implied or otherwise.

# Simple Script by Rick Nickell to manage your Portmaster/Radius logs...
# You may need to change some of these pathnames and filenames 
# in order to use them with your system... More info? email me:
# rick@old-dominion.net 

# You can get the LATEST rev of this script at:
# http://www.old-dominion.net/shellscripts/

# **************************************
# What does this script do??           *
# **************************************

# This script seperates your radius detail logs out on a weekly basis for
# up to six weeks and then stores any log entries and an archival file.
# Then it kills and restarts your radius daemon to initialize a new log
# file which it also creates. Then it emails root to let you know it worked.
# Tested on LINUX ONLY


#########################
###  Settings ###########
#########################

############### Set your portmaster's ip address #####################

portmaster='xxx.xxx.xxx.xxx'

######################################################################

# This is what the LINUX path is normally. For your system is MAY be different

radacctpath='/usr/adm/radacct/'


# This is the default name of the actual Radius Detail Log but if you changed
# the logfile name in your Radius Settings then you need to change this.

logname='detail'

# This is the name of the command on YOUR unix system that will automatically
# kill ALL processes under any input name. (e.g. killall radiusd)

killcommand='killall'


########## Do NOT EDIT ANTYTHING BELOW THIS LINE  #################

cat $radacctpath/$portmaster/6weeks >> $radacctpath/$portmaster/archive98
cp $radacctpath/$portmaster/5weeks $radacctpath/$portmaster/6weeks
cp $radacctpath/$portmaster/4weeks $radacctpath/$portmaster/5weeks
cp $radacctpath/$portmaster/3weeks $radacctpath/$portmaster/4weeks
cp $radacctpath/$portmaster/2weeks $radacctpath/$portmaster/3weeks
cp $radacctpath/$portmaster/lastweek $radacctpath/$portmaster/2weeks
cp $radacctpath/$portmaster/$logname $radacctpath/$portmaster/lastweek
rm $radacctpath/$portmaster/$logname
touch $radacctpath/$portmaster/$logname
$killcommand radiusd
/etc/radiusd -d /etc/raddb -a $radacctpath

#end radlog.sh

