/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEChannels;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEEthernets;
import com.lucent.ra.nms.model.LEIMT;
import com.lucent.ra.nms.model.LEL2TP;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LEPVCs;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.util.LEVector;

public class LEBoard
extends LEConfig {
    public static final String ASSIGNED_ADDR = Integer.toString(164);
    public static final String ASSIGNED_POOL = Integer.toString(165);
    public static final String BACKPLANE_CLOCK = "473";
    public static final String BOARD_TYPE = Integer.toString(272);
    public static final String CHANNELS = "3670019";
    public static final String ETHERNETS = Integer.toString(720896);
    public static final String IMT = "3670022";
    public static final String PRI_SWITCH = Integer.toString(172);
    public static final String LINE_CLOCK = "472";
    public static final String LINE_LOOP = "461";
    public static final String LINES = Integer.toString(131072);
    public static final String MGR_TYPE = "530";
    public static final String MODEMS = Integer.toString(196608);
    public static final String OS_VERSION = Integer.toString(276);
    public static final String PORTS = Integer.toString(262144);
    public static final String POWER = Integer.toString(279);
    public static final String PVCS = "4194311";
    public static final String SERIAL_NUMBER = Integer.toString(273);
    public static final String SLOT = Integer.toString(274);
    public static final String L2TP = Integer.toString(0x350000);
    public static final String STATUS = "17";
    public static final int KEY_COUNT = 21;
    public static final String ETHERNET = "Ethernet";
    public static final String DUAL_ETHER = "Dual Ethernet";
    public static final String PRESENT = "Present";
    public static final String QUAD_T1 = "Quad T1";
    public static final String TRI_E1 = "Tri E1";
    public static final String SYSTEM_MANAGER = "System Manager";
    public static final String T3_MUX = "T3 Mux";
    public static final String E3_MUX = "E3 Mux";
    public static final String T3_CLEAR = "T3 Clear";
    public static final String LNS = "LNS";
    public static final String T3_MUXR = "T3 Mux Redundant";
    public static final String E3_MUXR = "E3 Mux Redundant";
    public static final String T3_ATM = "T3 ATM";
    public static final String E3_ATM = "E3 ATM";
    public static final String E3_CLEAR = "E3 Clear";
    public static final String STS1 = "STS1 Mux";
    public static final String STS1_R = "STS1 Mux Redundant";
    public static final String HSSI = "HSSI";
    public static final String PCT = "PCT";
    public static final String UNKNOWN = "Unknown";
    public static final String PRIMARY = "Primary";
    public static final String SECONDARY = "Secondary";
    public static final String MANAGER_1 = "4";
    public static final String MANAGER_2 = "5";
    public static final String BOOTING = "booting";
    public static final String SYSTEM_MANAGER_ID_1 = "4";
    public static final String SYSTEM_MANAGER_ID_2 = "5";
    public static final String ETHER_DAUGHTER_ID = "10";
    public static final String DUALETHER_DAUGHTER_ID = "11";
    public static final String SET_GLOBAL_VIEW = "set view global";
    public static final String SET_MGR_VIEW = "set view 4";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;
    LEDataSpec m_powerSpec;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[21];
            int n = 0;
            LEBoard.s_keys[n++] = ASSIGNED_ADDR;
            LEBoard.s_keys[n++] = ASSIGNED_POOL;
            LEBoard.s_keys[n++] = BACKPLANE_CLOCK;
            LEBoard.s_keys[n++] = BOARD_TYPE;
            LEBoard.s_keys[n++] = CHANNELS;
            LEBoard.s_keys[n++] = ETHERNETS;
            LEBoard.s_keys[n++] = IMT;
            LEBoard.s_keys[n++] = PRI_SWITCH;
            LEBoard.s_keys[n++] = LINE_CLOCK;
            LEBoard.s_keys[n++] = LINE_LOOP;
            LEBoard.s_keys[n++] = LINES;
            LEBoard.s_keys[n++] = MGR_TYPE;
            LEBoard.s_keys[n++] = MODEMS;
            LEBoard.s_keys[n++] = OS_VERSION;
            LEBoard.s_keys[n++] = PORTS;
            LEBoard.s_keys[n++] = POWER;
            LEBoard.s_keys[n++] = PVCS;
            LEBoard.s_keys[n++] = SERIAL_NUMBER;
            LEBoard.s_keys[n++] = SLOT;
            LEBoard.s_keys[n++] = STATUS;
            LEBoard.s_keys[n++] = L2TP;
        }
        return s_keys;
    }

    public LEBoard(LEConnectionFacade lEConnectionFacade, String string) {
        super(lEConnectionFacade);
        this.m_name = string;
        this.m_board = string;
    }

    public static final LEPMCommand SetView(LEConnectionFacade lEConnectionFacade, String string) {
        String string2 = new String("set view " + string);
        return lEConnectionFacade.execute(string2);
    }

    public static boolean IsManager(String string) {
        return string.equals("4") || string.equals("5") || string.equals(ETHER_DAUGHTER_ID);
    }

    public static boolean IsDaughter(String string) {
        return string.equals(ETHER_DAUGHTER_ID) || string.equals(DUALETHER_DAUGHTER_ID);
    }

    public Object clone() {
        LEBoard lEBoard = new LEBoard(this.m_facade, this.m_name);
        lEBoard.copy(this);
        return lEBoard;
    }

    public LEDataSpec getSpecFor(String string) {
        LEDataSpec lEDataSpec = super.getSpecFor(string);
        if (lEDataSpec != null && string.equals(POWER) && (LEBoard.IsManager(this.m_board) || LEBoard.IsDaughter(this.m_board))) {
            if (this.m_powerSpec == null) {
                this.m_powerSpec = (LEDataSpec)lEDataSpec.clone();
                this.m_powerSpec.addAttribute(LEAttributes.READONLY, "");
            }
            lEDataSpec = this.m_powerSpec;
        }
        return lEDataSpec;
    }

    public String getType() {
        String string = (String)this.get(BOARD_TYPE);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public String getStatus() {
        String string = this.getType();
        String string2 = (String)this.get(POWER);
        if (string2 == null) {
            return "";
        }
        if (string.equals(PRESENT) && string2.equals("on")) {
            return BOOTING;
        }
        return string2;
    }

    public boolean isPoweredUp() {
        String string = (String)this.get(BOARD_TYPE);
        String string2 = (String)this.get(POWER);
        return string != null && !string.equals(PRESENT) && string2 != null && string2.equals("on");
    }

    public boolean isPoweringUp() {
        String string = (String)this.get(BOARD_TYPE);
        String string2 = (String)this.get(POWER);
        return string != null && string.equals(PRESENT) && string2 != null && string2.equals("on");
    }

    public boolean getGlobalCommands(LEVector lEVector) {
        return this.generateCommands(null, lEVector);
    }

    boolean makeViewCommand(LEVector lEVector) {
        String string = this.getViewCommand();
        String string2 = (String)this.get(POWER);
        if (string != null && string2.equals("on")) {
            lEVector.addElement(string);
            return true;
        }
        return false;
    }

    LEConfig createConfig(String string) {
        if (string.equals(PORTS)) {
            return new LEPorts(this.m_facade, this.m_name, PORTS);
        }
        if (string.equals(LINES)) {
            return new LELines(this.m_facade, this.m_name, LINES);
        }
        if (string.equals(ETHERNETS)) {
            return new LEEthernets(this.m_facade, this.m_name, ETHERNETS);
        }
        if (string.equals(MODEMS)) {
            return new LEModems(this.m_facade, this.m_name, MODEMS);
        }
        if (string.equals(IMT)) {
            return new LEIMT(this.m_facade, this.m_name, IMT);
        }
        if (string.equals(CHANNELS)) {
            return new LEChannels(this.m_facade, this.m_name, CHANNELS);
        }
        if (string.equals(L2TP)) {
            return new LEL2TP(this.m_facade, this.m_name, L2TP);
        }
        if (string.equals(PVCS)) {
            return new LEPVCs(this.m_facade, this.m_name, PVCS);
        }
        return new LEConfig(this.m_facade);
    }

    boolean generateCommands(LEVector lEVector, LEVector lEVector2) {
        String string;
        String string2;
        boolean bl = lEVector == null;
        int n = lEVector2.size();
        if ((bl || lEVector.contains(POWER)) && this.makePowerCommand(lEVector2, string2 = (String)this.get(SLOT), string = (String)this.get(POWER))) {
            this.makeViewCommand(lEVector2);
        }
        if (bl || lEVector.contains(ASSIGNED_ADDR)) {
            this.makeSetCommand(lEVector2, null, ASSIGNED_ADDR, "assigned_address");
        }
        if (bl || lEVector.contains(ASSIGNED_POOL)) {
            this.makeSetCommand(lEVector2, null, ASSIGNED_POOL, "pool");
        }
        if (bl || lEVector.contains(PRI_SWITCH)) {
            this.makeSetCommand(lEVector2, null, PRI_SWITCH, "isdn-switch");
        }
        if (bl || lEVector.contains(BACKPLANE_CLOCK)) {
            this.makeSetCommand(lEVector2, null, BACKPLANE_CLOCK, "mux backplane-clock");
        }
        if (bl || lEVector.contains(LINE_CLOCK)) {
            this.makeSetCommand(lEVector2, null, LINE_CLOCK, "mux line-clock");
        }
        if (bl || lEVector.contains(LINE_LOOP)) {
            this.makeSetCommand(lEVector2, null, LINE_LOOP, "mux line-loop");
        }
        return lEVector2.size() > n;
    }

    boolean makePowerCommand(LEVector lEVector, String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            if (n < 10 && n != 4 && n != 5) {
                if (this.m_smm) {
                    lEVector.addElement(SET_GLOBAL_VIEW);
                } else {
                    lEVector.addElement(SET_MGR_VIEW);
                }
                StringBuffer stringBuffer = new StringBuffer(14);
                stringBuffer.append("set ");
                stringBuffer.append("slot");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                stringBuffer.append(string2);
                lEVector.addElement(stringBuffer.toString());
                bl = true;
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    LEVector getChildren(boolean bl) {
        LEVector lEVector = null;
        if (this.get(IMT) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(IMT);
        }
        if (this.get(LINES) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(LINES);
        }
        if (this.get(ETHERNETS) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(ETHERNETS);
        }
        if (this.get(PORTS) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(PORTS);
        }
        if (this.get(MODEMS) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(MODEMS);
        }
        if (this.get(CHANNELS) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(CHANNELS);
        }
        if (this.get(L2TP) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(L2TP);
        }
        if (this.get(PVCS) != null) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addElement(PVCS);
        }
        return lEVector;
    }
}

