/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.model.LEAsyncPort;
import com.lucent.ra.nms.model.LEAsyncPorts;
import com.lucent.ra.nms.model.LEBGPPeer;
import com.lucent.ra.nms.model.LEBGPPolicy;
import com.lucent.ra.nms.model.LEBGPPolicyRule;
import com.lucent.ra.nms.model.LEBinding;
import com.lucent.ra.nms.model.LEBindings;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEChannels;
import com.lucent.ra.nms.model.LEChoicenet;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LECustomPlans;
import com.lucent.ra.nms.model.LEDBNetUser;
import com.lucent.ra.nms.model.LEDLCI;
import com.lucent.ra.nms.model.LEDLCITable;
import com.lucent.ra.nms.model.LEDialScript;
import com.lucent.ra.nms.model.LEDomCustomPlan;
import com.lucent.ra.nms.model.LEDomCustomPlans;
import com.lucent.ra.nms.model.LEEthernet;
import com.lucent.ra.nms.model.LEEthernets;
import com.lucent.ra.nms.model.LEGlobal;
import com.lucent.ra.nms.model.LEGroup;
import com.lucent.ra.nms.model.LEGroups;
import com.lucent.ra.nms.model.LEHost;
import com.lucent.ra.nms.model.LEHostOverrides;
import com.lucent.ra.nms.model.LEHosts;
import com.lucent.ra.nms.model.LEIMT;
import com.lucent.ra.nms.model.LEIPPool;
import com.lucent.ra.nms.model.LEIPPools;
import com.lucent.ra.nms.model.LEIPRange;
import com.lucent.ra.nms.model.LEIPRanges;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEIPSecProfileRule;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEISDNPort;
import com.lucent.ra.nms.model.LEISDNPorts;
import com.lucent.ra.nms.model.LEIntlCustomPlan;
import com.lucent.ra.nms.model.LEIntlCustomPlans;
import com.lucent.ra.nms.model.LEL2TP;
import com.lucent.ra.nms.model.LELine;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LELocalIPAddress;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LELoginUser;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LEMuxChannel;
import com.lucent.ra.nms.model.LENATMap;
import com.lucent.ra.nms.model.LENATMapRule;
import com.lucent.ra.nms.model.LENATMaps;
import com.lucent.ra.nms.model.LENetUser;
import com.lucent.ra.nms.model.LENetworkRanges;
import com.lucent.ra.nms.model.LENumberingPlan;
import com.lucent.ra.nms.model.LEOSPFArea;
import com.lucent.ra.nms.model.LEOrderedList;
import com.lucent.ra.nms.model.LEPVC;
import com.lucent.ra.nms.model.LEPVCs;
import com.lucent.ra.nms.model.LEParallelPort;
import com.lucent.ra.nms.model.LEParallelPorts;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.model.LEPrefixes;
import com.lucent.ra.nms.model.LEPriCustomPlan;
import com.lucent.ra.nms.model.LEPriCustomPlans;
import com.lucent.ra.nms.model.LERadius;
import com.lucent.ra.nms.model.LERoute;
import com.lucent.ra.nms.model.LESNMPHosts;
import com.lucent.ra.nms.model.LESubInterface;
import com.lucent.ra.nms.model.LESubInterfaces;
import com.lucent.ra.nms.model.LESyncPort;
import com.lucent.ra.nms.model.LESyncPorts;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LENetmask;
import com.lucent.ra.nms.util.LEOctets;
import com.lucent.ra.nms.util.LETokenizer;
import java.util.StringTokenizer;

public class LEPMEntityParser {
    public static final String MCPU_EMPTY = "0";
    public static final String MCPU_PRESENT = "1";
    public static final String MCPU_MGR_PM4 = "3";
    public static final String MCPU_PM4_QT1 = "5";
    public static final String MCPU_PM4_TE1 = "6";
    public static final String MCPU_T3MX = "7";
    public static final String MCPU_ETHER = "8";
    public static final String MCPU_E3MX = "9";
    public static final String MCPU_T3_CLR = "10";
    public static final String MCPU_LNS = "11";
    public static final String MCPU_T3_MUXR = "12";
    public static final String MCPU_E3_MUXR = "13";
    public static final String MCPU_100E_2P = "14";
    public static final String MCPU_T3_ATM = "15";
    public static final String MCPU_E3_ATM = "16";
    public static final String MCPU_E3_CLR = "17";
    public static final String MCPU_STS1 = "18";
    public static final String MCPU_STS1_R = "19";
    public static final String MCPU_HSSI = "20";
    public static final String MCPU_PCT = "21";
    public static final String ASYNC_PORT = "async";
    public static final String ISDN_PORT = "isdn";
    public static final String PARA_PORT = "parallel";
    public static final String SYNC_PORT = "sync";
    public static final String X_PORT_PRE = "X";

    public static boolean Parse(String string, LEDSSPortMaster lEDSSPortMaster, LEPortMaster lEPortMaster) {
        String string2 = string;
        if (string.equals("1048580") || string.equals("1048581") || string.equals("1048582")) {
            return LEPMEntityParser.Parse(lEDSSPortMaster, lEPortMaster.getConfig("1048577"), string, string2);
        }
        return LEPMEntityParser.Parse(lEDSSPortMaster, lEPortMaster.getConfig(string), string, string2);
    }

    public static boolean Parse(String string, String string2, LEDSSPortMaster lEDSSPortMaster, LEPortMaster lEPortMaster) {
        String string3 = String.valueOf(string) + " " + 275 + " " + string2;
        return LEPMEntityParser.Parse(lEDSSPortMaster, lEPortMaster.getConfig("2555904"), string, string3);
    }

    public static boolean Parse(LEDSSPortMaster lEDSSPortMaster, LEConfig lEConfig, String string, String string2) {
        boolean bl = true;
        try {
            LESendResponse lESendResponse = lEDSSPortMaster.send((byte)31, (short)string2.length(), string2, true);
            bl = lESendResponse.successful();
            while (bl && LEPMEntityParser.Parse(string, lEConfig, lESendResponse.getStreamTok())) {
                lESendResponse = lEDSSPortMaster.recv(true);
                bl = lESendResponse.successful();
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            bl = false;
        }
        lEDSSPortMaster.done();
        return bl;
    }

    public static boolean Parse(String string, LEConfig lEConfig, LETokenizer lETokenizer) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        boolean bl = false;
        switch (n) {
            case 0x210000: {
                bl = LEPMEntityParser.ParseGlobal(lEConfig, lETokenizer);
                break;
            }
            case 327680: {
                bl = LEPMEntityParser.ParseSyslog(lEConfig, lETokenizer);
                break;
            }
            case 0x150000: {
                bl = LEPMEntityParser.ParseSNMP(lEConfig, lETokenizer);
                break;
            }
            case 0x100000: {
                bl = LEPMEntityParser.ParseOSPF(lEConfig, lETokenizer);
                break;
            }
            case 524288: {
                bl = LEPMEntityParser.ParseOSPFAreas(lEConfig, lETokenizer);
                break;
            }
            case 0x140000: {
                bl = LEPMEntityParser.ParseRoutes(lEConfig, lETokenizer);
                break;
            }
            case 0x130000: {
                bl = LEPMEntityParser.ParseHosts(lEConfig, lETokenizer);
                break;
            }
            case 196608: {
                bl = LEPMEntityParser.ParseModems(lEConfig, lETokenizer);
                break;
            }
            case 131072: {
                bl = LEPMEntityParser.ParseLines(lEConfig, lETokenizer);
                break;
            }
            case 0x260000: {
                bl = LEPMEntityParser.ParseSubInterface(lEConfig, lETokenizer);
                break;
            }
            case 0x270000: {
                bl = LEPMEntityParser.ParseBoards(lEConfig, lETokenizer);
                break;
            }
            case 0x1A0000: {
                bl = LEPMEntityParser.ParseLocations(lEConfig, lETokenizer);
                break;
            }
            case 262144: {
                bl = LEPMEntityParser.ParsePorts(lEConfig, lETokenizer);
                break;
            }
            case 0x290000: {
                bl = LEPMEntityParser.ParseNATMaps(lEConfig, lETokenizer);
                break;
            }
            case 720896: {
                bl = LEPMEntityParser.ParseEthernets(lEConfig, lETokenizer);
                break;
            }
            case 0x1C0000: {
                bl = LEPMEntityParser.ParseUsers(lEConfig, lETokenizer);
                break;
            }
            case 0x310000: {
                bl = LEPMEntityParser.ParseUserPasswords(lEConfig, lETokenizer);
                break;
            }
            case 0x220000: {
                bl = LEPMEntityParser.ParseRadius(lEConfig, lETokenizer);
                break;
            }
            case 0x170000: {
                bl = LEPMEntityParser.ParseChoiceNet(lEConfig, lETokenizer);
                break;
            }
            case 0x320000: {
                bl = LEPMEntityParser.ParseSecrets(lEConfig, lETokenizer);
                break;
            }
            case 589824: {
                bl = LEPMEntityParser.ParseBGP(lEConfig, lETokenizer);
                break;
            }
            case 0x160000: {
                bl = LEPMEntityParser.ParseBGPPeers(lEConfig, lETokenizer);
                break;
            }
            case 0x300000: {
                bl = LEPMEntityParser.ParseBGPPolicies(lEConfig, lETokenizer);
                break;
            }
            case 0x250000: {
                bl = LEPMEntityParser.ParseSAs(lEConfig, lETokenizer);
                break;
            }
            case 0x390000: {
                bl = LEPMEntityParser.ParseIPSecProfiles(lEConfig, lETokenizer);
                break;
            }
            case 3670021: {
                bl = LEPMEntityParser.ParseIPPools(lEConfig, lETokenizer);
                break;
            }
            case 3670022: {
                bl = LEPMEntityParser.ParseIMT(lEConfig, lETokenizer);
                break;
            }
            case 3670023: {
                bl = LEPMEntityParser.ParseLocalIPAddresses(lEConfig, lETokenizer);
                break;
            }
            case 0x350000: {
                bl = LEPMEntityParser.ParseL2TP(lEConfig, lETokenizer);
                break;
            }
            case 0x100001: {
                bl = LEPMEntityParser.ParseNumberingPlan(lEConfig, lETokenizer);
                break;
            }
            case 0x100002: {
                bl = LEPMEntityParser.ParseGateway(lEConfig, lETokenizer);
                break;
            }
            case 0x100004: {
                bl = LEPMEntityParser.ParseDomCustPlans(lEConfig, lETokenizer);
                break;
            }
            case 0x100005: {
                bl = LEPMEntityParser.ParseIntlCustPlans(lEConfig, lETokenizer);
                break;
            }
            case 0x100006: {
                bl = LEPMEntityParser.ParsePrivateCustPlans(lEConfig, lETokenizer);
                break;
            }
            case 0x380003: {
                bl = LEPMEntityParser.ParseMuxChannels(lEConfig, lETokenizer);
                break;
            }
            case 0x400007: {
                bl = LEPMEntityParser.ParseATMPVCs(lEConfig, lETokenizer);
                break;
            }
            case 3670032: {
                bl = LEPMEntityParser.ParseDHCP(lEConfig, lETokenizer);
                break;
            }
            default: {
                LEDebug.getLog().logln(20, "No parser for entity: " + n);
            }
        }
        return bl;
    }

    public static boolean ParseNumberingPlan(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block7: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x100001: {
                        lETokenizer.getNextQuotedString();
                        lEConfig.getConfig("1048580");
                        lEConfig.getConfig("1048581");
                        lEConfig.getConfig("1048582");
                        break;
                    }
                    case 61440: 
                    case 61441: 
                    case 61442: 
                    case 61443: 
                    case 61444: 
                    case 61445: 
                    case 61446: 
                    case 61447: 
                    case 61448: 
                    case 61449: 
                    case 61450: 
                    case 61451: 
                    case 61452: 
                    case 61453: 
                    case 61460: 
                    case 61461: 
                    case 61462: 
                    case 61473: 
                    case 61474: 
                    case 61475: 
                    case 61476: 
                    case 61477: 
                    case 61495: 
                    case 61501: 
                    case 61502: 
                    case 61503: {
                        String string = lETokenizer.getNextQuotedString();
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block7;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Numbering Plan", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseDomCustPlans(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LECustomPlans lECustomPlans = null;
            LEDomCustomPlan lEDomCustomPlan = null;
            LEOrderedList lEOrderedList = null;
            boolean bl2 = false;
            block10: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x100004: {
                        lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LENumberingPlan)) continue block10;
                        lECustomPlans = (LEDomCustomPlans)lEConfig.get("1048580");
                        break;
                    }
                    case 61491: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lECustomPlans == null || (lEDomCustomPlan = (LEDomCustomPlan)lECustomPlans.getConfig(string)) == null) continue block10;
                        lEOrderedList = (LEPrefixes)lEDomCustomPlan.getConfig("61492");
                        lEOrderedList.clearList();
                        break;
                    }
                    case 61494: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEDomCustomPlan == null) continue block10;
                        lEDomCustomPlan.setField(Integer.toString(n), string);
                        break;
                    }
                    case 61493: {
                        String string = lETokenizer.getNextQuotedString();
                        String string2 = string.replace('\'', '\"');
                        if (lEDomCustomPlan == null) continue block10;
                        lEDomCustomPlan.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 61492: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEOrderedList == null) continue block10;
                        lEOrderedList.addField(string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block10;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Domestic Custom Plan", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseIntlCustPlans(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LECustomPlans lECustomPlans = null;
            LEIntlCustomPlan lEIntlCustomPlan = null;
            LEOrderedList lEOrderedList = null;
            boolean bl2 = false;
            block10: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x100005: {
                        lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LENumberingPlan)) continue block10;
                        lECustomPlans = (LEIntlCustomPlans)lEConfig.get("1048581");
                        break;
                    }
                    case 61491: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lECustomPlans == null || (lEIntlCustomPlan = (LEIntlCustomPlan)lECustomPlans.getConfig(string)) == null) continue block10;
                        lEOrderedList = (LEPrefixes)lEIntlCustomPlan.getConfig("61492");
                        lEOrderedList.clearList();
                        break;
                    }
                    case 61494: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEIntlCustomPlan == null) continue block10;
                        lEIntlCustomPlan.setField(Integer.toString(n), string);
                        break;
                    }
                    case 61493: {
                        String string = lETokenizer.getNextQuotedString();
                        String string2 = string.replace('\'', '\"');
                        if (lEIntlCustomPlan == null) continue block10;
                        lEIntlCustomPlan.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 61492: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEOrderedList == null) continue block10;
                        lEOrderedList.addField(string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block10;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("International Custom Plan", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParsePrivateCustPlans(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LECustomPlans lECustomPlans = null;
            LEPriCustomPlan lEPriCustomPlan = null;
            LEOrderedList lEOrderedList = null;
            boolean bl2 = false;
            block10: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x100006: {
                        lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LENumberingPlan)) continue block10;
                        lECustomPlans = (LEPriCustomPlans)lEConfig.get("1048582");
                        break;
                    }
                    case 61491: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lECustomPlans == null || (lEPriCustomPlan = (LEPriCustomPlan)lECustomPlans.getConfig(string)) == null) continue block10;
                        lEOrderedList = (LEPrefixes)lEPriCustomPlan.getConfig("61492");
                        lEOrderedList.clearList();
                        break;
                    }
                    case 61494: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEPriCustomPlan == null) continue block10;
                        lEPriCustomPlan.setField(Integer.toString(n), string);
                        break;
                    }
                    case 61493: {
                        String string = lETokenizer.getNextQuotedString();
                        String string2 = string.replace('\'', '\"');
                        if (lEPriCustomPlan == null) continue block10;
                        lEPriCustomPlan.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 61492: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEOrderedList == null) continue block10;
                        lEOrderedList.addField(string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block10;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Private Custom Plan", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseGateway(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block7: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x100002: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 61465: 
                    case 61466: 
                    case 61467: 
                    case 61468: 
                    case 61469: 
                    case 61472: 
                    case 61478: 
                    case 61479: 
                    case 61480: 
                    case 61481: 
                    case 61482: 
                    case 61483: 
                    case 61484: 
                    case 61485: 
                    case 61486: 
                    case 61487: 
                    case 61488: 
                    case 61489: 
                    case 61490: 
                    case 61496: 
                    case 61497: 
                    case 61498: 
                    case 61499: 
                    case 61500: 
                    case 61504: 
                    case 61505: 
                    case 61506: 
                    case 61507: 
                    case 61508: 
                    case 61510: 
                    case 61511: 
                    case 61514: 
                    case 61515: 
                    case 61516: 
                    case 61517: {
                        String string = lETokenizer.getNextQuotedString();
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block7;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Gateway", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseRoutes(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = null;
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            block12: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x140000: {
                        String string5 = lETokenizer.getNextQuotedString();
                        if (string5.length() <= 0) continue block12;
                        string = string5;
                        break;
                    }
                    case 74: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 75: {
                        string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 77: {
                        string3 = lETokenizer.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 78: {
                        string4 = lETokenizer.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 82: {
                        String string5 = lETokenizer.getNextQuotedString().toLowerCase();
                        lEConfig2 = null;
                        if (string3 != null && string3.equals("local") && string5 != null && string5.equals("static") && string != null) {
                            lEConfig2 = (LERoute)lEConfig.getConfig(string);
                            if (string2 != null) {
                                lEConfig2.setField(LERoute.GATEWAY, string2);
                            }
                            if (string4 != null) {
                                lEConfig2.setField(LERoute.TYPE, string4);
                            }
                            lEConfig2.setField(LERoute.SOURCE, string3);
                            lEConfig2.setField(LERoute.STATUS, string5);
                        }
                        string = null;
                        string2 = null;
                        string3 = null;
                        string4 = null;
                        break;
                    }
                    case 79: 
                    case 81: 
                    case 83: 
                    case 84: {
                        String string5 = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEConfig2 == null) continue block12;
                        lEConfig2.setField(Integer.toString(n), string5);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block12;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Routes", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseGlobal(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block13: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x210000: {
                        lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block13;
                        lEConfig.setField("password", "");
                        break;
                    }
                    case 36: 
                    case 57: 
                    case 75: 
                    case 87: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 195: 
                    case 199: 
                    case 220: 
                    case 221: 
                    case 275: 
                    case 529: 
                    case 530: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block13;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 181: 
                    case 197: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("on")) {
                            lEConfig.setField(Integer.toString(n), "enable");
                            break;
                        }
                        lEConfig.setField(Integer.toString(n), "disable");
                        break;
                    }
                    case 146: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block13;
                        lEConfig.setField(Integer.toString(n), string);
                        if (!string.startsWith("7.")) continue block13;
                        lEConfig.setField("rip-password", "");
                        break;
                    }
                    case 178: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 280: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            lEConfig.setField(Integer.toString(n), "pm4");
                            break;
                        }
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 281: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            lEConfig.setField(Integer.toString(n), "60");
                            break;
                        }
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 134: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block13;
                        lEConfig.setField("callcheck-password", string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block13;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Global", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseRadius(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x220000: {
                        lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block9;
                        lEConfig.setField("secret", "");
                        break;
                    }
                    case 12: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 216: 
                    case 218: 
                    case 278: 
                    case 282: 
                    case 283: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block9;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 212: 
                    case 213: 
                    case 217: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            string = "1645";
                        }
                        if (lEConfig == null) continue block9;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 214: 
                    case 215: 
                    case 219: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            string = "1646";
                        }
                        if (lEConfig == null) continue block9;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("RADIUS", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseChoiceNet(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x170000: {
                        lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block8;
                        lEConfig.setField("choicenet-secret", "");
                        break;
                    }
                    case 208: 
                    case 209: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block8;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 212: 
                    case 213: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            string = "1647";
                        }
                        if (lEConfig == null) continue block8;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("ChoiceNet", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSyslog(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            String string = null;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 327680: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0) continue block8;
                        string = string2;
                        break;
                    }
                    case 91: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 90: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null) continue block8;
                        lEConfig.setField(string, string3);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Syslog", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSNMP(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LESNMPHosts lESNMPHosts = null;
            boolean bl2 = false;
            String string = null;
            block16: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x150000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 17: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 87: {
                        lEConfig.setField("sysname", lETokenizer.getNextQuotedString());
                        break;
                    }
                    case 85: {
                        lEConfig.setField("read", lETokenizer.getNextQuotedString());
                        lESNMPHosts = (LESNMPHosts)lEConfig.getConfig("readhost");
                        lESNMPHosts.clearList();
                        string = "readtype";
                        break;
                    }
                    case 86: {
                        lEConfig.setField("write", lETokenizer.getNextQuotedString());
                        lESNMPHosts = (LESNMPHosts)lEConfig.getConfig("writehost");
                        lESNMPHosts.clearList();
                        string = "writetype";
                        break;
                    }
                    case 12: {
                        int n2 = lETokenizer.getNextInt();
                        switch (n2) {
                            case -1: {
                                if (string != null) {
                                    lEConfig.setField(string, "any");
                                }
                                if (lESNMPHosts == null) continue block16;
                                lESNMPHosts.setType(0);
                                break;
                            }
                            case 0: {
                                if (string != null) {
                                    lEConfig.setField(string, "none");
                                }
                                if (lESNMPHosts == null) continue block16;
                                lESNMPHosts.setType(1);
                                break;
                            }
                            default: {
                                if (string != null) {
                                    lEConfig.setField(string, "specified");
                                }
                                if (lESNMPHosts == null) continue block16;
                                lESNMPHosts.setType(2);
                                break;
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.endsWith(".in-addr.arpa")) {
                            string2 = LEPMEntityParser.fixHostname(string2);
                        }
                        if (lESNMPHosts == null) continue block16;
                        lESNMPHosts.addField(string2);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block16;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("SNMP", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    static String fixHostname(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringBuffer.insert(0, stringTokenizer.nextToken());
        stringBuffer.insert(0, '.');
        stringBuffer.insert(0, stringTokenizer.nextToken());
        stringBuffer.insert(0, '.');
        stringBuffer.insert(0, stringTokenizer.nextToken());
        stringBuffer.insert(0, '.');
        stringBuffer.insert(0, stringTokenizer.nextToken());
        return stringBuffer.toString();
    }

    public static boolean ParseOSPF(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block7: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x100000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 97: 
                    case 100: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block7;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block7;
                        bl = true;
                        break;
                    }
                    default: {
                        lETokenizer.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad OSPF attribute: " + n);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseOSPFAreas(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEOSPFArea lEOSPFArea = null;
            LETable lETable = null;
            boolean bl2 = false;
            String string = null;
            block14: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 524288: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0 || string2.equals(MCPU_EMPTY)) continue block14;
                        lEOSPFArea = (LEOSPFArea)lEConfig.getConfig(string2);
                        lETable = (LENetworkRanges)lEOSPFArea.getConfig("range");
                        break;
                    }
                    case 9: {
                        String string2 = lETokenizer.getNextQuotedString();
                        lEOSPFArea = (LEOSPFArea)lEConfig.getConfig(string2);
                        lETable = (LENetworkRanges)lEOSPFArea.getConfig("range");
                        break;
                    }
                    case 12: {
                        String string2 = lETokenizer.getNextQuotedString();
                        int n2 = Integer.parseInt(string2);
                        break;
                    }
                    case 101: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEOSPFArea == null) continue block14;
                        if (string2.equalsIgnoreCase("md5")) {
                            lEOSPFArea.setField("AuthType", "md5");
                        } else if (string2.equalsIgnoreCase("none")) {
                            lEOSPFArea.setField("AuthType", "none");
                        } else {
                            lEOSPFArea.setField("AuthType", "password");
                        }
                        if (!string2.equalsIgnoreCase("md5")) {
                            lEOSPFArea.setField("AuthID", "");
                            lEOSPFArea.setField("AuthKey", "");
                        }
                        lEOSPFArea.setField("password", "");
                        break;
                    }
                    case 99: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEOSPFArea == null) continue block14;
                        lEOSPFArea.setField("AuthID", string2);
                        break;
                    }
                    case 102: {
                        String string3;
                        String string2 = lETokenizer.getNextQuotedString();
                        string2.length();
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        if (lEOSPFArea == null || (string3 = (String)lEOSPFArea.get("AuthType")) == null) continue block14;
                        if (string3.equals("md5")) {
                            lEOSPFArea.setField("AuthKey", stringBuffer.toString());
                            break;
                        }
                        if (!string3.equals("password")) continue block14;
                        lEOSPFArea.setField("password", stringBuffer.toString());
                        break;
                    }
                    case 103: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEOSPFArea == null) continue block14;
                        if (string2.equalsIgnoreCase("external")) {
                            lEOSPFArea.setField("AreaType", "external");
                            break;
                        }
                        if (string2.equalsIgnoreCase("stub")) {
                            lEOSPFArea.setField("AreaType", "stub");
                            break;
                        }
                        lEOSPFArea.setField("AreaType", "nssa");
                        break;
                    }
                    case 117: {
                        String string2;
                        string = string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 104: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lETable == null || string == null) continue block14;
                        lETable.setField(string2, string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block14;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("OSPF Area", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseHosts(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEHosts lEHosts = (LEHosts)lEConfig;
            lEHosts.clearList();
            String string = null;
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x130000: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0) continue block8;
                        string = string2;
                        break;
                    }
                    case 9: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 3: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null) continue block8;
                        LEHost lEHost = (LEHost)lEHosts.addConfig();
                        lEHost.setField("address", string);
                        lEHost.setField("hostname", string3);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Hosts", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseModems(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEModems lEModems = null;
            if (lEConfig instanceof LEModems) {
                lEModems = (LEModems)lEConfig;
            }
            String string = null;
            boolean bl2 = false;
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: {
                        LEBoard lEBoard;
                        String string2 = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEBoard = (LEBoard)lEConfig.get(string2)) == null) continue block9;
                        lEModems = (LEModems)lEBoard.get(LEBoard.MODEMS);
                        break;
                    }
                    case 196608: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0) continue block9;
                        string = "M" + string2;
                        break;
                    }
                    case 40: {
                        string = "M" + lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 41: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null) continue block9;
                        lEModems.setField(string, string3);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Modems", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseMuxChannels(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        boolean bl2 = false;
        String string = "";
        try {
            LEChannels lEChannels = null;
            if (lEConfig instanceof LEChannels) {
                lEChannels = (LEChannels)lEConfig;
            }
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: {
                        LEConfig lEConfig2;
                        String string2 = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEConfig2 = (LEBoard)lEConfig.get(string2)) == null) continue block9;
                        lEChannels = (LEChannels)lEConfig2.get("3670019");
                        break;
                    }
                    case 0x380003: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 416: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 462: {
                        LEConfig lEConfig2;
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEChannels == null || (lEConfig2 = (LEMuxChannel)lEChannels.getConfig(string)) == null) continue block9;
                        lEConfig2.setField("462", string2);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Mux Channels", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseLines(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LELines lELines = null;
            if (lEConfig instanceof LELines) {
                lELines = (LELines)lEConfig;
            }
            LEConfig lEConfig2 = null;
            LETable lETable = null;
            LEGroup lEGroup = null;
            boolean bl2 = false;
            block15: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: {
                        LEBoard lEBoard;
                        String string = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEBoard = (LEBoard)lEConfig.get(string)) == null) continue block15;
                        lELines = (LELines)lEBoard.get(LEBoard.LINES);
                        break;
                    }
                    case 131072: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0) continue block15;
                        lEConfig2 = (LELine)lELines.getConfig("line" + string);
                        lETable = (LEGroups)lEConfig2.getConfig("groups");
                        break;
                    }
                    case 11: {
                        String string = "line" + lETokenizer.getNextQuotedString();
                        lEConfig2 = (LELine)lELines.getConfig(string);
                        lETable = (LEGroups)lEConfig2.getConfig("groups");
                        break;
                    }
                    case 17: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 37: 
                    case 39: 
                    case 472: 
                    case 474: 
                    case 475: 
                    case 476: 
                    case 477: 
                    case 61463: 
                    case 61464: 
                    case 61470: 
                    case 61471: 
                    case 61512: 
                    case 61513: {
                        String string = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEConfig2 == null) continue block15;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 478: {
                        String string = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEConfig2 == null) continue block15;
                        if (string.endsWith(":0")) {
                            lEConfig2.setField("477", "local");
                        }
                        lEConfig2.setField("478", string);
                        break;
                    }
                    case 53: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block15;
                        if (string.equals("down")) {
                            string = "up";
                        } else if (string.equals("up")) {
                            string = "down";
                        }
                        lEConfig2.setField("53", string.toLowerCase());
                        break;
                    }
                    case 129: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lETable == null) continue block15;
                        lEGroup = (LEGroup)lETable.getConfig(string);
                        break;
                    }
                    case 130: 
                    case 131: 
                    case 132: {
                        String string = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEGroup == null) continue block15;
                        lEGroup.setField(Integer.toString(n), string);
                        break;
                    }
                    case 128: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 38: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("r2 custom") || string.equals("R2 custom")) {
                            string = "r2custom";
                        } else if (string.equals("r2mf generic") || string.equals("R2MF generic")) {
                            string = "r2generic";
                        }
                        if (lEConfig2 == null) continue block15;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block15;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Lines", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseSubInterface(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = (LESubInterfaces)var0;
        var4_4 = null;
        var6_5 = false;
        try {
            block8: while (true) lbl-1000:
            // 9 sources

            {
                if (var6_5) {
                    return var2_2;
                }
                var7_7 = var1_1.getNextInt();
                switch (var7_7) {
                    case 0x260000: {
                        var5_6 = var1_1.getNextQuotedString();
                        if (var5_6.length() <= 0) continue block8;
                        var4_4 = (LESubInterface)var3_3.getConfig(var5_6);
                        ** break;
                    }
                    case 237: {
                        var5_6 = var1_1.getNextQuotedString();
                        var4_4 = (LESubInterface)var3_3.getConfig(var5_6);
                        ** break;
                    }
                    case 9: 
                    case 15: 
                    case 186: 
                    case 260: {
                        var5_6 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block8;
                        var4_4.setField(Integer.toString(var7_7), var5_6);
                        ** break;
                    }
                    case 65535: {
                        var6_5 = true;
                        if (var1_1.getNextInt() != 1) continue block8;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("SubInterfaces", var7_7, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var8_8) {
            LEDebug.getLog().logln(20, var8_8);
        }
        return var2_2;
    }

    public static boolean ParseBoards(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = null;
            String string = null;
            boolean bl2 = false;
            block11: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x270000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        string = lETokenizer.getNextQuotedString();
                        lEConfig2 = null;
                        break;
                    }
                    case 272: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string != null && !string2.equals(MCPU_EMPTY) && (lEConfig2 = (LEBoard)lEConfig.getConfig(string)) != null) {
                            if (string2.equals(MCPU_PRESENT)) {
                                string2 = "Present";
                            } else if (string2.equals(MCPU_MGR_PM4)) {
                                string2 = "System Manager";
                                lEConfig2.getConfig(LEBoard.PORTS);
                                lEConfig2.getConfig(LEBoard.ETHERNETS);
                            } else if (string2.equals(MCPU_PM4_QT1)) {
                                string2 = "Quad T1";
                                lEConfig2.getConfig(LEBoard.PORTS);
                                lEConfig2.getConfig(LEBoard.LINES);
                                lEConfig2.getConfig(LEBoard.MODEMS);
                                lEConfig2.getConfig("3670022");
                                lEConfig2.getConfig(LEBoard.L2TP);
                            } else if (string2.equals(MCPU_PM4_TE1)) {
                                string2 = "Tri E1";
                                lEConfig2.getConfig(LEBoard.PORTS);
                                lEConfig2.getConfig(LEBoard.LINES);
                                lEConfig2.getConfig(LEBoard.MODEMS);
                                lEConfig2.getConfig("3670022");
                                lEConfig2.getConfig(LEBoard.L2TP);
                            } else if (string2.equals(MCPU_T3MX)) {
                                string2 = "T3 Mux";
                                lEConfig2.getConfig("3670019");
                            } else if (string2.equals(MCPU_ETHER)) {
                                string2 = "Ethernet";
                                lEConfig2.getConfig(LEBoard.ETHERNETS);
                            } else if (string2.equals(MCPU_E3MX)) {
                                string2 = "E3 Mux";
                                lEConfig2.getConfig("3670019");
                            } else if (string2.equals(MCPU_T3_CLR)) {
                                string2 = "T3 Clear";
                            } else if (string2.equals(MCPU_LNS)) {
                                string2 = "LNS";
                            } else if (string2.equals(MCPU_T3_MUXR)) {
                                string2 = "T3 Mux Redundant";
                            } else if (string2.equals(MCPU_E3_MUXR)) {
                                string2 = "E3 Mux Redundant";
                            } else if (string2.equals(MCPU_100E_2P)) {
                                string2 = "Dual Ethernet";
                            } else if (string2.equals(MCPU_T3_ATM)) {
                                string2 = "T3 ATM";
                                lEConfig2.getConfig("4194311");
                            } else if (string2.equals(MCPU_E3_ATM)) {
                                string2 = "E3 ATM";
                                lEConfig2.getConfig("4194311");
                            } else if (string2.equals(MCPU_E3_CLR)) {
                                string2 = "E3 Clear";
                            } else if (string2.equals(MCPU_STS1)) {
                                string2 = "STS1 Mux";
                                lEConfig2.getConfig("3670019");
                            } else {
                                string2 = string2.equals(MCPU_STS1_R) ? "STS1 Mux Redundant" : (string2.equals(MCPU_HSSI) ? "HSSI" : (string2.equals(MCPU_PCT) ? "PCT" : "Unknown"));
                            }
                        }
                        if (lEConfig2 == null) continue block11;
                        lEConfig2.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 17: 
                    case 164: 
                    case 165: 
                    case 172: 
                    case 273: 
                    case 274: 
                    case 276: 
                    case 461: 
                    case 472: 
                    case 530: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block11;
                        lEConfig2.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 279: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block11;
                        if (LEBoard.IsDaughter(string)) {
                            string2 = "on";
                        }
                        lEConfig2.setField(LEBoard.POWER, string2);
                        break;
                    }
                    case 473: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0) continue block11;
                        char c = string2.charAt(0);
                        string2 = c == 'e' || c == 'E' ? "enable" : "disable";
                        if (lEConfig2 == null) continue block11;
                        lEConfig2.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block11;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Boards", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseLocations(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        LELocations lELocations = (LELocations)lEConfig;
        LELocation lELocation = null;
        boolean bl2 = false;
        LEDLCITable lEDLCITable = null;
        LEDLCITable lEDLCITable2 = null;
        String string = null;
        String string2 = null;
        LEDialScript lEDialScript = null;
        try {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            block23: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x1A0000: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.length() <= 0) continue block23;
                        lELocation = (LELocation)lELocations.getConfig(string3);
                        break;
                    }
                    case 237: {
                        String string3 = lETokenizer.getNextQuotedString();
                        lELocation = (LELocation)lELocations.getConfig(string3);
                        break;
                    }
                    case 2: 
                    case 9: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 170: 
                    case 177: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 525: 
                    case 533: 
                    case 534: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lELocation == null) continue block23;
                        lELocation.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 288: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.equals("on_demand")) {
                            string3 = "on-demand";
                        }
                        if (lELocation == null) continue block23;
                        lELocation.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 189: {
                        Object object;
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lELocation == null) continue block23;
                        if (string3.indexOf(46) > -1) {
                            object = new LEOctets(string3);
                            string3 = ((LEOctets)object).toHexString();
                        }
                        lELocation.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 187: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.equals("on")) {
                            bl3 = true;
                            break;
                        }
                        bl3 = false;
                        break;
                    }
                    case 188: {
                        String string3 = lETokenizer.getNextQuotedString();
                        bl4 = string3.equals("on");
                        if (lELocation == null) continue block23;
                        if (!bl3 && !bl4) {
                            lELocation.setField("rip", "off");
                            break;
                        }
                        if (bl3 && bl4) {
                            lELocation.setField("rip", "on");
                            break;
                        }
                        if (bl3 && !bl4) {
                            lELocation.setField("rip", "broadcast");
                            break;
                        }
                        if (!bl3 && bl4) {
                            lELocation.setField("rip", "listen");
                            break;
                        }
                        lELocation.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.equals("broadcast")) {
                            bl5 = true;
                            bl6 = false;
                            break;
                        }
                        if (string3.equals("multicast")) {
                            bl5 = false;
                            bl6 = true;
                            break;
                        }
                        if (!string3.equals("off")) continue block23;
                        bl5 = false;
                        bl6 = false;
                        break;
                    }
                    case 536: {
                        String string3 = lETokenizer.getNextQuotedString();
                        bl7 = string3.equals("on");
                        if (lELocation == null) continue block23;
                        if (bl5 || bl6 || bl7) {
                            lELocation.setField("rip", "v2 enabled");
                        }
                        if (bl6 && bl7) {
                            lELocation.setField("rip_v2", "on");
                            break;
                        }
                        if (bl6 && !bl7) {
                            lELocation.setField("rip_v2", "multicast");
                            break;
                        }
                        if (bl5 && bl7) {
                            lELocation.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (bl5 && !bl7) {
                            lELocation.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (bl7) {
                            lELocation.setField("rip_v2", "listen");
                            break;
                        }
                        lELocation.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.equals("")) {
                            string3 = "0.0.0.0";
                        }
                        if (lELocation == null) continue block23;
                        lELocation.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 303: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lELocation == null) continue block23;
                        lEDialScript = (LEDialScript)lELocation.getConfig("script");
                        LEDialScript.LoadScript(lEDialScript, string3);
                        lELocation.setField("script", lEDialScript);
                        break;
                    }
                    case 304: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lELocation == null) continue block23;
                        lEDialScript = (LEDialScript)lELocation.getConfig("v25bis");
                        LEDialScript.LoadScript(lEDialScript, string3);
                        lELocation.setField("v25bis", lEDialScript);
                        break;
                    }
                    case 339: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lELocation == null) continue block23;
                        lEDLCITable = (LEDLCITable)lELocation.getConfig("ipdlci");
                        break;
                    }
                    case 340: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lELocation == null) continue block23;
                        lEDLCITable2 = (LEDLCITable)lELocation.getConfig("ipxdlci");
                        break;
                    }
                    case 305: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 306: {
                        string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 307: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null || lEDLCITable == null) continue block23;
                        Object object = (LEDLCI)lEDLCITable.getConfig(string);
                        if (object != null) {
                            ((LEConfig)object).setField("address", string3);
                        }
                        string = null;
                        break;
                    }
                    case 308: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string2 == null || lEDLCITable2 == null) continue block23;
                        Object object = (LEDLCI)lEDLCITable2.getConfig(string2);
                        if (object != null) {
                            ((LEConfig)object).setField("address", string3);
                        }
                        string2 = null;
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block23;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Locations", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParsePorts(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEPorts lEPorts = null;
            LEBoard lEBoard = null;
            LEBoards lEBoards = null;
            if (lEConfig instanceof LEPorts) {
                lEPorts = (LEPorts)lEConfig;
            } else if (lEConfig instanceof LEBoards) {
                lEBoards = (LEBoards)lEConfig;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            String string = null;
            int n = 0;
            block9: while (!bl2) {
                int n2;
                if (n > 0) {
                    n2 = n;
                    n = 0;
                } else {
                    n2 = lETokenizer.getNextInt();
                }
                switch (n2) {
                    case 262144: {
                        string = null;
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        string = null;
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEBoards == null || (lEBoard = (LEBoard)lEBoards.getConfig(string2)) == null) continue block9;
                        lEPorts = (LEPorts)lEBoard.getConfig(LEBoard.PORTS);
                        break;
                    }
                    case 333: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 1: {
                        String string2 = lETokenizer.getNextQuotedString();
                        bl3 = string2.startsWith(X_PORT_PRE);
                        if (lEPorts == null || string == null || bl3) continue block9;
                        if (string.equals(ASYNC_PORT)) {
                            n = LEPMEntityParser.ParseAsyncPort(lEPorts, string2, lETokenizer);
                            break;
                        }
                        if (string.equals(ISDN_PORT)) {
                            n = LEPMEntityParser.ParseISDNPort(lEPorts, string2, lETokenizer);
                            break;
                        }
                        if (string.equals(PARA_PORT)) {
                            n = LEPMEntityParser.ParseParallelPort(lEPorts, string2, lETokenizer);
                            break;
                        }
                        if (!string.equals(SYNC_PORT)) continue block9;
                        n = LEPMEntityParser.ParseSyncPort(lEPorts, string2, lETokenizer);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() == 1) {
                            bl = true;
                            break;
                        }
                        bl3 = false;
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (bl3) continue block9;
                        LEPMEntityParser.LogBadAttribute("Ports", n2, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static int ParseAsyncPort(LEPorts lEPorts, String string, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LEAsyncPorts lEAsyncPorts = (LEAsyncPorts)lEPorts.getConfig("AsyncPort");
            LEAsyncPort lEAsyncPort = null;
            if (lEAsyncPorts != null) {
                lEAsyncPort = (LEAsyncPort)lEAsyncPorts.getConfig(string);
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            block12: while (!bl) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl = true;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 23: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 332: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: 
                    case 553: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEAsyncPort == null) continue block12;
                        lEAsyncPort.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: {
                        LEHostOverrides lEHostOverrides;
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEAsyncPort == null || (lEHostOverrides = (LEHostOverrides)lEAsyncPort.getConfig("overrides")) == null) continue block12;
                        lEHostOverrides.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 187: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.equals("on")) {
                            bl2 = true;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    case 188: {
                        String string2 = lETokenizer.getNextQuotedString();
                        bl3 = string2.equals("on");
                        if (lEAsyncPort == null) continue block12;
                        if (!bl2 && !bl3) {
                            lEAsyncPort.setField("rip", "off");
                            break;
                        }
                        if (bl2 && bl3) {
                            lEAsyncPort.setField("rip", "on");
                            break;
                        }
                        if (bl2 && !bl3) {
                            lEAsyncPort.setField("rip", "broadcast");
                            break;
                        }
                        if (!bl2 && bl3) {
                            lEAsyncPort.setField("rip", "listen");
                            break;
                        }
                        lEAsyncPort.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.equals("broadcast")) {
                            bl4 = true;
                            bl5 = false;
                            break;
                        }
                        if (string2.equals("multicast")) {
                            bl4 = false;
                            bl5 = true;
                            break;
                        }
                        if (!string2.equals("off")) continue block12;
                        bl4 = false;
                        bl5 = false;
                        break;
                    }
                    case 536: {
                        String string2 = lETokenizer.getNextQuotedString();
                        bl6 = string2.equals("on");
                        if (lEAsyncPort == null) continue block12;
                        if (bl4 || bl5 || bl6) {
                            lEAsyncPort.setField("rip", "v2 enabled");
                        }
                        if (bl5 && bl6) {
                            lEAsyncPort.setField("rip_v2", "on");
                            break;
                        }
                        if (bl5 && !bl6) {
                            lEAsyncPort.setField("rip_v2", "multicast");
                            break;
                        }
                        if (bl4 && bl6) {
                            lEAsyncPort.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (bl4 && !bl6) {
                            lEAsyncPort.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (bl6) {
                            lEAsyncPort.setField("rip_v2", "listen");
                            break;
                        }
                        lEAsyncPort.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.equals("")) {
                            string2 = "0.0.0.0";
                        }
                        if (lEAsyncPort == null) continue block12;
                        lEAsyncPort.setField(Integer.toString(n), string2);
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Async Port", n, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    public static int ParseISDNPort(LEPorts lEPorts, String string, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LEISDNPorts lEISDNPorts = (LEISDNPorts)lEPorts.getConfig("ISDNPort");
            LEISDNPort lEISDNPort = null;
            if (lEISDNPorts != null) {
                lEISDNPort = (LEISDNPort)lEISDNPorts.getConfig(string);
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            block13: while (!bl6) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl6 = true;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 181: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 317: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 325: 
                    case 332: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEISDNPort == null) continue block13;
                        lEISDNPort.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 189: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEISDNPort == null) continue block13;
                        LEOctets lEOctets = new LEOctets(string2);
                        string2 = lEOctets.toHexString();
                        lEISDNPort.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 289: {
                        String string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 187: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.equals("on")) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 188: {
                        String string2 = lETokenizer.getNextQuotedString();
                        bl2 = string2.equals("on");
                        if (lEISDNPort == null) continue block13;
                        if (!bl && !bl2) {
                            lEISDNPort.setField("rip", "off");
                            break;
                        }
                        if (bl && bl2) {
                            lEISDNPort.setField("rip", "on");
                            break;
                        }
                        if (bl && !bl2) {
                            lEISDNPort.setField("rip", "broadcast");
                            break;
                        }
                        if (!bl && bl2) {
                            lEISDNPort.setField("rip", "listen");
                            break;
                        }
                        lEISDNPort.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.equals("broadcast")) {
                            bl3 = true;
                            bl4 = false;
                            break;
                        }
                        if (string2.equals("multicast")) {
                            bl3 = false;
                            bl4 = true;
                            break;
                        }
                        if (!string2.equals("off")) continue block13;
                        bl3 = false;
                        bl4 = false;
                        break;
                    }
                    case 536: {
                        String string2 = lETokenizer.getNextQuotedString();
                        bl5 = string2.equals("on");
                        if (lEISDNPort == null) continue block13;
                        if (bl3 || bl4 || bl5) {
                            lEISDNPort.setField("rip", "v2 enabled");
                        }
                        if (bl4 && bl5) {
                            lEISDNPort.setField("rip_v2", "on");
                            break;
                        }
                        if (bl4 && !bl5) {
                            lEISDNPort.setField("rip_v2", "multicast");
                            break;
                        }
                        if (bl3 && bl5) {
                            lEISDNPort.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (bl3 && !bl5) {
                            lEISDNPort.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (bl5) {
                            lEISDNPort.setField("rip_v2", "listen");
                            break;
                        }
                        lEISDNPort.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.equals("")) {
                            string2 = "0.0.0.0";
                        }
                        if (lEISDNPort == null) continue block13;
                        lEISDNPort.setField(Integer.toString(n), string2);
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("ISDN Port", n, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    public static int ParseParallelPort(LEPorts lEPorts, String string, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LEParallelPorts lEParallelPorts = (LEParallelPorts)lEPorts.getConfig("ParallelPort");
            LEParallelPort lEParallelPort = null;
            if (lEParallelPorts != null) {
                lEParallelPort = (LEParallelPort)lEParallelPorts.getConfig(string);
            }
            boolean bl = false;
            block6: while (!bl) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl = true;
                        break;
                    }
                    case 173: 
                    case 309: 
                    case 310: 
                    case 311: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEParallelPort == null) continue block6;
                        lEParallelPort.setField(Integer.toString(n), string2);
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Parallel Port", n, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    public static int ParseSyncPort(LEPorts lEPorts, String string, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LESyncPorts lESyncPorts = (LESyncPorts)lEPorts.getConfig("SyncPort");
            LESyncPort lESyncPort = null;
            if (lESyncPorts != null) {
                lESyncPort = (LESyncPort)lESyncPorts.getConfig(string);
            }
            LEDLCITable lEDLCITable = null;
            LEDLCITable lEDLCITable2 = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            block18: while (!bl6) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl6 = true;
                        break;
                    }
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 177: 
                    case 181: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 312: 
                    case 316: 
                    case 318: 
                    case 319: 
                    case 332: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (lESyncPort == null) continue block18;
                        lESyncPort.setField(Integer.toString(n), string4);
                        break;
                    }
                    case 189: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (lESyncPort == null) continue block18;
                        Object object = new LEOctets(string4);
                        string4 = ((LEOctets)object).toHexString();
                        lESyncPort.setField(Integer.toString(n), string4);
                        break;
                    }
                    case 339: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (lESyncPort == null) continue block18;
                        lEDLCITable = (LEDLCITable)lESyncPort.getConfig(LESyncPort.IP_DLCI_TAB);
                        break;
                    }
                    case 340: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (lESyncPort == null) continue block18;
                        lEDLCITable2 = (LEDLCITable)lESyncPort.getConfig(LESyncPort.IPX_DLCI_TAB);
                        break;
                    }
                    case 305: {
                        string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 306: {
                        string3 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 307: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (string2 == null || lEDLCITable == null) continue block18;
                        Object object = (LEDLCI)lEDLCITable.getConfig(string2);
                        if (object != null) {
                            ((LEConfig)object).setField("address", string4);
                        }
                        string2 = null;
                        break;
                    }
                    case 308: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (string3 == null || lEDLCITable2 == null) continue block18;
                        Object object = (LEDLCI)lEDLCITable2.getConfig(string3);
                        if (object != null) {
                            ((LEConfig)object).setField("address", string4);
                        }
                        string3 = null;
                        break;
                    }
                    case 187: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (string4.equals("on")) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 188: {
                        String string4 = lETokenizer.getNextQuotedString();
                        bl2 = string4.equals("on");
                        if (lESyncPort == null) continue block18;
                        if (!bl && !bl2) {
                            lESyncPort.setField("rip", "off");
                            break;
                        }
                        if (bl && bl2) {
                            lESyncPort.setField("rip", "on");
                            break;
                        }
                        if (bl && !bl2) {
                            lESyncPort.setField("rip", "broadcast");
                            break;
                        }
                        if (!bl && bl2) {
                            lESyncPort.setField("rip", "listen");
                            break;
                        }
                        lESyncPort.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (string4.equals("broadcast")) {
                            bl3 = true;
                            bl4 = false;
                            break;
                        }
                        if (string4.equals("multicast")) {
                            bl3 = false;
                            bl4 = true;
                            break;
                        }
                        if (!string4.equals("off")) continue block18;
                        bl3 = false;
                        bl4 = false;
                        break;
                    }
                    case 536: {
                        String string4 = lETokenizer.getNextQuotedString();
                        bl5 = string4.equals("on");
                        if (lESyncPort == null) continue block18;
                        if (bl3 || bl4 || bl5) {
                            lESyncPort.setField("rip", "v2 enabled");
                        }
                        if (bl4 && bl5) {
                            lESyncPort.setField("rip_v2", "on");
                            break;
                        }
                        if (bl4 && !bl5) {
                            lESyncPort.setField("rip_v2", "multicast");
                            break;
                        }
                        if (bl3 && bl5) {
                            lESyncPort.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (bl3 && !bl5) {
                            lESyncPort.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (bl5) {
                            lESyncPort.setField("rip_v2", "listen");
                            break;
                        }
                        lESyncPort.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String string4 = lETokenizer.getNextQuotedString();
                        if (string4.equals("")) {
                            string4 = "0.0.0.0";
                        }
                        if (lESyncPort == null) continue block18;
                        lESyncPort.setField(Integer.toString(n), string4);
                        break;
                    }
                    default: {
                        String string4 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Sync Port", n, string4);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseIPPools(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = false;
        var6_4 = (LEIPPools)var0;
        var7_5 = null;
        var8_6 = null;
        var9_7 = null;
        try {
            block11: while (true) lbl-1000:
            // 14 sources

            {
                if (var3_3) {
                    return var2_2;
                }
                var5_9 = var1_1.getNextInt();
                switch (var5_9) {
                    case 3670021: {
                        var4_8 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 237: {
                        var4_8 = var1_1.getNextQuotedString();
                        var7_5 = (LEIPPool)var6_4.getConfig(var4_8);
                        var8_6 = (LEIPRanges)var7_5.getConfig("ranges");
                        var9_7 = null;
                        ** break;
                    }
                    case 75: {
                        var4_8 = var1_1.getNextQuotedString();
                        if (var7_5 == null) continue block11;
                        var7_5.setField("75", var4_8);
                        ** break;
                    }
                    case 521: {
                        var4_8 = var1_1.getNextQuotedString();
                        if (var8_6 == null) continue block11;
                        var9_7 = (LEIPRange)var8_6.getConfig(var4_8);
                        ** break;
                    }
                    case 165: {
                        var4_8 = var1_1.getNextQuotedString();
                        var10_10 = Long.parseLong(var4_8);
                        var12_12 = LENetmask.GetCIDRFromTotal(var10_10);
                        if (var9_7 == null) continue block11;
                        var9_7.setField("165", var4_8);
                        var9_7.setField("15", Integer.toString(var12_12));
                        ** break;
                    }
                    case 522: {
                        var4_8 = var1_1.getNextQuotedString();
                        if (var9_7 == null) continue block11;
                        var9_7.setField("522", var4_8);
                        ** break;
                    }
                    case 65535: {
                        var3_3 = true;
                        if (var1_1.getNextInt() != 1) continue block11;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("IP Pools", var5_9, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var10_11) {
            LEDebug.getLog().logln(20, var10_11);
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseNATMaps(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = false;
        var6_4 = (LENATMaps)var0;
        var7_5 = null;
        var8_6 = null;
        var9_7 = null;
        var10_8 = 0;
        var11_9 = null;
        var12_10 = null;
        var13_11 = null;
        var14_12 = null;
        var15_13 = null;
        var16_14 = null;
        var17_15 = 0;
        var18_16 = 0;
        var19_17 = 0;
        try {
            block31: while (true) lbl-1000:
            // 28 sources

            {
                if (var3_3) {
                    return var2_2;
                }
                var5_19 = var1_1.getNextInt();
                switch (var5_19) {
                    case 0x290000: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var4_18.length() <= 0) continue block31;
                        var7_5 = (LENATMap)var6_4.getConfig(var4_18);
                        ** break;
                    }
                    case 237: {
                        var4_18 = var1_1.getNextQuotedString();
                        var7_5 = (LENATMap)var6_4.getConfig(var4_18);
                        ** break;
                    }
                    case 341: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var7_5 != null) {
                            var8_6 = (LENATMapRule)var7_5.getConfig(var4_18);
                            ** break;
                        }
                        var8_6 = null;
                        ** break;
                    }
                    case 352: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var8_6 == null) continue block31;
                        var8_6.setField("type", var4_18);
                        ** break;
                    }
                    case 351: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var8_6 == null) continue block31;
                        if (var4_18.equals("off")) {
                            var8_6.setField("log", "off");
                            ** break;
                        }
                        var8_6.setField("log", "on");
                        ** break;
                    }
                    case 342: {
                        var17_15 = Integer.parseInt(var1_1.getNextQuotedString());
                        ** break;
                    }
                    case 343: {
                        var18_16 = Integer.parseInt(var1_1.getNextQuotedString()) + var17_15;
                        ** break;
                    }
                    case 344: {
                        var19_17 = Integer.parseInt(var1_1.getNextQuotedString()) + 1;
                        ** break;
                    }
                    case 345: {
                        var10_8 = Integer.parseInt(var1_1.getNextQuotedString());
                        ** break;
                    }
                    case 15: {
                        var11_9 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 346: {
                        var12_10 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 347: {
                        var13_11 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 348: {
                        var14_12 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 349: {
                        var15_13 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 350: {
                        var16_14 = var1_1.getNextQuotedString();
                        if (var8_6 == null) continue block31;
                        if (var9_7 == null) {
                            var9_7 = new StringBuffer();
                        } else {
                            var9_7.append(",");
                        }
                        switch (var10_8) {
                            case 1: {
                                var9_7.append(var14_12);
                                var9_7.append('/');
                                var9_7.append(var11_9);
                                break;
                            }
                            case 2: {
                                var9_7.append(var15_13);
                                var9_7.append('-');
                                var9_7.append(var16_14);
                                break;
                            }
                            case 4: {
                                var9_7.append(var15_13);
                                break;
                            }
                            case 8: {
                                var9_7.append(var15_13);
                                var9_7.append(':');
                                var9_7.append(var12_10);
                                break;
                            }
                            case 16: {
                                var9_7.append(var15_13);
                                var9_7.append(':');
                                var9_7.append(var12_10);
                                var9_7.append('-');
                                var9_7.append(var13_11);
                                break;
                            }
                            case 132: {
                                var9_7.append("@ipaddr");
                                break;
                            }
                            case 136: {
                                var9_7.append("@ipaddr");
                                var9_7.append(':');
                                var9_7.append(var12_10);
                                break;
                            }
                            case 144: {
                                var9_7.append("@ipaddr");
                                var9_7.append(':');
                                var9_7.append(var12_10);
                                var9_7.append('-');
                                var9_7.append(var13_11);
                                break;
                            }
                        }
                        if (var19_17 == var17_15) {
                            var8_6.setField("lhs", var9_7.toString());
                            var9_7 = null;
                            ** break;
                        }
                        if (var19_17 != var18_16) continue block31;
                        var8_6.setField("rhs", var9_7.toString());
                        var9_7 = null;
                        ** break;
                    }
                    case 12: {
                        var4_18 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 65535: {
                        var3_3 = true;
                        if (var1_1.getNextInt() != 1) continue block31;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("NAT Maps", var5_19, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var20_20) {
            LEDebug.getLog().logln(20, var20_20);
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseDHCP(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = false;
        var6_4 = null;
        var7_5 = null;
        var8_6 = new StringBuffer();
        var9_7 = 0;
        var10_8 = null;
        var11_9 = null;
        var12_10 = null;
        var13_11 = null;
        var14_12 = 0;
        try {
            block25: while (true) lbl-1000:
            // 22 sources

            {
                if (var3_3) {
                    return var2_2;
                }
                var4_13 = var1_1.getNextInt();
                switch (var4_13) {
                    case 3670032: {
                        var5_14 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 15: 
                    case 17: 
                    case 75: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 190: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: {
                        var5_14 = var1_1.getNextQuotedString();
                        if (var0 == null) continue block25;
                        var0.setField(Integer.toString(var4_13), var5_14);
                        ** break;
                    }
                    case 200: {
                        var5_14 = var1_1.getNextQuotedString();
                        var15_15 = 0L;
                        try {
                            var15_15 = Long.parseLong(var5_14);
                        }
                        catch (NumberFormatException var17_17) {
                            LEDebug.getLog().logln(20, var17_17);
                        }
                        var15_15 /= 60L;
                        if (var0 == null) continue block25;
                        var0.setField(Integer.toString(var4_13), Long.toString(var15_15));
                        ** break;
                    }
                    case 364: {
                        var5_14 = var1_1.getNextQuotedString();
                        var8_6 = new StringBuffer();
                        if (var0 == null) continue block25;
                        var0.setField("ippool", var8_6.toString());
                        ** break;
                    }
                    case 344: {
                        var14_12 = Integer.parseInt(var1_1.getNextQuotedString());
                        ** break;
                    }
                    case 345: {
                        var9_7 = Integer.parseInt(var1_1.getNextQuotedString());
                        ** break;
                    }
                    case 76: {
                        var10_8 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 348: {
                        var11_9 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 349: {
                        var12_10 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 350: {
                        var13_11 = var1_1.getNextQuotedString();
                        if (var14_12 > 0) {
                            var8_6.append(",");
                        }
                        switch (var9_7) {
                            case 1: {
                                var8_6.append(var12_10);
                                var8_6.append('-');
                                var8_6.append(var13_11);
                                break;
                            }
                            case 2: {
                                var8_6.append(var11_9);
                                var8_6.append('/');
                                var8_6.append(var10_8);
                                break;
                            }
                            case 3: {
                                var8_6.append(var12_10);
                                break;
                            }
                        }
                        if (var0 == null) continue block25;
                        var0.setField("ippool", var8_6.toString());
                        ** break;
                    }
                    case 365: {
                        var5_14 = var1_1.getNextQuotedString();
                        var6_4 = (LEBindings)var0.getConfig("bindings");
                        ** break;
                    }
                    case 9: {
                        var11_9 = var1_1.getNextQuotedString();
                        if (var6_4 == null) continue block25;
                        var7_5 = (LEBinding)var6_4.getConfig(var11_9);
                        ** break;
                    }
                    case 195: {
                        var5_14 = var1_1.getNextQuotedString();
                        if (var7_5 != null) {
                            var7_5.setField("195", var5_14);
                        }
                        var7_5 = null;
                        ** break;
                    }
                    case 65535: {
                        var3_3 = true;
                        if (var1_1.getNextInt() != 1) continue block25;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("DHCP", var4_13, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var15_16) {
            LEDebug.getLog().logln(20, var15_16);
        }
        return var2_2;
    }

    public static boolean ParseEthernets(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEEthernets lEEthernets = null;
            if (lEConfig instanceof LEEthernets) {
                lEEthernets = (LEEthernets)lEConfig;
            }
            LEEthernet lEEthernet = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            block18: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 720896: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lEEthernets == null) continue block18;
                        lEEthernet = (LEEthernet)lEEthernets.getConfig(string);
                        break;
                    }
                    case 275: {
                        LEBoard lEBoard;
                        String string = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEBoard = (LEBoard)lEConfig.get(string)) == null) continue block18;
                        lEEthernets = (LEEthernets)lEBoard.get(LEBoard.ETHERNETS);
                        break;
                    }
                    case 260: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEEthernets == null) continue block18;
                        lEEthernet = (LEEthernet)lEEthernets.getConfig(string);
                        break;
                    }
                    case 190: {
                        String string = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEEthernet == null) continue block18;
                        lEEthernet.setField(Integer.toString(n), string);
                        break;
                    }
                    case 9: 
                    case 15: 
                    case 100: 
                    case 186: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 198: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 246: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 512: 
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 517: 
                    case 533: 
                    case 534: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEEthernet == null) continue block18;
                        lEEthernet.setField(Integer.toString(n), string);
                        break;
                    }
                    case 191: 
                    case 192: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("on")) {
                            lEEthernet.setField(Integer.toString(n), "enable");
                            break;
                        }
                        lEEthernet.setField(Integer.toString(n), "disable");
                        break;
                    }
                    case 187: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("on")) {
                            bl3 = true;
                            break;
                        }
                        bl3 = false;
                        break;
                    }
                    case 188: {
                        String string = lETokenizer.getNextQuotedString();
                        bl4 = string.equals("on");
                        if (lEEthernet == null) continue block18;
                        if (!bl3 && !bl4) {
                            lEEthernet.setField("rip", "off");
                            break;
                        }
                        if (bl3 && bl4) {
                            lEEthernet.setField("rip", "on");
                            break;
                        }
                        if (bl3 && !bl4) {
                            lEEthernet.setField("rip", "broadcast");
                            break;
                        }
                        if (!bl3 && bl4) {
                            lEEthernet.setField("rip", "listen");
                            break;
                        }
                        lEEthernet.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("broadcast")) {
                            bl5 = true;
                            bl6 = false;
                            break;
                        }
                        if (string.equals("multicast")) {
                            bl5 = false;
                            bl6 = true;
                            break;
                        }
                        if (!string.equals("off")) continue block18;
                        bl5 = false;
                        bl6 = false;
                        break;
                    }
                    case 536: {
                        String string = lETokenizer.getNextQuotedString();
                        bl7 = string.equals("on");
                        if (lEEthernet == null) continue block18;
                        if (bl5 || bl6 || bl7) {
                            lEEthernet.setField("rip", "v2 enabled");
                        }
                        if (bl6 && bl7) {
                            lEEthernet.setField("rip_v2", "on");
                            break;
                        }
                        if (bl6 && !bl7) {
                            lEEthernet.setField("rip_v2", "multicast");
                            break;
                        }
                        if (bl5 && bl7) {
                            lEEthernet.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (bl5 && !bl7) {
                            lEEthernet.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (bl7) {
                            lEEthernet.setField("rip_v2", "listen");
                            break;
                        }
                        lEEthernet.setField("rip_v2", "on");
                        break;
                    }
                    case 518: 
                    case 519: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEEthernet == null) continue block18;
                        if (string.equals(MCPU_EMPTY)) {
                            string = MCPU_PRESENT;
                        }
                        lEEthernet.setField(Integer.toString(n), string);
                        break;
                    }
                    case 520: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEEthernet == null) continue block18;
                        if (string.equals(MCPU_EMPTY)) {
                            string = "60";
                        }
                        lEEthernet.setField(Integer.toString(n), string);
                        break;
                    }
                    case 72: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("")) {
                            string = "0.0.0.0";
                        }
                        if (lEEthernet == null) continue block18;
                        lEEthernet.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block18;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Ethernets", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseUsers(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = lEConfig.getConfig("netuser");
            LEConfig lEConfig3 = lEConfig.getConfig("netdialback");
            LEConfig lEConfig4 = lEConfig.getConfig("user");
            LEConfig lEConfig5 = lEConfig.getConfig("logindialback");
            LEConfig lEConfig6 = null;
            String string = null;
            String string2 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            block19: while (!bl7) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x1C0000: {
                        String string3 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.length() > 8) {
                            string = string3.substring(0, 8).trim();
                            break;
                        }
                        string = string3.trim();
                        break;
                    }
                    case 78: {
                        String string3 = lETokenizer.getNextQuotedString();
                        lEConfig6 = null;
                        if (lEConfig == null || string == null) continue block19;
                        if (string3.equals("network")) {
                            lEConfig6 = lEConfig2.getConfig(string);
                            lEConfig6.setField("password", "");
                            break;
                        }
                        if (string3.equals("dialback_network")) {
                            lEConfig6 = lEConfig3.getConfig(string);
                            lEConfig6.setField("password", "");
                            break;
                        }
                        if (string3.equals("login")) {
                            lEConfig6 = lEConfig4.getConfig(string);
                            lEConfig6.setField("password", "");
                            break;
                        }
                        if (!string3.equals("dialback_login")) continue block19;
                        lEConfig6 = lEConfig5.getConfig(string);
                        break;
                    }
                    case 300: {
                        String string3 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 173: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null) continue block19;
                        if (string3.equals("0.0.0.0")) {
                            lEConfig6.setField("host", "default");
                        } else if (string3.equals("255.255.255.255")) {
                            lEConfig6.setField("host", "prompt");
                        } else {
                            lEConfig6.setField("host", "specified");
                        }
                        lEConfig6.setField("HostAddress", string3);
                        break;
                    }
                    case 74: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null) continue block19;
                        if (string3.equals("255.255.255.255")) {
                            lEConfig6.setField("destination", "negotiated");
                        } else if (string3.equals("255.255.255.254")) {
                            lEConfig6.setField("destination", "assigned");
                        } else {
                            lEConfig6.setField("destination", "specified");
                        }
                        lEConfig6.setField("IPAddress", string3);
                        break;
                    }
                    case 369: {
                        string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 370: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null || string2 == null) continue block19;
                        if ((string2.equals("netdata") || string2.equals("telnet")) && string3.length() > 0) {
                            string2 = String.valueOf(string2) + "@" + string3;
                        }
                        lEConfig6.setField("service", string2);
                        string2 = null;
                        break;
                    }
                    case 15: 
                    case 177: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 198: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 299: 
                    case 301: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 368: 
                    case 371: 
                    case 496: 
                    case 497: 
                    case 498: 
                    case 499: 
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 533: 
                    case 534: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null) continue block19;
                        lEConfig6.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 187: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.equals("on")) {
                            bl2 = true;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    case 188: {
                        String string3 = lETokenizer.getNextQuotedString();
                        bl3 = string3.equals("on");
                        if (lEConfig6 == null) continue block19;
                        if (!bl2 && !bl3) {
                            lEConfig6.setField("rip", "off");
                            break;
                        }
                        if (bl2 && bl3) {
                            lEConfig6.setField("rip", "on");
                            break;
                        }
                        if (bl2 && !bl3) {
                            lEConfig6.setField("rip", "broadcast");
                            break;
                        }
                        if (!bl2 && bl3) {
                            lEConfig6.setField("rip", "listen");
                            break;
                        }
                        lEConfig6.setField("rip", "off");
                        break;
                    }
                    case 535: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.equals("broadcast")) {
                            bl4 = true;
                            bl5 = false;
                            break;
                        }
                        if (string3.equals("multicast")) {
                            bl4 = false;
                            bl5 = true;
                            break;
                        }
                        if (!string3.equals("off")) continue block19;
                        bl4 = false;
                        bl5 = false;
                        break;
                    }
                    case 536: {
                        String string3 = lETokenizer.getNextQuotedString();
                        bl6 = string3.equals("on");
                        if (lEConfig6 == null) continue block19;
                        if (bl4 || bl5 || bl6) {
                            lEConfig6.setField("rip", "v2 enabled");
                        }
                        if (bl5 && bl6) {
                            lEConfig6.setField("rip_v2", "on");
                            break;
                        }
                        if (bl5 && !bl6) {
                            lEConfig6.setField("rip_v2", "multicast");
                            break;
                        }
                        if (bl4 && bl6) {
                            lEConfig6.setField("rip_v2", "v1-compatability");
                            break;
                        }
                        if (bl4 && !bl6) {
                            lEConfig6.setField("rip_v2", "broadcast");
                            break;
                        }
                        if (bl6) {
                            lEConfig6.setField("rip_v2", "listen");
                            break;
                        }
                        lEConfig6.setField("rip_v2", "on");
                        break;
                    }
                    case 72: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.equals("")) {
                            string3 = "0.0.0.0";
                        }
                        if (lEConfig6 == null) continue block19;
                        lEConfig6.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 65535: {
                        bl7 = true;
                        if (lETokenizer.getNextInt() != 1) continue block19;
                        bl = true;
                        break;
                    }
                    default: {
                        String string3 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User", n, string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseUserPasswords(LEConfig lEConfig, LETokenizer lETokenizer) {
        if (!(lEConfig instanceof LEUsers)) {
            return false;
        }
        LEUsers lEUsers = (LEUsers)lEConfig;
        boolean bl = false;
        try {
            boolean bl2 = false;
            String string = null;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x310000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String string2 = lETokenizer.getNextQuotedString();
                        string = string2.trim();
                        break;
                    }
                    case 300: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string != null && string2.length() > 0) {
                            LEConfig lEConfig2 = (LEConfig)lEUsers.getUser(string);
                            if (lEConfig2 instanceof LELoginUser) {
                                ((LELoginUser)lEConfig2).setPassword(string2);
                            } else if (lEConfig2 instanceof LENetUser) {
                                ((LENetUser)lEConfig2).setPassword(string2);
                            } else if (lEConfig2 instanceof LEDBNetUser) {
                                ((LEDBNetUser)lEConfig2).setPassword(string2);
                            }
                        }
                        string = null;
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User Passwords", n, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSecrets(LEConfig lEConfig, LETokenizer lETokenizer) {
        LERadius lERadius = (LERadius)lEConfig.get("2228224");
        LEChoicenet lEChoicenet = (LEChoicenet)lEConfig.get("1507328");
        LEGlobal lEGlobal = (LEGlobal)lEConfig.get("2162688");
        LEL2TP cfr_ignored_0 = (LEL2TP)lEConfig.get("3473408");
        boolean bl = false;
        try {
            boolean bl2 = false;
            block10: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x320000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 64: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lERadius == null) continue block10;
                        lERadius.setSecret(string);
                        break;
                    }
                    case 65: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEChoicenet == null) continue block10;
                        lEChoicenet.setSecret(string);
                        break;
                    }
                    case 199: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEGlobal == null) continue block10;
                        lEGlobal.setRIPPassword(string);
                        break;
                    }
                    case 134: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEGlobal == null) continue block10;
                        lEGlobal.setCallCheckPassword(string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block10;
                        bl = true;
                        break;
                    }
                    default: {
                        String string = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Secrets", n, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseBGP(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 589824: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 9: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block8;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 106: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            string = MCPU_PRESENT;
                        }
                        if (lEConfig == null) continue block8;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGP", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseBGPPeers(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = null;
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x160000: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 9: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lEConfig == null) continue block8;
                        lEConfig2 = (LEBGPPeer)lEConfig.getConfig(string);
                        break;
                    }
                    case 96: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 119: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 177: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block8;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPeers", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseATMPVCs(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = null;
            LEPVCs lEPVCs = null;
            boolean bl2 = false;
            String string = "";
            block10: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x400007: {
                        String string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        Object object;
                        String string2 = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (object = (LEBoard)lEConfig.get(string2)) == null) continue block10;
                        lEPVCs = (LEPVCs)((LEConfig)object).get("4194311");
                        break;
                    }
                    case 562: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 563: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string3.length() <= 0 || string.length() <= 0 || lEConfig == null) continue block10;
                        Object object = new StringBuffer();
                        ((StringBuffer)object).append(string);
                        ((StringBuffer)object).append(".");
                        ((StringBuffer)object).append(string3);
                        if (lEPVCs == null) continue block10;
                        lEConfig2 = (LEPVC)lEPVCs.getConfig(((StringBuffer)object).toString());
                        break;
                    }
                    case 370: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block10;
                        lEConfig2.setField(Integer.toString(n), "S" + string2);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block10;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("PVCs", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSAs(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = lEConfig.getConfig("ipsec");
            LEConfig lEConfig3 = lEConfig.getConfig("ipip");
            LEConfig lEConfig4 = lEConfig.getConfig("proxy");
            LEConfig lEConfig5 = null;
            String string = null;
            boolean bl2 = false;
            block12: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x250000: {
                        String string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 289: {
                        String string2 = lETokenizer.getNextQuotedString();
                        lEConfig5 = null;
                        if (lEConfig == null || string == null) continue block12;
                        if (string2.equals("IPSEC")) {
                            lEConfig5 = lEConfig2.getConfig(string);
                            break;
                        }
                        if (string2.equals("IPIP")) {
                            lEConfig5 = lEConfig3.getConfig(string);
                            break;
                        }
                        if (!string2.equals("PROXY")) continue block12;
                        lEConfig5 = lEConfig4.getConfig(string);
                        lEConfig5.setField("secret", "");
                        break;
                    }
                    case 74: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig5 == null) continue block12;
                        lEConfig5.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 226: 
                    case 227: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig5 == null) continue block12;
                        lEConfig5.setField(Integer.toString(n), string2.toLowerCase());
                        break;
                    }
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig5 == null) continue block12;
                        if (string2.equals(MCPU_EMPTY)) {
                            string2 = "";
                        }
                        lEConfig5.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 240: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig5 == null) continue block12;
                        lEConfig5.setField("secret", string2);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block12;
                        bl = true;
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("SA", n, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseIPSecProfiles(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            LEIPSecProfiles lEIPSecProfiles = (LEIPSecProfiles)lEConfig;
            LEIPSecProfile lEIPSecProfile = null;
            LEIPSecProfileRule lEIPSecProfileRule = null;
            block10: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x390000: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0) continue block10;
                        lEIPSecProfile = (LEIPSecProfile)lEIPSecProfiles.getConfig(string);
                        break;
                    }
                    case 237: {
                        String string = lETokenizer.getNextQuotedString();
                        lEIPSecProfile = (LEIPSecProfile)lEIPSecProfiles.getConfig(string);
                        break;
                    }
                    case 12: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 504: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEIPSecProfile != null) {
                            lEIPSecProfileRule = (LEIPSecProfileRule)lEIPSecProfile.getConfig(string);
                            break;
                        }
                        lEIPSecProfileRule = null;
                        break;
                    }
                    case 505: 
                    case 506: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEIPSecProfileRule == null) continue block10;
                        lEIPSecProfileRule.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block10;
                        bl = true;
                        break;
                    }
                    default: {
                        String string = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("IPSecProfiles", n, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseBGPPolicies(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LETable lETable = null;
            LEConfig lEConfig2 = null;
            boolean bl2 = false;
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x300000: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lEConfig == null) continue block9;
                        lETable = (LEBGPPolicy)lEConfig.getConfig(string);
                        break;
                    }
                    case 416: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lETable == null) continue block9;
                        lEConfig2 = (LEBGPPolicyRule)lETable.getConfig(string);
                        break;
                    }
                    case 417: 
                    case 418: 
                    case 419: 
                    case 420: 
                    case 421: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 426: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 431: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block9;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPolicies", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseIMT(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = false;
        var6_4 = null;
        try {
            block8: while (true) lbl-1000:
            // 9 sources

            {
                if (var3_3) {
                    return var2_2;
                }
                var5_6 = var1_1.getNextInt();
                switch (var5_6) {
                    case 3670022: {
                        var4_5 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 75: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 370: 
                    case 523: 
                    case 526: {
                        var4_5 = var1_1.getNextQuotedString();
                        var0.setField(Integer.toString(var5_6), var4_5);
                        ** break;
                    }
                    case 275: {
                        var4_5 = var1_1.getNextQuotedString();
                        if (!(var0 instanceof LEBoards)) continue block8;
                        var7_7 = (LEBoard)var0.get(var4_5);
                        if (var7_7 != null) {
                            var6_4 = (LEIMT)var7_7.get("3670022");
                        }
                        if (var6_4 == null) continue block8;
                        var0 = var6_4;
                        ** break;
                    }
                    case 65535: {
                        var3_3 = true;
                        if (var1_1.getNextInt() != 1) continue block8;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("IMT", var5_6, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var7_8) {
            LEDebug.getLog().logln(20, var7_8);
        }
        return var2_2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseLocalIPAddresses(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = false;
        var7_4 = null;
        try {
            block8: while (true) lbl-1000:
            // 8 sources

            {
                if (var3_3) {
                    return var2_2;
                }
                var5_6 = var1_1.getNextInt();
                switch (var5_6) {
                    case 3670023: {
                        var4_5 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 416: {
                        var6_7 = var1_1.getNextQuotedString();
                        var7_4 = (LELocalIPAddress)var0.getConfig(var6_7);
                        ** break;
                    }
                    case 9: {
                        var4_5 = var1_1.getNextQuotedString();
                        if (var7_4 == null) continue block8;
                        var7_4.setField("9", var4_5);
                        ** break;
                    }
                    case 65535: {
                        var3_3 = true;
                        if (var1_1.getNextInt() != 1) continue block8;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("Local IP Addresses", var5_6, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var8_8) {
            LEDebug.getLog().logln(20, var8_8);
        }
        return var2_2;
    }

    public static boolean ParseL2TP(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            LEL2TP lEL2TP = null;
            if (lEConfig instanceof LEL2TP) {
                lEL2TP = (LEL2TP)lEConfig;
            }
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: {
                        LEBoard lEBoard;
                        String string = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEBoard = (LEBoard)lEConfig.get(string)) == null || lEL2TP == null) continue block9;
                        lEL2TP = (LEL2TP)lEBoard.get(LEBoard.L2TP);
                        break;
                    }
                    case 0x350000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 479: 
                    case 495: 
                    case 507: 
                    case 508: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEL2TP == null) continue block9;
                        lEL2TP.setField(Integer.toString(n), string);
                        break;
                    }
                    case 480: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEL2TP == null) continue block9;
                        lEL2TP.setField("l2tp-secret", string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("L2TP", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    static void LogBadAttribute(String string, int n, String string2) {
        LEDebug.getLog().log(30, "Bad ");
        LEDebug.getLog().log(30, string);
        LEDebug.getLog().log(30, " Attribute: ", n);
        LEDebug.getLog().log(30, ", ");
        LEDebug.getLog().logln(30, string2);
    }
}

