/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEAsyncPort;
import com.lucent.ra.nms.model.LEBGP;
import com.lucent.ra.nms.model.LEBGPPeers;
import com.lucent.ra.nms.model.LEBGPPolicies;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEChoicenet;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDHCP;
import com.lucent.ra.nms.model.LEDataSpecFactory;
import com.lucent.ra.nms.model.LEEthernets;
import com.lucent.ra.nms.model.LEFilters;
import com.lucent.ra.nms.model.LEGateway;
import com.lucent.ra.nms.model.LEGlobal;
import com.lucent.ra.nms.model.LEHosts;
import com.lucent.ra.nms.model.LEIMT;
import com.lucent.ra.nms.model.LEIPPools;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEISDNPort;
import com.lucent.ra.nms.model.LEISDNSwitch;
import com.lucent.ra.nms.model.LEL2TP;
import com.lucent.ra.nms.model.LELines;
import com.lucent.ra.nms.model.LELocalIPAddresses;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.model.LEModems;
import com.lucent.ra.nms.model.LENATMaps;
import com.lucent.ra.nms.model.LENumberingPlan;
import com.lucent.ra.nms.model.LEOSPF;
import com.lucent.ra.nms.model.LEOSPFAreas;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPort;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.model.LERadius;
import com.lucent.ra.nms.model.LERoutes;
import com.lucent.ra.nms.model.LESAs;
import com.lucent.ra.nms.model.LESNMP;
import com.lucent.ra.nms.model.LESubInterfaces;
import com.lucent.ra.nms.model.LESyncPort;
import com.lucent.ra.nms.model.LESyslog;
import com.lucent.ra.nms.model.LEUsers;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEThreadStatus;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LEPortMaster
extends LEConfig {
    public static final String BGP = "589824";
    public static final String BGP_PEERS = "1441792";
    public static final String BGP_POLICIES = "3145728";
    public static final String BOARDS = "2555904";
    public static final String CHOICENET = "1507328";
    public static final String DHCP = "3670032";
    public static final String ETHERNETS = "720896";
    public static final String FILTERS = "filter";
    public static final String GLOBAL = "2162688";
    public static final String HOSTS = "1245184";
    public static final String IMT = "3670022";
    public static final String IP_POOLS = "3670021";
    public static final String LINES = "131072";
    public static final String LOCAL_IP_ADDRS = "3670023";
    public static final String LOCATIONS = "1703936";
    public static final String MODEMS = "196608";
    public static final String NAT_MAPS = "2686976";
    public static final String OSPF = "1048576";
    public static final String OSPF_AREAS = "524288";
    public static final String PORTS = "262144";
    public static final String RADIUS = "2228224";
    public static final String ROUTES = "1310720";
    public static final String SEC_ASSNS = "2424832";
    public static final String SNMP = "1376256";
    public static final String SUB_IS = "2490368";
    public static final String SYSLOG = "327680";
    public static final String USERS = "1835008";
    public static final String IPSEC_PROFILES = "3735552";
    public static final String L2TP = "3473408";
    public static final String NUMPLAN = "1048577";
    public static final String GATEWAY = "1048578";
    public static final String DOM_CUST_PLANS = "1048580";
    public static final String INTL_CUST_PLANS = "1048581";
    public static final String PRIVATE_CUST_PLANS = "1048582";
    public static final int KEY_COUNT = 33;
    public static final String DEFAULT_USER = "!root";
    public static final String MOD_IRX_111 = "IRX-111";
    public static final String MOD_IRX_112 = "IRX-112";
    public static final String MOD_IRX_114 = "IRX-114";
    public static final String MOD_IRX_211 = "IRX-211";
    public static final String MOD_LEGEND = "INA";
    public static final String MOD_MSM_RAC = "MSM-RAC";
    public static final String MOD_OR = "OR";
    public static final String MOD_OR_AP = "OR-AP";
    public static final String MOD_OR_HS = "OR-HS";
    public static final String MOD_OR_LS = "OR-LS";
    public static final String MOD_OR_M = "OR-M";
    public static final String MOD_OR_ST = "OR-ST";
    public static final String MOD_OR_U = "OR-U";
    public static final String MOD_PM2 = "PM-2";
    public static final String MOD_PM25 = "PM-25";
    public static final String MOD_PM2E = "PM-2e";
    public static final String MOD_PM2EI = "PM-2ei";
    public static final String MOD_PM2ER = "PM-2er";
    public static final String MOD_PM2I = "PM-2i";
    public static final String MOD_PM2R = "PM-2r";
    public static final String MOD_PM3 = "PM-3";
    public static final String MOD_PM3VT = "PM-3VT";
    public static final String MOD_PM4 = "PM-4";
    public static final String MOD_GW1000 = "1000";
    public static final String MOD_SIM = "Simulator";
    public static final String MOD_UNKNOWN = "";
    static final String SET_PASSWORD = "set pas";
    static final String PM4 = "7.";
    static final String PM3 = "6.";
    static final String IRX = "4.";
    static final String OR = "5.";
    static final String PM25 = "2.5";
    static final String PM2 = "2.2";
    static final String MSM_RAC = "msm-rac";
    static final String LEGEND = "legend";
    static final String PM3VT = "pm3vt";
    static final String GW1000_NAME = "PacketStar IP Gateway 1000";
    public static final String PORTMASTER = "PortMaster";
    public static final String ITS = "Gateway";
    public static final String RTX = "Legend";
    public static final String PORTMASTER_KEY = "pm";
    public static final String ITS_KEY = "its";
    public static final String RTX_KEY = "rtx";
    static String[] s_keys = null;
    Vector m_retrieved = new Vector();
    LEVector m_toc;
    LEPMConnectionFacade m_smm;
    String m_primary;
    String m_secondary;
    String m_software = "";
    String m_hardware;
    String m_uptime = "";
    String m_hardwareName = "";
    String m_platform = "PortMaster";

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[32];
            int n = 0;
            LEPortMaster.s_keys[n++] = BGP;
            LEPortMaster.s_keys[n++] = BGP_PEERS;
            LEPortMaster.s_keys[n++] = BGP_POLICIES;
            LEPortMaster.s_keys[n++] = BOARDS;
            LEPortMaster.s_keys[n++] = CHOICENET;
            LEPortMaster.s_keys[n++] = DHCP;
            LEPortMaster.s_keys[n++] = ETHERNETS;
            LEPortMaster.s_keys[n++] = FILTERS;
            LEPortMaster.s_keys[n++] = GLOBAL;
            LEPortMaster.s_keys[n++] = HOSTS;
            LEPortMaster.s_keys[n++] = IMT;
            LEPortMaster.s_keys[n++] = IP_POOLS;
            LEPortMaster.s_keys[n++] = LINES;
            LEPortMaster.s_keys[n++] = LOCAL_IP_ADDRS;
            LEPortMaster.s_keys[n++] = LOCATIONS;
            LEPortMaster.s_keys[n++] = MODEMS;
            LEPortMaster.s_keys[n++] = NAT_MAPS;
            LEPortMaster.s_keys[n++] = OSPF;
            LEPortMaster.s_keys[n++] = OSPF_AREAS;
            LEPortMaster.s_keys[n++] = PORTS;
            LEPortMaster.s_keys[n++] = RADIUS;
            LEPortMaster.s_keys[n++] = SEC_ASSNS;
            LEPortMaster.s_keys[n++] = SNMP;
            LEPortMaster.s_keys[n++] = SUB_IS;
            LEPortMaster.s_keys[n++] = SYSLOG;
            LEPortMaster.s_keys[n++] = USERS;
            LEPortMaster.s_keys[n++] = IPSEC_PROFILES;
            LEPortMaster.s_keys[n++] = L2TP;
            LEPortMaster.s_keys[n++] = NUMPLAN;
            LEPortMaster.s_keys[n++] = GATEWAY;
            LEPortMaster.s_keys[n++] = DOM_CUST_PLANS;
            LEPortMaster.s_keys[n++] = INTL_CUST_PLANS;
            LEPortMaster.s_keys[n++] = PRIVATE_CUST_PLANS;
        }
        return s_keys;
    }

    public LEPortMaster() {
        super(null);
    }

    public void setConnectionFacade(LEConnectionFacade lEConnectionFacade) {
        this.m_facade = lEConnectionFacade;
        this.ping();
        try {
            this.setSpec(LEDataSpecFactory.GetSpec(this.getPlatformKey()));
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, iOException);
        }
        this.checkSMM();
    }

    public boolean isConnected() {
        return this.m_facade.isConnected();
    }

    public void disconnect() {
        this.m_facade.disconnect();
        if (this.m_smm != null) {
            this.m_smm.disconnect();
            this.m_smm = null;
        }
    }

    public boolean reconnect() {
        boolean bl = this.m_facade.reconnect();
        if (bl) {
            this.checkSMM();
        }
        return bl;
    }

    public void reboot() {
        this.m_facade.execute("reboot");
    }

    public String getResourceID() {
        return this.m_facade.getResourceID();
    }

    public String getDescription() {
        return this.m_facade.getDescription();
    }

    public String getUpTime() {
        return this.m_uptime;
    }

    public String getSoftwareVersion() {
        return this.m_software;
    }

    public String getHardwareType() {
        return this.m_hardware;
    }

    public String getHardwareName() {
        return this.m_hardwareName;
    }

    public String getPlatformKey() {
        if (this.m_platform.equals(PORTMASTER)) {
            return PORTMASTER_KEY;
        }
        if (this.m_platform.equals(ITS)) {
            return ITS_KEY;
        }
        if (this.m_platform.equals(RTX)) {
            return RTX_KEY;
        }
        return null;
    }

    public LEConnectionFacade getFacade() {
        return this.m_facade;
    }

    public LEDSS getDSS() {
        return this.m_facade.getDSS();
    }

    public LEDSS getSecondaryDSS() {
        if (this.m_smm == null) {
            return null;
        }
        return this.m_smm.getDSS();
    }

    public boolean supportsSMM() {
        if (this.m_facade instanceof LEPMConnectionFacade) {
            return ((LEPMConnectionFacade)this.m_facade).supportsSMM();
        }
        return false;
    }

    public boolean hasSMM() {
        return this.m_smm != null;
    }

    public String getPrimary() {
        return this.m_primary;
    }

    public String getSecondary() {
        return this.m_secondary;
    }

    public boolean getUserPasswords() {
        boolean bl = false;
        if (this.m_facade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)this.m_facade;
            bl = lEPMConnectionFacade.getUserPasswords();
        }
        return bl;
    }

    public boolean getSecrets() {
        boolean bl = false;
        if (this.m_facade instanceof LEPMConnectionFacade) {
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)this.m_facade;
            bl = lEPMConnectionFacade.getSecrets();
        }
        return bl;
    }

    public Object get(String string) {
        Object v = this.m_fields.get(string);
        if (v == null && !this.m_retrieved.contains(string) && this.load(string)) {
            this.m_retrieved.addElement(string);
            v = this.m_fields.get(string);
        }
        return v;
    }

    public Object fetch(String string) {
        if (this.m_fields.containsKey(string)) {
            this.load(string);
        }
        return this.get(string);
    }

    public LEPMCommand execute(String string) {
        LEPMCommand lEPMCommand = this.m_facade.execute(string);
        LEStatusManager.SetStatus(LEThreadStatus.NO_MESSAGE);
        return lEPMCommand;
    }

    public LEPMCommand executeSMM(String string) {
        LEPMCommand lEPMCommand = this.m_smm.execute(string);
        LEStatusManager.SetStatus(LEThreadStatus.NO_MESSAGE);
        return lEPMCommand;
    }

    public boolean ping() {
        boolean bl = false;
        if (this.m_facade.supportsEntities()) {
            LEPMCommand lEPMCommand = this.execute("version");
            if (lEPMCommand.getStatus()) {
                bl = true;
                this.parseVersion(lEPMCommand.getResult());
            }
        } else if (this.load(GLOBAL)) {
            bl = true;
        }
        return bl;
    }

    public void purgeCache() {
        this.m_toc = null;
        this.m_retrieved.removeAllElements();
        this.fetch(GLOBAL);
    }

    public boolean getCommands(LEVector lEVector) {
        String[] stringArray = LEPortMaster.GetAllPossibleKeys();
        int n = 0;
        while (n < stringArray.length) {
            this.get(stringArray[n]);
            ++n;
        }
        return super.getCommands(lEVector);
    }

    void rebooted(LEPMConnectionFacade lEPMConnectionFacade) {
        if (lEPMConnectionFacade == this.m_facade) {
            this.checkSMM();
        }
    }

    void checkSMM() {
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)this.m_facade;
        this.purgeCache();
        boolean bl = lEPMConnectionFacade.supportsSMM();
        this.setSMMSupport(bl);
        this.m_smm = null;
        this.m_primary = null;
        this.m_secondary = null;
        LEGlobal lEGlobal = (LEGlobal)this.get(GLOBAL);
        String string = (String)lEGlobal.get("530");
        String string2 = (String)lEGlobal.get("275");
        if (string == null || string2 == null) {
            return;
        }
        if (string.equals("Primary")) {
            this.m_primary = string2;
            this.m_secondary = this.m_primary.equals("4") ? "5" : "4";
        } else {
            this.m_secondary = string2;
            this.m_primary = this.m_secondary.equals("4") ? "5" : "4";
        }
        String string3 = (String)lEGlobal.get("529");
        if (string3 == null) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade2 = null;
        try {
            String string4 = lEPMConnectionFacade.getUsername();
            String string5 = lEPMConnectionFacade.getPassword();
            LEStatusManager.SetStatus("Connecting to " + string3);
            lEPMConnectionFacade2 = LEPMFactory.GetFromPM(lEPMConnectionFacade.getConnectionManager(), this, string3, string4, string5);
            if (string.equals("Primary")) {
                this.m_smm = lEPMConnectionFacade2;
            } else {
                super.setConnectionFacade(lEPMConnectionFacade2);
                this.m_smm = lEPMConnectionFacade;
            }
            this.purgeCache();
            ((LEPMConnectionFacade)this.m_facade).checkForBoards();
            LEBoards lEBoards = (LEBoards)this.get(BOARDS);
            LEBoard lEBoard = (LEBoard)lEBoards.get(this.m_secondary);
            lEBoard.setConnectionFacade(this.m_smm);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(10, exception);
            return;
        }
    }

    void refresh(LEConfig lEConfig) {
        String string = this.getKeyFor(lEConfig);
        if (string != null) {
            this.fetch(string);
        }
    }

    void parseVersion(String string) {
        if (string == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        boolean bl = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                stringBuffer.append(' ');
                stringBuffer.append(string2);
                continue;
            }
            if (string2.equals("is")) {
                bl = true;
                stringBuffer.append(stringTokenizer.nextToken());
                continue;
            }
            if (string2.equals(PORTMASTER)) {
                this.m_platform = PORTMASTER;
                string2 = stringTokenizer.nextToken();
                if (this.m_hardware == null) {
                    this.m_hardware = string2.equals(MOD_SIM) || string2.equals(MOD_PM25) ? string2 : this.determineModel();
                }
                if (!this.m_hardware.equals(MOD_LEGEND)) continue;
                this.m_platform = RTX;
                continue;
            }
            if (string2.equals(ITS)) {
                this.m_platform = ITS;
                string2 = stringTokenizer.nextToken();
                if (this.m_hardware != null || !string2.equals(MOD_GW1000) && !string2.equals("1000,")) continue;
                this.m_hardwareName = GW1000_NAME;
                this.m_hardware = MOD_GW1000;
                continue;
            }
            if (string2.equals("Release")) {
                this.m_software = stringTokenizer.nextToken();
                continue;
            }
            if (!string2.equals("ComOS")) continue;
            this.m_software = stringTokenizer.nextToken();
        }
        this.m_uptime = new String(stringBuffer);
        int n = this.m_uptime.length();
        if (n > 0) {
            this.m_uptime = this.m_uptime.substring(0, n - 1);
        }
    }

    boolean load(String string) {
        LEStatusManager.SetStatus("Getting " + this.getDescriptionFor(string) + " from " + this.getDescription());
        boolean bl = this.m_facade.getConfig(string);
        if (bl && string.equals(GLOBAL)) {
            LEGlobal lEGlobal = (LEGlobal)this.get(GLOBAL);
            String string2 = (String)lEGlobal.get("145");
            if (string2 != null && string2.length() > 0) {
                this.m_software = string2;
            }
            if (this.m_hardware == null) {
                this.m_hardware = this.determineModel();
            }
            string2 = (String)lEGlobal.get("36");
            try {
                int n = Integer.parseInt(string2);
                this.m_uptime = LEUpTimeCompare.FormatTime(n);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        LEStatusManager.StatusComplete();
        return bl;
    }

    String determineModel() {
        LEGlobal lEGlobal = (LEGlobal)this.get(GLOBAL);
        if (lEGlobal == null) {
            return MOD_UNKNOWN;
        }
        String string = (String)lEGlobal.get("146");
        if (string == null || string.length() == 0) {
            return MOD_UNKNOWN;
        }
        if (string.startsWith(PM3)) {
            String string2 = (String)lEGlobal.get("280");
            if (string2 != null && string2.equals(LEGEND)) {
                return MOD_LEGEND;
            }
            if (string2 != null && string2.equals(PM3VT)) {
                return MOD_PM3VT;
            }
            return MOD_PM3;
        }
        if (string.startsWith(PM4)) {
            String string3 = (String)lEGlobal.get("280");
            if (string3 != null && string3.equals(MSM_RAC)) {
                return MOD_MSM_RAC;
            }
            return MOD_PM4;
        }
        if (string.startsWith(PM25)) {
            return MOD_PM25;
        }
        LEPorts lEPorts = (LEPorts)this.get(PORTS);
        if (lEPorts == null) {
            return MOD_UNKNOWN;
        }
        if (string.startsWith(IRX)) {
            LEPort lEPort = lEPorts.getPort("S4");
            if (lEPort != null) {
                return MOD_IRX_114;
            }
            lEPort = lEPorts.getPort("S2");
            if (lEPort != null) {
                return MOD_IRX_112;
            }
            LEEthernets lEEthernets = (LEEthernets)this.get(ETHERNETS);
            if (lEEthernets != null && lEEthernets.get("ether1") != null) {
                return MOD_IRX_211;
            }
            return MOD_IRX_111;
        }
        if (string.startsWith(OR)) {
            LEPort lEPort = lEPorts.getPort("S1");
            if (lEPort != null) {
                if (lEPort instanceof LEAsyncPort) {
                    return MOD_OR_M;
                }
                if (lEPort instanceof LEISDNPort) {
                    String string4 = (String)lEGlobal.get("145");
                    if (string4.indexOf("AP") != -1) {
                        return MOD_OR_AP;
                    }
                    String string5 = (String)lEGlobal.get("144");
                    if (string5 == null) {
                        return MOD_OR_U;
                    }
                    if (LEISDNSwitch.IsUSSwitch(string5)) {
                        return MOD_OR_U;
                    }
                    return MOD_OR_ST;
                }
            }
            if ((lEPort = lEPorts.getPort("W1")) instanceof LESyncPort) {
                return MOD_OR_HS;
            }
            return MOD_OR;
        }
        if (string.startsWith(PM2)) {
            boolean bl = false;
            LEPort lEPort = lEPorts.getPort("S10");
            if (lEPort != null) {
                bl = true;
            } else {
                lEPort = lEPorts.getPort("S20");
                if (lEPort != null) {
                    bl = true;
                }
            }
            lEPort = lEPorts.getPort("P0");
            if (lEPort != null) {
                if (bl) {
                    return MOD_PM2E;
                }
                return MOD_PM2;
            }
            lEPort = lEPorts.getPort("W1");
            if (lEPort != null) {
                if (bl) {
                    return MOD_PM2ER;
                }
                return MOD_PM2R;
            }
            lEPort = lEPorts.getPort("C0");
            if (lEPort != null) {
                if (bl) {
                    return MOD_PM2EI;
                }
                return MOD_PM2I;
            }
            return MOD_PM2;
        }
        return MOD_UNKNOWN;
    }

    LEConfig createConfig(String string) {
        LEConfig lEConfig = string.equals(BGP) ? new LEBGP(this.m_facade) : (string.equals(BGP_PEERS) ? new LEBGPPeers(this.m_facade) : (string.equals(BGP_POLICIES) ? new LEBGPPolicies(this.m_facade) : (string.equals(GLOBAL) ? new LEGlobal(this.m_facade) : (string.equals(RADIUS) ? new LERadius(this.m_facade) : (string.equals(CHOICENET) ? new LEChoicenet(this.m_facade) : (string.equals(DHCP) ? new LEDHCP(this.m_facade) : (string.equals(FILTERS) ? new LEFilters(this.m_facade) : (string.equals(PORTS) ? new LEPorts(this.m_facade) : (string.equals(USERS) ? new LEUsers(this.m_facade) : (string.equals(LOCATIONS) ? new LELocations(this.m_facade) : (string.equals(ETHERNETS) ? new LEEthernets(this.m_facade) : (string.equals(SYSLOG) ? new LESyslog(this.m_facade) : (string.equals(SNMP) ? new LESNMP(this.m_facade) : (string.equals(OSPF) ? new LEOSPF(this.m_facade) : (string.equals(OSPF_AREAS) ? new LEOSPFAreas(this.m_facade) : (string.equals(ROUTES) ? new LERoutes(this.m_facade) : (string.equals(HOSTS) ? new LEHosts(this.m_facade) : (string.equals(MODEMS) ? new LEModems(this.m_facade) : (string.equals(LINES) ? new LELines(this.m_facade) : (string.equals(SUB_IS) ? new LESubInterfaces(this.m_facade) : (string.equals(BOARDS) ? new LEBoards(this.m_facade) : (string.equals(NAT_MAPS) ? new LENATMaps(this.m_facade) : (string.equals(SEC_ASSNS) ? new LESAs(this.m_facade) : (string.equals(IPSEC_PROFILES) ? new LEIPSecProfiles(this.m_facade) : (string.equals(IP_POOLS) ? new LEIPPools(this.m_facade) : (string.equals(IMT) ? new LEIMT(this.m_facade) : (string.equals(LOCAL_IP_ADDRS) ? new LELocalIPAddresses(this.m_facade) : (string.equals(L2TP) ? new LEL2TP(this.m_facade) : (string.equals(NUMPLAN) ? new LENumberingPlan(this.m_facade) : (string.equals(GATEWAY) ? new LEGateway(this.m_facade) : new LEConfig(this.m_facade)))))))))))))))))))))))))))))));
        return lEConfig;
    }
}

