/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEByteArray;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;

public class LETFTPErrorPacket
extends LETFTPPacket {
    public static final short UNDEFINED = 0;
    public static final short FILE_NOT_FOUND = 1;
    public static final short ACCESS_VIOLATION = 2;
    public static final short DISK_FULL = 3;
    public static final short ILLEGAL_TFTP_OPERATION = 4;
    public static final short UNKNOWN_TID = 5;
    public static final short FILE_ALREADY_EXISTS = 6;
    public static final short NO_SUCH_USER = 7;
    public static final short OPTIONS_REJECTED = 8;
    public static final String NO_MESSAGE = "";
    private static final int MAX_PACKET_SIZE = 128;
    private short m_errorCode;
    private String m_errorMsg;
    private byte[] m_data;
    private int m_length;

    public LETFTPErrorPacket(short s, String string) {
        this.m_errorCode = s;
        this.m_errorMsg = string;
        this.m_data = new byte[128];
        int n = 0;
        LEByteArray.CopyShort((short)5, this.m_data, n);
        LEByteArray.CopyShort(this.m_errorCode, this.m_data, n += 2);
        LEByteArray.CopyBytes(this.m_errorMsg.getBytes(), this.m_data, n += 2, this.m_errorMsg.length());
        n += this.m_errorMsg.length();
        this.m_data[n++] = 0;
        this.m_length = n;
    }

    public LETFTPErrorPacket(DatagramPacket datagramPacket) {
        super(datagramPacket);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = 0;
        try {
            this.m_data = new byte[128];
            this.m_data[n++] = dataInputStream.readByte();
            this.m_data[n++] = dataInputStream.readByte();
            this.m_data[n++] = dataInputStream.readByte();
            int n2 = n++;
            byte by = dataInputStream.readByte();
            this.m_data[n2] = by;
            this.m_errorCode = by;
            int n3 = n;
            while ((this.m_data[n++] = dataInputStream.readByte()) != 0) {
            }
            this.m_errorMsg = new String(this.m_data, n3, n - 1 - n3);
            this.m_length = n;
            return;
        }
        catch (IOException iOException) {
            if (n < 5) {
                LETFTPServer.GetServer().printMsg("Problem reading from input data stream at byte ");
            }
            return;
        }
    }

    public byte[] getBytes() {
        return this.m_data;
    }

    public int getSize() {
        return this.m_length;
    }

    public String getErrorMsg() {
        return this.m_errorMsg;
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public void printPacket() {
        LETFTPServer.GetServer().printMsg("Error packet", false);
        LETFTPServer.GetServer().printMsg(" Error code: " + Integer.toString(this.m_errorCode), false);
        LETFTPServer.GetServer().printMsg(" Error message: " + this.m_errorMsg, false);
        LETFTPServer.GetServer().printMsg(" Contents: ", false);
        int n = 0;
        while (n < this.m_length) {
            LETFTPServer.GetServer().printMsg(Byte.toString(this.m_data[n]), false);
            ++n;
        }
    }
}

