/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSSFlatFile;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEThreadStatus;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.wizard.LEWizardAction;
import com.lucent.ra.nms.wizard.LEWizardActionClient;
import com.lucent.ra.nms.wizard.LEWizardDataModel;

public class LEBackupAction
extends LEWizardAction {
    public LEBackupAction(LEWizardDataModel lEWizardDataModel, LEWizardActionClient lEWizardActionClient) {
        super(lEWizardDataModel, lEWizardActionClient);
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart(this, "Saving the configurations to a backup file ");
        this.backupConfig();
    }

    private void backupConfig() {
        LEPortMaster lEPortMaster = (LEPortMaster)this.m_model.getObject(LEPMWizardModel.PORTMASTER);
        if (lEPortMaster == null) {
            this.m_client.actionDone(this, "Could not get the Portmaster", -1);
            return;
        }
        LEVector lEVector = new LEVector();
        if (!lEPortMaster.getCommands(lEVector)) {
            this.m_client.actionDone(this, "Could not get the configurations", -1);
            return;
        }
        LEConnectionManager lEConnectionManager = (LEConnectionManager)this.m_model.getObject(LEPMWizardModel.CONNECTION_MGR);
        String string = LEAppInfo.createFullPath(this.m_model.get(LEPMWizardModel.BACKUP_DIR), this.m_model.get(LEPMWizardModel.BACKUP_FILE));
        try {
            LEDSSFlatFile lEDSSFlatFile = lEConnectionManager.connectToFile(string, 1);
            String string2 = "IP_ADDRESS ";
            string2 = String.valueOf(string2) + this.m_model.get(LEPMWizardModel.IPADDRESS);
            String string3 = "NET_MASK ";
            string3 = String.valueOf(string3) + this.m_model.get(LEPMWizardModel.NETMASK);
            lEDSSFlatFile.connect();
            lEDSSFlatFile.writeComments(string2);
            lEDSSFlatFile.writeComments(string3);
            lEDSSFlatFile.writeConfig(lEVector);
            lEDSSFlatFile.disconnect();
        }
        catch (Exception exception) {
            String string4 = "Could not open the selected backup file.  \n\nPress Retry and verify that the location ";
            string4 = String.valueOf(string4) + "for the backup file exists, or press Cancel to save the current configuration and exit the wizard.";
            this.m_client.actionDone(this, string4, -1);
            return;
        }
        this.m_client.actionDone(this, LEThreadStatus.NO_MESSAGE, 0);
    }
}

