/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.border;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import oracle.ewt.border.BorderException;
import oracle.ewt.border.BorderManager;
import oracle.ewt.border.DynamicBorder;

public abstract class Border {
    private Border _next;

    protected Border(Border border) {
        this._next = border;
    }

    public final Insets getInsets() {
        Border border = this._getNext();
        Insets insets = border != null ? border.getInsets() : new Insets(0, 0, 0, 0);
        Insets insets2 = this.getBorderInsets();
        insets.top += insets2.top;
        insets.left += insets2.left;
        insets.bottom += insets2.bottom;
        insets.right += insets2.right;
        return insets;
    }

    public final boolean isManaged() {
        if (this instanceof DynamicBorder && ((DynamicBorder)((Object)this)).getBorderManager() != null) {
            return true;
        }
        Border border = this._getNext();
        if (border == null) {
            return false;
        }
        return border.isManaged();
    }

    public final void manageNotify(BorderManager borderManager) throws BorderException {
        if (this.isManaged()) {
            throw new BorderException();
        }
        this._manageNotify(borderManager);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, BorderManager borderManager) {
        Color color = graphics.getColor();
        this.paintBorder(graphics, n, n2, n3, n4, borderManager);
        graphics.setColor(color);
        Border border = this._getNext();
        if (border != null) {
            Insets insets = this.getBorderInsets();
            border.paint(graphics, n + insets.left, n2 + insets.top, n3 - (insets.left + insets.right), n4 - (insets.top + insets.bottom), borderManager);
        }
    }

    public void unmanageNotify() {
        Border border;
        if (this instanceof DynamicBorder) {
            ((DynamicBorder)((Object)this)).setBorderManager(null);
        }
        if ((border = this._getNext()) != null) {
            border.unmanageNotify();
        }
    }

    protected abstract Insets getBorderInsets();

    protected abstract void paintBorder(Graphics var1, int var2, int var3, int var4, int var5, BorderManager var6);

    private Border _getNext() {
        return this._next;
    }

    private void _manageNotify(BorderManager borderManager) {
        Border border;
        if (this instanceof DynamicBorder) {
            ((DynamicBorder)((Object)this)).setBorderManager(borderManager);
        }
        if ((border = this._getNext()) != null) {
            border.manageNotify(borderManager);
        }
    }

    private void _paint(Graphics graphics, int n, int n2, int n3, int n4, BorderManager borderManager) {
        this.paintBorder(graphics, n, n2, n3, n4, borderManager);
        Border border = this._getNext();
        if (border != null) {
            Insets insets = this.getBorderInsets();
            border.paint(graphics, n + insets.left, n2 + insets.top, n3 - (insets.left + insets.right), n4 - (insets.top + insets.bottom), borderManager);
        }
    }
}

