/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.border;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import oracle.ewt.border.Border;
import oracle.ewt.border.BorderManager;
import oracle.ewt.graphics.separator.SeparatorPainter;

public class SeparatorBorder
extends Border {
    public static final int ORIENTATION_TOP = 0;
    public static final int ORIENTATION_BOTTOM = 1;
    public static final int ORIENTATION_LEFT = 2;
    public static final int ORIENTATION_RIGHT = 3;
    private SeparatorPainter _painter;
    private int _thickness;
    private int _orientation;

    public SeparatorBorder(int n, SeparatorPainter separatorPainter, int n2) {
        this(n, separatorPainter, n2, null);
    }

    public SeparatorBorder(int n, SeparatorPainter separatorPainter, int n2, Border border) {
        super(border);
        this._setSeparatorPainter(separatorPainter);
        this._setOrientation(n2);
        this._thickness = n;
    }

    public final int getOrientation() {
        return this._orientation;
    }

    public final SeparatorPainter getSeparatorPainter() {
        return this._painter;
    }

    public final int getThickness() {
        return this._thickness;
    }

    protected Insets getBorderInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        int n = this._painter.thicknessToSize(this._thickness);
        switch (this._orientation) {
            case 0: {
                insets.top = n;
                break;
            }
            case 1: {
                insets.bottom = n;
                break;
            }
            case 2: {
                insets.left = n;
                break;
            }
            case 3: {
                insets.right = n;
                break;
            }
        }
        return insets;
    }

    protected void paintBorder(Graphics graphics, int n, int n2, int n3, int n4, BorderManager borderManager) {
        Color color = this._painter.prefersBackground() ? borderManager.getBorderBackground() : borderManager.getBorderForeground();
        graphics.setColor(color);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this._thickness / 2;
        int n10 = this._thickness % 2 == 0 ? 0 : 1;
        switch (this._orientation) {
            case 0: {
                n5 = n;
                n6 = n + n3;
                n8 = n7 = n2 + n9;
                break;
            }
            case 1: {
                n5 = n;
                n6 = n + n3;
                n8 = n7 = n2 + n4 - n9 - n10;
                break;
            }
            case 2: {
                n6 = n5 = n + n9;
                n7 = n2;
                n8 = n2 + n4;
                break;
            }
            case 3: {
                n6 = n5 = n + n3 - n9 - n10;
                n7 = n2;
                n8 = n2 + n4;
                break;
            }
        }
        this._painter.paint(graphics, n5, n7, n6, n8, this._thickness);
    }

    final void _setOrientation(int n) {
        this._orientation = n;
    }

    final void _setSeparatorPainter(SeparatorPainter separatorPainter) {
        this._painter = separatorPainter;
    }

    final void _setThickness(int n) {
        this._thickness = n;
    }
}

