/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dataSource;

import java.util.Enumeration;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.event.ListenerManager;

public class ArrayOneDDataSource
implements OneDDataSource {
    private int _itemCount;
    private Object[] _items;
    private ListenerManager _manager;

    public ArrayOneDDataSource(Object[] objectArray) {
        if (objectArray != null) {
            this._itemCount = objectArray.length;
            this._items = new Object[this._itemCount];
            System.arraycopy(objectArray, 0, this._items, 0, this._itemCount);
        }
    }

    public int getItemCount() {
        return this._itemCount;
    }

    public void addItems(int n, Object[] objectArray) {
        this._addToArray(n, objectArray);
        this._itemsAdded(n, objectArray.length);
    }

    public void removeItems(int n, int n2) {
        this._removeFromArray(n, n2);
        this._itemsRemoved(n, n2);
    }

    public Object getData(int n) {
        if (this._items == null) {
            return null;
        }
        return this._items[n];
    }

    public void setData(int n, Object object) {
        if (this._items == null) {
            this._items = new Object[this._itemCount];
        }
        this._items[n] = object;
        this._invalidateItems(n, 1);
    }

    public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._manager == null) {
            this._manager = new ListenerManager();
        }
        this._manager.addListener(oneDDataSourceListener);
    }

    public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._manager != null) {
            this._manager.removeListener(oneDDataSourceListener);
        }
    }

    private void _itemsAdded(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, n2);
        while (enumeration.hasMoreElements()) {
            OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
            oneDDataSourceListener.itemsAdded(oneDDataSourceEvent);
        }
    }

    private void _itemsRemoved(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2002, n, n2);
        while (enumeration.hasMoreElements()) {
            OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
            oneDDataSourceListener.itemsRemoved(oneDDataSourceEvent);
        }
    }

    private void _invalidateItems(int n, int n2) {
        if (this._manager == null) {
            return;
        }
        Enumeration enumeration = this._manager.getListeners();
        if (enumeration == null) {
            return;
        }
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2003, n, n2);
        while (enumeration.hasMoreElements()) {
            OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
            oneDDataSourceListener.invalidateItems(oneDDataSourceEvent);
        }
    }

    private void _addToArray(int n, Object[] objectArray) {
        Object[] objectArray2 = this._items;
        int n2 = 0;
        if (objectArray2 != null) {
            n2 = objectArray2.length;
        }
        int n3 = objectArray.length;
        Object[] objectArray3 = new Object[n2 + n3];
        if (n != 0) {
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
        }
        if (n != n2) {
            System.arraycopy(objectArray2, n, objectArray3, n + n3, n2 - n);
        }
        System.arraycopy(objectArray, 0, objectArray3, n, n3);
        this._items = objectArray3;
        this._itemCount = this._items.length;
    }

    private void _removeFromArray(int n, int n2) {
        Object[] objectArray = this._items;
        int n3 = 0;
        if (objectArray != null) {
            n3 = objectArray.length;
        }
        Object[] objectArray2 = new Object[n3 - n2];
        if (n != 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(objectArray, n + n2, objectArray2, n, n3 - (n + n2));
        }
        int n4 = n;
        while (n4 < n + n2) {
            this._items[n4] = null;
            ++n4;
        }
        this._items = objectArray2;
        this._itemCount = this._items.length;
    }
}

