/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ewt.EwtComponent;
import oracle.ewt.border.FrameBorder;
import oracle.ewt.border.MarginBorder;
import oracle.ewt.button.DefaultableButton;
import oracle.ewt.button.TextContent;
import oracle.ewt.dTree.DTreeButtonDecoration;
import oracle.ewt.dTree.DTreeLineDecoration;
import oracle.ewt.dTree.DTreeStackingDecoration;
import oracle.ewt.dialog.directory.DefaultButtonTracker;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.dialog.directory.DirectoryTree;
import oracle.ewt.dialog.directory.DismissListener;
import oracle.ewt.dialog.directory.DriveChangeListener;
import oracle.ewt.dialog.directory.FieldSyncListener;
import oracle.ewt.dialog.directory.RootChangeListener;
import oracle.ewt.graphics.frame.LoweredFramePainter;
import oracle.ewt.layout.EqualRowLayout;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.WindowUtils;

public class DirectoryDialog
extends BufferedDialog {
    private File _directory;
    private DirectoryDrive[] _drives;
    private Component _centerOver;
    private String _message;
    private MultiLineLabel _messageLabel;
    private DefaultableButton _okButton;
    private DefaultableButton _cancelButton;
    private DirectoryTree _dirTree;
    private LWTextField _dirField;
    private LWLabel _dirLabel;
    private LWChoice _driveChoice;
    private LWLabel _driveLabel;
    private EwtComponent _drivePane;
    private boolean _defaultTitle;
    private boolean _createAllowed;
    private ResourceBundle _messageBundle;
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _OK_KEY = "OK";
    private static final String _TITLE_KEY = "TITLE";
    private static final String _MESSAGE_KEY = "MESSAGE";
    private static final String _DRIVES_KEY = "DRIVES";
    private static final String _DIRECTORY_KEY = "DIRECTORY";
    private static final int _MARGIN = 10;

    public DirectoryDialog(Frame frame) {
        this(frame, null);
    }

    public DirectoryDialog(Frame frame, String string) {
        super(frame, string, true);
        if (string == null) {
            this._defaultTitle = true;
        }
    }

    public boolean isCreateAllowed() {
        return this._createAllowed;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public DirectoryDrive[] getDrives() {
        DirectoryDrive[] directoryDriveArray = null;
        if (this._drives != null) {
            directoryDriveArray = new DirectoryDrive[this._drives.length];
            System.arraycopy(this._drives, 0, directoryDriveArray, 0, this._drives.length);
        }
        return directoryDriveArray;
    }

    public String getMessage() {
        if (this._message == null && this._messageLabel != null) {
            return this._messageLabel.getText();
        }
        return this._message;
    }

    public File runDialog(File file) {
        int n;
        if (this._dirTree == null) {
            this._createComponents();
        }
        if ((n = this._dirTree.setDirectory(file, false)) != 0 && n != 4) {
            String string = System.getProperty("user.dir");
            n = this._dirTree.setDirectory(new File(string), false);
        }
        if (n != 0) {
            this._dirField.setText(file.getPath());
        }
        this.pack();
        WindowUtils.centerWindow(this, this._centerOver);
        this._dirTree.requestFocus();
        this._dirTree.setCanvasOrigin(0, 0);
        this._dirTree.makeVisible(this._dirTree.getFocusedItem());
        int n2 = this._dirField.getCaretPosition();
        this._dirField.setCaretPosition(0);
        this._dirField.setCaretPosition(n2);
        ((Component)this).setVisible(true);
        this._dirTree.setRoot(null);
        this._messageBundle = null;
        return this._directory;
    }

    public void setCreateAllowed(boolean bl) {
        this._createAllowed = bl;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public void setMessage(String string) {
        this._message = string;
        if (this._messageLabel != null) {
            this._messageLabel.setText(string);
        }
    }

    public void setDrives(DirectoryDrive[] directoryDriveArray) {
        if (directoryDriveArray == null) {
            this._drives = null;
        } else {
            this._drives = new DirectoryDrive[directoryDriveArray.length];
            System.arraycopy(directoryDriveArray, 0, this._drives, 0, directoryDriveArray.length);
        }
        this._updateDriveChoice();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._loadMessages(locale);
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this._defaultTitle = false;
    }

    void _dismiss(File file) {
        this._directory = file;
        ((Component)this).setVisible(false);
    }

    String _getCancelMessage() {
        return this._messageBundle.getString(_CANCEL_KEY);
    }

    String _getMessage(String string) {
        return this._messageBundle.getString(string);
    }

    String _getOKMessage() {
        return this._messageBundle.getString(_OK_KEY);
    }

    private void _addComponents(Component component) {
        EwtComponent ewtComponent = new EwtComponent();
        ewtComponent.setLayout(new BorderLayout());
        EwtComponent ewtComponent2 = new EwtComponent();
        ewtComponent2.setLayout(new BorderLayout());
        ewtComponent2.setBorder(new MarginBorder(0, 0, 10, 0, null));
        EwtComponent ewtComponent3 = new EwtComponent();
        ewtComponent3.setLayout(new BorderLayout());
        ewtComponent3.add("West", this._dirLabel);
        ewtComponent3.add("Center", this._dirField);
        ewtComponent2.add("Center", component);
        ewtComponent.add("Center", ewtComponent2);
        ewtComponent.add("South", ewtComponent3);
        ewtComponent.setBorder(new MarginBorder(5, 0, 10, 0, null));
        LWComponent lWComponent = new LWComponent();
        lWComponent.setLayout(new EqualRowLayout(10, 1, 1));
        lWComponent.add(this._okButton);
        lWComponent.add(this._cancelButton);
        EwtComponent ewtComponent4 = new EwtComponent();
        ewtComponent4.setLayout(new BorderLayout());
        this._drivePane = new EwtComponent();
        this._drivePane.setLayout(new BorderLayout());
        this._drivePane.add("West", this._driveLabel);
        this._drivePane.add("Center", this._driveChoice);
        this._drivePane.setBorder(new MarginBorder(5, 0, 5, 0, null));
        this._messageLabel.setBorder(new MarginBorder(0, 0, 5, 0, null));
        ewtComponent4.add("North", this._messageLabel);
        ewtComponent4.add("South", this._drivePane);
        EwtComponent ewtComponent5 = new EwtComponent();
        ewtComponent5.setLayout(new BorderLayout());
        ewtComponent5.setBorder(new MarginBorder(10, 10, 10, 10, null));
        ewtComponent5.add("North", ewtComponent4);
        ewtComponent5.add("Center", ewtComponent);
        ewtComponent5.add("South", lWComponent);
        this.add("Center", ewtComponent5);
    }

    private void _createComponents() {
        this._messageLabel = new MultiLineLabel();
        this._okButton = new DefaultableButton("");
        this._cancelButton = new DefaultableButton("");
        this._dirField = new LWTextField();
        this._dirLabel = new LWLabel();
        this._dirTree = new DirectoryTree();
        this._dirTree.setBackground(Color.white);
        this._dirTree.setPreferredItemsOnScreen(13);
        this._dirTree.setPreferredLevelsOnScreen(10);
        DTreeButtonDecoration dTreeButtonDecoration = new DTreeButtonDecoration();
        DTreeLineDecoration dTreeLineDecoration = new DTreeLineDecoration();
        DTreeStackingDecoration dTreeStackingDecoration = new DTreeStackingDecoration(dTreeLineDecoration, dTreeButtonDecoration);
        this._dirTree.setDecoration(dTreeStackingDecoration);
        ScrollBox scrollBox = new ScrollBox(this._dirTree, 0, 0);
        scrollBox.setBorder(new FrameBorder(2, LoweredFramePainter.getFramePainter()));
        this._driveChoice = new LWChoice();
        this._driveLabel = new LWLabel();
        DismissListener dismissListener = new DismissListener(this, this._dirTree, this._dirField, this._cancelButton);
        this._dirTree.addKeyListener(dismissListener);
        this._dirField.addKeyListener(dismissListener);
        this._okButton.addKeyListener(dismissListener);
        this._cancelButton.addKeyListener(dismissListener);
        this._okButton.addActionListener(dismissListener);
        this._cancelButton.addActionListener(dismissListener);
        FieldSyncListener fieldSyncListener = new FieldSyncListener(this._dirField);
        this._dirTree.addSelectionListener(fieldSyncListener);
        this._dirTree.addPropertyChangeListener(new RootChangeListener(this, this._driveChoice));
        this._driveChoice.addItemListener(new DriveChangeListener(this, this._dirTree));
        this._okButton.setDefault(true);
        this._cancelButton.addFocusListener(new DefaultButtonTracker(this._okButton));
        this._loadMessages(this.getLocale());
        this._addComponents(scrollBox);
        this._updateDriveChoice();
    }

    private void _loadMessages(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this._messageBundle = ResourceBundle.getBundle("oracle.ewt.dialog.directory.resource.DirectoryDialogBundle", locale);
        if (this._okButton != null) {
            ((TextContent)this._okButton.getContent()).setText(this._messageBundle.getString(_OK_KEY));
        }
        if (this._cancelButton != null) {
            ((TextContent)this._cancelButton.getContent()).setText(this._messageBundle.getString(_CANCEL_KEY));
        }
        if (this._messageLabel != null) {
            if (this._message == null) {
                this._messageLabel.setText(this._messageBundle.getString(_MESSAGE_KEY));
            } else {
                this._messageLabel.setText(this._message);
            }
        }
        if (this._driveLabel != null) {
            this._driveLabel.setText(this._messageBundle.getString(_DRIVES_KEY));
        }
        if (this._dirLabel != null) {
            this._dirLabel.setText(this._messageBundle.getString(_DIRECTORY_KEY));
        }
        if (this._defaultTitle) {
            super.setTitle(this._messageBundle.getString(_TITLE_KEY));
        }
    }

    private void _updateDriveChoice() {
        if (this._drivePane == null) {
            return;
        }
        if (this._drives == null || this._drives.length == 0) {
            this._drivePane.setVisible(false);
            this._driveChoice.removeAll();
            return;
        }
        this._driveChoice.removeAll();
        int n = 0;
        while (n < this._drives.length) {
            DirectoryDrive directoryDrive = this._drives[n];
            String string = directoryDrive.getPath();
            String string2 = directoryDrive.getLabel();
            String string3 = null;
            string3 = string2 == null || string2.equals("") ? "(" + string + ")" : String.valueOf(string2) + " (" + string + ")";
            this._driveChoice.add(string3);
            ++n;
        }
        this._drivePane.setVisible(true);
    }
}

