/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.peer.LightweightPeer;
import oracle.ewt.event.AnyEventListener;
import oracle.ewt.event.AnyEventMulticaster;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.help.HelpProvider;
import oracle.ewt.lwAWT.BufferedPanel;
import oracle.ewt.lwAWT.DoubleBuffer;
import oracle.ewt.lwAWT.DoubleBufferer;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.InteriorPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.SharedPainter;
import oracle.ewt.painter.BackgroundFill;
import oracle.ewt.painter.Fill;
import oracle.ewt.popup.PopupFrame;

public class BufferedFrame
extends PopupFrame
implements ImmediatePainter,
DoubleBufferer,
HelpCapable,
InteriorPainter {
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private SharedPainter _painter;
    private AnyEventListener _anyListener;
    private Object _helpBook;
    private String _helpTopic;
    private HelpProvider _helpProvider;

    public BufferedFrame() {
        this._init();
    }

    public BufferedFrame(String string) {
        super(string);
        this._init();
    }

    public synchronized void addAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.add(this._anyListener, anyEventListener);
    }

    public synchronized void removeAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.remove(this._anyListener, anyEventListener);
    }

    public String getHelpTopic() {
        return this._helpTopic;
    }

    public void setHelpTopic(String string) {
        this._helpTopic = string;
    }

    public Object getHelpBook() {
        return this._helpBook;
    }

    public void setHelpBook(Object object) {
        this._helpBook = object;
    }

    public HelpProvider getHelpProvider() {
        HelpProvider helpProvider = this._helpProvider;
        if (helpProvider == null) {
            return LWComponent.getDefaultHelpProvider();
        }
        return helpProvider;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this._helpProvider = helpProvider;
    }

    public void showHelp() {
        HelpProvider helpProvider = this.getHelpProvider();
        if (helpProvider != null) {
            helpProvider.showHelp(this.getHelpBook(), this.getHelpTopic(), this);
        }
    }

    public void setFill(Fill fill) {
        this._painter.setFill(fill);
    }

    public Fill getFill() {
        return this._painter.getFill();
    }

    public boolean isTransparent() {
        return false;
    }

    public boolean isPaintPropagationRequired() {
        return false;
    }

    public void freezeRepaints() {
        this._painter.freezeRepaints();
    }

    public void unfreezeRepaints() {
        this._painter.unfreezeRepaints(this.getDoubleBuffer());
    }

    public void paintImmediate(int n, int n2, int n3, int n4) {
        this._painter.paintImmediate(n, n2, n3, n4, this.getDoubleBuffer());
    }

    public void paintImmediateUnclipped(int n, int n2, int n3, int n4) {
        this.paintImmediate(n, n2, n3, n4);
    }

    public boolean isChildClipped(Component component) {
        return this._painter.isChildClipped(component);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this._painter.repaint(n, n2, n3, n4)) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            this._painter.paint(graphics, this.getDoubleBuffer(), this);
        }
    }

    public void paintInterior(Graphics graphics) {
    }

    public void paintChildren(Graphics graphics) {
        super.paint(graphics);
    }

    public void invalidate() {
        this._painter.clearClipCache();
        super.invalidate();
    }

    public void doLayout() {
        this._painter.clearClipCache();
        super.doLayout();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = null;
        if (this.getFill().damageOnResize()) {
            dimension = this.getSize();
        }
        super.reshape(n, n2, n3, n4);
        if (dimension != null && (dimension.width != n3 || dimension.height != n4)) {
            this.repaint();
        }
    }

    public void removeNotify() {
        LWComponent._loseFocusIfChild(this);
        super.removeNotify();
    }

    public void remove(int n) {
        Component component;
        Object object = this.getTreeLock();
        synchronized (object) {
            component = this.getComponent(n);
            if (!(component.getPeer() instanceof LightweightPeer)) {
                component = null;
            }
            super.remove(n);
            this._painter.remove(n);
        }
        if (component != null && component.isVisible()) {
            object = component.getBounds();
            this.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
    }

    public void removeAll() {
        Rectangle rectangle;
        Object object = this.getTreeLock();
        synchronized (object) {
            rectangle = LWComponent._getLWChildBounds(this);
            super.removeAll();
            this._painter.removeAll();
        }
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            super.addImpl(component, object, n);
            this._painter.add(component, n);
        }
        if (component.getPeer() instanceof LightweightPeer && component.isVisible()) {
            component.repaint();
        }
    }

    protected final void processEvent(AWTEvent aWTEvent) {
        AnyEventListener anyEventListener = this._anyListener;
        if (anyEventListener != null) {
            anyEventListener.processEventStart(aWTEvent);
        }
        this.processEventImpl(aWTEvent);
        if (anyEventListener != null) {
            anyEventListener.processEventEnd(aWTEvent);
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    protected DoubleBuffer getDoubleBuffer() {
        return BufferedPanel._getDoubleBuffer();
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    protected String getBaseClassName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    private void _init() {
        this.setName(this.getDefaultName());
        this._painter = new SharedPainter(this, BackgroundFill.getFill());
    }
}

