/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.thread;

import java.util.Enumeration;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.thread.SchedulerEvent;
import oracle.ewt.thread.SchedulerListener;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.timer.Timer;

public class TaskScheduler {
    private TaskQueue _queue = new TaskQueue();
    Timer _timer = new Timer(this._queue);
    private ListenerManager _listeners;
    private static TaskScheduler _sTaskScheduler;

    public static TaskScheduler getDefaultTaskScheduler() {
        if (_sTaskScheduler == null) {
            _sTaskScheduler = new TaskScheduler();
        }
        return _sTaskScheduler;
    }

    public TaskScheduler() {
        this._timer.setName("TaskScheduler timer");
    }

    public void schedule(Task task, int n) {
        TaskQueue taskQueue;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        long l = System.currentTimeMillis() + (long)n;
        SchedulerEvent schedulerEvent = new SchedulerEvent(this, 1, task, l);
        this.processSchedulerEvent(schedulerEvent);
        if (schedulerEvent.isTaskRejected()) {
            return;
        }
        TaskQueue taskQueue2 = taskQueue = this._queue;
        synchronized (taskQueue2) {
            boolean bl = taskQueue.remove(task);
            boolean bl2 = bl = taskQueue.add(task, l) || bl;
            if (bl) {
                this._timer.schedule(taskQueue.getNextDelay());
            }
            return;
        }
    }

    public void cancel(Task task) {
        TaskQueue taskQueue;
        TaskQueue taskQueue2 = taskQueue = this._queue;
        synchronized (taskQueue2) {
            if (taskQueue.remove(task)) {
                if (taskQueue.isEmpty()) {
                    this._timer.cancel();
                } else {
                    this._timer.schedule(taskQueue.getNextDelay());
                }
            }
            return;
        }
    }

    public void setDaemon(boolean bl) {
        this._timer.setDaemon(bl);
    }

    public boolean isDaemon() {
        return this._timer.isDaemon();
    }

    public void setName(String string) {
        this._timer.setName(string);
    }

    public String getName() {
        return this._timer.getName();
    }

    public void setPriority(int n) {
        this._timer.setPriority(n);
    }

    public int getPriority() {
        return this._timer.getPriority();
    }

    public synchronized void addSchedulerListener(SchedulerListener schedulerListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(schedulerListener);
    }

    public synchronized void removeSchedulerListener(SchedulerListener schedulerListener) {
        this._listeners.removeListener(schedulerListener);
    }

    protected void processTask(Task task, long l) {
        try {
            SchedulerEvent schedulerEvent = new SchedulerEvent(this, 2, task, l);
            this.processSchedulerEvent(schedulerEvent);
            if (!schedulerEvent.isTaskRejected()) {
                this.runTask(task, new TaskEvent(this, task, l));
                return;
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void runTask(Task task, TaskEvent taskEvent) {
        task.runTask(taskEvent);
    }

    protected void finalize() throws Throwable {
        this._timer.kill();
        super.finalize();
    }

    protected void processSchedulerEvent(SchedulerEvent schedulerEvent) {
        Enumeration enumeration;
        int n = schedulerEvent.getID();
        ListenerManager listenerManager = this._listeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                SchedulerListener schedulerListener = (SchedulerListener)enumeration.nextElement();
                switch (n) {
                    case 1: {
                        schedulerListener.taskScheduled(schedulerEvent);
                        break;
                    }
                    case 2: {
                        schedulerListener.taskRunning(schedulerEvent);
                        break;
                    }
                }
            }
        }
    }

    private class TaskQueue
    implements Runnable {
        private Element _head;

        public void run() {
            Element element = null;
            TaskQueue taskQueue = this;
            synchronized (taskQueue) {
                if (this.isEmpty()) {
                    Object var3_3 = null;
                    return;
                }
                long l = this.getNextDelay();
                if (l <= 0L) {
                    element = this.popFirstTask();
                }
            }
            if (element != null) {
                TaskScheduler.this.processTask(element.task, element.time);
            }
            taskQueue = this;
            synchronized (taskQueue) {
                if (!this.isEmpty()) {
                    TaskScheduler.this._timer.schedule(this.getNextDelay());
                }
                return;
            }
        }

        public boolean add(Task task, long l) {
            Element element = null;
            Element element2 = this._head;
            while (element2 != null) {
                if (element2.time > l) break;
                element = element2;
                element2 = element2.next;
            }
            Element element3 = new Element(task, l, element2);
            if (element == null) {
                this._head = element3;
                return true;
            }
            element.next = element3;
            return false;
        }

        public boolean remove(Task task) {
            Element element = null;
            Element element2 = this._head;
            while (element2 != null) {
                if (element2.task == task) {
                    if (element == null) {
                        this._head = element2.next;
                        return true;
                    }
                    element.next = element2.next;
                    break;
                }
                element = element2;
                element2 = element2.next;
            }
            return false;
        }

        public Element popFirstTask() {
            Element element = this._head;
            this._head = element.next;
            return element;
        }

        public long getNextDelay() {
            long l = this._head.time - System.currentTimeMillis();
            if (l < 0L) {
                l = 0L;
            }
            return l;
        }

        public boolean isEmpty() {
            return this._head == null;
        }

        TaskQueue() {
            TaskScheduler.this = TaskScheduler.this;
        }
    }

    private class Element {
        public final Task task;
        public final long time;
        public Element next;

        public Element(Task task, long l, Element element) {
            TaskScheduler.this = TaskScheduler.this;
            this.task = task;
            this.time = l;
            this.next = element;
        }
    }
}

