/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import oracle.ewt.event.HelpEvent;
import oracle.ewt.event.HelpListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.WizardValidateEvent;
import oracle.ewt.wizard.WizardValidateListener;

public class WizardPage {
    public static final int NOT_ADDED_INDEX = -1;
    private String _label;
    private Component _content;
    private boolean _enabled = true;
    private boolean _visible = true;
    private boolean _canAdvance;
    private BaseWizard _parent;
    private ListenerManager _wizardValidateListeners;
    private ListenerManager _helpListeners;
    private PropertyChangeSupport _propertySupport;

    public WizardPage(Component component) {
        this(component, null);
    }

    public WizardPage(Component component, String string) {
        this._label = string;
        this._content = component;
        this._canAdvance = true;
    }

    public void setVisible(boolean bl) {
        if (bl != this._visible) {
            BaseWizard baseWizard;
            this._visible = bl;
            if (this._propertySupport != null) {
                this._propertySupport.firePropertyChange("visible", new Boolean(!bl), new Boolean(bl));
            }
            if ((baseWizard = this.getParent()) != null) {
                if (!bl) {
                    this._moveIfSelected();
                    return;
                }
                baseWizard.enableButtons();
            }
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setContent(Component component) {
        Component component2 = this._content;
        if (component2 != component && this._propertySupport != null) {
            this._propertySupport.firePropertyChange("content", component2, component);
        }
    }

    public Component getContent() {
        return this._content;
    }

    public void setLabel(String string) {
        String string2 = this._label;
        if (string2 != string) {
            this._label = string;
            if (this._propertySupport != null) {
                this._propertySupport.firePropertyChange("label", string2, string);
            }
        }
    }

    public String getLabel() {
        return this._label;
    }

    public void setEnabled(boolean bl) {
        if (this._enabled != bl) {
            BaseWizard baseWizard;
            this._enabled = bl;
            if (this._propertySupport != null) {
                this._propertySupport.firePropertyChange("enabled", new Boolean(!bl), new Boolean(bl));
            }
            if ((baseWizard = this.getParent()) != null) {
                if (!bl) {
                    this._moveIfSelected();
                    return;
                }
                baseWizard.enableButtons();
            }
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setCanAdvance(boolean bl) {
        if (bl != this.getCanAdvance()) {
            this._canAdvance = bl;
            if (this.isSelected()) {
                this.getParent().enableButtons();
            }
        }
    }

    public boolean getCanAdvance() {
        return this._canAdvance;
    }

    public boolean isSelected() {
        BaseWizard baseWizard = this.getParent();
        if (baseWizard == null) {
            return false;
        }
        return baseWizard.getSelectedPage() == this;
    }

    public int getIndex() {
        BaseWizard baseWizard = this.getParent();
        if (baseWizard == null) {
            return -1;
        }
        return baseWizard.getPageIndex(this);
    }

    public BaseWizard getParent() {
        return this._parent;
    }

    public synchronized void addWizardValidateListener(WizardValidateListener wizardValidateListener) {
        if (this._wizardValidateListeners == null) {
            this._wizardValidateListeners = new ListenerManager();
        }
        this._wizardValidateListeners.addListener(wizardValidateListener);
    }

    public synchronized void removeWizardValidateListener(WizardValidateListener wizardValidateListener) {
        this._wizardValidateListeners.removeListener(wizardValidateListener);
    }

    public synchronized void addHelpListener(HelpListener helpListener) {
        if (this._helpListeners == null) {
            this._helpListeners = new ListenerManager();
        }
        this._helpListeners.addListener(helpListener);
    }

    public synchronized void removeHelpListener(HelpListener helpListener) {
        this._helpListeners.removeListener(helpListener);
    }

    public String toString() {
        String string = String.valueOf(this.getClass().getName()) + " " + this.getLabel();
        if (!this.isEnabled()) {
            string = String.valueOf(string) + ",disabled";
        }
        if (!this.isVisible()) {
            string = String.valueOf(string) + ",hidden";
        }
        if (this.isSelected()) {
            string = String.valueOf(string) + ",selected";
        }
        return string;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected boolean validatePage() {
        WizardValidateEvent wizardValidateEvent = new WizardValidateEvent(this, 2000, this);
        this.processWizardValidateEvent(wizardValidateEvent);
        return !wizardValidateEvent.isCancelled();
    }

    protected void processWizardValidateEvent(WizardValidateEvent wizardValidateEvent) {
        Enumeration enumeration;
        int n = wizardValidateEvent.getID();
        ListenerManager listenerManager = this._wizardValidateListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                WizardValidateListener wizardValidateListener = (WizardValidateListener)enumeration.nextElement();
                wizardValidateListener.wizardValidatePage(wizardValidateEvent);
            }
        }
    }

    protected void processHelpEvent(HelpEvent helpEvent) {
        Enumeration enumeration;
        int n = helpEvent.getID();
        ListenerManager listenerManager = this._helpListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                HelpListener helpListener = (HelpListener)enumeration.nextElement();
                helpListener.helpRequested(helpEvent);
            }
        }
    }

    void setParent(BaseWizard baseWizard) {
        this._parent = baseWizard;
    }

    private void _moveIfSelected() {
        BaseWizard baseWizard = this.getParent();
        if (this.isSelected()) {
            if (baseWizard != null) {
                WizardPage wizardPage = baseWizard.getNextPage(this);
                if (wizardPage != null) {
                    baseWizard.selectPage(wizardPage, false);
                    return;
                }
                baseWizard.setSelectedPage(null);
                return;
            }
        } else {
            baseWizard.enableButtons();
        }
    }
}

